/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.formations;

import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.struct.IntSeq;
import arc.struct.Seq;
import mindustry.ai.formations.FormationMember;
import mindustry.ai.formations.FormationPattern;
import mindustry.ai.formations.SlotAssignment;
import mindustry.ai.formations.SlotAssignmentStrategy;

public class DistanceAssignmentStrategy
implements SlotAssignmentStrategy {
    private final Vec3 vec = new Vec3();
    private final FormationPattern form;

    public DistanceAssignmentStrategy(FormationPattern form) {
        this.form = form;
    }

    @Override
    public void updateSlotAssignments(Seq<SlotAssignment> assignments) {
        IntSeq slots = IntSeq.range(0, assignments.size);
        for (SlotAssignment slot : assignments) {
            int mindex = 0;
            float mcost = Float.MAX_VALUE;
            for (int i = 0; i < slots.size; ++i) {
                float cost = this.cost(slot.member, slots.get(i));
                if (!(cost < mcost)) continue;
                mcost = cost;
                mindex = i;
            }
            slot.slotNumber = slots.get(mindex);
            slots.removeIndex(mindex);
        }
    }

    @Override
    public int calculateNumberOfSlots(Seq<SlotAssignment> assignments) {
        return assignments.size;
    }

    @Override
    public void removeSlotAssignment(Seq<SlotAssignment> assignments, int index) {
        assignments.remove(index);
    }

    float cost(FormationMember member, int slot) {
        this.form.calculateSlotLocation(this.vec, slot);
        return Mathf.dst2(member.formationPos().x, member.formationPos().y, this.vec.x, this.vec.y);
    }
}

