/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.formations;

import arc.math.Mat;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import mindustry.ai.formations.FormationMember;
import mindustry.ai.formations.FormationMotionModerator;
import mindustry.ai.formations.FormationPattern;
import mindustry.ai.formations.FreeSlotAssignmentStrategy;
import mindustry.ai.formations.SlotAssignment;
import mindustry.ai.formations.SlotAssignmentStrategy;

public class Formation {
    public Seq<SlotAssignment> slotAssignments;
    public Vec3 anchor;
    public FormationPattern pattern;
    public SlotAssignmentStrategy slotAssignmentStrategy;
    public FormationMotionModerator motionModerator;
    private final Vec2 positionOffset;
    private final Mat orientationMatrix = new Mat();
    private final Vec3 driftOffset;

    public Formation(Vec3 anchor, FormationPattern pattern) {
        this(anchor, pattern, new FreeSlotAssignmentStrategy(), null);
    }

    public Formation(Vec3 anchor, FormationPattern pattern, SlotAssignmentStrategy slotAssignmentStrategy) {
        this(anchor, pattern, slotAssignmentStrategy, null);
    }

    public Formation(Vec3 anchor, FormationPattern pattern, SlotAssignmentStrategy slotAssignmentStrategy, FormationMotionModerator motionModerator) {
        if (anchor == null) {
            throw new IllegalArgumentException("The anchor point cannot be null");
        }
        this.anchor = anchor;
        this.pattern = pattern;
        this.slotAssignmentStrategy = slotAssignmentStrategy;
        this.motionModerator = motionModerator;
        this.slotAssignments = new Seq();
        this.driftOffset = new Vec3();
        this.positionOffset = new Vec2(anchor.x, anchor.y).cpy();
    }

    public void updateSlotAssignments() {
        this.pattern.slots = this.slotAssignments.size;
        this.slotAssignmentStrategy.updateSlotAssignments(this.slotAssignments);
        this.pattern.slots = this.slotAssignmentStrategy.calculateNumberOfSlots(this.slotAssignments);
        if (this.motionModerator != null) {
            this.motionModerator.calculateDriftOffset(this.driftOffset, this.slotAssignments, this.pattern);
        }
    }

    public boolean changePattern(FormationPattern pattern) {
        int occupiedSlots = this.slotAssignments.size;
        if (pattern.supportsSlots(occupiedSlots)) {
            this.pattern = pattern;
            this.updateSlotAssignments();
            return true;
        }
        return false;
    }

    public int addMembers(Iterable<? extends FormationMember> members) {
        int added = 0;
        for (FormationMember formationMember : members) {
            if (!this.pattern.supportsSlots(this.slotAssignments.size + 1)) continue;
            this.slotAssignments.add(new SlotAssignment(formationMember, this.slotAssignments.size));
            ++added;
        }
        this.updateSlotAssignments();
        return added;
    }

    public boolean addMember(FormationMember member) {
        if (this.pattern.supportsSlots(this.slotAssignments.size + 1)) {
            this.slotAssignments.add(new SlotAssignment(member, this.slotAssignments.size));
            this.updateSlotAssignments();
            return true;
        }
        return false;
    }

    public void removeMember(FormationMember member) {
        int slot = this.findMemberSlot(member);
        if (slot >= 0) {
            this.slotAssignmentStrategy.removeSlotAssignment(this.slotAssignments, slot);
            this.updateSlotAssignments();
        }
    }

    private int findMemberSlot(FormationMember member) {
        for (int i = 0; i < this.slotAssignments.size; ++i) {
            if (this.slotAssignments.get((int)i).member != member) continue;
            return i;
        }
        return -1;
    }

    public SlotAssignment getSlotAssignmentAt(int index) {
        return this.slotAssignments.get(index);
    }

    public int getSlotAssignmentCount() {
        return this.slotAssignments.size;
    }

    public void updateSlots() {
        this.positionOffset.set(this.anchor);
        float orientationOffset = this.anchor.z;
        if (this.motionModerator != null) {
            this.positionOffset.sub(this.driftOffset);
            orientationOffset -= this.driftOffset.z;
        }
        this.orientationMatrix.idt().rotate(this.anchor.z);
        for (int i = 0; i < this.slotAssignments.size; ++i) {
            SlotAssignment slotAssignment = this.slotAssignments.get(i);
            Vec3 relativeLoc = slotAssignment.member.formationPos();
            float z = relativeLoc.z;
            this.pattern.calculateSlotLocation(relativeLoc, slotAssignment.slotNumber);
            relativeLoc.mul(this.orientationMatrix);
            relativeLoc.add(this.positionOffset.x, this.positionOffset.y, 0.0f);
            relativeLoc.z = z + orientationOffset;
        }
        if (this.motionModerator != null) {
            this.motionModerator.updateAnchorPoint(this.anchor);
        }
    }
}

