/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.formations;

import arc.math.geom.Vec3;
import arc.struct.Seq;
import mindustry.ai.formations.FormationPattern;
import mindustry.ai.formations.SlotAssignment;

public abstract class FormationMotionModerator {
    private Vec3 tempLocation;

    public abstract void updateAnchorPoint(Vec3 var1);

    public Vec3 calculateDriftOffset(Vec3 centerOfMass, Seq<SlotAssignment> slotAssignments, FormationPattern pattern) {
        centerOfMass.y = 0.0f;
        centerOfMass.x = 0.0f;
        float centerOfMassOrientation = 0.0f;
        if (this.tempLocation == null) {
            this.tempLocation = new Vec3();
        }
        float numberOfAssignments = slotAssignments.size;
        int i = 0;
        while ((float)i < numberOfAssignments) {
            pattern.calculateSlotLocation(this.tempLocation, slotAssignments.get((int)i).slotNumber);
            centerOfMass.add(this.tempLocation);
            centerOfMassOrientation += this.tempLocation.z;
            ++i;
        }
        centerOfMass.scl(1.0f / numberOfAssignments);
        centerOfMass.z = centerOfMassOrientation /= numberOfAssignments;
        return centerOfMass;
    }
}

