/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.formations;

import arc.struct.BoolSeq;
import arc.struct.Seq;
import arc.util.ArcRuntimeException;
import mindustry.ai.formations.BoundedSlotAssignmentStrategy;
import mindustry.ai.formations.FormationMember;
import mindustry.ai.formations.SlotAssignment;

public class SoftRoleSlotAssignmentStrategy
extends BoundedSlotAssignmentStrategy {
    protected SlotCostProvider slotCostProvider;
    protected float costThreshold;
    private BoolSeq filledSlots;

    public SoftRoleSlotAssignmentStrategy(SlotCostProvider slotCostProvider) {
        this(slotCostProvider, Float.POSITIVE_INFINITY);
    }

    public SoftRoleSlotAssignmentStrategy(SlotCostProvider slotCostProvider, float costThreshold) {
        this.slotCostProvider = slotCostProvider;
        this.costThreshold = costThreshold;
        this.filledSlots = new BoolSeq();
    }

    @Override
    public void updateSlotAssignments(Seq<SlotAssignment> assignments) {
        SlotAssignment slot;
        int j;
        int i;
        Seq<MemberAndSlots> memberData = new Seq<MemberAndSlots>();
        int numberOfAssignments = assignments.size;
        for (i = 0; i < numberOfAssignments; ++i) {
            SlotAssignment assignment = assignments.get(i);
            MemberAndSlots datum = new MemberAndSlots(assignment.member);
            for (j = 0; j < numberOfAssignments; ++j) {
                float cost = this.slotCostProvider.getCost(assignment.member, j);
                if (cost >= this.costThreshold) continue;
                slot = assignments.get(j);
                CostAndSlot slotDatum = new CostAndSlot(cost, slot.slotNumber);
                datum.costAndSlots.add(slotDatum);
                datum.assignmentEase += 1.0f / (1.0f + cost);
            }
            memberData.add(datum);
        }
        if (numberOfAssignments > this.filledSlots.size) {
            this.filledSlots.ensureCapacity(numberOfAssignments - this.filledSlots.size);
        }
        this.filledSlots.size = numberOfAssignments;
        for (i = 0; i < numberOfAssignments; ++i) {
            this.filledSlots.set(i, false);
        }
        memberData.sort();
        for (i = 0; i < memberData.size; ++i) {
            int slotNumber;
            MemberAndSlots memberDatum;
            block7: {
                memberDatum = (MemberAndSlots)memberData.get(i);
                memberDatum.costAndSlots.sort();
                int m = memberDatum.costAndSlots.size;
                for (j = 0; j < m; ++j) {
                    slotNumber = memberDatum.costAndSlots.get((int)j).slotNumber;
                    if (this.filledSlots.get(slotNumber)) {
                        continue;
                    }
                    break block7;
                }
                throw new ArcRuntimeException("SoftRoleSlotAssignmentStrategy cannot find valid slot assignment for member " + memberDatum.member);
            }
            slot = assignments.get(slotNumber);
            slot.member = memberDatum.member;
            slot.slotNumber = slotNumber;
            this.filledSlots.set(slotNumber, true);
        }
    }

    public static interface SlotCostProvider {
        public float getCost(FormationMember var1, int var2);
    }

    static class MemberAndSlots
    implements Comparable<MemberAndSlots> {
        FormationMember member;
        float assignmentEase;
        Seq<CostAndSlot> costAndSlots;

        public MemberAndSlots(FormationMember member) {
            this.member = member;
            this.assignmentEase = 0.0f;
            this.costAndSlots = new Seq();
        }

        @Override
        public int compareTo(MemberAndSlots other) {
            return Float.compare(this.assignmentEase, other.assignmentEase);
        }
    }

    static class CostAndSlot
    implements Comparable<CostAndSlot> {
        float cost;
        int slotNumber;

        public CostAndSlot(float cost, int slotNumber) {
            this.cost = cost;
            this.slotNumber = slotNumber;
        }

        @Override
        public int compareTo(CostAndSlot other) {
            return Float.compare(this.cost, other.cost);
        }
    }
}

