/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.formations.patterns;

import arc.math.Angles;
import arc.math.geom.Vec3;
import mindustry.ai.formations.FormationPattern;

public class CircleFormation
extends FormationPattern {
    public float angleOffset = 0.0f;

    @Override
    public Vec3 calculateSlotLocation(Vec3 outLocation, int slotNumber) {
        if (this.slots > 1) {
            float angle = 360.0f * (float)slotNumber / (float)this.slots;
            float radius = this.spacing / (float)Math.sin(180.0f / (float)this.slots * ((float)Math.PI / 180));
            outLocation.set(Angles.trnsx(angle, radius), Angles.trnsy(angle, radius), angle);
        } else {
            outLocation.set(0.0f, this.spacing * 1.1f, 360.0f * (float)slotNumber);
        }
        outLocation.z += this.angleOffset;
        return outLocation;
    }
}

