/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.struct.Queue;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import mindustry.ai.types.GroundAI;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.Build;
import mindustry.world.blocks.ConstructBlock;

public class BuilderAI
extends AIController {
    public static float buildRadius = 1500.0f;
    public static float retreatDst = 110.0f;
    public static float fleeRange = 370.0f;
    public static float retreatDelay = 120.0f;
    boolean found = false;
    @Nullable
    Unit following;
    @Nullable
    Teamc enemy;
    float retreatTimer;

    @Override
    public void updateMovement() {
        if (this.target != null && this.shouldShoot()) {
            this.unit.lookAt(this.target);
        }
        this.unit.updateBuilding = true;
        if (this.following != null) {
            this.retreatTimer = 0.0f;
            if (!this.following.isValid() || !this.following.activelyBuilding()) {
                this.following = null;
                this.unit.plans.clear();
                return;
            }
            this.unit.plans.clear();
            this.unit.plans.addFirst(this.following.buildPlan());
        } else if (this.unit.buildPlan() == null) {
            Building core;
            float f;
            if (this.timer.get(3, 40.0f)) {
                this.enemy = this.target(this.unit.x, this.unit.y, fleeRange, true, true);
            }
            this.retreatTimer += Time.delta;
            if (f >= retreatDelay && this.enemy != null && (core = this.unit.closestCore()) != null && !this.unit.within(core, retreatDst)) {
                this.moveTo(core, retreatDst);
            }
        }
        if (this.unit.buildPlan() != null) {
            boolean valid;
            ConstructBlock.ConstructBuild cons;
            Building building;
            this.retreatTimer = 0.0f;
            BuildPlan req = this.unit.buildPlan();
            if (!req.breaking && this.timer.get(1, 40.0f)) {
                for (Player player : Groups.player) {
                    if (!player.isBuilder() || !player.unit().activelyBuilding() || !player.unit().buildPlan().samePos(req) || !player.unit().buildPlan().breaking) continue;
                    this.unit.plans.removeFirst();
                    return;
                }
            }
            boolean bl = req.tile() != null && (building = req.tile().build) instanceof ConstructBlock.ConstructBuild && (cons = (ConstructBlock.ConstructBuild)building) == (ConstructBlock.ConstructBuild)building && cons.cblock == req.block || (req.breaking ? Build.validBreak(this.unit.team(), req.x, req.y) : Build.validPlace(req.block, this.unit.team(), req.x, req.y, req.rotation)) ? true : (valid = false);
            if (valid) {
                this.moveTo(req.tile(), 200.0f);
            } else {
                this.unit.plans.removeFirst();
            }
        } else {
            if (this.timer.get(1, 60.0f)) {
                this.found = false;
                Units.nearby(this.unit.team, this.unit.x, this.unit.y, buildRadius, u -> {
                    if (this.found) {
                        return;
                    }
                    if (u.canBuild() && u != this.unit && u.activelyBuilding()) {
                        float dist;
                        ConstructBlock.ConstructBuild cons;
                        BuildPlan plan = u.buildPlan();
                        Building build = Vars.world.build(plan.x, plan.y);
                        Building cons$temp = build;
                        if (cons$temp instanceof ConstructBlock.ConstructBuild && (cons = (ConstructBlock.ConstructBuild)cons$temp) == (ConstructBlock.ConstructBuild)cons$temp && (dist = Math.min(cons.dst(this.unit) - 220.0f, 0.0f)) / this.unit.speed() < cons.buildCost * 0.9f) {
                            this.following = u;
                            this.found = true;
                        }
                    }
                });
            }
            float rebuildTime = (this.unit.team.rules().ai ? Mathf.lerp(15.0f, 2.0f, this.unit.team.rules().aiTier) : 2.0f) * 60.0f;
            if (!this.unit.team.data().blocks.isEmpty() && this.following == null && this.timer.get(2, rebuildTime)) {
                Queue<Teams.BlockPlan> blocks = this.unit.team.data().blocks;
                Teams.BlockPlan block = blocks.first();
                if (Vars.world.tile(block.x, block.y) != null && Vars.world.tile((int)block.x, (int)block.y).block().id == block.block) {
                    blocks.removeFirst();
                } else if (Build.validPlace(Vars.content.block(block.block), this.unit.team(), block.x, block.y, block.rotation)) {
                    this.unit.addBuild(new BuildPlan(block.x, block.y, block.rotation, Vars.content.block(block.block), block.config));
                    blocks.addLast(blocks.removeFirst());
                } else {
                    blocks.removeFirst();
                    blocks.addLast(block);
                }
            }
        }
    }

    @Override
    public AIController fallback() {
        return this.unit.type.flying ? new FlyingAI() : new GroundAI();
    }

    @Override
    public boolean useFallback() {
        return Vars.state.rules.waves && this.unit.team == Vars.state.rules.waveTeam && !this.unit.team.rules().ai;
    }

    @Override
    public boolean shouldShoot() {
        return !this.unit.isBuilding();
    }
}

