/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import mindustry.entities.Units;
import mindustry.entities.comp.Sized;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitCommand;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.meta.BlockFlag;

public class DefenderAI
extends AIController {
    @Override
    public void updateMovement() {
        if (this.target != null) {
            Sized s;
            Teamc teamc = this.target;
            this.moveTo(this.target, (teamc instanceof Sized && (s = (Sized)((Object)teamc)) == (Sized)((Object)teamc) ? s.hitSize() / 2.0f * 1.1f : 0.0f) + this.unit.hitSize / 2.0f + 15.0f, 50.0f);
            this.unit.lookAt(this.target);
        }
    }

    @Override
    protected void updateTargeting() {
        if (this.retarget()) {
            this.target = this.findTarget(this.unit.x, this.unit.y, this.unit.range(), true, true);
        }
    }

    @Override
    protected Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Unit result;
        if (this.command() != UnitCommand.rally && (result = Units.closest(this.unit.team, x, y, Math.max(range, 400.0f), u -> !u.dead() && u.type != this.unit.type, (u, tx, ty) -> -u.maxHealth + Mathf.dst2(u.x, u.y, tx, ty) / 800.0f)) != null) {
            return result;
        }
        Teamc block = this.targetFlag(this.unit.x, this.unit.y, BlockFlag.rally, false);
        if (block != null) {
            return block;
        }
        return this.unit.closestCore();
    }
}

