/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Angles;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitCommand;
import mindustry.gen.Teamc;
import mindustry.world.meta.BlockFlag;

public class FlyingAI
extends AIController {
    @Override
    public void updateMovement() {
        if (this.target != null && this.unit.hasWeapons() && this.command() == UnitCommand.attack) {
            if (!this.unit.type.circleTarget) {
                this.moveTo(this.target, this.unit.type.range * 0.8f);
                this.unit.lookAt(this.target);
            } else {
                this.attack(120.0f);
            }
        }
        if (this.target == null && this.command() == UnitCommand.attack && Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam) {
            this.moveTo(this.getClosestSpawner(), Vars.state.rules.dropZoneRadius + 120.0f);
        }
        if (this.command() == UnitCommand.rally) {
            this.moveTo(this.targetFlag(this.unit.x, this.unit.y, BlockFlag.rally, false), 60.0f);
        }
    }

    @Override
    protected Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc result = this.target(x, y, range, air, ground);
        if (result != null) {
            return result;
        }
        if (ground) {
            result = this.targetFlag(x, y, BlockFlag.generator, true);
        }
        if (result != null) {
            return result;
        }
        if (ground) {
            result = this.targetFlag(x, y, BlockFlag.core, true);
        }
        if (result != null) {
            return result;
        }
        return null;
    }

    protected void attack(float circleLength) {
        vec.set(this.target).sub(this.unit);
        float ang = this.unit.angleTo(this.target);
        float diff = Angles.angleDist(ang, this.unit.rotation());
        if (diff > 70.0f && vec.len() < circleLength) {
            vec.setAngle(this.unit.vel().angle());
        } else {
            vec.setAngle(Angles.moveToward(this.unit.vel().angle(), vec.angle(), 6.0f));
        }
        vec.setLength(this.unit.speed());
        this.unit.moveAt(vec);
    }
}

