/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.ai.formations.Formation;
import mindustry.ai.formations.FormationMember;
import mindustry.entities.units.AIController;
import mindustry.gen.Call;
import mindustry.gen.Unit;
import mindustry.world.blocks.storage.CoreBlock;

public class FormationAI
extends AIController
implements FormationMember {
    public Unit leader;
    private Vec3 target = new Vec3();
    @Nullable
    private Formation formation;

    public FormationAI(Unit leader, Formation formation) {
        this.leader = leader;
        this.formation = formation;
    }

    @Override
    public void init() {
        this.target.set(this.unit.x, this.unit.y, 0.0f);
    }

    @Override
    public void updateUnit() {
        if (this.leader == null || this.leader.dead) {
            this.unit.resetController();
            return;
        }
        if (this.unit.type.canBoost) {
            this.unit.elevation = Mathf.approachDelta(this.unit.elevation, this.unit.onSolid() ? 1.0f : (this.leader.type.canBoost ? this.leader.elevation : 0.0f), this.unit.type.riseSpeed);
        }
        this.unit.controlWeapons(true, this.leader.isShooting);
        this.unit.aim(this.leader.aimX(), this.leader.aimY());
        if (this.unit.type.rotateShooting) {
            this.unit.lookAt(this.leader.aimX(), this.leader.aimY());
        } else if (this.unit.moving()) {
            this.unit.lookAt(this.unit.vel.angle());
        }
        Vec2 realtarget = vec.set(this.target).add(this.leader.vel);
        float speed = this.unit.realSpeed() * Time.delta;
        this.unit.approach(Mathf.arrive(this.unit.x, this.unit.y, realtarget.x, realtarget.y, this.unit.vel, speed, 0.0f, speed, 1.0f).scl(1.0f / Time.delta));
        if (this.unit.canMine() && this.leader.canMine()) {
            if (this.leader.mineTile != null && this.unit.validMine(this.leader.mineTile)) {
                this.unit.mineTile(this.leader.mineTile);
                CoreBlock.CoreBuild core = this.unit.team.core();
                if (core != null && this.leader.mineTile.drop() != null && this.unit.within(core, this.unit.type.range) && !this.unit.acceptsItem(this.leader.mineTile.drop()) && core.acceptStack(this.unit.stack.item, this.unit.stack.amount, this.unit) > 0) {
                    Call.transferItemTo(this.unit, this.unit.stack.item, this.unit.stack.amount, this.unit.x, this.unit.y, core);
                    this.unit.clearItem();
                }
            } else {
                this.unit.mineTile(null);
            }
        }
        if (this.unit.canBuild() && this.leader.canBuild() && this.leader.activelyBuilding()) {
            this.unit.clearBuilding();
            this.unit.addBuild(this.leader.buildPlan());
        }
    }

    @Override
    public void removed(Unit unit) {
        if (this.formation != null) {
            this.formation.removeMember(this);
            unit.resetController();
        }
    }

    @Override
    public float formationSize() {
        return this.unit.hitSize * 1.1f;
    }

    @Override
    public boolean isBeingControlled(Unit player) {
        return this.leader == player;
    }

    @Override
    public Vec3 formationPos() {
        return this.target;
    }
}

