/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.geom.Position;
import mindustry.Vars;
import mindustry.entities.Predict;
import mindustry.entities.Units;
import mindustry.entities.units.AIController;
import mindustry.entities.units.UnitCommand;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;

public class GroundAI
extends AIController {
    @Override
    public void updateMovement() {
        Teamc target;
        Building core = this.unit.closestEnemyCore();
        if (core != null && this.unit.within(core, this.unit.range() / 1.1f + (float)(core.block.size * 8) / 2.0f)) {
            this.target = core;
            for (int i = 0; i < this.targets.length; ++i) {
                if (!this.unit.mounts[i].weapon.bullet.collidesGround) continue;
                this.targets[i] = core;
            }
        }
        if (!(core != null && this.unit.within(core, this.unit.range() * 0.5f) || this.command() != UnitCommand.attack)) {
            Tile spawner;
            boolean move = true;
            if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam && (spawner = this.getClosestSpawner()) != null && this.unit.within(spawner, Vars.state.rules.dropZoneRadius + 120.0f)) {
                move = false;
            }
            if (move) {
                this.pathfind(0);
            }
        }
        if (this.command() == UnitCommand.rally && (target = this.targetFlag(this.unit.x, this.unit.y, BlockFlag.rally, false)) != null && !this.unit.within(target, 70.0f)) {
            this.pathfind(1);
        }
        if (this.unit.type.canBoost && !this.unit.onSolid()) {
            this.unit.elevation = Mathf.approachDelta(this.unit.elevation, 0.0f, this.unit.type.riseSpeed);
        }
        if (!Units.invalidateTarget(this.target, this.unit, this.unit.range()) && this.unit.type.rotateShooting) {
            if (this.unit.type.hasWeapons()) {
                this.unit.lookAt(Predict.intercept((Position)this.unit, this.target, this.unit.type.weapons.first().bullet.speed));
            }
        } else if (this.unit.moving()) {
            this.unit.lookAt(this.unit.vel().angle());
        }
    }
}

