/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitCommand;
import mindustry.gen.Building;
import mindustry.gen.PosTeam;
import mindustry.gen.Teamc;
import mindustry.logic.LUnitControl;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;

public class LogicAI
extends AIController {
    public static final float transferDelay = 120.0f;
    public static final float logicControlTimeout = 600.0f;
    public LUnitControl control = LUnitControl.idle;
    public float moveX;
    public float moveY;
    public float moveRad;
    public float itemTimer;
    public float payTimer;
    public float controlTimer = 600.0f;
    public float targetTimer;
    @Nullable
    public Building controller;
    public BuildPlan plan = new BuildPlan();
    public ObjectMap<Object, Object> execCache = new ObjectMap();
    public LUnitControl aimControl = LUnitControl.stop;
    public boolean boost;
    public Teamc mainTarget;
    public boolean shoot;
    public PosTeam posTarget = PosTeam.create();
    private ObjectSet<Object> radars = new ObjectSet();

    @Override
    protected void updateMovement() {
        if (this.itemTimer >= 0.0f) {
            this.itemTimer -= Time.delta;
        }
        if (this.payTimer >= 0.0f) {
            this.payTimer -= Time.delta;
        }
        if (this.targetTimer > 0.0f) {
            this.targetTimer -= Time.delta;
        } else {
            this.radars.clear();
            this.targetTimer = 40.0f;
        }
        if (this.controlTimer > 0.0f && this.controller != null && this.controller.isValid()) {
            this.controlTimer -= Time.delta;
        } else {
            this.unit.resetController();
            return;
        }
        switch (this.control) {
            case move: {
                this.moveTo(Tmp.v1.set(this.moveX, this.moveY), 1.0f, 30.0f);
                break;
            }
            case approach: {
                this.moveTo(Tmp.v1.set(this.moveX, this.moveY), this.moveRad - 7.0f, 7.0f);
                break;
            }
            case pathfind: {
                Teamc target;
                Building core = this.unit.closestEnemyCore();
                if (!(core != null && this.unit.within(core, this.unit.range() * 0.5f) || this.command() != UnitCommand.attack)) {
                    Tile spawner;
                    boolean move = true;
                    if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam && (spawner = this.getClosestSpawner()) != null && this.unit.within(spawner, Vars.state.rules.dropZoneRadius + 120.0f)) {
                        move = false;
                    }
                    if (move) {
                        this.pathfind(0);
                    }
                }
                if (this.command() != UnitCommand.rally || (target = this.targetFlag(this.unit.x, this.unit.y, BlockFlag.rally, false)) == null || this.unit.within(target, 70.0f)) break;
                this.pathfind(1);
                break;
            }
            case stop: {
                this.unit.clearBuilding();
            }
        }
        if (this.unit.type.canBoost && !this.unit.type.flying) {
            this.unit.elevation = Mathf.approachDelta(this.unit.elevation, Mathf.num(this.boost || this.unit.onSolid()), 0.08f);
        }
        if (!this.shoot) {
            this.unit.lookAt(this.unit.prefRotation());
        } else if (this.unit.hasWeapons() && this.unit.mounts.length > 0) {
            this.unit.lookAt(this.unit.mounts[0].aimX, this.unit.mounts[0].aimY);
        }
    }

    public boolean checkTargetTimer(Object radar) {
        return this.radars.add(radar);
    }

    @Override
    protected void moveTo(Position target, float circleLength, float smooth) {
        if (target == null) {
            return;
        }
        vec.set(target).sub(this.unit);
        float length = circleLength <= 0.001f ? 1.0f : Mathf.clamp((this.unit.dst(target) - circleLength) / smooth, -1.0f, 1.0f);
        vec.setLength(this.unit.realSpeed() * length);
        if (length < -0.5f) {
            vec.rotate(180.0f);
        } else if (length < 0.0f) {
            vec.setZero();
        }
        if (vec.isNaN() || vec.isInfinite()) {
            return;
        }
        this.unit.approach(vec);
    }

    @Override
    protected boolean checkTarget(Teamc target, float x, float y, float range) {
        return false;
    }

    @Override
    protected boolean retarget() {
        return true;
    }

    @Override
    protected boolean invalid(Teamc target) {
        return false;
    }

    @Override
    protected boolean shouldShoot() {
        return this.shoot && (!this.unit.type.canBoost || !this.boost);
    }

    @Override
    protected Teamc target(float x, float y, float range, boolean air, boolean ground) {
        Teamc teamc;
        switch (this.aimControl) {
            case target: {
                teamc = this.posTarget;
                break;
            }
            case targetp: {
                teamc = this.mainTarget;
                break;
            }
            default: {
                teamc = null;
            }
        }
        return teamc;
    }
}

