/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import mindustry.Vars;
import mindustry.ai.types.GroundAI;
import mindustry.entities.Predict;
import mindustry.entities.Units;
import mindustry.entities.units.UnitCommand;
import mindustry.gen.Building;
import mindustry.gen.Hitboxc;
import mindustry.gen.Teamc;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;

public class SuicideAI
extends GroundAI {
    static boolean blockedByBlock;

    @Override
    public void updateUnit() {
        if (Units.invalidateTarget(this.target, this.unit.team, this.unit.x, this.unit.y, Float.MAX_VALUE)) {
            this.target = null;
        }
        if (this.retarget()) {
            this.target = this.target(this.unit.x, this.unit.y, this.unit.range(), this.unit.type.targetAir, this.unit.type.targetGround);
        }
        Building core = this.unit.closestEnemyCore();
        boolean rotate = false;
        boolean shoot = false;
        boolean moveToTarget = false;
        if (!Units.invalidateTarget(this.target, this.unit, this.unit.range()) && this.unit.hasWeapons()) {
            Building build;
            Building b;
            Teamc teamc;
            rotate = true;
            shoot = this.unit.within(this.target, this.unit.type.weapons.first().bullet.range() + ((teamc = this.target) instanceof Building && (b = (Building)teamc) == (Building)teamc ? (float)(b.block.size * 8) / 2.0f : ((Hitboxc)((Object)this.target)).hitSize() / 2.0f));
            if (this.unit.type.hasWeapons()) {
                this.unit.aimLook(Predict.intercept((Position)this.unit, this.target, this.unit.type.weapons.first().bullet.speed));
            }
            if (!((teamc = this.target) instanceof Building) || (build = (Building)teamc) != (Building)teamc || build.block.group != BlockGroup.walls && build.block.group != BlockGroup.liquids && build.block.group != BlockGroup.transportation) {
                blockedByBlock = false;
                boolean blocked = Vars.world.raycast(this.unit.tileX(), this.unit.tileY(), this.target.tileX(), this.target.tileY(), (x, y) -> {
                    int n = 0;
                    Point2[] point2Array = Geometry.d4c;
                    int n2 = point2Array.length;
                    if (n < n2) {
                        Point2 p = point2Array[n];
                        Tile tile = Vars.world.tile(x + p.x, y + p.y);
                        if (tile != null && tile.build == this.target) {
                            return false;
                        }
                        if (tile != null && tile.build != null && tile.build.team != this.unit.team()) {
                            blockedByBlock = true;
                            return true;
                        }
                        return tile == null || tile.solid();
                    }
                    return false;
                });
                if (blockedByBlock) {
                    shoot = true;
                }
                if (!blocked) {
                    moveToTarget = true;
                    this.unit.moveAt(vec.set(this.target).sub(this.unit).limit(this.unit.speed()));
                }
            }
        }
        if (!moveToTarget) {
            if (this.command() == UnitCommand.rally) {
                Teamc target = this.targetFlag(this.unit.x, this.unit.y, BlockFlag.rally, false);
                if (target != null && !this.unit.within(target, 70.0f)) {
                    this.pathfind(1);
                }
            } else if (this.command() == UnitCommand.attack && core != null) {
                this.pathfind(0);
            }
            if (this.unit.moving()) {
                this.unit.lookAt(this.unit.vel().angle());
            }
        }
        this.unit.controlWeapons(rotate, shoot);
    }

    @Override
    protected Teamc target(float x, float y, float range, boolean air, boolean ground) {
        return Units.closestTarget(this.unit.team, x, y, range, u -> u.checkTarget(air, ground), t -> ground && !(t.block instanceof Conveyor) && !(t.block instanceof Conduit));
    }
}

