/*
 * Decompiled with CFR 0.152.
 */
package mindustry.async;

import arc.Core;
import arc.Events;
import arc.struct.Seq;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mindustry.Vars;
import mindustry.async.AsyncProcess;
import mindustry.async.PhysicsProcess;
import mindustry.game.EventType;

public class AsyncCore {
    private final Seq<AsyncProcess> processes = Seq.with(new PhysicsProcess());
    private final Seq<Future<?>> futures = new Seq();
    private final ExecutorService executor;

    public AsyncCore() {
        this.executor = Executors.newFixedThreadPool(this.processes.size, r -> {
            Thread thread = new Thread(r, "AsyncLogic-Thread");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((t, e) -> Core.app.post(() -> {
                throw new RuntimeException(e);
            }));
            return thread;
        });
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.complete();
            for (AsyncProcess p : this.processes) {
                p.init();
            }
        });
        Events.on(EventType.ResetEvent.class, e -> {
            this.complete();
            for (AsyncProcess p : this.processes) {
                p.reset();
            }
        });
    }

    public void begin() {
        if (Vars.state.isPlaying()) {
            for (AsyncProcess p : this.processes) {
                p.begin();
            }
            this.futures.clear();
            for (AsyncProcess p : this.processes) {
                if (!p.shouldProcess()) continue;
                this.futures.add(this.executor.submit(p::process));
            }
        }
    }

    public void end() {
        if (Vars.state.isPlaying()) {
            this.complete();
            for (AsyncProcess p : this.processes) {
                p.end();
            }
        }
    }

    private void complete() {
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        this.futures.clear();
    }
}

