/*
 * Decompiled with CFR 0.152.
 */
package mindustry.async;

import arc.math.Mathf;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.async.AsyncProcess;
import mindustry.entities.EntityGroup;
import mindustry.gen.Groups;
import mindustry.gen.Physicsc;
import mindustry.gen.Unit;

public class PhysicsProcess
implements AsyncProcess {
    private static final int layers = 3;
    private static final int layerGround = 0;
    private static final int layerLegs = 1;
    private static final int layerFlying = 2;
    private PhysicsWorld physics;
    private Seq<PhysicRef> refs = new Seq(false);
    private EntityGroup<Unit> group = Groups.unit;

    @Override
    public void begin() {
        if (this.physics == null) {
            return;
        }
        this.refs.removeAll(ref -> {
            if (!ref.entity.isAdded()) {
                this.physics.remove(ref.body);
                ref.entity.physref(null);
                return true;
            }
            return false;
        });
        for (Unit entity : this.group) {
            if (entity.type == null) continue;
            if (entity.physref == null) {
                PhysicsWorld.PhysicsBody body = new PhysicsWorld.PhysicsBody();
                body.x = entity.x();
                body.y = entity.y();
                body.mass = entity.mass();
                body.radius = entity.hitSize() / 2.0f;
                PhysicRef ref2 = new PhysicRef(entity, body);
                this.refs.add(ref2);
                entity.physref = ref2;
                this.physics.add(body);
            }
            PhysicRef ref3 = entity.physref;
            ref3.body.layer = entity.type.allowLegStep ? 1 : (entity.isGrounded() ? 0 : 2);
            ref3.x = entity.x();
            ref3.y = entity.y();
        }
    }

    @Override
    public void process() {
        if (this.physics == null) {
            return;
        }
        for (PhysicRef ref : this.refs) {
            ref.body.x = ref.x;
            ref.body.y = ref.y;
        }
        this.physics.update();
    }

    @Override
    public void end() {
        if (this.physics == null) {
            return;
        }
        for (PhysicRef ref : this.refs) {
            Physicsc entity = ref.entity;
            entity.move(ref.body.x - ref.x, ref.body.y - ref.y);
        }
    }

    @Override
    public void reset() {
        if (this.physics != null) {
            this.refs.clear();
            this.physics = null;
        }
    }

    @Override
    public void init() {
        this.reset();
        this.physics = new PhysicsWorld(Vars.world.getQuadBounds(new Rect()));
    }

    public static class PhysicsWorld {
        private static final float scl = 1.25f;
        private final QuadTree<PhysicsBody>[] trees = new QuadTree[3];
        private final Seq<PhysicsBody> bodies = new Seq(false, 16, PhysicsBody.class);
        private final Seq<PhysicsBody> seq = new Seq(PhysicsBody.class);
        private final Rect rect = new Rect();
        private final Vec2 vec = new Vec2();

        public PhysicsWorld(Rect bounds) {
            for (int i = 0; i < 3; ++i) {
                this.trees[i] = new QuadTree(new Rect(bounds));
            }
        }

        public void add(PhysicsBody body) {
            this.bodies.add(body);
        }

        public void remove(PhysicsBody body) {
            this.bodies.remove(body);
        }

        public void update() {
            PhysicsBody body;
            int i;
            for (i = 0; i < 3; ++i) {
                this.trees[i].clear();
            }
            for (i = 0; i < this.bodies.size; ++i) {
                body = ((PhysicsBody[])this.bodies.items)[i];
                body.collided = false;
                this.trees[body.layer].insert(body);
            }
            for (i = 0; i < this.bodies.size; ++i) {
                body = ((PhysicsBody[])this.bodies.items)[i];
                body.hitbox(this.rect);
                this.seq.size = 0;
                this.trees[body.layer].intersect(this.rect, this.seq);
                for (int j = 0; j < this.seq.size; ++j) {
                    PhysicsBody other = ((PhysicsBody[])this.seq.items)[j];
                    if (other == body || other.collided) continue;
                    float rs = body.radius + other.radius;
                    float dst = Mathf.dst(body.x, body.y, other.x, other.y);
                    if (!(dst < rs)) continue;
                    this.vec.set(body.x - other.x, body.y - other.y).setLength(rs - dst);
                    float ms = body.mass + other.mass;
                    float m1 = other.mass / ms;
                    float m2 = body.mass / ms;
                    body.x += this.vec.x * m1 / 1.25f;
                    body.y += this.vec.y * m1 / 1.25f;
                    other.x -= this.vec.x * m2 / 1.25f;
                    other.y -= this.vec.y * m2 / 1.25f;
                }
                body.collided = true;
            }
        }

        public static class PhysicsBody
        implements QuadTree.QuadTreeObject {
            public float x;
            public float y;
            public float radius;
            public float mass;
            public int layer = 0;
            public boolean collided = false;

            @Override
            public void hitbox(Rect out) {
                out.setCentered(this.x, this.y, this.radius * 2.0f, this.radius * 2.0f);
            }
        }
    }

    public static class PhysicRef {
        public Physicsc entity;
        public PhysicsWorld.PhysicsBody body;
        public float x;
        public float y;

        public PhysicRef(Physicsc entity, PhysicsWorld.PhysicsBody body) {
            this.entity = entity;
            this.body = body;
        }
    }
}

