/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.graphics.Color;
import arc.struct.EnumSet;
import arc.struct.Seq;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.ctype.ContentList;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.LightningBulletType;
import mindustry.entities.bullet.PointBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.gen.Sounds;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.type.LiquidStack;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.campaign.Accelerator;
import mindustry.world.blocks.campaign.LaunchPad;
import mindustry.world.blocks.defense.Door;
import mindustry.world.blocks.defense.ForceProjector;
import mindustry.world.blocks.defense.MendProjector;
import mindustry.world.blocks.defense.OverdriveProjector;
import mindustry.world.blocks.defense.ShockMine;
import mindustry.world.blocks.defense.Thruster;
import mindustry.world.blocks.defense.Wall;
import mindustry.world.blocks.defense.turrets.ItemTurret;
import mindustry.world.blocks.defense.turrets.LaserTurret;
import mindustry.world.blocks.defense.turrets.LiquidTurret;
import mindustry.world.blocks.defense.turrets.PointDefenseTurret;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.distribution.ArmoredConveyor;
import mindustry.world.blocks.distribution.BufferedItemBridge;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.distribution.MassDriver;
import mindustry.world.blocks.distribution.OverflowGate;
import mindustry.world.blocks.distribution.PayloadConveyor;
import mindustry.world.blocks.distribution.PayloadRouter;
import mindustry.world.blocks.distribution.Router;
import mindustry.world.blocks.distribution.Sorter;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.blocks.environment.AirBlock;
import mindustry.world.blocks.environment.Boulder;
import mindustry.world.blocks.environment.Cliff;
import mindustry.world.blocks.environment.DoubleOverlayFloor;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.environment.ShallowLiquid;
import mindustry.world.blocks.environment.SpawnBlock;
import mindustry.world.blocks.environment.StaticTree;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.environment.TreeBlock;
import mindustry.world.blocks.experimental.BlockForge;
import mindustry.world.blocks.experimental.BlockLoader;
import mindustry.world.blocks.experimental.BlockUnloader;
import mindustry.world.blocks.legacy.LegacyMechPad;
import mindustry.world.blocks.legacy.LegacyUnitFactory;
import mindustry.world.blocks.liquid.ArmoredConduit;
import mindustry.world.blocks.liquid.Conduit;
import mindustry.world.blocks.liquid.LiquidBridge;
import mindustry.world.blocks.liquid.LiquidExtendingBridge;
import mindustry.world.blocks.liquid.LiquidJunction;
import mindustry.world.blocks.liquid.LiquidRouter;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.blocks.logic.MemoryBlock;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.blocks.logic.SwitchBlock;
import mindustry.world.blocks.power.Battery;
import mindustry.world.blocks.power.BurnerGenerator;
import mindustry.world.blocks.power.DecayGenerator;
import mindustry.world.blocks.power.ImpactReactor;
import mindustry.world.blocks.power.LightBlock;
import mindustry.world.blocks.power.NuclearReactor;
import mindustry.world.blocks.power.PowerDiode;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.blocks.power.SingleTypeGenerator;
import mindustry.world.blocks.power.SolarGenerator;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.blocks.production.AttributeSmelter;
import mindustry.world.blocks.production.Cultivator;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.production.Fracker;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.GenericSmelter;
import mindustry.world.blocks.production.Incinerator;
import mindustry.world.blocks.production.LiquidConverter;
import mindustry.world.blocks.production.Pump;
import mindustry.world.blocks.production.Separator;
import mindustry.world.blocks.production.SolidPump;
import mindustry.world.blocks.sandbox.ItemSource;
import mindustry.world.blocks.sandbox.ItemVoid;
import mindustry.world.blocks.sandbox.LiquidSource;
import mindustry.world.blocks.sandbox.LiquidVoid;
import mindustry.world.blocks.sandbox.PowerSource;
import mindustry.world.blocks.sandbox.PowerVoid;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.blocks.storage.Unloader;
import mindustry.world.blocks.units.CommandCenter;
import mindustry.world.blocks.units.Reconstructor;
import mindustry.world.blocks.units.RepairPoint;
import mindustry.world.blocks.units.ResupplyPoint;
import mindustry.world.blocks.units.UnitFactory;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.draw.DrawAnimation;
import mindustry.world.draw.DrawGlow;
import mindustry.world.draw.DrawMixer;
import mindustry.world.draw.DrawRotator;
import mindustry.world.draw.DrawWeave;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BlockGroup;
import mindustry.world.meta.BuildVisibility;

public class Blocks
implements ContentList {
    public static Block air;
    public static Block spawn;
    public static Block cliff;
    public static Block deepwater;
    public static Block water;
    public static Block taintedWater;
    public static Block tar;
    public static Block slag;
    public static Block stone;
    public static Block craters;
    public static Block charr;
    public static Block sand;
    public static Block darksand;
    public static Block dirt;
    public static Block mud;
    public static Block ice;
    public static Block snow;
    public static Block darksandTaintedWater;
    public static Block space;
    public static Block dacite;
    public static Block stoneWall;
    public static Block dirtWall;
    public static Block sporeWall;
    public static Block iceWall;
    public static Block daciteWall;
    public static Block sporePine;
    public static Block snowPine;
    public static Block pine;
    public static Block shrubs;
    public static Block whiteTree;
    public static Block whiteTreeDead;
    public static Block sporeCluster;
    public static Block iceSnow;
    public static Block sandWater;
    public static Block darksandWater;
    public static Block duneWall;
    public static Block sandWall;
    public static Block moss;
    public static Block sporeMoss;
    public static Block shale;
    public static Block shaleWall;
    public static Block shaleBoulder;
    public static Block sandBoulder;
    public static Block daciteBoulder;
    public static Block boulder;
    public static Block snowBoulder;
    public static Block basaltBoulder;
    public static Block grass;
    public static Block salt;
    public static Block metalFloor;
    public static Block metalFloorDamaged;
    public static Block metalFloor2;
    public static Block metalFloor3;
    public static Block metalFloor5;
    public static Block basalt;
    public static Block magmarock;
    public static Block hotrock;
    public static Block snowWall;
    public static Block saltWall;
    public static Block darkPanel1;
    public static Block darkPanel2;
    public static Block darkPanel3;
    public static Block darkPanel4;
    public static Block darkPanel5;
    public static Block darkPanel6;
    public static Block darkMetal;
    public static Block pebbles;
    public static Block tendrils;
    public static Block oreCopper;
    public static Block oreLead;
    public static Block oreScrap;
    public static Block oreCoal;
    public static Block oreTitanium;
    public static Block oreThorium;
    public static Block siliconSmelter;
    public static Block siliconCrucible;
    public static Block kiln;
    public static Block graphitePress;
    public static Block plastaniumCompressor;
    public static Block multiPress;
    public static Block phaseWeaver;
    public static Block surgeSmelter;
    public static Block pyratiteMixer;
    public static Block blastMixer;
    public static Block cryofluidMixer;
    public static Block melter;
    public static Block separator;
    public static Block disassembler;
    public static Block sporePress;
    public static Block pulverizer;
    public static Block incinerator;
    public static Block coalCentrifuge;
    public static Block powerSource;
    public static Block powerVoid;
    public static Block itemSource;
    public static Block itemVoid;
    public static Block liquidSource;
    public static Block liquidVoid;
    public static Block illuminator;
    public static Block copperWall;
    public static Block copperWallLarge;
    public static Block titaniumWall;
    public static Block titaniumWallLarge;
    public static Block plastaniumWall;
    public static Block plastaniumWallLarge;
    public static Block thoriumWall;
    public static Block thoriumWallLarge;
    public static Block door;
    public static Block doorLarge;
    public static Block phaseWall;
    public static Block phaseWallLarge;
    public static Block surgeWall;
    public static Block surgeWallLarge;
    public static Block mender;
    public static Block mendProjector;
    public static Block overdriveProjector;
    public static Block overdriveDome;
    public static Block forceProjector;
    public static Block shockMine;
    public static Block scrapWall;
    public static Block scrapWallLarge;
    public static Block scrapWallHuge;
    public static Block scrapWallGigantic;
    public static Block thruster;
    public static Block conveyor;
    public static Block titaniumConveyor;
    public static Block plastaniumConveyor;
    public static Block armoredConveyor;
    public static Block distributor;
    public static Block junction;
    public static Block itemBridge;
    public static Block phaseConveyor;
    public static Block sorter;
    public static Block invertedSorter;
    public static Block router;
    public static Block overflowGate;
    public static Block underflowGate;
    public static Block massDriver;
    public static Block payloadConveyor;
    public static Block payloadRouter;
    public static Block mechanicalPump;
    public static Block rotaryPump;
    public static Block thermalPump;
    public static Block conduit;
    public static Block pulseConduit;
    public static Block platedConduit;
    public static Block liquidRouter;
    public static Block liquidTank;
    public static Block liquidJunction;
    public static Block bridgeConduit;
    public static Block phaseConduit;
    public static Block combustionGenerator;
    public static Block thermalGenerator;
    public static Block steamGenerator;
    public static Block differentialGenerator;
    public static Block rtgGenerator;
    public static Block solarPanel;
    public static Block largeSolarPanel;
    public static Block thoriumReactor;
    public static Block impactReactor;
    public static Block battery;
    public static Block batteryLarge;
    public static Block powerNode;
    public static Block powerNodeLarge;
    public static Block surgeTower;
    public static Block diode;
    public static Block mechanicalDrill;
    public static Block pneumaticDrill;
    public static Block laserDrill;
    public static Block blastDrill;
    public static Block waterExtractor;
    public static Block oilExtractor;
    public static Block cultivator;
    public static Block coreShard;
    public static Block coreFoundation;
    public static Block coreNucleus;
    public static Block vault;
    public static Block container;
    public static Block unloader;
    public static Block duo;
    public static Block scatter;
    public static Block scorch;
    public static Block hail;
    public static Block arc;
    public static Block wave;
    public static Block lancer;
    public static Block swarmer;
    public static Block salvo;
    public static Block fuse;
    public static Block ripple;
    public static Block cyclone;
    public static Block foreshadow;
    public static Block spectre;
    public static Block meltdown;
    public static Block segment;
    public static Block parallax;
    public static Block tsunami;
    public static Block commandCenter;
    public static Block groundFactory;
    public static Block airFactory;
    public static Block navalFactory;
    public static Block additiveReconstructor;
    public static Block multiplicativeReconstructor;
    public static Block exponentialReconstructor;
    public static Block tetrativeReconstructor;
    public static Block repairPoint;
    public static Block resupplyPoint;
    public static Block message;
    public static Block switchBlock;
    public static Block microProcessor;
    public static Block logicProcessor;
    public static Block hyperProcessor;
    public static Block largeLogicDisplay;
    public static Block logicDisplay;
    public static Block memoryCell;
    public static Block memoryBank;
    public static Block launchPad;
    public static Block launchPadLarge;
    public static Block interplanetaryAccelerator;
    public static Block blockForge;
    public static Block blockLoader;
    public static Block blockUnloader;

    @Override
    public void load() {
        air = new AirBlock("air");
        spawn = new SpawnBlock("spawn");
        cliff = new Cliff("cliff"){
            {
                this.inEditor = false;
                this.saveData = true;
            }
        };
        for (int i = 1; i <= 16; ++i) {
            new ConstructBlock(i);
        }
        deepwater = new Floor("deepwater"){
            {
                this.speedMultiplier = 0.2f;
                this.variants = 0;
                this.liquidDrop = Liquids.water;
                this.liquidMultiplier = 1.5f;
                this.isLiquid = true;
                this.status = StatusEffects.wet;
                this.statusDuration = 120.0f;
                this.drownTime = 140.0f;
                this.cacheLayer = CacheLayer.water;
                this.albedo = 0.5f;
            }
        };
        water = new Floor("water"){
            {
                this.speedMultiplier = 0.5f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 90.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
                this.albedo = 0.5f;
            }
        };
        taintedWater = new Floor("tainted-water"){
            {
                this.speedMultiplier = 0.17f;
                this.variants = 0;
                this.status = StatusEffects.wet;
                this.statusDuration = 140.0f;
                this.drownTime = 120.0f;
                this.liquidDrop = Liquids.water;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.water;
                this.albedo = 0.5f;
                this.attributes.set(Attribute.spores, 0.15f);
            }
        };
        darksandTaintedWater = new ShallowLiquid("darksand-tainted-water"){
            {
                this.speedMultiplier = 0.75f;
                this.statusDuration = 60.0f;
                this.albedo = 0.5f;
                this.attributes.set(Attribute.spores, 0.1f);
            }
        };
        sandWater = new ShallowLiquid("sand-water"){
            {
                this.speedMultiplier = 0.8f;
                this.statusDuration = 50.0f;
                this.albedo = 0.5f;
            }
        };
        darksandWater = new ShallowLiquid("darksand-water"){
            {
                this.speedMultiplier = 0.8f;
                this.statusDuration = 50.0f;
                this.albedo = 0.5f;
            }
        };
        tar = new Floor("tar"){
            {
                this.drownTime = 150.0f;
                this.status = StatusEffects.tarred;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 0.19f;
                this.variants = 0;
                this.liquidDrop = Liquids.oil;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.tar;
            }
        };
        slag = new Floor("slag"){
            {
                this.drownTime = 150.0f;
                this.status = StatusEffects.melting;
                this.statusDuration = 240.0f;
                this.speedMultiplier = 0.19f;
                this.variants = 0;
                this.liquidDrop = Liquids.slag;
                this.isLiquid = true;
                this.cacheLayer = CacheLayer.slag;
                this.attributes.set(Attribute.heat, 0.85f);
                this.emitLight = true;
                this.lightRadius = 40.0f;
                this.lightColor = Color.orange.cpy().a(0.38f);
            }
        };
        space = new Floor("space"){
            {
                this.cacheLayer = CacheLayer.space;
                this.placeableOn = false;
                this.solid = true;
                this.variants = 0;
            }
        };
        stone = new Floor("stone");
        craters = new Floor("craters"){
            {
                this.variants = 3;
                this.blendGroup = stone;
            }
        };
        charr = new Floor("char"){
            {
                this.blendGroup = stone;
            }
        };
        basalt = new Floor("basalt"){
            {
                this.attributes.set(Attribute.water, -0.25f);
            }
        };
        hotrock = new Floor("hotrock"){
            {
                this.attributes.set(Attribute.heat, 0.5f);
                this.attributes.set(Attribute.water, -0.5f);
                this.blendGroup = basalt;
                this.emitLight = true;
                this.lightRadius = 30.0f;
                this.lightColor = Color.orange.cpy().a(0.15f);
            }
        };
        magmarock = new Floor("magmarock"){
            {
                this.attributes.set(Attribute.heat, 0.75f);
                this.attributes.set(Attribute.water, -0.75f);
                this.updateEffect = Fx.magmasmoke;
                this.blendGroup = basalt;
                this.emitLight = true;
                this.lightRadius = 50.0f;
                this.lightColor = Color.orange.cpy().a(0.3f);
            }
        };
        sand = new Floor("sand"){
            {
                this.itemDrop = Items.sand;
                this.playerUnmineable = true;
                this.attributes.set(Attribute.oil, 0.7f);
            }
        };
        darksand = new Floor("darksand"){
            {
                this.itemDrop = Items.sand;
                this.playerUnmineable = true;
                this.attributes.set(Attribute.oil, 1.5f);
            }
        };
        dirt = new Floor("dirt");
        mud = new Floor("mud"){
            {
                this.speedMultiplier = 0.6f;
                this.variants = 3;
                this.status = StatusEffects.muddy;
                this.statusDuration = 30.0f;
                this.attributes.set(Attribute.water, 1.0f);
                this.cacheLayer = CacheLayer.mud;
                this.albedo = 0.35f;
                this.walkSound = Sounds.mud;
                this.walkSoundVolume = 0.08f;
                this.walkSoundPitchMin = 0.4f;
                this.walkSoundPitchMax = 0.5f;
            }
        };
        ((ShallowLiquid)darksandTaintedWater).set(taintedWater, darksand);
        ((ShallowLiquid)sandWater).set(water, sand);
        ((ShallowLiquid)darksandWater).set(water, darksand);
        dacite = new Floor("dacite");
        grass = new Floor("grass"){
            {
                this.attributes.set(Attribute.water, 0.1f);
            }
        };
        salt = new Floor("salt"){
            {
                this.variants = 0;
                this.attributes.set(Attribute.water, -0.3f);
                this.attributes.set(Attribute.oil, 0.3f);
            }
        };
        snow = new Floor("snow"){
            {
                this.attributes.set(Attribute.water, 0.2f);
            }
        };
        ice = new Floor("ice"){
            {
                this.dragMultiplier = 0.35f;
                this.speedMultiplier = 0.9f;
                this.attributes.set(Attribute.water, 0.4f);
            }
        };
        iceSnow = new Floor("ice-snow"){
            {
                this.dragMultiplier = 0.6f;
                this.variants = 3;
                this.attributes.set(Attribute.water, 0.3f);
            }
        };
        shale = new Floor("shale"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.oil, 1.0f);
            }
        };
        stoneWall = new StaticWall("stone-wall"){
            {
                this.variants = 2;
            }
        };
        sporeWall = new StaticWall("spore-wall"){
            {
                this.variants = 2;
            }
        };
        dirtWall = new StaticWall("dirt-wall"){
            {
                this.variants = 2;
            }
        };
        daciteWall = new StaticWall("dacite-wall"){
            {
                this.variants = 2;
            }
        };
        iceWall = new StaticWall("ice-wall"){
            {
                this.variants = 2;
                Blocks.iceSnow.asFloor().wall = this;
            }
        };
        snowWall = new StaticWall("snow-wall"){
            {
                this.variants = 2;
            }
        };
        duneWall = new StaticWall("dune-wall"){
            {
                this.variants = 2;
                Blocks.darksandWater.asFloor().wall = Blocks.darksandTaintedWater.asFloor().wall = this;
                Blocks.basalt.asFloor().wall = Blocks.darksandTaintedWater.asFloor().wall;
            }
        };
        sandWall = new StaticWall("sand-wall"){
            {
                this.variants = 2;
                Blocks.water.asFloor().wall = Blocks.deepwater.asFloor().wall = this;
                Blocks.sandWater.asFloor().wall = Blocks.deepwater.asFloor().wall;
            }
        };
        saltWall = new StaticWall("salt-wall");
        shrubs = new StaticWall("shrubs");
        shaleWall = new StaticWall("shale-wall"){
            {
                this.variants = 2;
            }
        };
        sporePine = new StaticTree("spore-pine"){
            {
                this.variants = 0;
            }
        };
        snowPine = new StaticTree("snow-pine"){
            {
                this.variants = 0;
            }
        };
        pine = new StaticTree("pine"){
            {
                this.variants = 0;
            }
        };
        whiteTreeDead = new TreeBlock("white-tree-dead");
        whiteTree = new TreeBlock("white-tree");
        sporeCluster = new Boulder("spore-cluster"){
            {
                this.variants = 3;
            }
        };
        boulder = new Boulder("boulder"){
            {
                this.variants = 2;
            }
        };
        snowBoulder = new Boulder("snow-boulder"){
            {
                this.variants = 2;
                Blocks.iceSnow.asFloor().decoration = Blocks.salt.asFloor().decoration = this;
                Blocks.ice.asFloor().decoration = Blocks.salt.asFloor().decoration;
                Blocks.snow.asFloor().decoration = Blocks.salt.asFloor().decoration;
            }
        };
        shaleBoulder = new Boulder("shale-boulder"){
            {
                this.variants = 2;
            }
        };
        sandBoulder = new Boulder("sand-boulder"){
            {
                this.variants = 2;
            }
        };
        daciteBoulder = new Boulder("dacite-boulder"){
            {
                this.variants = 2;
            }
        };
        basaltBoulder = new Boulder("basalt-boulder"){
            {
                this.variants = 2;
            }
        };
        moss = new Floor("moss"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.spores, 0.15f);
                this.wall = sporePine;
            }
        };
        sporeMoss = new Floor("spore-moss"){
            {
                this.variants = 3;
                this.attributes.set(Attribute.spores, 0.3f);
                this.wall = sporeWall;
            }
        };
        metalFloor = new Floor("metal-floor"){
            {
                this.variants = 0;
            }
        };
        metalFloorDamaged = new Floor("metal-floor-damaged"){
            {
                this.variants = 3;
            }
        };
        metalFloor2 = new Floor("metal-floor-2"){
            {
                this.variants = 0;
            }
        };
        metalFloor3 = new Floor("metal-floor-3"){
            {
                this.variants = 0;
            }
        };
        metalFloor5 = new Floor("metal-floor-5"){
            {
                this.variants = 0;
            }
        };
        darkPanel1 = new Floor("dark-panel-1"){
            {
                this.variants = 0;
            }
        };
        darkPanel2 = new Floor("dark-panel-2"){
            {
                this.variants = 0;
            }
        };
        darkPanel3 = new Floor("dark-panel-3"){
            {
                this.variants = 0;
            }
        };
        darkPanel4 = new Floor("dark-panel-4"){
            {
                this.variants = 0;
            }
        };
        darkPanel5 = new Floor("dark-panel-5"){
            {
                this.variants = 0;
            }
        };
        darkPanel6 = new Floor("dark-panel-6"){
            {
                this.variants = 0;
            }
        };
        darkMetal = new StaticWall("dark-metal");
        pebbles = new DoubleOverlayFloor("pebbles");
        tendrils = new OverlayFloor("tendrils");
        oreCopper = new OreBlock(Items.copper){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.81f;
                this.oreScale = 23.47619f;
            }
        };
        oreLead = new OreBlock(Items.lead){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.828f;
                this.oreScale = 23.952381f;
            }
        };
        oreScrap = new OreBlock(Items.scrap);
        oreCoal = new OreBlock(Items.coal){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.846f;
                this.oreScale = 24.428572f;
            }
        };
        oreTitanium = new OreBlock(Items.titanium){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.864f;
                this.oreScale = 24.904762f;
            }
        };
        oreThorium = new OreBlock(Items.thorium){
            {
                this.oreDefault = true;
                this.oreThreshold = 0.882f;
                this.oreScale = 25.380953f;
            }
        };
        graphitePress = new GenericCrafter("graphite-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 75, Items.lead, 30));
                this.craftEffect = Fx.pulverizeMedium;
                this.outputItem = new ItemStack(Items.graphite, 1);
                this.craftTime = 90.0f;
                this.size = 2;
                this.hasItems = true;
                this.consumes.item(Items.coal, 2);
            }
        };
        multiPress = new GenericCrafter("multi-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 100, Items.silicon, 25, Items.lead, 100, Items.graphite, 50));
                this.craftEffect = Fx.pulverizeMedium;
                this.outputItem = new ItemStack(Items.graphite, 2);
                this.craftTime = 30.0f;
                this.size = 3;
                this.hasItems = true;
                this.hasLiquids = true;
                this.hasPower = true;
                this.consumes.power(1.8f);
                this.consumes.item(Items.coal, 3);
                this.consumes.liquid(Liquids.water, 0.1f);
            }
        };
        siliconSmelter = new GenericSmelter("silicon-smelter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 25));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.silicon, 1);
                this.craftTime = 40.0f;
                this.size = 2;
                this.hasPower = true;
                this.hasLiquids = false;
                this.flameColor = Color.valueOf("ffef99");
                this.consumes.items(ItemStack.with(Items.coal, 1, Items.sand, 2));
                this.consumes.power(0.5f);
            }
        };
        siliconCrucible = new AttributeSmelter("silicon-crucible"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 120, Items.metaglass, 80, Items.plastanium, 35, Items.silicon, 60));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.silicon, 8);
                this.craftTime = 90.0f;
                this.size = 3;
                this.hasPower = true;
                this.hasLiquids = false;
                this.flameColor = Color.valueOf("ffef99");
                this.itemCapacity = 30;
                this.boostScale = 0.15f;
                this.consumes.items(ItemStack.with(Items.coal, 4, Items.sand, 6, Items.pyratite, 1));
                this.consumes.power(4.0f);
            }
        };
        kiln = new GenericSmelter("kiln"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 60, Items.graphite, 30, Items.lead, 30));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.metaglass, 1);
                this.craftTime = 30.0f;
                this.size = 2;
                this.hasItems = true;
                this.hasPower = true;
                this.flameColor = Color.valueOf("ffc099");
                this.consumes.items(ItemStack.with(Items.lead, 1, Items.sand, 1));
                this.consumes.power(0.6f);
            }
        };
        plastaniumCompressor = new GenericCrafter("plastanium-compressor"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 80, Items.lead, 115, Items.graphite, 60, Items.titanium, 80));
                this.hasItems = true;
                this.liquidCapacity = 60.0f;
                this.craftTime = 60.0f;
                this.outputItem = new ItemStack(Items.plastanium, 1);
                this.size = 2;
                this.health = 320;
                this.hasLiquids = true;
                this.hasPower = true;
                this.craftEffect = Fx.formsmoke;
                this.updateEffect = Fx.plasticburn;
                this.drawer = new DrawGlow();
                this.consumes.liquid(Liquids.oil, 0.25f);
                this.consumes.power(3.0f);
                this.consumes.item(Items.titanium, 2);
            }
        };
        phaseWeaver = new GenericCrafter("phase-weaver"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 130, Items.lead, 120, Items.thorium, 75));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.phaseFabric, 1);
                this.craftTime = 120.0f;
                this.size = 2;
                this.hasPower = true;
                this.drawer = new DrawWeave();
                this.ambientSound = Sounds.techloop;
                this.ambientSoundVolume = 0.02f;
                this.consumes.items(ItemStack.with(Items.thorium, 4, Items.sand, 10));
                this.consumes.power(5.0f);
                this.itemCapacity = 20;
            }
        };
        surgeSmelter = new GenericSmelter("alloy-smelter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.silicon, 80, Items.lead, 80, Items.thorium, 70));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.surgeAlloy, 1);
                this.craftTime = 75.0f;
                this.size = 3;
                this.hasPower = true;
                this.itemCapacity = 20;
                this.consumes.power(4.0f);
                this.consumes.items(ItemStack.with(Items.copper, 3, Items.lead, 4, Items.titanium, 2, Items.silicon, 3));
            }
        };
        cryofluidMixer = new LiquidConverter("cryofluid-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 65, Items.silicon, 40, Items.titanium, 60));
                this.outputLiquid = new LiquidStack(Liquids.cryofluid, 0.2f);
                this.craftTime = 120.0f;
                this.size = 2;
                this.hasPower = true;
                this.hasItems = true;
                this.hasLiquids = true;
                this.rotate = false;
                this.solid = true;
                this.outputsLiquid = true;
                this.drawer = new DrawMixer();
                this.consumes.power(1.0f);
                this.consumes.item(Items.titanium);
                this.consumes.liquid(Liquids.water, 0.2f);
            }
        };
        pyratiteMixer = new GenericSmelter("pyratite-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 50, Items.lead, 25));
                this.flameColor = Color.clear;
                this.hasItems = true;
                this.hasPower = true;
                this.outputItem = new ItemStack(Items.pyratite, 1);
                this.size = 2;
                this.consumes.power(0.2f);
                this.consumes.items(ItemStack.with(Items.coal, 1, Items.lead, 2, Items.sand, 2));
            }
        };
        blastMixer = new GenericCrafter("blast-mixer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 30, Items.titanium, 20));
                this.hasItems = true;
                this.hasPower = true;
                this.outputItem = new ItemStack(Items.blastCompound, 1);
                this.size = 2;
                this.consumes.items(ItemStack.with(Items.pyratite, 1, Items.sporePod, 1));
                this.consumes.power(0.4f);
            }
        };
        melter = new GenericCrafter("melter"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 35, Items.graphite, 45));
                this.health = 200;
                this.outputLiquid = new LiquidStack(Liquids.slag, 2.0f);
                this.craftTime = 10.0f;
                this.hasPower = true;
                this.hasLiquids = true;
                this.consumes.power(1.0f);
                this.consumes.item(Items.scrap, 1);
            }
        };
        separator = new Separator("separator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.titanium, 25));
                this.results = ItemStack.with(Items.copper, 5, Items.lead, 3, Items.graphite, 2, Items.titanium, 2);
                this.hasPower = true;
                this.craftTime = 35.0f;
                this.size = 2;
                this.consumes.power(1.0f);
                this.consumes.liquid(Liquids.slag, 0.07f);
            }
        };
        disassembler = new Separator("disassembler"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.graphite, 140, Items.titanium, 100, Items.silicon, 150, Items.surgeAlloy, 70));
                this.results = ItemStack.with(Items.sand, 4, Items.graphite, 2, Items.titanium, 2, Items.thorium, 1);
                this.hasPower = true;
                this.craftTime = 15.0f;
                this.size = 3;
                this.itemCapacity = 20;
                this.consumes.power(4.0f);
                this.consumes.item(Items.scrap);
                this.consumes.liquid(Liquids.slag, 0.12f);
            }
        };
        sporePress = new GenericCrafter("spore-press"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.lead, 35, Items.silicon, 30));
                this.liquidCapacity = 60.0f;
                this.craftTime = 20.0f;
                this.outputLiquid = new LiquidStack(Liquids.oil, 6.0f);
                this.size = 2;
                this.health = 320;
                this.hasLiquids = true;
                this.hasPower = true;
                this.craftEffect = Fx.none;
                this.drawer = new DrawAnimation();
                this.consumes.item(Items.sporePod, 1);
                this.consumes.power(0.7f);
            }
        };
        pulverizer = new GenericCrafter("pulverizer"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.copper, 30, Items.lead, 25));
                this.outputItem = new ItemStack(Items.sand, 1);
                this.craftEffect = Fx.pulverize;
                this.craftTime = 40.0f;
                this.updateEffect = Fx.pulverizeSmall;
                this.hasPower = true;
                this.hasItems = true;
                this.drawer = new DrawRotator();
                this.ambientSound = Sounds.grinding;
                this.ambientSoundVolume = 0.025f;
                this.consumes.item(Items.scrap, 1);
                this.consumes.power(0.5f);
            }
        };
        coalCentrifuge = new GenericCrafter("coal-centrifuge"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.titanium, 20, Items.graphite, 40, Items.lead, 30));
                this.craftEffect = Fx.smeltsmoke;
                this.outputItem = new ItemStack(Items.coal, 1);
                this.craftTime = 30.0f;
                this.size = 2;
                this.hasLiquids = true;
                this.hasItems = true;
                this.hasPower = true;
                this.consumes.liquid(Liquids.oil, 0.1f);
                this.consumes.power(0.7f);
            }
        };
        incinerator = new Incinerator("incinerator"){
            {
                this.requirements(Category.crafting, ItemStack.with(Items.graphite, 5, Items.lead, 15));
                this.health = 90;
                this.consumes.power(0.5f);
            }
        };
        final int wallHealthMultiplier = 4;
        copperWall = new Wall("copper-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.copper, 6));
                this.health = 80 * wallHealthMultiplier;
            }
        };
        copperWallLarge = new Wall("copper-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.copperWall.requirements, 4.0f));
                this.health = 320 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        titaniumWall = new Wall("titanium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.titanium, 6));
                this.health = 110 * wallHealthMultiplier;
            }
        };
        titaniumWallLarge = new Wall("titanium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.titaniumWall.requirements, 4.0f));
                this.health = 110 * wallHealthMultiplier * 4;
                this.size = 2;
            }
        };
        plastaniumWall = new Wall("plastanium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.plastanium, 5, Items.metaglass, 2));
                this.health = 130 * wallHealthMultiplier;
                this.insulated = true;
                this.absorbLasers = true;
                this.schematicPriority = 10;
            }
        };
        plastaniumWallLarge = new Wall("plastanium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.plastaniumWall.requirements, 4.0f));
                this.health = 130 * wallHealthMultiplier * 4;
                this.size = 2;
                this.insulated = true;
                this.absorbLasers = true;
                this.schematicPriority = 10;
            }
        };
        thoriumWall = new Wall("thorium-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.thorium, 6));
                this.health = 200 * wallHealthMultiplier;
            }
        };
        thoriumWallLarge = new Wall("thorium-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.thoriumWall.requirements, 4.0f));
                this.health = 200 * wallHealthMultiplier * 4;
                this.size = 2;
            }
        };
        phaseWall = new Wall("phase-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.phaseFabric, 6));
                this.health = 150 * wallHealthMultiplier;
                this.chanceDeflect = 10.0f;
                this.flashHit = true;
            }
        };
        phaseWallLarge = new Wall("phase-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.phaseWall.requirements, 4.0f));
                this.health = 600 * wallHealthMultiplier;
                this.size = 2;
                this.chanceDeflect = 10.0f;
                this.flashHit = true;
            }
        };
        surgeWall = new Wall("surge-wall"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.surgeAlloy, 6));
                this.health = 230 * wallHealthMultiplier;
                this.lightningChance = 0.05f;
            }
        };
        surgeWallLarge = new Wall("surge-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.surgeWall.requirements, 4.0f));
                this.health = 920 * wallHealthMultiplier;
                this.size = 2;
                this.lightningChance = 0.05f;
            }
        };
        door = new Door("door"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.with(Items.titanium, 6, Items.silicon, 4));
                this.health = 100 * wallHealthMultiplier;
            }
        };
        doorLarge = new Door("door-large"){
            {
                super(name);
                this.requirements(Category.defense, ItemStack.mult(Blocks.door.requirements, 4.0f));
                this.openfx = Fx.dooropenlarge;
                this.closefx = Fx.doorcloselarge;
                this.health = 400 * wallHealthMultiplier;
                this.size = 2;
            }
        };
        scrapWall = new Wall("scrap-wall"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.with(Items.scrap, 6));
                this.health = 60 * wallHealthMultiplier;
                this.variants = 5;
            }
        };
        scrapWallLarge = new Wall("scrap-wall-large"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.mult(Blocks.scrapWall.requirements, 4.0f));
                this.health = 240 * wallHealthMultiplier;
                this.size = 2;
                this.variants = 4;
            }
        };
        scrapWallHuge = new Wall("scrap-wall-huge"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.mult(Blocks.scrapWall.requirements, 9.0f));
                this.health = 540 * wallHealthMultiplier;
                this.size = 3;
                this.variants = 3;
            }
        };
        scrapWallGigantic = new Wall("scrap-wall-gigantic"){
            {
                super(name);
                this.requirements(Category.defense, BuildVisibility.sandboxOnly, ItemStack.mult(Blocks.scrapWall.requirements, 16.0f));
                this.health = 960 * wallHealthMultiplier;
                this.size = 4;
            }
        };
        thruster = new Thruster("thruster"){
            {
                super(name);
                this.health = 880 * wallHealthMultiplier;
                this.size = 4;
            }
        };
        mender = new MendProjector("mender"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 30, Items.copper, 25));
                this.consumes.power(0.3f);
                this.size = 1;
                this.reload = 200.0f;
                this.range = 40.0f;
                this.healPercent = 4.0f;
                this.phaseBoost = 4.0f;
                this.phaseRangeBoost = 20.0f;
                this.health = 80;
                this.consumes.item(Items.silicon).boost();
            }
        };
        mendProjector = new MendProjector("mend-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 25, Items.silicon, 40));
                this.consumes.power(1.5f);
                this.size = 2;
                this.reload = 250.0f;
                this.range = 85.0f;
                this.healPercent = 11.0f;
                this.phaseBoost = 15.0f;
                this.health = 80 * this.size * this.size;
                this.consumes.item(Items.phaseFabric).boost();
            }
        };
        overdriveProjector = new OverdriveProjector("overdrive-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 75, Items.silicon, 75, Items.plastanium, 30));
                this.consumes.power(3.5f);
                this.size = 2;
                this.consumes.item(Items.phaseFabric).boost();
            }
        };
        overdriveDome = new OverdriveProjector("overdrive-dome"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 200, Items.titanium, 130, Items.silicon, 130, Items.plastanium, 80, Items.surgeAlloy, 120));
                this.consumes.power(10.0f);
                this.size = 3;
                this.range = 200.0f;
                this.speedBoost = 2.5f;
                this.useTime = 300.0f;
                this.hasBoost = false;
                this.consumes.items(ItemStack.with(Items.phaseFabric, 1, Items.silicon, 1));
            }
        };
        forceProjector = new ForceProjector("force-projector"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 100, Items.titanium, 75, Items.silicon, 125));
                this.size = 3;
                this.phaseRadiusBoost = 80.0f;
                this.radius = 101.7f;
                this.shieldHealth = 750.0f;
                this.cooldownNormal = 1.5f;
                this.cooldownLiquid = 1.2f;
                this.cooldownBrokenBase = 0.35f;
                this.consumes.item(Items.phaseFabric).boost();
                this.consumes.power(4.0f);
            }
        };
        shockMine = new ShockMine("shock-mine"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.lead, 25, Items.silicon, 12));
                this.hasShadow = false;
                this.health = 50;
                this.damage = 25.0f;
                this.tileDamage = 7.0f;
                this.length = 10;
                this.tendrils = 4;
            }
        };
        conveyor = new Conveyor("conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 1), true);
                this.health = 45;
                this.speed = 0.03f;
                this.displayedSpeed = 4.2f;
                this.buildCostMultiplier = 2.0f;
            }
        };
        titaniumConveyor = new Conveyor("titanium-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 1, Items.lead, 1, Items.titanium, 1));
                this.health = 65;
                this.speed = 0.08f;
                this.displayedSpeed = 11.0f;
            }
        };
        plastaniumConveyor = new StackConveyor("plastanium-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.plastanium, 1, Items.silicon, 1, Items.graphite, 1));
                this.health = 75;
                this.speed = 0.06666667f;
                this.itemCapacity = 10;
            }
        };
        armoredConveyor = new ArmoredConveyor("armored-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.plastanium, 1, Items.thorium, 1, Items.metaglass, 1));
                this.health = 180;
                this.speed = 0.08f;
                this.displayedSpeed = 11.0f;
            }
        };
        junction = new Junction("junction"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 2), true);
                this.speed = 26.0f;
                this.capacity = 6;
                this.health = 30;
                this.buildCostMultiplier = 6.0f;
            }
        };
        itemBridge = new BufferedItemBridge("bridge-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 6, Items.copper, 6));
                this.range = 4;
                this.speed = 74.0f;
                this.bufferCapacity = 14;
            }
        };
        phaseConveyor = new ItemBridge("phase-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.phaseFabric, 5, Items.silicon, 7, Items.lead, 10, Items.graphite, 10));
                this.range = 12;
                this.canOverdrive = false;
                this.hasPower = true;
                this.consumes.power(0.3f);
            }
        };
        sorter = new Sorter("sorter"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 2));
                this.buildCostMultiplier = 3.0f;
            }
        };
        invertedSorter = new Sorter("inverted-sorter"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 2));
                this.buildCostMultiplier = 3.0f;
                this.invert = true;
            }
        };
        router = new Router("router"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.copper, 3));
                this.buildCostMultiplier = 4.0f;
            }
        };
        distributor = new Router("distributor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 4, Items.copper, 4));
                this.size = 2;
            }
        };
        overflowGate = new OverflowGate("overflow-gate"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 4));
                this.buildCostMultiplier = 3.0f;
            }
        };
        underflowGate = new OverflowGate("underflow-gate"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.lead, 2, Items.copper, 4));
                this.buildCostMultiplier = 3.0f;
                this.invert = true;
            }
        };
        massDriver = new MassDriver("mass-driver"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.titanium, 125, Items.silicon, 75, Items.lead, 125, Items.thorium, 50));
                this.size = 3;
                this.itemCapacity = 120;
                this.reloadTime = 200.0f;
                this.range = 440.0f;
                this.consumes.power(1.75f);
            }
        };
        payloadConveyor = new PayloadConveyor("payload-conveyor"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.graphite, 10, Items.copper, 20));
                this.canOverdrive = false;
            }
        };
        payloadRouter = new PayloadRouter("payload-router"){
            {
                this.requirements(Category.distribution, ItemStack.with(Items.graphite, 15, Items.copper, 20));
                this.canOverdrive = false;
            }
        };
        mechanicalPump = new Pump("mechanical-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 15, Items.metaglass, 10));
                this.pumpAmount = 0.11f;
            }
        };
        rotaryPump = new Pump("rotary-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 70, Items.metaglass, 50, Items.silicon, 20, Items.titanium, 35));
                this.pumpAmount = 0.2f;
                this.consumes.power(0.3f);
                this.liquidCapacity = 30.0f;
                this.hasPower = true;
                this.size = 2;
            }
        };
        thermalPump = new Pump("thermal-pump"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.copper, 80, Items.metaglass, 90, Items.silicon, 30, Items.titanium, 40, Items.thorium, 35));
                this.pumpAmount = 0.22f;
                this.consumes.power(1.3f);
                this.liquidCapacity = 40.0f;
                this.hasPower = true;
                this.size = 3;
            }
        };
        conduit = new Conduit("conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.metaglass, 1));
                this.health = 45;
            }
        };
        pulseConduit = new Conduit("pulse-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.titanium, 2, Items.metaglass, 1));
                this.liquidCapacity = 16.0f;
                this.liquidPressure = 1.025f;
                this.health = 90;
            }
        };
        platedConduit = new ArmoredConduit("plated-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.thorium, 2, Items.metaglass, 1, Items.plastanium, 1));
                this.liquidCapacity = 16.0f;
                this.liquidPressure = 1.025f;
                this.health = 220;
            }
        };
        liquidRouter = new LiquidRouter("liquid-router"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.metaglass, 2));
                this.liquidCapacity = 20.0f;
            }
        };
        liquidTank = new LiquidRouter("liquid-tank"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.titanium, 25, Items.metaglass, 25));
                this.size = 3;
                this.liquidCapacity = 1500.0f;
                this.health = 500;
            }
        };
        liquidJunction = new LiquidJunction("liquid-junction"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 2, Items.metaglass, 2));
            }
        };
        bridgeConduit = new LiquidExtendingBridge("bridge-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.graphite, 4, Items.metaglass, 8));
                this.range = 4;
                this.hasPower = false;
            }
        };
        phaseConduit = new LiquidBridge("phase-conduit"){
            {
                this.requirements(Category.liquid, ItemStack.with(Items.phaseFabric, 5, Items.silicon, 7, Items.metaglass, 20, Items.titanium, 10));
                this.range = 12;
                this.hasPower = true;
                this.canOverdrive = false;
                this.consumes.power(0.3f);
            }
        };
        powerNode = new PowerNode("power-node"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 1, Items.lead, 3));
                this.maxNodes = 10;
                this.laserRange = 6.0f;
            }
        };
        powerNodeLarge = new PowerNode("power-node-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 5, Items.lead, 10, Items.silicon, 3));
                this.size = 2;
                this.maxNodes = 15;
                this.laserRange = 9.5f;
            }
        };
        surgeTower = new PowerNode("surge-tower"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 7, Items.lead, 10, Items.silicon, 15, Items.surgeAlloy, 15));
                this.size = 2;
                this.maxNodes = 2;
                this.laserRange = 40.0f;
            }
        };
        diode = new PowerDiode("diode"){
            {
                this.requirements(Category.power, ItemStack.with(Items.silicon, 10, Items.plastanium, 5, Items.metaglass, 10));
            }
        };
        battery = new Battery("battery"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 5, Items.lead, 20));
                this.consumes.powerBuffered(4000.0f);
            }
        };
        batteryLarge = new Battery("battery-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.titanium, 20, Items.lead, 40, Items.silicon, 20));
                this.size = 3;
                this.consumes.powerBuffered(50000.0f);
            }
        };
        combustionGenerator = new BurnerGenerator("combustion-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 25, Items.lead, 15));
                this.powerProduction = 1.0f;
                this.itemDuration = 120.0f;
                this.ambientSound = Sounds.smelter;
                this.ambientSoundVolume = 0.03f;
            }
        };
        thermalGenerator = new ThermalGenerator("thermal-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 40, Items.graphite, 35, Items.lead, 50, Items.silicon, 35, Items.metaglass, 40));
                this.powerProduction = 1.8f;
                this.generateEffect = Fx.redgeneratespark;
                this.size = 2;
                this.floating = true;
                this.ambientSound = Sounds.hum;
                this.ambientSoundVolume = 0.06f;
            }
        };
        steamGenerator = new BurnerGenerator("steam-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 35, Items.graphite, 25, Items.lead, 40, Items.silicon, 30));
                this.powerProduction = 5.5f;
                this.itemDuration = 90.0f;
                this.consumes.liquid(Liquids.water, 0.1f);
                this.hasLiquids = true;
                this.size = 2;
                this.ambientSound = Sounds.smelter;
                this.ambientSoundVolume = 0.06f;
            }
        };
        differentialGenerator = new SingleTypeGenerator("differential-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.copper, 70, Items.titanium, 50, Items.lead, 100, Items.silicon, 65, Items.metaglass, 50));
                this.powerProduction = 18.0f;
                this.itemDuration = 220.0f;
                this.hasLiquids = true;
                this.hasItems = true;
                this.size = 3;
                this.ambientSound = Sounds.steam;
                this.ambientSoundVolume = 0.03f;
                this.consumes.item(Items.pyratite).optional(true, false);
                this.consumes.liquid(Liquids.cryofluid, 0.1f);
            }
        };
        rtgGenerator = new DecayGenerator("rtg-generator"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 100, Items.silicon, 75, Items.phaseFabric, 25, Items.plastanium, 75, Items.thorium, 50));
                this.size = 2;
                this.powerProduction = 4.5f;
                this.itemDuration = 840.0f;
            }
        };
        solarPanel = new SolarGenerator("solar-panel"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 10, Items.silicon, 15));
                this.powerProduction = 0.1f;
            }
        };
        largeSolarPanel = new SolarGenerator("solar-panel-large"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 80, Items.silicon, 110, Items.phaseFabric, 15));
                this.size = 3;
                this.powerProduction = 1.3f;
            }
        };
        thoriumReactor = new NuclearReactor("thorium-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 300, Items.silicon, 200, Items.graphite, 150, Items.thorium, 150, Items.metaglass, 50));
                this.ambientSound = Sounds.hum;
                this.ambientSoundVolume = 0.24f;
                this.size = 3;
                this.health = 700;
                this.itemDuration = 360.0f;
                this.powerProduction = 15.0f;
                this.consumes.item(Items.thorium);
                this.heating = 0.02f;
                this.consumes.liquid(Liquids.cryofluid, this.heating / this.coolantPower).update(false);
            }
        };
        impactReactor = new ImpactReactor("impact-reactor"){
            {
                this.requirements(Category.power, ItemStack.with(Items.lead, 500, Items.silicon, 300, Items.graphite, 400, Items.thorium, 100, Items.surgeAlloy, 250, Items.metaglass, 250));
                this.size = 4;
                this.health = 900;
                this.powerProduction = 130.0f;
                this.itemDuration = 140.0f;
                this.ambientSound = Sounds.pulse;
                this.ambientSoundVolume = 0.07f;
                this.consumes.power(25.0f);
                this.consumes.item(Items.blastCompound);
                this.consumes.liquid(Liquids.cryofluid, 0.25f);
            }
        };
        mechanicalDrill = new Drill("mechanical-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 12), true);
                this.tier = 2;
                this.drillTime = 600.0f;
                this.size = 2;
                this.consumes.liquid(Liquids.water, 0.05f).boost();
            }
        };
        pneumaticDrill = new Drill("pneumatic-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 18, Items.graphite, 10));
                this.tier = 3;
                this.drillTime = 400.0f;
                this.size = 2;
                this.consumes.liquid(Liquids.water, 0.06f).boost();
            }
        };
        laserDrill = new Drill("laser-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 35, Items.graphite, 30, Items.silicon, 30, Items.titanium, 20));
                this.drillTime = 280.0f;
                this.size = 3;
                this.hasPower = true;
                this.tier = 4;
                this.updateEffect = Fx.pulverizeMedium;
                this.drillEffect = Fx.mineBig;
                this.consumes.power(1.1f);
                this.consumes.liquid(Liquids.water, 0.08f).boost();
            }
        };
        blastDrill = new Drill("blast-drill"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 65, Items.silicon, 60, Items.titanium, 50, Items.thorium, 75));
                this.drillTime = 280.0f;
                this.size = 4;
                this.drawRim = true;
                this.hasPower = true;
                this.tier = 5;
                this.updateEffect = Fx.pulverizeRed;
                this.updateEffectChance = 0.03f;
                this.drillEffect = Fx.mineHuge;
                this.rotateSpeed = 6.0f;
                this.warmupSpeed = 0.01f;
                this.liquidBoostIntensity = 1.8f;
                this.consumes.power(3.0f);
                this.consumes.liquid(Liquids.water, 0.1f).boost();
            }
        };
        waterExtractor = new SolidPump("water-extractor"){
            {
                this.requirements(Category.production, ItemStack.with(Items.metaglass, 30, Items.graphite, 30, Items.lead, 30));
                this.result = Liquids.water;
                this.pumpAmount = 0.11f;
                this.size = 2;
                this.liquidCapacity = 30.0f;
                this.rotateSpeed = 1.4f;
                this.attribute = Attribute.water;
                this.consumes.power(1.5f);
            }
        };
        cultivator = new Cultivator("cultivator"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 25, Items.lead, 25, Items.silicon, 10));
                this.outputItem = new ItemStack(Items.sporePod, 1);
                this.craftTime = 140.0f;
                this.size = 2;
                this.hasLiquids = true;
                this.hasPower = true;
                this.hasItems = true;
                this.consumes.power(0.9f);
                this.consumes.liquid(Liquids.water, 0.2f);
            }
        };
        oilExtractor = new Fracker("oil-extractor"){
            {
                this.requirements(Category.production, ItemStack.with(Items.copper, 150, Items.graphite, 175, Items.lead, 115, Items.thorium, 115, Items.silicon, 75));
                this.result = Liquids.oil;
                this.updateEffect = Fx.pulverize;
                this.liquidCapacity = 50.0f;
                this.updateEffectChance = 0.05f;
                this.pumpAmount = 0.25f;
                this.size = 3;
                this.liquidCapacity = 30.0f;
                this.attribute = Attribute.oil;
                this.baseEfficiency = 0.0f;
                this.itemUseTime = 60.0f;
                this.consumes.item(Items.sand);
                this.consumes.power(3.0f);
                this.consumes.liquid(Liquids.water, 0.15f);
            }
        };
        coreShard = new CoreBlock("core-shard"){
            {
                this.requirements(Category.effect, BuildVisibility.editorOnly, ItemStack.with(Items.copper, 1000, Items.lead, 800));
                this.alwaysUnlocked = true;
                this.unitType = UnitTypes.alpha;
                this.health = 1100;
                this.itemCapacity = 4000;
                this.size = 3;
                this.unitCapModifier = 8;
            }
        };
        coreFoundation = new CoreBlock("core-foundation"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.copper, 3000, Items.lead, 3000, Items.silicon, 2000));
                this.unitType = UnitTypes.beta;
                this.health = 3500;
                this.itemCapacity = 9000;
                this.size = 4;
                this.unitCapModifier = 16;
                this.researchCostMultiplier = 0.04f;
            }
        };
        coreNucleus = new CoreBlock("core-nucleus"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.copper, 8000, Items.lead, 8000, Items.silicon, 5000, Items.thorium, 4000));
                this.unitType = UnitTypes.gamma;
                this.health = 6000;
                this.itemCapacity = 13000;
                this.size = 5;
                this.unitCapModifier = 24;
                this.researchCostMultiplier = 0.06f;
            }
        };
        vault = new StorageBlock("vault"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 250, Items.thorium, 125));
                this.size = 3;
                this.itemCapacity = 1000;
            }
        };
        container = new StorageBlock("container"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 100));
                this.size = 2;
                this.itemCapacity = 300;
            }
        };
        unloader = new Unloader("unloader"){
            {
                this.requirements(Category.effect, ItemStack.with(Items.titanium, 25, Items.silicon, 30));
                this.speed = 6.0f;
                this.group = BlockGroup.transportation;
            }
        };
        duo = new ItemTurret("duo"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 35), true);
                this.ammo(Items.copper, Bullets.standardCopper, Items.graphite, Bullets.standardDense, Items.pyratite, Bullets.standardIncendiary, Items.silicon, Bullets.standardHoming);
                this.spread = 4.0f;
                this.shots = 2;
                this.alternate = true;
                this.reloadTime = 20.0f;
                this.restitution = 0.03f;
                this.range = 100.0f;
                this.shootCone = 15.0f;
                this.ammoUseEffect = Fx.casing1;
                this.health = 250;
                this.inaccuracy = 2.0f;
                this.rotateSpeed = 10.0f;
            }
        };
        scatter = new ItemTurret("scatter"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 85, Items.lead, 45));
                this.ammo(Items.scrap, Bullets.flakScrap, Items.lead, Bullets.flakLead, Items.metaglass, Bullets.flakGlass);
                this.reloadTime = 18.0f;
                this.range = 160.0f;
                this.size = 2;
                this.burstSpacing = 5.0f;
                this.shots = 2;
                this.targetGround = false;
                this.recoilAmount = 2.0f;
                this.rotateSpeed = 15.0f;
                this.inaccuracy = 17.0f;
                this.shootCone = 35.0f;
                this.health = 200 * this.size * this.size;
                this.shootSound = Sounds.shootSnap;
            }
        };
        scorch = new ItemTurret("scorch"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 25, Items.graphite, 22));
                this.ammo(Items.coal, Bullets.basicFlame, Items.pyratite, Bullets.pyraFlame);
                this.recoilAmount = 0.0f;
                this.reloadTime = 6.0f;
                this.coolantMultiplier = 1.5f;
                this.range = 60.0f;
                this.shootCone = 50.0f;
                this.targetAir = false;
                this.ammoUseEffect = Fx.none;
                this.health = 400;
                this.shootSound = Sounds.flame;
            }
        };
        hail = new ItemTurret("hail"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 40, Items.graphite, 17));
                this.ammo(Items.graphite, Bullets.artilleryDense, Items.silicon, Bullets.artilleryHoming, Items.pyratite, Bullets.artilleryIncendiary);
                this.targetAir = false;
                this.reloadTime = 60.0f;
                this.recoilAmount = 2.0f;
                this.range = 230.0f;
                this.inaccuracy = 1.0f;
                this.shootCone = 10.0f;
                this.health = 260;
                this.shootSound = Sounds.bang;
            }
        };
        wave = new LiquidTurret("wave"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.metaglass, 45, Items.lead, 75));
                this.ammo(Liquids.water, Bullets.waterShot, Liquids.slag, Bullets.slagShot, Liquids.cryofluid, Bullets.cryoShot, Liquids.oil, Bullets.oilShot);
                this.size = 2;
                this.recoilAmount = 0.0f;
                this.reloadTime = 2.0f;
                this.inaccuracy = 5.0f;
                this.shootCone = 50.0f;
                this.liquidCapacity = 10.0f;
                this.shootEffect = Fx.shootLiquid;
                this.range = 110.0f;
                this.health = 250 * this.size * this.size;
                this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret, BlockFlag.extinguisher});
            }
        };
        lancer = new PowerTurret("lancer"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 60, Items.lead, 70, Items.silicon, 50));
                this.range = 165.0f;
                this.chargeTime = 40.0f;
                this.chargeMaxDelay = 30.0f;
                this.chargeEffects = 7;
                this.recoilAmount = 2.0f;
                this.reloadTime = 80.0f;
                this.cooldown = 0.03f;
                this.powerUse = 6.0f;
                this.shootShake = 2.0f;
                this.shootEffect = Fx.lancerLaserShoot;
                this.smokeEffect = Fx.none;
                this.chargeEffect = Fx.lancerLaserCharge;
                this.chargeBeginEffect = Fx.lancerLaserChargeBegin;
                this.heatColor = Color.red;
                this.size = 2;
                this.health = 280 * this.size * this.size;
                this.targetAir = false;
                this.shootSound = Sounds.laser;
                this.shootType = new LaserBulletType(140.0f){
                    {
                        this.colors = new Color[]{Pal.lancerLaser.cpy().a(0.4f), Pal.lancerLaser, Color.white};
                        this.hitEffect = Fx.hitLancer;
                        this.despawnEffect = Fx.none;
                        this.hitSize = 4.0f;
                        this.lifetime = 16.0f;
                        this.drawSize = 400.0f;
                        this.collidesAir = false;
                        this.length = 173.0f;
                    }
                };
            }
        };
        arc = new PowerTurret("arc"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 50, Items.lead, 50));
                this.shootType = new LightningBulletType(){
                    {
                        this.damage = 20.0f;
                        this.lightningLength = 25;
                        this.collidesAir = false;
                    }
                };
                this.reloadTime = 35.0f;
                this.shootCone = 40.0f;
                this.rotateSpeed = 8.0f;
                this.powerUse = 3.3f;
                this.targetAir = false;
                this.range = 90.0f;
                this.shootEffect = Fx.lightningShoot;
                this.heatColor = Color.red;
                this.recoilAmount = 1.0f;
                this.size = 1;
                this.health = 260;
                this.shootSound = Sounds.spark;
            }
        };
        parallax = new TractorBeamTurret("parallax"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.silicon, 120, Items.titanium, 90, Items.graphite, 30));
                this.hasPower = true;
                this.size = 2;
                this.force = 8.0f;
                this.scaledForce = 7.0f;
                this.range = 230.0f;
                this.damage = 0.3f;
                this.health = 160 * this.size * this.size;
                this.rotateSpeed = 10.0f;
                this.consumes.powerCond(3.0f, e -> e.target != null);
            }
        };
        swarmer = new ItemTurret("swarmer"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.graphite, 35, Items.titanium, 35, Items.plastanium, 45, Items.silicon, 30));
                this.ammo(Items.blastCompound, Bullets.missileExplosive, Items.pyratite, Bullets.missileIncendiary, Items.surgeAlloy, Bullets.missileSurge);
                this.reloadTime = 30.0f;
                this.shots = 4;
                this.burstSpacing = 5.0f;
                this.inaccuracy = 10.0f;
                this.range = 200.0f;
                this.xRand = 6.0f;
                this.size = 2;
                this.health = 300 * this.size * this.size;
                this.shootSound = Sounds.missile;
            }
        };
        salvo = new ItemTurret("salvo"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 100, Items.graphite, 90, Items.titanium, 60));
                this.ammo(Items.copper, Bullets.standardCopper, Items.graphite, Bullets.standardDense, Items.pyratite, Bullets.standardIncendiary, Items.silicon, Bullets.standardHoming, Items.thorium, Bullets.standardThorium);
                this.size = 2;
                this.range = 150.0f;
                this.reloadTime = 38.0f;
                this.restitution = 0.03f;
                this.ammoEjectBack = 3.0f;
                this.cooldown = 0.03f;
                this.recoilAmount = 3.0f;
                this.shootShake = 1.0f;
                this.burstSpacing = 3.0f;
                this.shots = 4;
                this.ammoUseEffect = Fx.casing2;
                this.health = 240 * this.size * this.size;
                this.shootSound = Sounds.shootBig;
            }
        };
        segment = new PointDefenseTurret("segment"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.silicon, 130, Items.thorium, 80, Items.phaseFabric, 40));
                this.health = 250 * this.size * this.size;
                this.range = 180.0f;
                this.hasPower = true;
                this.consumes.powerCond(8.0f, b -> b.target != null);
                this.size = 2;
                this.shootLength = 5.0f;
                this.bulletDamage = 30.0f;
                this.reloadTime = 9.0f;
            }
        };
        tsunami = new LiquidTurret("tsunami"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.metaglass, 100, Items.lead, 400, Items.titanium, 250, Items.thorium, 100));
                this.ammo(Liquids.water, Bullets.heavyWaterShot, Liquids.slag, Bullets.heavySlagShot, Liquids.cryofluid, Bullets.heavyCryoShot, Liquids.oil, Bullets.heavyOilShot);
                this.size = 3;
                this.reloadTime = 2.0f;
                this.shots = 2;
                this.velocityInaccuracy = 0.1f;
                this.inaccuracy = 4.0f;
                this.recoilAmount = 1.0f;
                this.restitution = 0.04f;
                this.shootCone = 45.0f;
                this.liquidCapacity = 40.0f;
                this.shootEffect = Fx.shootLiquid;
                this.range = 190.0f;
                this.health = 250 * this.size * this.size;
                this.flags = EnumSet.of((Enum[])new BlockFlag[]{BlockFlag.turret, BlockFlag.extinguisher});
            }
        };
        fuse = new ItemTurret("fuse"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 225, Items.graphite, 225, Items.thorium, 100));
                this.reloadTime = 35.0f;
                this.shootShake = 4.0f;
                this.range = 90.0f;
                this.recoilAmount = 5.0f;
                this.shots = 3;
                this.spread = 20.0f;
                this.restitution = 0.1f;
                this.shootCone = 30.0f;
                this.size = 3;
                this.health = 220 * this.size * this.size;
                this.shootSound = Sounds.shotgun;
                final float brange = this.range + 10.0f;
                this.ammo(Items.titanium, new ShrapnelBulletType(){
                    {
                        this.length = brange;
                        this.damage = 66.0f;
                        this.ammoMultiplier = 4.0f;
                        this.width = 17.0f;
                        this.reloadMultiplier = 1.3f;
                    }
                }, Items.thorium, new ShrapnelBulletType(){
                    {
                        this.length = brange;
                        this.damage = 105.0f;
                        this.ammoMultiplier = 5.0f;
                        this.toColor = Pal.thoriumPink;
                        this.shootEffect = this.smokeEffect = Fx.thoriumShoot;
                    }
                });
            }
        };
        ripple = new ItemTurret("ripple"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 150, Items.graphite, 135, Items.titanium, 60));
                this.ammo(Items.graphite, Bullets.artilleryDense, Items.silicon, Bullets.artilleryHoming, Items.pyratite, Bullets.artilleryIncendiary, Items.blastCompound, Bullets.artilleryExplosive, Items.plastanium, Bullets.artilleryPlastic);
                this.targetAir = false;
                this.size = 3;
                this.shots = 4;
                this.inaccuracy = 12.0f;
                this.reloadTime = 60.0f;
                this.ammoEjectBack = 5.0f;
                this.ammoUseEffect = Fx.casing3Double;
                this.ammoPerShot = 2;
                this.cooldown = 0.03f;
                this.velocityInaccuracy = 0.2f;
                this.restitution = 0.02f;
                this.recoilAmount = 6.0f;
                this.shootShake = 2.0f;
                this.range = 290.0f;
                this.minRange = 50.0f;
                this.health = 130 * this.size * this.size;
                this.shootSound = Sounds.artillery;
            }
        };
        cyclone = new ItemTurret("cyclone"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 200, Items.titanium, 125, Items.plastanium, 80));
                this.ammo(Items.metaglass, Bullets.fragGlass, Items.blastCompound, Bullets.fragExplosive, Items.plastanium, Bullets.fragPlastic, Items.surgeAlloy, Bullets.fragSurge);
                this.xRand = 4.0f;
                this.reloadTime = 8.0f;
                this.range = 200.0f;
                this.size = 3;
                this.recoilAmount = 3.0f;
                this.rotateSpeed = 10.0f;
                this.inaccuracy = 10.0f;
                this.shootCone = 30.0f;
                this.shootSound = Sounds.shootSnap;
                this.health = 145 * this.size * this.size;
            }
        };
        foreshadow = new ItemTurret("foreshadow"){
            {
                this.range = 500.0f;
                final float brange = 500.0f;
                this.requirements(Category.turret, ItemStack.with(Items.copper, 1000, Items.metaglass, 600, Items.surgeAlloy, 300, Items.plastanium, 200, Items.silicon, 600));
                this.ammo(Items.surgeAlloy, new PointBulletType(){
                    {
                        this.shootEffect = Fx.instShoot;
                        this.hitEffect = Fx.instHit;
                        this.smokeEffect = Fx.smokeCloud;
                        this.trailEffect = Fx.instTrail;
                        this.despawnEffect = Fx.instBomb;
                        this.trailSpacing = 20.0f;
                        this.damage = 1350.0f;
                        this.buildingDamageMultiplier = 0.3f;
                        this.speed = brange;
                        this.hitShake = 6.0f;
                        this.ammoMultiplier = 1.0f;
                    }
                });
                this.maxAmmo = 40;
                this.ammoPerShot = 4;
                this.rotateSpeed = 2.0f;
                this.reloadTime = 200.0f;
                this.ammoUseEffect = Fx.casing3Double;
                this.recoilAmount = 5.0f;
                this.restitution = 0.009f;
                this.cooldown = 0.009f;
                this.shootShake = 4.0f;
                this.shots = 1;
                this.size = 4;
                this.shootCone = 2.0f;
                this.shootSound = Sounds.railgun;
                this.unitSort = (u, x, y) -> -u.maxHealth;
                this.coolantMultiplier = 0.4f;
                this.health = 150 * this.size * this.size;
                this.coolantUsage = 1.0f;
                this.consumes.powerCond(10.0f, Turret.TurretBuild::isActive);
            }
        };
        spectre = new ItemTurret("spectre"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 900, Items.graphite, 300, Items.surgeAlloy, 250, Items.plastanium, 175, Items.thorium, 250));
                this.ammo(Items.graphite, Bullets.standardDenseBig, Items.pyratite, Bullets.standardIncendiaryBig, Items.thorium, Bullets.standardThoriumBig);
                this.reloadTime = 6.0f;
                this.coolantMultiplier = 0.5f;
                this.restitution = 0.1f;
                this.ammoUseEffect = Fx.casing3;
                this.range = 200.0f;
                this.inaccuracy = 3.0f;
                this.recoilAmount = 3.0f;
                this.spread = 8.0f;
                this.alternate = true;
                this.shootShake = 2.0f;
                this.shots = 2;
                this.size = 4;
                this.shootCone = 24.0f;
                this.shootSound = Sounds.shootBig;
                this.health = 160 * this.size * this.size;
                this.coolantUsage = 1.0f;
            }
        };
        meltdown = new LaserTurret("meltdown"){
            {
                this.requirements(Category.turret, ItemStack.with(Items.copper, 1200, Items.lead, 350, Items.graphite, 300, Items.surgeAlloy, 325, Items.silicon, 325));
                this.shootEffect = Fx.shootBigSmoke2;
                this.shootCone = 40.0f;
                this.recoilAmount = 4.0f;
                this.size = 4;
                this.shootShake = 2.0f;
                this.range = 190.0f;
                this.reloadTime = 90.0f;
                this.firingMoveFract = 0.5f;
                this.shootDuration = 220.0f;
                this.powerUse = 17.0f;
                this.shootSound = Sounds.laserbig;
                this.loopSound = Sounds.beam;
                this.loopSoundVolume = 2.0f;
                this.shootType = new ContinuousLaserBulletType(70.0f){
                    {
                        this.length = 200.0f;
                        this.hitEffect = Fx.hitMeltdown;
                        this.hitColor = Pal.meltdownHit;
                        this.drawSize = 420.0f;
                        this.incendChance = 0.4f;
                        this.incendSpread = 5.0f;
                        this.incendAmount = 1;
                    }
                };
                this.health = 200 * this.size * this.size;
                this.consumes.add(new ConsumeLiquidFilter(liquid -> liquid.temperature <= 0.5f && liquid.flammability < 0.1f, 0.5f)).update(false);
            }
        };
        commandCenter = new CommandCenter("command-center"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 200, Items.lead, 250, Items.silicon, 250, Items.graphite, 100));
                this.size = 2;
                this.health = this.size * this.size * 55;
            }
        };
        groundFactory = new UnitFactory("ground-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 50, Items.lead, 120, Items.silicon, 80));
                this.plans = Seq.with(new UnitFactory.UnitPlan(UnitTypes.dagger, 900.0f, ItemStack.with(Items.silicon, 10, Items.lead, 10)), new UnitFactory.UnitPlan(UnitTypes.crawler, 720.0f, ItemStack.with(Items.silicon, 10, Items.coal, 20)), new UnitFactory.UnitPlan(UnitTypes.nova, 2400.0f, ItemStack.with(Items.silicon, 30, Items.lead, 20, Items.titanium, 20)));
                this.size = 3;
                this.consumes.power(1.2f);
            }
        };
        airFactory = new UnitFactory("air-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 60, Items.lead, 70));
                this.plans = Seq.with(new UnitFactory.UnitPlan(UnitTypes.flare, 900.0f, ItemStack.with(Items.silicon, 15)), new UnitFactory.UnitPlan(UnitTypes.mono, 2100.0f, ItemStack.with(Items.silicon, 30, Items.lead, 15)));
                this.size = 3;
                this.consumes.power(1.2f);
            }
        };
        navalFactory = new UnitFactory("naval-factory"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 150, Items.lead, 130, Items.metaglass, 120));
                this.plans = Seq.with(new UnitFactory.UnitPlan(UnitTypes.risso, 2700.0f, ItemStack.with(Items.silicon, 20, Items.metaglass, 35)));
                this.size = 3;
                this.consumes.power(1.2f);
                this.floating = true;
            }
        };
        additiveReconstructor = new Reconstructor("additive-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.copper, 200, Items.lead, 120, Items.silicon, 90));
                this.size = 3;
                this.consumes.power(3.0f);
                this.consumes.items(ItemStack.with(Items.silicon, 40, Items.graphite, 40));
                this.constructTime = 600.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.nova, UnitTypes.pulsar}, {UnitTypes.dagger, UnitTypes.mace}, {UnitTypes.crawler, UnitTypes.atrax}, {UnitTypes.flare, UnitTypes.horizon}, {UnitTypes.mono, UnitTypes.poly}, {UnitTypes.risso, UnitTypes.minke}});
            }
        };
        multiplicativeReconstructor = new Reconstructor("multiplicative-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 650, Items.silicon, 450, Items.titanium, 350, Items.thorium, 650));
                this.size = 5;
                this.consumes.power(6.0f);
                this.consumes.items(ItemStack.with(Items.silicon, 130, Items.titanium, 80, Items.metaglass, 40));
                this.constructTime = 1800.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.horizon, UnitTypes.zenith}, {UnitTypes.mace, UnitTypes.fortress}, {UnitTypes.poly, UnitTypes.mega}, {UnitTypes.minke, UnitTypes.bryde}, {UnitTypes.pulsar, UnitTypes.quasar}, {UnitTypes.atrax, UnitTypes.spiroct}});
            }
        };
        exponentialReconstructor = new Reconstructor("exponential-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 2000, Items.silicon, 1000, Items.titanium, 2000, Items.thorium, 750, Items.plastanium, 450, Items.phaseFabric, 600));
                this.size = 7;
                this.consumes.power(13.0f);
                this.consumes.items(ItemStack.with(Items.silicon, 850, Items.titanium, 750, Items.plastanium, 650));
                this.consumes.liquid(Liquids.cryofluid, 1.0f);
                this.constructTime = 5400.0f;
                this.liquidCapacity = 60.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.zenith, UnitTypes.antumbra}, {UnitTypes.spiroct, UnitTypes.arkyid}, {UnitTypes.fortress, UnitTypes.scepter}, {UnitTypes.bryde, UnitTypes.sei}, {UnitTypes.mega, UnitTypes.quad}, {UnitTypes.quasar, UnitTypes.vela}});
            }
        };
        tetrativeReconstructor = new Reconstructor("tetrative-reconstructor"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 4000, Items.silicon, 3000, Items.thorium, 1000, Items.plastanium, 600, Items.phaseFabric, 600, Items.surgeAlloy, 800));
                this.size = 9;
                this.consumes.power(25.0f);
                this.consumes.items(ItemStack.with(Items.silicon, 1000, Items.plastanium, 600, Items.surgeAlloy, 500, Items.phaseFabric, 350));
                this.consumes.liquid(Liquids.cryofluid, 3.0f);
                this.constructTime = 14400.0f;
                this.liquidCapacity = 180.0f;
                this.upgrades.addAll((T[])new UnitType[][]{{UnitTypes.antumbra, UnitTypes.eclipse}, {UnitTypes.arkyid, UnitTypes.toxopid}, {UnitTypes.scepter, UnitTypes.reign}, {UnitTypes.sei, UnitTypes.omura}, {UnitTypes.quad, UnitTypes.oct}, {UnitTypes.vela, UnitTypes.corvus}});
            }
        };
        repairPoint = new RepairPoint("repair-point"){
            {
                this.requirements(Category.units, ItemStack.with(Items.lead, 15, Items.copper, 15, Items.silicon, 15));
                this.repairSpeed = 0.5f;
                this.repairRadius = 65.0f;
                this.powerUse = 1.0f;
            }
        };
        resupplyPoint = new ResupplyPoint("resupply-point"){
            {
                this.requirements(Category.units, BuildVisibility.ammoOnly, ItemStack.with(Items.lead, 20, Items.copper, 15, Items.silicon, 15));
                this.size = 2;
                this.range = 80.0f;
                this.itemCapacity = 20;
                this.ammoAmount = 5;
                this.consumes.item(Items.copper, 1);
            }
        };
        powerSource = new PowerSource("power-source"){
            {
                this.requirements(Category.power, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.powerProduction = 16666.666f;
                this.alwaysUnlocked = true;
            }
        };
        powerVoid = new PowerVoid("power-void"){
            {
                this.requirements(Category.power, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        itemSource = new ItemSource("item-source"){
            {
                this.requirements(Category.distribution, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        itemVoid = new ItemVoid("item-void"){
            {
                this.requirements(Category.distribution, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        liquidSource = new LiquidSource("liquid-source"){
            {
                this.requirements(Category.liquid, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        liquidVoid = new LiquidVoid("liquid-void"){
            {
                this.requirements(Category.liquid, BuildVisibility.sandboxOnly, ItemStack.with(new Object[0]));
                this.alwaysUnlocked = true;
            }
        };
        illuminator = new LightBlock("illuminator"){
            {
                this.requirements(Category.effect, BuildVisibility.lightingOnly, ItemStack.with(Items.graphite, 12, Items.silicon, 8));
                this.brightness = 0.75f;
                this.radius = 120.0f;
                this.consumes.power(0.05f);
            }
        };
        new LegacyMechPad("legacy-mech-pad");
        new LegacyUnitFactory("legacy-unit-factory");
        new LegacyUnitFactory("legacy-unit-factory-air"){
            {
                this.replacement = airFactory;
            }
        };
        new LegacyUnitFactory("legacy-unit-factory-ground"){
            {
                this.replacement = groundFactory;
            }
        };
        launchPad = new LaunchPad("launch-pad"){
            {
                this.requirements(Category.effect, BuildVisibility.campaignOnly, ItemStack.with(Items.copper, 350, Items.silicon, 140, Items.lead, 200, Items.titanium, 150));
                this.size = 3;
                this.itemCapacity = 100;
                this.launchTime = 1200.0f;
                this.hasPower = true;
                this.consumes.power(4.0f);
            }
        };
        launchPadLarge = new LaunchPad("launch-pad-large"){
            {
                this.requirements(Category.effect, BuildVisibility.debugOnly, ItemStack.with(Items.titanium, 200, Items.silicon, 150, Items.lead, 250, Items.plastanium, 75));
                this.size = 4;
                this.itemCapacity = 300;
                this.launchTime = 2100.0f;
                this.hasPower = true;
                this.consumes.power(6.0f);
            }
        };
        interplanetaryAccelerator = new Accelerator("interplanetary-accelerator"){
            {
                this.requirements(Category.effect, BuildVisibility.campaignOnly, ItemStack.with(Items.copper, 16000, Items.silicon, 11000, Items.thorium, 13000, Items.titanium, 12000, Items.surgeAlloy, 6000, Items.phaseFabric, 5000));
                this.researchCostMultiplier = 0.1f;
                this.size = 7;
                this.hasPower = true;
                this.consumes.power(10.0f);
                this.buildCostMultiplier = 0.5f;
                this.health = this.size * this.size * 80;
            }
        };
        message = new MessageBlock("message"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 5));
            }
        };
        switchBlock = new SwitchBlock("switch"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 5));
            }
        };
        microProcessor = new LogicBlock("micro-processor"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.copper, 80, Items.lead, 50, Items.silicon, 30));
                this.instructionsPerTick = 2;
                this.size = 1;
            }
        };
        logicProcessor = new LogicBlock("logic-processor"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 320, Items.silicon, 60, Items.graphite, 60, Items.thorium, 50));
                this.instructionsPerTick = 8;
                this.range = 176.0f;
                this.size = 2;
            }
        };
        hyperProcessor = new LogicBlock("hyper-processor"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 450, Items.silicon, 130, Items.thorium, 75, Items.surgeAlloy, 50));
                this.consumes.liquid(Liquids.cryofluid, 0.08f);
                this.hasLiquids = true;
                this.instructionsPerTick = 25;
                this.range = 336.0f;
                this.size = 3;
            }
        };
        memoryCell = new MemoryBlock("memory-cell"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 30, Items.silicon, 30));
                this.memoryCapacity = 64;
            }
        };
        memoryBank = new MemoryBlock("memory-bank"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.graphite, 80, Items.silicon, 80, Items.phaseFabric, 30));
                this.memoryCapacity = 512;
                this.size = 2;
            }
        };
        logicDisplay = new LogicDisplay("logic-display"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 100, Items.silicon, 50, Items.metaglass, 50));
                this.displaySize = 80;
                this.size = 3;
            }
        };
        largeLogicDisplay = new LogicDisplay("large-logic-display"){
            {
                this.requirements(Category.logic, ItemStack.with(Items.lead, 200, Items.silicon, 150, Items.metaglass, 100, Items.phaseFabric, 75));
                this.displaySize = 176;
                this.size = 6;
            }
        };
        blockForge = new BlockForge("block-forge"){
            {
                this.requirements(Category.crafting, BuildVisibility.debugOnly, ItemStack.with(Items.thorium, 100));
                this.hasPower = true;
                this.consumes.power(2.0f);
                this.size = 3;
            }
        };
        blockLoader = new BlockLoader("block-loader"){
            {
                this.requirements(Category.distribution, BuildVisibility.debugOnly, ItemStack.with(Items.thorium, 100));
                this.hasPower = true;
                this.consumes.power(2.0f);
                this.size = 3;
            }
        };
        blockUnloader = new BlockUnloader("block-unloader"){
            {
                this.requirements(Category.distribution, BuildVisibility.debugOnly, ItemStack.with(Items.thorium, 100));
                this.hasPower = true;
                this.consumes.power(2.0f);
                this.size = 3;
            }
        };
    }
}

