/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.ctype.ContentList;
import mindustry.entities.Fires;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.FlakBulletType;
import mindustry.entities.bullet.LiquidBulletType;
import mindustry.entities.bullet.MassDriverBolt;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.world.Tile;

public class Bullets
implements ContentList {
    public static BulletType artilleryDense;
    public static BulletType artilleryPlastic;
    public static BulletType artilleryPlasticFrag;
    public static BulletType artilleryHoming;
    public static BulletType artilleryIncendiary;
    public static BulletType artilleryExplosive;
    public static BulletType flakScrap;
    public static BulletType flakLead;
    public static BulletType flakGlass;
    public static BulletType flakGlassFrag;
    public static BulletType fragGlass;
    public static BulletType fragExplosive;
    public static BulletType fragPlastic;
    public static BulletType fragSurge;
    public static BulletType fragGlassFrag;
    public static BulletType fragPlasticFrag;
    public static BulletType missileExplosive;
    public static BulletType missileIncendiary;
    public static BulletType missileSurge;
    public static BulletType standardCopper;
    public static BulletType standardDense;
    public static BulletType standardThorium;
    public static BulletType standardHoming;
    public static BulletType standardIncendiary;
    public static BulletType standardDenseBig;
    public static BulletType standardThoriumBig;
    public static BulletType standardIncendiaryBig;
    public static BulletType waterShot;
    public static BulletType cryoShot;
    public static BulletType slagShot;
    public static BulletType oilShot;
    public static BulletType heavyWaterShot;
    public static BulletType heavyCryoShot;
    public static BulletType heavySlagShot;
    public static BulletType heavyOilShot;
    public static BulletType damageLightning;
    public static BulletType damageLightningGround;
    public static BulletType fireball;
    public static BulletType basicFlame;
    public static BulletType pyraFlame;
    public static BulletType driverBolt;

    @Override
    public void load() {
        damageLightning = new BulletType(1.0E-4f, 0.0f){
            {
                this.lifetime = Fx.lightning.lifetime;
                this.hitEffect = Fx.hitLancer;
                this.despawnEffect = Fx.none;
                this.status = StatusEffects.shocked;
                this.statusDuration = 10.0f;
                this.hittable = false;
            }
        };
        damageLightningGround = new BulletType(1.0E-4f, 0.0f){};
        JsonIO.copy(damageLightning, damageLightningGround);
        Bullets.damageLightningGround.collidesAir = false;
        artilleryDense = new ArtilleryBulletType(3.0f, 20.0f, "shell"){
            {
                this.hitEffect = Fx.flakExplosion;
                this.knockback = 0.8f;
                this.lifetime = 80.0f;
                this.height = 11.0f;
                this.width = 11.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 18.75f;
                this.splashDamage = 33.0f;
            }
        };
        artilleryPlasticFrag = new BasicBulletType(2.5f, 10.0f, "bullet"){
            {
                this.width = 10.0f;
                this.height = 12.0f;
                this.shrinkY = 1.0f;
                this.lifetime = 15.0f;
                this.backColor = Pal.plastaniumBack;
                this.frontColor = Pal.plastaniumFront;
                this.despawnEffect = Fx.none;
                this.collidesAir = false;
            }
        };
        artilleryPlastic = new ArtilleryBulletType(3.4f, 20.0f, "shell"){
            {
                this.hitEffect = Fx.plasticExplosion;
                this.knockback = 1.0f;
                this.lifetime = 80.0f;
                this.height = 13.0f;
                this.width = 13.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 26.25f;
                this.splashDamage = 45.0f;
                this.fragBullet = artilleryPlasticFrag;
                this.fragBullets = 10;
                this.backColor = Pal.plastaniumBack;
                this.frontColor = Pal.plastaniumFront;
            }
        };
        artilleryHoming = new ArtilleryBulletType(3.0f, 20.0f, "shell"){
            {
                this.hitEffect = Fx.flakExplosion;
                this.knockback = 0.8f;
                this.lifetime = 80.0f;
                this.height = 11.0f;
                this.width = 11.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 18.75f;
                this.splashDamage = 33.0f;
                this.reloadMultiplier = 1.2f;
                this.ammoMultiplier = 3.0f;
                this.homingPower = 0.08f;
                this.homingRange = 50.0f;
            }
        };
        artilleryIncendiary = new ArtilleryBulletType(3.0f, 20.0f, "shell"){
            {
                this.hitEffect = Fx.blastExplosion;
                this.knockback = 0.8f;
                this.lifetime = 80.0f;
                this.height = 13.0f;
                this.width = 13.0f;
                this.collidesTiles = false;
                this.splashDamageRadius = 18.75f;
                this.splashDamage = 35.0f;
                this.status = StatusEffects.burning;
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.makeFire = true;
                this.trailEffect = Fx.incendTrail;
            }
        };
        artilleryExplosive = new ArtilleryBulletType(2.0f, 20.0f, "shell"){
            {
                this.hitEffect = Fx.blastExplosion;
                this.knockback = 0.8f;
                this.lifetime = 80.0f;
                this.height = 14.0f;
                this.width = 14.0f;
                this.collidesTiles = false;
                this.ammoMultiplier = 4.0f;
                this.splashDamageRadius = 33.75f;
                this.splashDamage = 50.0f;
                this.backColor = Pal.missileYellowBack;
                this.frontColor = Pal.missileYellow;
                this.status = StatusEffects.blasted;
                this.statusDuration = 60.0f;
            }
        };
        flakGlassFrag = new BasicBulletType(3.0f, 5.0f, "bullet"){
            {
                this.width = 5.0f;
                this.height = 12.0f;
                this.shrinkY = 1.0f;
                this.lifetime = 20.0f;
                this.backColor = Pal.gray;
                this.frontColor = Color.white;
                this.despawnEffect = Fx.none;
                this.collidesGround = false;
            }
        };
        flakLead = new FlakBulletType(4.2f, 3.0f){
            {
                this.lifetime = 60.0f;
                this.ammoMultiplier = 4.0f;
                this.shootEffect = Fx.shootSmall;
                this.width = 6.0f;
                this.height = 8.0f;
                this.hitEffect = Fx.flakExplosion;
                this.splashDamage = 40.5f;
                this.splashDamageRadius = 15.0f;
            }
        };
        flakScrap = new FlakBulletType(4.0f, 3.0f){
            {
                this.lifetime = 60.0f;
                this.ammoMultiplier = 5.0f;
                this.shootEffect = Fx.shootSmall;
                this.reloadMultiplier = 0.5f;
                this.width = 6.0f;
                this.height = 8.0f;
                this.hitEffect = Fx.flakExplosion;
                this.splashDamage = 33.0f;
                this.splashDamageRadius = 24.0f;
            }
        };
        flakGlass = new FlakBulletType(4.0f, 3.0f){
            {
                this.lifetime = 60.0f;
                this.ammoMultiplier = 5.0f;
                this.shootEffect = Fx.shootSmall;
                this.reloadMultiplier = 0.8f;
                this.width = 6.0f;
                this.height = 8.0f;
                this.hitEffect = Fx.flakExplosion;
                this.splashDamage = 33.0f;
                this.splashDamageRadius = 20.0f;
                this.fragBullet = flakGlassFrag;
                this.fragBullets = 6;
            }
        };
        fragGlassFrag = new BasicBulletType(3.0f, 5.0f, "bullet"){
            {
                this.width = 5.0f;
                this.height = 12.0f;
                this.shrinkY = 1.0f;
                this.lifetime = 20.0f;
                this.backColor = Pal.gray;
                this.frontColor = Color.white;
                this.despawnEffect = Fx.none;
            }
        };
        fragPlasticFrag = new BasicBulletType(2.5f, 10.0f, "bullet"){
            {
                this.width = 10.0f;
                this.height = 12.0f;
                this.shrinkY = 1.0f;
                this.lifetime = 15.0f;
                this.backColor = Pal.plastaniumBack;
                this.frontColor = Pal.plastaniumFront;
                this.despawnEffect = Fx.none;
            }
        };
        fragGlass = new FlakBulletType(4.0f, 3.0f){
            {
                this.ammoMultiplier = 3.0f;
                this.shootEffect = Fx.shootSmall;
                this.reloadMultiplier = 0.8f;
                this.width = 6.0f;
                this.height = 8.0f;
                this.hitEffect = Fx.flakExplosion;
                this.splashDamage = 27.0f;
                this.splashDamageRadius = 16.0f;
                this.fragBullet = fragGlassFrag;
                this.fragBullets = 4;
                this.explodeRange = 20.0f;
                this.collidesGround = true;
            }
        };
        fragPlastic = new FlakBulletType(4.0f, 6.0f){
            {
                this.splashDamageRadius = 40.0f;
                this.splashDamage = 37.5f;
                this.fragBullet = fragPlasticFrag;
                this.fragBullets = 6;
                this.hitEffect = Fx.plasticExplosion;
                this.frontColor = Pal.plastaniumFront;
                this.backColor = Pal.plastaniumBack;
                this.shootEffect = Fx.shootBig;
                this.collidesGround = true;
                this.explodeRange = 20.0f;
            }
        };
        fragExplosive = new FlakBulletType(4.0f, 5.0f){
            {
                this.shootEffect = Fx.shootBig;
                this.ammoMultiplier = 5.0f;
                this.splashDamage = 39.0f;
                this.splashDamageRadius = 60.0f;
                this.collidesGround = true;
                this.status = StatusEffects.blasted;
                this.statusDuration = 60.0f;
            }
        };
        fragSurge = new FlakBulletType(4.5f, 13.0f){
            {
                this.ammoMultiplier = 5.0f;
                this.splashDamage = 75.0f;
                this.splashDamageRadius = 38.0f;
                this.lightning = 2;
                this.lightningLength = 7;
                this.shootEffect = Fx.shootBig;
                this.collidesGround = true;
                this.explodeRange = 20.0f;
            }
        };
        missileExplosive = new MissileBulletType(3.7f, 10.0f){
            {
                this.width = 8.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.drag = -0.01f;
                this.splashDamageRadius = 30.0f;
                this.splashDamage = 45.0f;
                this.ammoMultiplier = 4.0f;
                this.hitEffect = Fx.blastExplosion;
                this.despawnEffect = Fx.blastExplosion;
                this.status = StatusEffects.blasted;
                this.statusDuration = 60.0f;
            }
        };
        missileIncendiary = new MissileBulletType(3.7f, 12.0f){
            {
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.width = 7.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.drag = -0.01f;
                this.homingPower = 0.08f;
                this.splashDamageRadius = 20.0f;
                this.splashDamage = 30.0f;
                this.makeFire = true;
                this.hitEffect = Fx.blastExplosion;
                this.status = StatusEffects.burning;
            }
        };
        missileSurge = new MissileBulletType(3.7f, 18.0f){
            {
                this.width = 8.0f;
                this.height = 8.0f;
                this.shrinkY = 0.0f;
                this.drag = -0.01f;
                this.splashDamageRadius = 25.0f;
                this.splashDamage = 37.5f;
                this.hitEffect = Fx.blastExplosion;
                this.despawnEffect = Fx.blastExplosion;
                this.lightningDamage = 10.0f;
                this.lightning = 2;
                this.lightningLength = 10;
            }
        };
        standardCopper = new BasicBulletType(2.5f, 9.0f){
            {
                this.width = 7.0f;
                this.height = 9.0f;
                this.lifetime = 60.0f;
                this.shootEffect = Fx.shootSmall;
                this.smokeEffect = Fx.shootSmallSmoke;
                this.ammoMultiplier = 2.0f;
            }
        };
        standardDense = new BasicBulletType(3.5f, 18.0f){
            {
                this.width = 9.0f;
                this.height = 12.0f;
                this.reloadMultiplier = 0.6f;
                this.ammoMultiplier = 4.0f;
                this.lifetime = 60.0f;
            }
        };
        standardThorium = new BasicBulletType(4.0f, 29.0f, "bullet"){
            {
                this.width = 10.0f;
                this.height = 13.0f;
                this.shootEffect = Fx.shootBig;
                this.smokeEffect = Fx.shootBigSmoke;
                this.ammoMultiplier = 4.0f;
                this.lifetime = 60.0f;
            }
        };
        standardHoming = new BasicBulletType(3.0f, 12.0f, "bullet"){
            {
                this.width = 7.0f;
                this.height = 9.0f;
                this.homingPower = 0.08f;
                this.reloadMultiplier = 1.5f;
                this.ammoMultiplier = 5.0f;
                this.lifetime = 60.0f;
            }
        };
        standardIncendiary = new BasicBulletType(3.2f, 11.0f, "bullet"){
            {
                this.width = 10.0f;
                this.height = 12.0f;
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.status = StatusEffects.burning;
                this.makeFire = true;
                this.inaccuracy = 3.0f;
                this.lifetime = 60.0f;
            }
        };
        standardDenseBig = new BasicBulletType(7.0f, 55.0f, "bullet"){
            {
                this.width = 15.0f;
                this.height = 21.0f;
                this.shootEffect = Fx.shootBig;
            }
        };
        standardThoriumBig = new BasicBulletType(8.0f, 80.0f, "bullet"){
            {
                this.width = 16.0f;
                this.height = 23.0f;
                this.shootEffect = Fx.shootBig;
                this.pierceCap = 2;
                this.pierceBuilding = true;
                this.knockback = 0.7f;
            }
        };
        standardIncendiaryBig = new BasicBulletType(7.0f, 60.0f, "bullet"){
            {
                this.width = 16.0f;
                this.height = 21.0f;
                this.frontColor = Pal.lightishOrange;
                this.backColor = Pal.lightOrange;
                this.status = StatusEffects.burning;
                this.shootEffect = Fx.shootBig;
                this.makeFire = true;
                this.pierceCap = 2;
                this.pierceBuilding = true;
                this.knockback = 0.7f;
            }
        };
        fireball = new BulletType(1.0f, 4.0f){
            {
                this.pierce = true;
                this.collidesTiles = false;
                this.collides = false;
                this.drag = 0.03f;
                this.hitEffect = this.despawnEffect = Fx.none;
            }

            @Override
            public void init(Bullet b) {
                b.vel.setLength(0.6f + Mathf.random(2.0f));
            }

            @Override
            public void draw(Bullet b) {
                Draw.color(Pal.lightFlame, Pal.darkFlame, Color.gray, b.fin());
                Fill.circle(b.x, b.y, 3.0f * b.fout());
                Draw.reset();
            }

            @Override
            public void update(Bullet b) {
                Tile tile;
                if (Mathf.chance(0.04 * (double)Time.delta) && (tile = Vars.world.tileWorld(b.x, b.y)) != null) {
                    Fires.create(tile);
                }
                if (Mathf.chance(0.1 * (double)Time.delta)) {
                    Fx.fireballsmoke.at(b.x, b.y);
                }
                if (Mathf.chance(0.1 * (double)Time.delta)) {
                    Fx.ballfire.at(b.x, b.y);
                }
            }
        };
        basicFlame = new BulletType(3.35f, 16.0f){
            {
                this.ammoMultiplier = 3.0f;
                this.hitSize = 7.0f;
                this.lifetime = 18.0f;
                this.pierce = true;
                this.collidesAir = false;
                this.statusDuration = 240.0f;
                this.shootEffect = Fx.shootSmallFlame;
                this.hitEffect = Fx.hitFlameSmall;
                this.despawnEffect = Fx.none;
                this.status = StatusEffects.burning;
                this.keepVelocity = false;
                this.hittable = false;
            }
        };
        pyraFlame = new BulletType(3.35f, 25.0f){
            {
                this.ammoMultiplier = 4.0f;
                this.hitSize = 7.0f;
                this.lifetime = 18.0f;
                this.pierce = true;
                this.collidesAir = false;
                this.statusDuration = 360.0f;
                this.shootEffect = Fx.shootPyraFlame;
                this.hitEffect = Fx.hitFlameSmall;
                this.despawnEffect = Fx.none;
                this.status = StatusEffects.burning;
                this.hittable = false;
            }
        };
        waterShot = new LiquidBulletType(Liquids.water){
            {
                this.knockback = 0.7f;
                this.drag = 0.01f;
            }
        };
        cryoShot = new LiquidBulletType(Liquids.cryofluid){
            {
                this.drag = 0.01f;
            }
        };
        slagShot = new LiquidBulletType(Liquids.slag){
            {
                this.damage = 4.0f;
                this.drag = 0.01f;
            }
        };
        oilShot = new LiquidBulletType(Liquids.oil){
            {
                this.drag = 0.01f;
            }
        };
        heavyWaterShot = new LiquidBulletType(Liquids.water){
            {
                this.lifetime = 49.0f;
                this.speed = 4.0f;
                this.knockback = 1.7f;
                this.puddleSize = 8.0f;
                this.orbSize = 4.0f;
                this.drag = 0.001f;
                this.ammoMultiplier = 0.4f;
                this.statusDuration = 240.0f;
                this.damage = 0.2f;
            }
        };
        heavyCryoShot = new LiquidBulletType(Liquids.cryofluid){
            {
                this.lifetime = 49.0f;
                this.speed = 4.0f;
                this.knockback = 1.3f;
                this.puddleSize = 8.0f;
                this.orbSize = 4.0f;
                this.drag = 0.001f;
                this.ammoMultiplier = 0.4f;
                this.statusDuration = 240.0f;
                this.damage = 0.2f;
            }
        };
        heavySlagShot = new LiquidBulletType(Liquids.slag){
            {
                this.lifetime = 49.0f;
                this.speed = 4.0f;
                this.knockback = 1.3f;
                this.puddleSize = 8.0f;
                this.orbSize = 4.0f;
                this.damage = 4.75f;
                this.drag = 0.001f;
                this.ammoMultiplier = 0.4f;
                this.statusDuration = 240.0f;
            }
        };
        heavyOilShot = new LiquidBulletType(Liquids.oil){
            {
                this.lifetime = 49.0f;
                this.speed = 4.0f;
                this.knockback = 1.3f;
                this.puddleSize = 8.0f;
                this.orbSize = 4.0f;
                this.drag = 0.001f;
                this.ammoMultiplier = 0.4f;
                this.statusDuration = 240.0f;
                this.damage = 0.2f;
            }
        };
        driverBolt = new MassDriverBolt();
    }
}

