/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.game.Team;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Icon;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.ui.Cicon;

public class Fx {
    public static final Effect none = new Effect(0.0f, 0.0f, e -> {});
    public static final Effect unitSpawn = new Effect(30.0f, e -> {
        UnitType unit;
        Object unit$temp = e.data;
        if (!(unit$temp instanceof UnitType) || (unit = (UnitType)unit$temp) != (UnitType)unit$temp) {
            return;
        }
        float scl = 1.0f + e.fout() * 2.0f;
        TextureRegion region = unit.icon(Cicon.full);
        Draw.alpha(e.fout());
        Draw.mixcol(Color.white, e.fin());
        Draw.rect(region, e.x, e.y, 180.0f);
        Draw.reset();
        Draw.alpha(e.fin());
        Draw.rect(region, e.x, e.y, (float)region.width * Draw.scl * scl, (float)region.height * Draw.scl * scl, e.rotation - 90.0f);
    });
    public static final Effect unitCapKill = new Effect(80.0f, e -> {
        Draw.color(Color.scarlet);
        Draw.alpha(e.fout(Interp.pow4Out));
        float size = 10.0f + e.fout(Interp.pow10In) * 25.0f;
        Draw.rect(Icon.warning.getRegion(), e.x, e.y, size, size);
    });
    public static final Effect unitControl = new Effect(30.0f, e -> {
        if (!(e.data instanceof Unit)) {
            return;
        }
        Unit select = (Unit)e.data();
        boolean block = select instanceof BlockUnitc;
        Draw.mixcol(Pal.accent, 1.0f);
        Draw.alpha(e.fout());
        Draw.rect(block ? ((BlockUnitc)((Object)select)).tile().block.icon(Cicon.full) : select.type.icon(Cicon.full), select.x, select.y, block ? 0.0f : select.rotation - 90.0f);
        Draw.alpha(1.0f);
        Lines.stroke(e.fslope());
        Lines.square(select.x, select.y, e.fout() * select.hitSize * 2.0f, 45.0f);
        Lines.stroke(e.fslope() * 2.0f);
        Lines.square(select.x, select.y, e.fout() * select.hitSize * 3.0f, 45.0f);
        Draw.reset();
    });
    public static final Effect unitDespawn = new Effect(100.0f, e -> {
        if (!(e.data instanceof Unit) || ((Unit)e.data()).type == null) {
            return;
        }
        Unit select = (Unit)e.data();
        float scl = e.fout(Interp.pow2Out);
        float p = Draw.scl;
        Draw.scl *= scl;
        Draw.mixcol(Pal.accent, 1.0f);
        Draw.rect(select.type.icon(Cicon.full), select.x, select.y, select.rotation - 90.0f);
        Draw.reset();
        Draw.scl = p;
    });
    public static final Effect unitSpirit = new Effect(17.0f, e -> {
        if (!(e.data instanceof Position)) {
            return;
        }
        Position to = (Position)e.data();
        Draw.color(Pal.accent);
        Tmp.v1.set(e.x, e.y).interpolate(Tmp.v2.set(to), e.fin(), (Interp)Interp.pow2In);
        float x = Tmp.v1.x;
        float y = Tmp.v1.y;
        float size = 2.5f * e.fin();
        Fill.square(x, y, 1.5f * size, 45.0f);
        Tmp.v1.set(e.x, e.y).interpolate(Tmp.v2.set(to), e.fin(), (Interp)Interp.pow5In);
        x = Tmp.v1.x;
        y = Tmp.v1.y;
        Fill.square(x, y, size, 45.0f);
    });
    public static final Effect itemTransfer = new Effect(12.0f, e -> {
        if (!(e.data instanceof Position)) {
            return;
        }
        Position to = (Position)e.data();
        Tmp.v1.set(e.x, e.y).interpolate(Tmp.v2.set(to), e.fin(), (Interp)Interp.pow3).add(Tmp.v2.sub(e.x, e.y).nor().rotate90(1).scl(Mathf.randomSeedRange(e.id, 1.0f) * e.fslope() * 10.0f));
        float x = Tmp.v1.x;
        float y = Tmp.v1.y;
        float size = 1.0f;
        Lines.stroke(e.fslope() * 2.0f * size, Pal.accent);
        Lines.circle(x, y, e.fslope() * 2.0f * size);
        Draw.color(e.color);
        Fill.circle(x, y, e.fslope() * 1.5f * size);
    });
    public static final Effect pointBeam = new Effect(25.0f, e -> {
        if (!(e.data instanceof Position)) {
            return;
        }
        Position pos = (Position)e.data();
        Draw.color(e.color);
        Draw.alpha(e.fout());
        Lines.stroke(1.5f);
        Lines.line(e.x, e.y, pos.getX(), pos.getY());
    });
    public static final Effect pointHit = new Effect(8.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() + 0.2f);
        Lines.circle(e.x, e.y, e.fin() * 6.0f);
    });
    public static final Effect lightning = new Effect(10.0f, 500.0f, e -> {
        if (!(e.data instanceof Seq)) {
            return;
        }
        Seq lines = (Seq)e.data();
        Lines.stroke(3.0f * e.fout());
        Draw.color(e.color, Color.white, e.fin());
        for (int i = 0; i < lines.size - 1; ++i) {
            Vec2 cur = (Vec2)lines.get(i);
            Vec2 next = (Vec2)lines.get(i + 1);
            Lines.line(cur.x, cur.y, next.x, next.y, false);
        }
        for (Vec2 p : lines) {
            Fill.circle(p.x, p.y, Lines.getStroke() / 2.0f);
        }
    });
    public static final Effect commandSend = new Effect(28.0f, e -> {
        Draw.color(Pal.command);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 120.0f);
    });
    public static final Effect upgradeCore = new Effect(120.0f, e -> {
        Draw.color(Color.white, Pal.accent, e.fin());
        Draw.alpha(e.fout());
        Fill.square(e.x, e.y, 4.0f * e.rotation);
    });
    public static final Effect placeBlock = new Effect(16.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(3.0f - e.fin() * 2.0f);
        Lines.square(e.x, e.y, 4.0f * e.rotation + e.fin() * 3.0f);
    });
    public static final Effect tapBlock = new Effect(12.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(3.0f - e.fin() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + 5.3333335f * e.rotation * e.fin());
    });
    public static final Effect breakBlock = new Effect(12.0f, e -> {
        Draw.color(Pal.remove);
        Lines.stroke(3.0f - e.fin() * 2.0f);
        Lines.square(e.x, e.y, 4.0f * e.rotation + e.fin() * 3.0f);
        Angles.randLenVectors(e.id, 3 + (int)(e.rotation * 3.0f), e.rotation * 2.0f + 8.0f * e.rotation * e.finpow(), (x, y) -> Fill.square(e.x + x, e.y + y, 1.0f + e.fout() * (3.0f + e.rotation)));
    });
    public static final Effect select = new Effect(23.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(e.fout() * 3.0f);
        Lines.circle(e.x, e.y, 3.0f + e.fin() * 14.0f);
    });
    public static final Effect smoke = new Effect(100.0f, e -> {
        Draw.color(Color.gray, Pal.darkishGray, e.fin());
        Fill.circle(e.x, e.y, (7.0f - e.fin() * 7.0f) / 2.0f);
    });
    public static final Effect fallSmoke = new Effect(110.0f, e -> {
        Draw.color(Color.gray, Color.darkGray, e.rotation);
        Fill.circle(e.x, e.y, e.fout() * 3.5f);
    });
    public static final Effect unitWreck = new Effect(200.0f, e -> {
        if (!(e.data instanceof TextureRegion)) {
            return;
        }
        Draw.mixcol(Pal.rubble, 1.0f);
        TextureRegion reg = (TextureRegion)e.data();
        float vel = e.fin(Interp.pow5Out) * 2.0f * Mathf.randomSeed(e.id, 1.0f);
        float totalRot = Mathf.randomSeed(e.id + 1, 10.0f);
        Tmp.v1.trns(Mathf.randomSeed(e.id + 2, 360.0f), vel);
        Draw.z(Mathf.lerp(90.0f, 20.0f, e.fin()));
        Draw.alpha(e.fout(Interp.pow5Out));
        Draw.rect(reg, e.x + Tmp.v1.x, e.y + Tmp.v1.y, e.rotation - 90.0f + totalRot * e.fin(Interp.pow5Out));
    });
    public static final Effect rocketSmoke = new Effect(120.0f, e -> {
        Draw.color(Color.gray);
        Draw.alpha(Mathf.clamp(e.fout() * 1.6f - Interp.pow3In.apply(e.rotation) * 1.2f));
        Fill.circle(e.x, e.y, 1.0f + 6.0f * e.rotation - e.fin() * 2.0f);
    });
    public static final Effect rocketSmokeLarge = new Effect(220.0f, e -> {
        Draw.color(Color.gray);
        Draw.alpha(Mathf.clamp(e.fout() * 1.6f - Interp.pow3In.apply(e.rotation) * 1.2f));
        Fill.circle(e.x, e.y, 1.0f + 6.0f * e.rotation * 1.3f - e.fin() * 2.0f);
    });
    public static final Effect magmasmoke = new Effect(110.0f, e -> {
        Draw.color(Color.gray);
        Fill.circle(e.x, e.y, e.fslope() * 6.0f);
    });
    public static final Effect spawn = new Effect(30.0f, e -> {
        Lines.stroke(2.0f * e.fout());
        Draw.color(Pal.accent);
        Lines.poly(e.x, e.y, 4, 5.0f + e.fin() * 12.0f);
    });
    public static final Effect padlaunch = new Effect(10.0f, e -> {
        Lines.stroke(4.0f * e.fout());
        Draw.color(Pal.accent);
        Lines.poly(e.x, e.y, 4, 5.0f + e.fin() * 60.0f);
    });
    public static final Effect vtolHover = new Effect(40.0f, e -> {
        float len = e.finpow() * 10.0f;
        float ang = e.rotation + Mathf.randomSeedRange(e.id, 30.0f);
        Draw.color(Pal.lightFlame, Pal.lightOrange, e.fin());
        Fill.circle(e.x + Angles.trnsx(ang, len), e.y + Angles.trnsy(ang, len), 2.0f * e.fout());
    });
    public static final Effect unitDrop = new Effect(30.0f, e -> {
        Draw.color(Pal.lightishGray);
        Angles.randLenVectors(e.id, 9, 3.0f + 20.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.4f));
    }).layer(20.0f);
    public static final Effect unitLand = new Effect(30.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).mul(1.1f));
        Angles.randLenVectors(e.id, 6, 17.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.3f));
    }).layer(20.0f);
    public static final Effect unitLandSmall = new Effect(30.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).mul(1.1f));
        Angles.randLenVectors(e.id, (int)(6.0f * e.rotation), 12.0f * e.finpow() * e.rotation, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.1f));
    }).layer(20.0f);
    public static final Effect unitPickup = new Effect(18.0f, e -> {
        Draw.color(Pal.lightishGray);
        Lines.stroke(e.fin() * 2.0f);
        Lines.poly(e.x, e.y, 4, 13.0f * e.fout());
    }).layer(20.0f);
    public static final Effect landShock = new Effect(12.0f, e -> {
        Draw.color(Pal.lancerLaser);
        Lines.stroke(e.fout() * 3.0f);
        Lines.poly(e.x, e.y, 12, 20.0f * e.fout());
    }).layer(20.0f);
    public static final Effect pickup = new Effect(18.0f, e -> {
        Draw.color(Pal.lightishGray);
        Lines.stroke(e.fout() * 2.0f);
        Lines.spikes(e.x, e.y, 1.0f + e.fin() * 6.0f, e.fout() * 4.0f, 6);
    });
    public static final Effect greenBomb = new Effect(40.0f, 100.0f, e -> {
        int i;
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 65.0f);
        Draw.color(Pal.heal);
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 6.0f, 100.0f * e.fout(), i * 90);
        }
        Draw.color();
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 3.0f, 35.0f * e.fout(), i * 90);
        }
    });
    public static final Effect greenLaserCharge = new Effect(80.0f, 100.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fin() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.fout() * 100.0f);
        Fill.circle(e.x, e.y, e.fin() * 20.0f);
        Angles.randLenVectors(e.id, 20, 40.0f * e.fout(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fin() * 5.0f));
        Draw.color();
        Fill.circle(e.x, e.y, e.fin() * 10.0f);
    });
    public static final Effect greenLaserChargeSmall = new Effect(40.0f, 100.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fin() * 2.0f);
        Lines.circle(e.x, e.y, e.fout() * 50.0f);
    });
    public static final Effect healWaveDynamic = new Effect(22.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * e.rotation);
    });
    public static final Effect healWave = new Effect(22.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 60.0f);
    });
    public static final Effect heal = new Effect(11.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 2.0f + e.finpow() * 7.0f);
    });
    public static final Effect shieldWave = new Effect(22.0f, e -> {
        Draw.color(Pal.shield);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 60.0f);
    });
    public static final Effect shieldApply = new Effect(11.0f, e -> {
        Draw.color(Pal.shield);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 2.0f + e.finpow() * 7.0f);
    });
    public static final Effect hitBulletSmall = new Effect(14.0f, e -> {
        Draw.color(Color.white, Pal.lightOrange, e.fin());
        e.scaled(7.0f, s -> {
            Lines.stroke(0.5f + s.fout());
            Lines.circle(e.x, e.y, s.fin() * 5.0f);
        });
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 5, e.fin() * 15.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
    });
    public static final Effect hitFuse = new Effect(14.0f, e -> {
        Draw.color(Color.white, Pal.surge, e.fin());
        e.scaled(7.0f, s -> {
            Lines.stroke(0.5f + s.fout());
            Lines.circle(e.x, e.y, s.fin() * 7.0f);
        });
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 6, e.fin() * 15.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
    });
    public static final Effect hitBulletBig = new Effect(13.0f, e -> {
        Draw.color(Color.white, Pal.lightOrange, e.fin());
        Lines.stroke(0.5f + e.fout() * 1.5f);
        Angles.randLenVectors(e.id, 8, e.finpow() * 30.0f, e.rotation, 50.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.5f);
        });
    });
    public static final Effect hitFlameSmall = new Effect(14.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 2, e.fin() * 15.0f, e.rotation, 50.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
    });
    public static final Effect hitLiquid = new Effect(16.0f, e -> {
        Draw.color(e.color);
        Angles.randLenVectors(e.id, 5, e.fin() * 15.0f, e.rotation, 60.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.0f));
    });
    public static final Effect hitLaserBlast = new Effect(12.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 1.5f);
        Angles.randLenVectors(e.id, 8, e.finpow() * 17.0f, e.rotation, 360.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitLancer = new Effect(12.0f, e -> {
        Draw.color(Color.white);
        Lines.stroke(e.fout() * 1.5f);
        Angles.randLenVectors(e.id, 8, e.finpow() * 17.0f, e.rotation, 360.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitBeam = new Effect(12.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 6, e.finpow() * 18.0f, e.rotation, 360.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitMeltdown = new Effect(12.0f, e -> {
        Draw.color(Pal.meltdownHit);
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 6, e.finpow() * 18.0f, e.rotation, 360.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitMeltHeal = new Effect(12.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 6, e.finpow() * 18.0f, e.rotation, 360.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect instBomb = new Effect(15.0f, 100.0f, e -> {
        int i;
        Draw.color(Pal.bulletYellowBack);
        Lines.stroke(e.fout() * 4.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 20.0f);
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 6.0f, 80.0f * e.fout(), i * 90 + 45);
        }
        Draw.color();
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 3.0f, 30.0f * e.fout(), i * 90 + 45);
        }
    });
    public static final Effect instTrail = new Effect(30.0f, e -> {
        for (int i = 0; i < 2; ++i) {
            Draw.color(i == 0 ? Pal.bulletYellowBack : Pal.bulletYellow);
            float m = i == 0 ? 1.0f : 0.5f;
            float rot = e.rotation + 180.0f;
            float w = 15.0f * e.fout() * m;
            Drawf.tri(e.x, e.y, w, (30.0f + Mathf.randomSeedRange(e.id, 15.0f)) * m, rot);
            Drawf.tri(e.x, e.y, w, 10.0f * m, rot + 180.0f);
        }
    });
    public static final Effect instShoot = new Effect(24.0f, e -> {
        e.scaled(10.0f, b -> {
            Draw.color(Color.white, Pal.bulletYellowBack, b.fin());
            Lines.stroke(b.fout() * 3.0f + 0.2f);
            Lines.circle(b.x, b.y, b.fin() * 50.0f);
        });
        Draw.color(Pal.bulletYellowBack);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 13.0f * e.fout(), 85.0f, e.rotation + 90.0f * (float)i);
            Drawf.tri(e.x, e.y, 13.0f * e.fout(), 50.0f, e.rotation + 20.0f * (float)i);
        }
    });
    public static final Effect instHit = new Effect(20.0f, 200.0f, e -> {
        Draw.color(Pal.bulletYellowBack);
        for (int i = 0; i < 2; ++i) {
            Draw.color(i == 0 ? Pal.bulletYellowBack : Pal.bulletYellow);
            float m = i == 0 ? 1.0f : 0.5f;
            for (int j = 0; j < 5; ++j) {
                float rot = e.rotation + Mathf.randomSeedRange(e.id + j, 50.0f);
                float w = 23.0f * e.fout() * m;
                Drawf.tri(e.x, e.y, w, (80.0f + Mathf.randomSeedRange(e.id + j, 40.0f)) * m, rot);
                Drawf.tri(e.x, e.y, w, 20.0f * m, rot + 180.0f);
            }
        }
        e.scaled(10.0f, c -> {
            Draw.color(Pal.bulletYellow);
            Lines.stroke(c.fout() * 2.0f + 0.2f);
            Lines.circle(e.x, e.y, c.fin() * 30.0f);
        });
        e.scaled(12.0f, c -> {
            Draw.color(Pal.bulletYellowBack);
            Angles.randLenVectors(e.id, 25, 5.0f + e.fin() * 80.0f, e.rotation, 60.0f, (x, y) -> Fill.square(e.x + x, e.y + y, c.fout() * 3.0f, 45.0f));
        });
    });
    public static final Effect hitLaser = new Effect(8.0f, e -> {
        Draw.color(Color.white, Pal.heal, e.fin());
        Lines.stroke(0.5f + e.fout());
        Lines.circle(e.x, e.y, e.fin() * 5.0f);
    });
    public static final Effect hitYellowLaser = new Effect(8.0f, e -> {
        Draw.color(Color.white, Pal.lightTrail, e.fin());
        Lines.stroke(0.5f + e.fout());
        Lines.circle(e.x, e.y, e.fin() * 5.0f);
    });
    public static final Effect despawn = new Effect(12.0f, e -> {
        Draw.color(Pal.lighterOrange, Color.gray, e.fin());
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id, 7, e.fin() * 7.0f, e.rotation, 40.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 2.0f + 1.0f);
        });
    });
    public static final Effect flakExplosion = new Effect(20.0f, e -> {
        Draw.color(Pal.bulletYellow);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 10.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 5, 2.0f + 23.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.5f));
        Draw.color(Pal.lighterOrange);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect plasticExplosion = new Effect(24.0f, e -> {
        Draw.color(Pal.plastaniumFront);
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 24.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 7, 2.0f + 28.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.plastaniumBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 25.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect plasticExplosionFlak = new Effect(28.0f, e -> {
        Draw.color(Pal.plastaniumFront);
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 34.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 7, 2.0f + 30.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.plastaniumBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 30.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect blastExplosion = new Effect(22.0f, e -> {
        Draw.color(Pal.missileYellow);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 15.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 5, 2.0f + 23.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.missileYellowBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect sapExplosion = new Effect(25.0f, e -> {
        Draw.color(Pal.sapBullet);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 80.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 9, 2.0f + 70.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.sapBulletBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 8, 1.0f + 60.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect massiveExplosion = new Effect(30.0f, e -> {
        Draw.color(Pal.missileYellow);
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 4.0f + i.fin() * 30.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 8, 2.0f + 30.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.missileYellowBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 6, 1.0f + 29.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 4.0f));
    });
    public static final Effect artilleryTrail = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    });
    public static final Effect incendTrail = new Effect(50.0f, e -> {
        Draw.color(Pal.lightOrange);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    });
    public static final Effect missileTrail = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    });
    public static final Effect absorb = new Effect(12.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(2.0f * e.fout());
        Lines.circle(e.x, e.y, 5.0f * e.fout());
    });
    public static final Effect forceShrink = new Effect(20.0f, e -> {
        Draw.color(e.color, e.fout());
        if (Vars.renderer.animateShields) {
            Fill.poly(e.x, e.y, 6, e.rotation * e.fout());
        } else {
            Lines.stroke(1.5f);
            Draw.alpha(0.09f);
            Fill.poly(e.x, e.y, 6, e.rotation * e.fout());
            Draw.alpha(1.0f);
            Lines.poly(e.x, e.y, 6, e.rotation * e.fout());
        }
    }).layer(125.0f);
    public static final Effect flakExplosionBig = new Effect(30.0f, e -> {
        Draw.color(Pal.bulletYellowBack);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 25.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 6, 2.0f + 23.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.bulletYellow);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect burning = new Effect(35.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Angles.randLenVectors(e.id, 3, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.1f + e.fout() * 1.4f));
    });
    public static final Effect fire = new Effect(50.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Angles.randLenVectors(e.id, 2, 2.0f + e.fin() * 9.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fslope() * 1.5f));
        Draw.color();
        Drawf.light(Team.derelict, e.x, e.y, 20.0f * e.fslope(), Pal.lightFlame, 0.5f);
    });
    public static final Effect fireSmoke = new Effect(35.0f, e -> {
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 1, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fslope() * 1.5f));
    });
    public static final Effect steam = new Effect(35.0f, e -> {
        Draw.color(Color.lightGray);
        Angles.randLenVectors(e.id, 2, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fslope() * 1.5f));
    });
    public static final Effect fireballsmoke = new Effect(25.0f, e -> {
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 1, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fout() * 1.5f));
    });
    public static final Effect ballfire = new Effect(25.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Angles.randLenVectors(e.id, 2, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fout() * 1.5f));
    });
    public static final Effect freezing = new Effect(40.0f, e -> {
        Draw.color(Liquids.cryofluid.color);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 1.2f));
    });
    public static final Effect melting = new Effect(40.0f, e -> {
        Draw.color(Liquids.slag.color, Color.white, e.fout() / 5.0f + Mathf.randomSeedRange(e.id, 0.12f));
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 3.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fout() * 1.2f));
    });
    public static final Effect wet = new Effect(80.0f, e -> {
        Draw.color(Liquids.water.color);
        Draw.alpha(Mathf.clamp(e.fin() * 2.0f));
        Fill.circle(e.x, e.y, e.fout());
    });
    public static final Effect muddy = new Effect(80.0f, e -> {
        Draw.color(Color.valueOf("432722"));
        Draw.alpha(Mathf.clamp(e.fin() * 2.0f));
        Fill.circle(e.x, e.y, e.fout());
    });
    public static final Effect sapped = new Effect(40.0f, e -> {
        Draw.color(Pal.sap);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fslope() * 1.1f, 45.0f));
    });
    public static final Effect sporeSlowed = new Effect(40.0f, e -> {
        Draw.color(Pal.spore);
        Fill.circle(e.x, e.y, e.fslope() * 1.1f);
    });
    public static final Effect oily = new Effect(42.0f, e -> {
        Draw.color(Liquids.oil.color);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout()));
    });
    public static final Effect overdriven = new Effect(20.0f, e -> {
        Draw.color(Pal.accent);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() * 2.3f + 0.5f));
    });
    public static final Effect overclocked = new Effect(50.0f, e -> {
        Draw.color(Pal.accent);
        Fill.square(e.x, e.y, e.fslope() * 2.0f, 45.0f);
    });
    public static final Effect dropItem = new Effect(20.0f, e -> {
        float length = 20.0f * e.finpow();
        float size = 7.0f * e.fout();
        Draw.rect(((Item)e.data).icon(Cicon.medium), e.x + Angles.trnsx(e.rotation, length), e.y + Angles.trnsy(e.rotation, length), size, size);
    });
    public static final Effect shockwave = new Effect(10.0f, 80.0f, e -> {
        Draw.color(Color.white, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 2.0f + 0.2f);
        Lines.circle(e.x, e.y, e.fin() * 28.0f);
    });
    public static final Effect bigShockwave = new Effect(10.0f, 80.0f, e -> {
        Draw.color(Color.white, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 3.0f);
        Lines.circle(e.x, e.y, e.fin() * 50.0f);
    });
    public static final Effect nuclearShockwave = new Effect(10.0f, 200.0f, e -> {
        Draw.color(Color.white, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 3.0f + 0.2f);
        Lines.circle(e.x, e.y, e.fin() * 140.0f);
    });
    public static final Effect impactShockwave = new Effect(13.0f, 300.0f, e -> {
        Draw.color(Pal.lighterOrange, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 4.0f + 0.2f);
        Lines.circle(e.x, e.y, e.fin() * 200.0f);
    });
    public static final Effect spawnShockwave = new Effect(20.0f, 400.0f, e -> {
        Draw.color(Color.white, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 3.0f + 0.5f);
        Lines.circle(e.x, e.y, e.fin() * (e.rotation + 50.0f));
    });
    public static final Effect explosion = new Effect(30.0f, e -> {
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 10.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 6, 2.0f + 19.0f * e.finpow(), (x, y) -> {
            Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.5f);
            Fill.circle(e.x + x / 2.0f, e.y + y / 2.0f, e.fout());
        });
        Draw.color(Pal.lighterOrange, Pal.lightOrange, Color.gray, e.fin());
        Lines.stroke(1.5f * e.fout());
        Angles.randLenVectors(e.id + 1, 8, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect dynamicExplosion = new Effect(30.0f, 100.0f, e -> {
        float intensity = e.rotation;
        e.scaled(5.0f + intensity * 2.0f, i -> {
            Lines.stroke(3.1f * i.fout());
            Lines.circle(e.x, e.y, (3.0f + i.fin() * 14.0f) * intensity);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors((long)e.id, e.finpow(), (int)(6.0f * intensity), 21.0f * intensity, (x, y, in, out) -> {
            Fill.circle(e.x + x, e.y + y, out * (2.0f + intensity) * 3.0f + 0.5f);
            Fill.circle(e.x + x / 2.0f, e.y + y / 2.0f, out * intensity * 3.0f);
        });
        Draw.color(Pal.lighterOrange, Pal.lightOrange, Color.gray, e.fin());
        Lines.stroke(1.7f * e.fout() * (1.0f + (intensity - 1.0f) / 2.0f));
        Angles.randLenVectors((long)(e.id + 1), e.finpow(), (int)(9.0f * intensity), 40.0f * intensity, (x, y, in, out) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + out * 4.0f * (3.0f + intensity)));
    });
    public static final Effect blockExplosion = new Effect(30.0f, e -> {
        e.scaled(7.0f, i -> {
            Lines.stroke(3.1f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 14.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 6, 2.0f + 19.0f * e.finpow(), (x, y) -> {
            Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.5f);
            Fill.circle(e.x + x / 2.0f, e.y + y / 2.0f, e.fout());
        });
        Draw.color(Pal.lighterOrange, Pal.lightOrange, Color.gray, e.fin());
        Lines.stroke(1.7f * e.fout());
        Angles.randLenVectors(e.id + 1, 9, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect blockExplosionSmoke = new Effect(30.0f, e -> {
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 6, 4.0f + 30.0f * e.finpow(), (x, y) -> {
            Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f);
            Fill.circle(e.x + x / 2.0f, e.y + y / 2.0f, e.fout());
        });
    });
    public static final Effect shootSmall = new Effect(8.0f, e -> {
        Draw.color(Pal.lighterOrange, Pal.lightOrange, e.fin());
        float w = 1.0f + 5.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 15.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 3.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootHeal = new Effect(8.0f, e -> {
        Draw.color(Pal.heal);
        float w = 1.0f + 5.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 17.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 4.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootHealYellow = new Effect(8.0f, e -> {
        Draw.color(Pal.lightTrail);
        float w = 1.0f + 5.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 17.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 4.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootSmallSmoke = new Effect(20.0f, e -> {
        Draw.color(Pal.lighterOrange, Color.lightGray, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 5, e.finpow() * 6.0f, e.rotation, 20.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 1.5f));
    });
    public static final Effect shootBig = new Effect(9.0f, e -> {
        Draw.color(Pal.lighterOrange, Pal.lightOrange, e.fin());
        float w = 1.2f + 7.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 25.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 4.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootBig2 = new Effect(10.0f, e -> {
        Draw.color(Pal.lightOrange, Color.gray, e.fin());
        float w = 1.2f + 8.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 29.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 5.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootBigSmoke = new Effect(17.0f, e -> {
        Draw.color(Pal.lighterOrange, Color.lightGray, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 8, e.finpow() * 19.0f, e.rotation, 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.0f + 0.2f));
    });
    public static final Effect shootBigSmoke2 = new Effect(18.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 9, e.finpow() * 23.0f, e.rotation, 20.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.4f + 0.2f));
    });
    public static final Effect shootSmallFlame = new Effect(32.0f, 80.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 8, e.finpow() * 60.0f, e.rotation, 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.65f + e.fout() * 1.5f));
    });
    public static final Effect shootPyraFlame = new Effect(33.0f, 80.0f, e -> {
        Draw.color(Pal.lightPyraFlame, Pal.darkPyraFlame, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 10, e.finpow() * 70.0f, e.rotation, 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.65f + e.fout() * 1.6f));
    });
    public static final Effect shootLiquid = new Effect(40.0f, 80.0f, e -> {
        Draw.color(e.color, Color.white, e.fout() / 6.0f + Mathf.randomSeedRange(e.id, 0.1f));
        Angles.randLenVectors(e.id, 6, e.finpow() * 60.0f, e.rotation, 11.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.5f + e.fout() * 2.5f));
    });
    public static final Effect casing1 = new Effect(30.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.3f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (2.0f + e.finpow() * 6.0f) * (float)i;
        float lr = rot + e.fin() * 30.0f * (float)i;
        Fill.rect(e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 1.0f, 2.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing2 = new Effect(34.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (2.0f + e.finpow() * 10.0f) * (float)i;
        float lr = rot + e.fin() * 20.0f * (float)i;
        Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.0f, 3.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing3 = new Effect(40.0f, e -> {
        Draw.color(Pal.lightOrange, Pal.lightishGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (4.0f + e.finpow() * 9.0f) * (float)i;
        float lr = rot + Mathf.randomSeedRange(e.id + i + 6, 20.0f * e.fin()) * (float)i;
        Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.5f, 4.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing4 = new Effect(45.0f, e -> {
        Draw.color(Pal.lightOrange, Pal.lightishGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (4.0f + e.finpow() * 9.0f) * (float)i;
        float lr = rot + Mathf.randomSeedRange(e.id + i + 6, 20.0f * e.fin()) * (float)i;
        Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 3.0f, 6.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing2Double = new Effect(34.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        for (int i : Mathf.signs) {
            float len = (2.0f + e.finpow() * 10.0f) * (float)i;
            float lr = rot + e.fin() * 20.0f * (float)i;
            Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.0f, 3.0f, rot + e.fin() * 50.0f * (float)i);
        }
    }).layer(100.0f);
    public static final Effect casing3Double = new Effect(40.0f, e -> {
        Draw.color(Pal.lightOrange, Pal.lightishGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        for (int i : Mathf.signs) {
            float len = (4.0f + e.finpow() * 9.0f) * (float)i;
            float lr = rot + Mathf.randomSeedRange(e.id + i + 6, 20.0f * e.fin()) * (float)i;
            Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.5f, 4.0f, rot + e.fin() * 50.0f * (float)i);
        }
    }).layer(100.0f);
    public static final Effect railShoot = new Effect(24.0f, e -> {
        e.scaled(10.0f, b -> {
            Draw.color(Color.white, Color.lightGray, b.fin());
            Lines.stroke(b.fout() * 3.0f + 0.2f);
            Lines.circle(b.x, b.y, b.fin() * 50.0f);
        });
        Draw.color(Pal.orangeSpark);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 13.0f * e.fout(), 85.0f, e.rotation + 90.0f * (float)i);
        }
    });
    public static final Effect railTrail = new Effect(16.0f, e -> {
        Draw.color(Pal.orangeSpark);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 10.0f * e.fout(), 24.0f, e.rotation + 90.0f + 90.0f * (float)i);
        }
    });
    public static final Effect railHit = new Effect(18.0f, 200.0f, e -> {
        Draw.color(Pal.orangeSpark);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 10.0f * e.fout(), 60.0f, e.rotation + 140.0f * (float)i);
        }
    });
    public static final Effect lancerLaserShoot = new Effect(21.0f, e -> {
        Draw.color(Pal.lancerLaser);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 4.0f * e.fout(), 29.0f, e.rotation + 90.0f * (float)i);
        }
    });
    public static final Effect lancerLaserShootSmoke = new Effect(26.0f, e -> {
        Draw.color(Color.white);
        float length = !(e.data instanceof Float) ? 70.0f : ((Float)e.data).floatValue();
        Angles.randLenVectors(e.id, 7, length, e.rotation, 0.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fout() * 9.0f));
    });
    public static final Effect lancerLaserCharge = new Effect(38.0f, e -> {
        Draw.color(Pal.lancerLaser);
        Angles.randLenVectors(e.id, 2, 1.0f + 20.0f * e.fout(), e.rotation, 120.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 3.0f + 1.0f));
    });
    public static final Effect lancerLaserChargeBegin = new Effect(60.0f, e -> {
        Draw.color(Pal.lancerLaser);
        Fill.circle(e.x, e.y, e.fin() * 3.0f);
        Draw.color();
        Fill.circle(e.x, e.y, e.fin() * 2.0f);
    });
    public static final Effect lightningCharge = new Effect(38.0f, e -> {
        Draw.color(Pal.lancerLaser);
        Angles.randLenVectors(e.id, 2, 1.0f + 20.0f * e.fout(), e.rotation, 120.0f, (x, y) -> Drawf.tri(e.x + x, e.y + y, e.fslope() * 3.0f + 1.0f, e.fslope() * 3.0f + 1.0f, Mathf.angle(x, y)));
    });
    public static final Effect sparkShoot = new Effect(12.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() * 1.2f + 0.6f);
        Angles.randLenVectors(e.id, 7, 25.0f * e.finpow(), e.rotation, 3.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 5.0f + 0.5f));
    });
    public static final Effect lightningShoot = new Effect(12.0f, e -> {
        Draw.color(Color.white, Pal.lancerLaser, e.fin());
        Lines.stroke(e.fout() * 1.2f + 0.5f);
        Angles.randLenVectors(e.id, 7, 25.0f * e.finpow(), e.rotation, 50.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 5.0f + 2.0f));
    });
    public static final Effect thoriumShoot = new Effect(12.0f, e -> {
        Draw.color(Color.white, Pal.thoriumPink, e.fin());
        Lines.stroke(e.fout() * 1.2f + 0.5f);
        Angles.randLenVectors(e.id, 7, 25.0f * e.finpow(), e.rotation, 50.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 5.0f + 2.0f));
    });
    public static final Effect reactorsmoke = new Effect(17.0f, e -> Angles.randLenVectors(e.id, 4, e.fin() * 8.0f, (x, y) -> {
        float size = 1.0f + e.fout() * 5.0f;
        Draw.color(Color.lightGray, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect nuclearsmoke = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 4, e.fin() * 13.0f, (x, y) -> {
        float size = e.fslope() * 4.0f;
        Draw.color(Color.lightGray, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect cloudsmoke = new Effect(70.0f, e -> Angles.randLenVectors(e.id, 12, 15.0f + e.fin() * 45.0f, (x, y) -> {
        float size = e.fslope() * 2.0f;
        Draw.color(Color.gray);
        Draw.alpha(e.fslope());
        Fill.circle(e.x + x, e.y + y, size);
    }));
    public static final Effect nuclearcloud = new Effect(90.0f, 200.0f, e -> Angles.randLenVectors(e.id, 10, e.finpow() * 90.0f, (x, y) -> {
        float size = e.fout() * 14.0f;
        Draw.color(Color.lime, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect impactsmoke = new Effect(60.0f, e -> Angles.randLenVectors(e.id, 7, e.fin() * 20.0f, (x, y) -> {
        float size = e.fslope() * 4.0f;
        Draw.color(Color.lightGray, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect impactcloud = new Effect(140.0f, 400.0f, e -> Angles.randLenVectors(e.id, 20, e.finpow() * 160.0f, (x, y) -> {
        float size = e.fout() * 15.0f;
        Draw.color(Pal.lighterOrange, Color.lightGray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect redgeneratespark = new Effect(18.0f, e -> Angles.randLenVectors(e.id, 5, e.fin() * 8.0f, (x, y) -> {
        float len = e.fout() * 4.0f;
        Draw.color(Pal.redSpark, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, len / 2.0f);
    }));
    public static final Effect generatespark = new Effect(18.0f, e -> Angles.randLenVectors(e.id, 5, e.fin() * 8.0f, (x, y) -> {
        float len = e.fout() * 4.0f;
        Draw.color(Pal.orangeSpark, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, len / 2.0f);
    }));
    public static final Effect fuelburn = new Effect(23.0f, e -> Angles.randLenVectors(e.id, 5, e.fin() * 9.0f, (x, y) -> {
        float len = e.fout() * 4.0f;
        Draw.color(Color.lightGray, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, len / 2.0f);
    }));
    public static final Effect coreBurn = new Effect(23.0f, e -> Angles.randLenVectors(e.id, 5, e.fin() * 9.0f, (x, y) -> {
        float len = e.fout() * 4.0f;
        Draw.color(Pal.accent, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, len / 2.0f);
    }));
    public static final Effect plasticburn = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 5.0f, (x, y) -> {
        Draw.color(Color.valueOf("e9ead3"), Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, e.fout());
    }));
    public static final Effect pulverize = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.stoneGray);
        Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.5f, 45.0f);
    }));
    public static final Effect pulverizeRed = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.redDust, Pal.stoneGray, e.fin());
        Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.5f, 45.0f);
    }));
    public static final Effect pulverizeRedder = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 9.0f, (x, y) -> {
        Draw.color(Pal.redderDust, Pal.stoneGray, e.fin());
        Fill.square(e.x + x, e.y + y, e.fout() * 2.5f + 0.5f, 45.0f);
    }));
    public static final Effect pulverizeSmall = new Effect(30.0f, e -> Angles.randLenVectors(e.id, 3, e.fin() * 5.0f, (x, y) -> {
        Draw.color(Pal.stoneGray);
        Fill.square(e.x + x, e.y + y, e.fout() + 0.5f, 45.0f);
    }));
    public static final Effect pulverizeMedium = new Effect(30.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.stoneGray);
        Fill.square(e.x + x, e.y + y, e.fout() + 0.5f, 45.0f);
    }));
    public static final Effect producesmoke = new Effect(12.0f, e -> Angles.randLenVectors(e.id, 8, 4.0f + e.fin() * 18.0f, (x, y) -> {
        Draw.color(Color.white, Pal.accent, e.fin());
        Fill.square(e.x + x, e.y + y, 1.0f + e.fout() * 3.0f, 45.0f);
    }));
    public static final Effect smokeCloud = new Effect(70.0f, e -> Angles.randLenVectors((long)e.id, e.fin(), 30, 30.0f, (x, y, fin, fout) -> {
        Draw.color(Color.gray);
        Draw.alpha((0.5f - Math.abs(fin - 0.5f)) * 2.0f);
        Fill.circle(e.x + x, e.y + y, 0.5f + fout * 4.0f);
    }));
    public static final Effect smeltsmoke = new Effect(15.0f, e -> Angles.randLenVectors(e.id, 6, 4.0f + e.fin() * 5.0f, (x, y) -> {
        Draw.color(Color.white, e.color, e.fin());
        Fill.square(e.x + x, e.y + y, 0.5f + e.fout() * 2.0f, 45.0f);
    }));
    public static final Effect formsmoke = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 6, 5.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.plasticSmoke, Color.lightGray, e.fin());
        Fill.square(e.x + x, e.y + y, 0.2f + e.fout() * 2.0f, 45.0f);
    }));
    public static final Effect blastsmoke = new Effect(26.0f, e -> Angles.randLenVectors(e.id, 12, 1.0f + e.fin() * 23.0f, (x, y) -> {
        float size = 2.0f + e.fout() * 6.0f;
        Draw.color(Color.lightGray, Color.darkGray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect lava = new Effect(18.0f, e -> Angles.randLenVectors(e.id, 3, 1.0f + e.fin() * 10.0f, (x, y) -> {
        float size = e.fslope() * 4.0f;
        Draw.color(Color.orange, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect dooropen = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, 4.0f + e.fin() * 2.0f);
    });
    public static final Effect doorclose = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, 4.0f + e.fout() * 2.0f);
    });
    public static final Effect dooropenlarge = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, 8.0f + e.fin() * 2.0f);
    });
    public static final Effect doorcloselarge = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, 8.0f + e.fout() * 2.0f);
    });
    public static final Effect purify = new Effect(10.0f, e -> {
        Draw.color(Color.royal, Color.gray, e.fin());
        Lines.stroke(2.0f);
        Lines.spikes(e.x, e.y, e.fin() * 4.0f, 2.0f, 6);
    });
    public static final Effect purifyoil = new Effect(10.0f, e -> {
        Draw.color(Color.black, Color.gray, e.fin());
        Lines.stroke(2.0f);
        Lines.spikes(e.x, e.y, e.fin() * 4.0f, 2.0f, 6);
    });
    public static final Effect purifystone = new Effect(10.0f, e -> {
        Draw.color(Color.orange, Color.gray, e.fin());
        Lines.stroke(2.0f);
        Lines.spikes(e.x, e.y, e.fin() * 4.0f, 2.0f, 6);
    });
    public static final Effect generate = new Effect(11.0f, e -> {
        Draw.color(Color.orange, Color.yellow, e.fin());
        Lines.stroke(1.0f);
        Lines.spikes(e.x, e.y, e.fin() * 5.0f, 2.0f, 8);
    });
    public static final Effect mine = new Effect(20.0f, e -> Angles.randLenVectors(e.id, 6, 3.0f + e.fin() * 6.0f, (x, y) -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Fill.square(e.x + x, e.y + y, e.fout() * 2.0f, 45.0f);
    }));
    public static final Effect mineBig = new Effect(30.0f, e -> Angles.randLenVectors(e.id, 6, 4.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.2f, 45.0f);
    }));
    public static final Effect mineHuge = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 8, 5.0f + e.fin() * 10.0f, (x, y) -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.5f, 45.0f);
    }));
    public static final Effect smelt = new Effect(20.0f, e -> Angles.randLenVectors(e.id, 6, 2.0f + e.fin() * 5.0f, (x, y) -> {
        Draw.color(Color.white, e.color, e.fin());
        Fill.square(e.x + x, e.y + y, 0.5f + e.fout() * 2.0f, 45.0f);
    }));
    public static final Effect teleportActivate = new Effect(50.0f, e -> {
        Draw.color(e.color);
        e.scaled(8.0f, e2 -> {
            Lines.stroke(e2.fout() * 4.0f);
            Lines.circle(e2.x, e2.y, 4.0f + e2.fin() * 27.0f);
        });
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 30, 4.0f + 40.0f * e.fin(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 4.0f + 1.0f));
    });
    public static final Effect teleport = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fin() * 2.0f);
        Lines.circle(e.x, e.y, 7.0f + e.fout() * 8.0f);
        Angles.randLenVectors(e.id, 20, 6.0f + 20.0f * e.fout(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 4.0f + 1.0f));
    });
    public static final Effect teleportOut = new Effect(20.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 7.0f + e.fin() * 8.0f);
        Angles.randLenVectors(e.id, 20, 4.0f + 20.0f * e.fin(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 4.0f + 1.0f));
    });
    public static final Effect ripple = new Effect(30.0f, e -> {
        e.lifetime = 30.0f * e.rotation;
        Draw.color(Tmp.c1.set(e.color).mul(1.5f));
        Lines.stroke(e.fout() * 1.4f);
        Lines.circle(e.x, e.y, (2.0f + e.fin() * 4.0f) * e.rotation);
    }).layer(20.0f);
    public static final Effect bubble = new Effect(20.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).shiftValue(0.1f));
        Lines.stroke(e.fout() + 0.2f);
        Angles.randLenVectors(e.id, 2, 8.0f, (x, y) -> Lines.circle(e.x + x, e.y + y, 1.0f + e.fin() * 3.0f));
    });
    public static final Effect launch = new Effect(28.0f, e -> {
        Draw.color(Pal.command);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 120.0f);
    });
    public static final Effect launchPod = new Effect(50.0f, e -> {
        Draw.color(Pal.engine);
        e.scaled(25.0f, f -> {
            Lines.stroke(f.fout() * 2.0f);
            Lines.circle(e.x, e.y, 4.0f + f.finpow() * 30.0f);
        });
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 24, e.finpow() * 50.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect healWaveMend = new Effect(40.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, e.finpow() * e.rotation);
    });
    public static final Effect overdriveWave = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout());
        Lines.circle(e.x, e.y, e.finpow() * e.rotation);
    });
    public static final Effect healBlock = new Effect(20.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(2.0f * e.fout() + 0.5f);
        Lines.square(e.x, e.y, 1.0f + (e.fin() * e.rotation * 8.0f / 2.0f - 1.0f));
    });
    public static final Effect healBlockFull = new Effect(20.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fout());
        Fill.square(e.x, e.y, e.rotation * 8.0f / 2.0f);
    });
    public static final Effect rotateBlock = new Effect(30.0f, e -> {
        Draw.color(Pal.accent);
        Draw.alpha(e.fout() * 1.0f);
        Fill.square(e.x, e.y, e.rotation * 8.0f / 2.0f);
    });
    public static final Effect lightBlock = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fout() * 1.0f);
        Fill.square(e.x, e.y, e.rotation * 8.0f / 2.0f);
    });
    public static final Effect overdriveBlockFull = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fslope() * 0.4f);
        Fill.square(e.x, e.y, e.rotation * 8.0f);
    });
    public static final Effect shieldBreak = new Effect(40.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(3.0f * e.fout());
        Lines.poly(e.x, e.y, 6, e.rotation + e.fin());
    });
    public static final Effect unitShieldBreak = new Effect(35.0f, e -> {
        if (!(e.data instanceof Unitc)) {
            return;
        }
        Unit unit = (Unit)e.data();
        float radius = unit.hitSize() * 1.3f;
        e.scaled(16.0f, c -> {
            Draw.color(Pal.shield);
            Lines.stroke(c.fout() * 2.0f + 0.1f);
            Angles.randLenVectors(e.id, (int)(radius * 1.2f), radius / 2.0f + c.finpow() * radius * 1.25f, (x, y) -> Lines.lineAngle(c.x + x, c.y + y, Mathf.angle(x, y), c.fout() * 5.0f + 1.0f));
        });
        Draw.color(Pal.shield, e.fout());
        Lines.stroke(e.fout());
        Lines.circle(e.x, e.y, radius);
    });
    public static final Effect coreLand = new Effect(120.0f, e -> {});
}

