/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.Events;
import arc.graphics.Color;
import arc.math.Mathf;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.ctype.ContentList;
import mindustry.game.EventType;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;

public class StatusEffects
implements ContentList {
    public static StatusEffect none;
    public static StatusEffect burning;
    public static StatusEffect freezing;
    public static StatusEffect unmoving;
    public static StatusEffect slow;
    public static StatusEffect wet;
    public static StatusEffect muddy;
    public static StatusEffect melting;
    public static StatusEffect sapped;
    public static StatusEffect tarred;
    public static StatusEffect overdrive;
    public static StatusEffect overclock;
    public static StatusEffect shielded;
    public static StatusEffect shocked;
    public static StatusEffect blasted;
    public static StatusEffect corroded;
    public static StatusEffect boss;
    public static StatusEffect sporeSlowed;
    public static StatusEffect disarmed;

    @Override
    public void load() {
        none = new StatusEffect("none");
        burning = new StatusEffect("burning"){
            {
                this.color = Color.valueOf("ffc455");
                this.damage = 0.12f;
                this.effect = Fx.burning;
                this.transitionDamage = 8.0f;
                this.init(() -> {
                    this.opposite(wet, freezing);
                    this.affinity(tarred, (unit, time, newTime, result) -> {
                        unit.damagePierce(this.transitionDamage);
                        Fx.burning.at(unit.x + Mathf.range(unit.bounds() / 2.0f), unit.y + Mathf.range(unit.bounds() / 2.0f));
                        result.set(burning, Math.min(time + newTime, 300.0f));
                    });
                });
            }
        };
        freezing = new StatusEffect("freezing"){
            {
                this.color = Color.valueOf("6ecdec");
                this.speedMultiplier = 0.6f;
                this.healthMultiplier = 0.8f;
                this.effect = Fx.freezing;
                this.transitionDamage = 18.0f;
                this.init(() -> {
                    this.opposite(melting, burning);
                    this.affinity(blasted, (unit, time, newTime, result) -> {
                        unit.damagePierce(this.transitionDamage);
                        result.set(freezing, time);
                    });
                });
            }
        };
        unmoving = new StatusEffect("unmoving"){
            {
                this.color = Pal.gray;
                this.speedMultiplier = 0.001f;
            }
        };
        slow = new StatusEffect("slow"){
            {
                this.color = Pal.lightishGray;
                this.speedMultiplier = 0.4f;
            }
        };
        wet = new StatusEffect("wet"){
            {
                this.color = Color.royal;
                this.speedMultiplier = 0.94f;
                this.effect = Fx.wet;
                this.effectChance = 0.09f;
                this.transitionDamage = 14.0f;
                this.init(() -> {
                    this.affinity(shocked, (unit, time, newTime, result) -> {
                        unit.damagePierce(this.transitionDamage);
                        if (unit.team == Vars.state.rules.waveTeam) {
                            Events.fire(EventType.Trigger.shock);
                        }
                        result.set(wet, time);
                    });
                    this.opposite(burning);
                });
            }
        };
        muddy = new StatusEffect("muddy"){
            {
                this.color = Color.valueOf("46382a");
                this.speedMultiplier = 0.94f;
                this.effect = Fx.muddy;
                this.effectChance = 0.09f;
            }
        };
        melting = new StatusEffect("melting"){
            {
                this.color = Color.valueOf("ffa166");
                this.speedMultiplier = 0.8f;
                this.healthMultiplier = 0.8f;
                this.damage = 0.3f;
                this.effect = Fx.melting;
                this.init(() -> {
                    this.opposite(wet, freezing);
                    this.affinity(tarred, (unit, time, newTime, result) -> {
                        unit.damagePierce(8.0f);
                        Fx.burning.at(unit.x + Mathf.range(unit.bounds() / 2.0f), unit.y + Mathf.range(unit.bounds() / 2.0f));
                        result.set(melting, Math.min(time + newTime, 200.0f));
                    });
                });
            }
        };
        sapped = new StatusEffect("sapped"){
            {
                this.color = Pal.sap;
                this.speedMultiplier = 0.7f;
                this.healthMultiplier = 0.8f;
                this.effect = Fx.sapped;
                this.effectChance = 0.1f;
            }
        };
        sporeSlowed = new StatusEffect("spore-slowed"){
            {
                this.color = Pal.spore;
                this.speedMultiplier = 0.8f;
                this.effect = Fx.sapped;
                this.effectChance = 0.04f;
            }
        };
        tarred = new StatusEffect("tarred"){
            {
                this.color = Color.valueOf("313131");
                this.speedMultiplier = 0.6f;
                this.effect = Fx.oily;
                this.init(() -> {
                    this.affinity(melting, (unit, time, newTime, result) -> result.set(melting, newTime + time));
                    this.affinity(burning, (unit, time, newTime, result) -> result.set(burning, newTime + time));
                });
            }
        };
        overdrive = new StatusEffect("overdrive"){
            {
                this.color = Pal.accent;
                this.healthMultiplier = 0.95f;
                this.speedMultiplier = 1.15f;
                this.damageMultiplier = 1.4f;
                this.damage = -0.01f;
                this.effect = Fx.overdriven;
                this.permanent = true;
            }
        };
        overclock = new StatusEffect("overclock"){
            {
                this.color = Pal.accent;
                this.speedMultiplier = 1.15f;
                this.damageMultiplier = 1.15f;
                this.reloadMultiplier = 1.25f;
                this.effectChance = 0.07f;
                this.effect = Fx.overclocked;
            }
        };
        shielded = new StatusEffect("shielded"){
            {
                this.color = Pal.accent;
                this.healthMultiplier = 3.0f;
            }
        };
        boss = new StatusEffect("boss"){
            {
                this.color = Pal.health;
                this.permanent = true;
                this.damageMultiplier = 1.3f;
                this.healthMultiplier = 1.5f;
            }
        };
        shocked = new StatusEffect("shocked"){
            {
                this.color = Pal.lancerLaser;
                this.reactive = true;
            }
        };
        blasted = new StatusEffect("blasted"){
            {
                this.color = Color.valueOf("ff795e");
                this.reactive = true;
            }
        };
        corroded = new StatusEffect("corroded"){
            {
                this.color = Pal.plastanium;
                this.damage = 0.1f;
            }
        };
        disarmed = new StatusEffect("disarmed"){
            {
                this.color = Color.valueOf("e9ead3");
                this.disarm = true;
            }
        };
    }
}

