/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.graphics.Color;
import arc.struct.ObjectSet;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.DefenderAI;
import mindustry.ai.types.MinerAI;
import mindustry.ai.types.RepairAI;
import mindustry.ai.types.SuicideAI;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.ctype.ContentList;
import mindustry.entities.abilities.ForceFieldAbility;
import mindustry.entities.abilities.RepairFieldAbility;
import mindustry.entities.abilities.ShieldRegenFieldAbility;
import mindustry.entities.abilities.StatusFieldAbility;
import mindustry.entities.abilities.UnitSpawnAbility;
import mindustry.entities.bullet.ArtilleryBulletType;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BombBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ContinuousLaserBulletType;
import mindustry.entities.bullet.FlakBulletType;
import mindustry.entities.bullet.LaserBoltBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.entities.bullet.LightningBulletType;
import mindustry.entities.bullet.LiquidBulletType;
import mindustry.entities.bullet.MissileBulletType;
import mindustry.entities.bullet.RailBulletType;
import mindustry.entities.bullet.SapBulletType;
import mindustry.entities.bullet.ShrapnelBulletType;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.AmmoTypes;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.world.meta.BlockFlag;

public class UnitTypes
implements ContentList {
    public static UnitType mace;
    public static UnitType dagger;
    public static UnitType crawler;
    public static UnitType fortress;
    public static UnitType scepter;
    public static UnitType reign;
    public static UnitType nova;
    public static UnitType pulsar;
    public static UnitType quasar;
    public static UnitType vela;
    public static UnitType corvus;
    public static UnitType atrax;
    public static UnitType spiroct;
    public static UnitType arkyid;
    public static UnitType toxopid;
    public static UnitType flare;
    public static UnitType eclipse;
    public static UnitType horizon;
    public static UnitType zenith;
    public static UnitType antumbra;
    public static UnitType mono;
    public static UnitType poly;
    public static UnitType mega;
    public static UnitType quad;
    public static UnitType oct;
    public static UnitType alpha;
    public static UnitType beta;
    public static UnitType gamma;
    public static UnitType risso;
    public static UnitType minke;
    public static UnitType bryde;
    public static UnitType sei;
    public static UnitType omura;
    public static UnitType block;

    @Override
    public void load() {
        dagger = new UnitType("dagger"){
            {
                this.speed = 0.5f;
                this.hitSize = 8.0f;
                this.health = 140.0f;
                this.weapons.add(new Weapon("large-weapon"){
                    {
                        this.reload = 14.0f;
                        this.x = 4.0f;
                        this.y = 2.0f;
                        this.top = false;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = Bullets.standardCopper;
                    }
                });
            }
        };
        mace = new UnitType("mace"){
            {
                this.speed = 0.4f;
                this.hitSize = 9.0f;
                this.health = 500.0f;
                this.armor = 4.0f;
                this.immunities.add(StatusEffects.burning);
                this.weapons.add(new Weapon("flamethrower"){
                    {
                        this.top = false;
                        this.shootSound = Sounds.flame;
                        this.shootY = 2.0f;
                        this.reload = 14.0f;
                        this.recoil = 1.0f;
                        this.ejectEffect = Fx.none;
                        this.bullet = new BulletType(3.9f, 30.0f){
                            {
                                this.ammoMultiplier = 3.0f;
                                this.hitSize = 7.0f;
                                this.lifetime = 12.0f;
                                this.pierce = true;
                                this.statusDuration = 240.0f;
                                this.shootEffect = Fx.shootSmallFlame;
                                this.hitEffect = Fx.hitFlameSmall;
                                this.despawnEffect = Fx.none;
                                this.status = StatusEffects.burning;
                                this.keepVelocity = false;
                                this.hittable = false;
                            }
                        };
                    }
                });
            }
        };
        fortress = new UnitType("fortress"){
            {
                this.speed = 0.39f;
                this.hitSize = 13.0f;
                this.rotateSpeed = 3.0f;
                this.targetAir = false;
                this.health = 800.0f;
                this.armor = 9.0f;
                this.mechFrontSway = 0.55f;
                this.weapons.add(new Weapon("artillery"){
                    {
                        this.top = false;
                        this.y = 1.0f;
                        this.x = 9.0f;
                        this.reload = 60.0f;
                        this.recoil = 4.0f;
                        this.shake = 2.0f;
                        this.ejectEffect = Fx.casing2;
                        this.shootSound = Sounds.artillery;
                        this.bullet = new ArtilleryBulletType(2.0f, 8.0f, "shell"){
                            {
                                this.hitEffect = Fx.blastExplosion;
                                this.knockback = 0.8f;
                                this.lifetime = 110.0f;
                                this.height = 14.0f;
                                this.width = 14.0f;
                                this.collides = true;
                                this.collidesTiles = true;
                                this.splashDamageRadius = 28.0f;
                                this.splashDamage = 54.0f;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                            }
                        };
                    }
                });
            }
        };
        scepter = new UnitType("scepter"){
            {
                this.speed = 0.35f;
                this.hitSize = 20.0f;
                this.rotateSpeed = 2.1f;
                this.health = 9000.0f;
                this.armor = 10.0f;
                this.canDrown = false;
                this.mechFrontSway = 1.0f;
                this.mechStepParticles = true;
                this.mechStepShake = 0.15f;
                this.singleTarget = true;
                this.weapons.add(new Weapon("scepter-weapon"){
                    {
                        this.top = false;
                        this.y = 1.0f;
                        this.x = 16.0f;
                        this.shootY = 8.0f;
                        this.reload = 45.0f;
                        this.recoil = 5.0f;
                        this.shake = 2.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.bang;
                        this.shots = 3;
                        this.inaccuracy = 3.0f;
                        this.shotDelay = 4.0f;
                        this.bullet = new BasicBulletType(7.0f, 45.0f){
                            {
                                this.width = 11.0f;
                                this.height = 20.0f;
                                this.lifetime = 25.0f;
                                this.shootEffect = Fx.shootBig;
                                this.lightning = 2;
                                this.lightningLength = 6;
                                this.lightningColor = Pal.surge;
                                this.lightningDamage = 19.0f;
                            }
                        };
                    }
                }, new Weapon("mount-weapon"){
                    {
                        this.reload = 13.0f;
                        this.x = 8.5f;
                        this.y = 6.0f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = Bullets.standardCopper;
                    }
                }, new Weapon("mount-weapon"){
                    {
                        this.reload = 16.0f;
                        this.x = 8.5f;
                        this.y = -7.0f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = Bullets.standardCopper;
                    }
                });
            }
        };
        reign = new UnitType("reign"){
            {
                this.speed = 0.35f;
                this.hitSize = 26.0f;
                this.rotateSpeed = 1.65f;
                this.health = 24000.0f;
                this.armor = 14.0f;
                this.mechStepParticles = true;
                this.mechStepShake = 0.75f;
                this.canDrown = false;
                this.mechFrontSway = 1.9f;
                this.mechSideSway = 0.6f;
                this.weapons.add(new Weapon("reign-weapon"){
                    {
                        this.top = false;
                        this.y = 1.0f;
                        this.x = 21.5f;
                        this.shootY = 11.0f;
                        this.reload = 9.0f;
                        this.recoil = 5.0f;
                        this.shake = 2.0f;
                        this.ejectEffect = Fx.casing4;
                        this.shootSound = Sounds.bang;
                        this.bullet = new BasicBulletType(13.0f, 65.0f){
                            {
                                this.pierce = true;
                                this.pierceCap = 10;
                                this.width = 14.0f;
                                this.height = 33.0f;
                                this.lifetime = 15.0f;
                                this.shootEffect = Fx.shootBig;
                                this.fragVelocityMin = 0.4f;
                                this.hitEffect = Fx.blastExplosion;
                                this.splashDamage = 16.0f;
                                this.splashDamageRadius = 13.0f;
                                this.fragBullets = 2;
                                this.fragLifeMin = 0.0f;
                                this.fragCone = 30.0f;
                                this.fragBullet = new BasicBulletType(9.0f, 18.0f){
                                    {
                                        this.width = 10.0f;
                                        this.height = 10.0f;
                                        this.pierce = true;
                                        this.pierceBuilding = true;
                                        this.pierceCap = 3;
                                        this.lifetime = 20.0f;
                                        this.hitEffect = Fx.flakExplosion;
                                        this.splashDamage = 15.0f;
                                        this.splashDamageRadius = 10.0f;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        nova = new UnitType("nova"){
            {
                this.canBoost = true;
                this.boostMultiplier = 1.5f;
                this.speed = 0.55f;
                this.hitSize = 8.0f;
                this.health = 120.0f;
                this.buildSpeed = 0.8f;
                this.armor = 1.0f;
                this.commandLimit = 8;
                this.abilities.add(new RepairFieldAbility(10.0f, 240.0f, 60.0f));
                this.ammoType = AmmoTypes.power;
                this.weapons.add(new Weapon("heal-weapon"){
                    {
                        this.top = false;
                        this.shootY = 2.0f;
                        this.reload = 24.0f;
                        this.x = 4.5f;
                        this.alternate = false;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.shootSound = Sounds.lasershoot;
                        this.bullet = new LaserBoltBulletType(5.2f, 14.0f){
                            {
                                this.lifetime = 32.0f;
                                this.healPercent = 5.0f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                            }
                        };
                    }
                });
            }
        };
        pulsar = new UnitType("pulsar"){
            {
                this.canBoost = true;
                this.boostMultiplier = 1.6f;
                this.speed = 0.7f;
                this.hitSize = 10.0f;
                this.health = 320.0f;
                this.buildSpeed = 0.9f;
                this.armor = 4.0f;
                this.riseSpeed = 0.07f;
                this.mineTier = 2;
                this.mineSpeed = 5.0f;
                this.commandLimit = 9;
                this.abilities.add(new ShieldRegenFieldAbility(20.0f, 40.0f, 300.0f, 60.0f));
                this.ammoType = AmmoTypes.power;
                this.weapons.add(new Weapon("heal-shotgun-weapon"){
                    {
                        this.top = false;
                        this.x = 5.0f;
                        this.shake = 2.2f;
                        this.y = 0.5f;
                        this.shootY = 2.5f;
                        this.reload = 38.0f;
                        this.shots = 3;
                        this.inaccuracy = 35.0f;
                        this.shotDelay = 0.5f;
                        this.spacing = 0.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.5f;
                        this.shootSound = Sounds.spark;
                        this.bullet = new LightningBulletType(){
                            {
                                this.lightningColor = this.hitColor = Pal.heal;
                                this.damage = 12.0f;
                                this.lightningLength = 7;
                                this.lightningLengthRand = 7;
                                this.shootEffect = Fx.shootHeal;
                                this.healPercent = 2.0f;
                                this.lightningType = new BulletType(1.0E-4f, 0.0f){
                                    {
                                        this.lifetime = Fx.lightning.lifetime;
                                        this.hitEffect = Fx.hitLancer;
                                        this.despawnEffect = Fx.none;
                                        this.status = StatusEffects.shocked;
                                        this.statusDuration = 10.0f;
                                        this.hittable = false;
                                        this.healPercent = 2.0f;
                                        this.collidesTeam = true;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        quasar = new UnitType("quasar"){
            {
                this.mineTier = 3;
                this.boostMultiplier = 2.0f;
                this.health = 650.0f;
                this.buildSpeed = 1.7f;
                this.canBoost = true;
                this.armor = 9.0f;
                this.landShake = 2.0f;
                this.riseSpeed = 0.05f;
                this.commandLimit = 10;
                this.mechFrontSway = 0.55f;
                this.ammoType = AmmoTypes.power;
                this.speed = 0.4f;
                this.hitSize = 10.0f;
                this.mineSpeed = 6.0f;
                this.drawShields = false;
                this.abilities.add(new ForceFieldAbility(60.0f, 0.3f, 400.0f, 360.0f));
                this.weapons.add(new Weapon("beam-weapon"){
                    {
                        this.top = false;
                        this.shake = 2.0f;
                        this.shootY = 4.0f;
                        this.x = 6.5f;
                        this.reload = 50.0f;
                        this.recoil = 4.0f;
                        this.shootSound = Sounds.laser;
                        this.bullet = new LaserBulletType(){
                            {
                                this.damage = 45.0f;
                                this.recoil = 1.0f;
                                this.sideAngle = 45.0f;
                                this.sideWidth = 1.0f;
                                this.sideLength = 70.0f;
                                this.healPercent = 10.0f;
                                this.collidesTeam = true;
                                this.colors = new Color[]{Pal.heal.cpy().a(0.4f), Pal.heal, Color.white};
                            }
                        };
                    }
                });
            }
        };
        vela = new UnitType("vela"){
            {
                this.hitSize = 23.0f;
                this.rotateSpeed = 1.6f;
                this.canDrown = false;
                this.mechFrontSway = 1.0f;
                this.buildSpeed = 3.0f;
                this.mechStepParticles = true;
                this.mechStepShake = 0.15f;
                this.ammoType = AmmoTypes.powerHigh;
                this.speed = 0.39f;
                this.boostMultiplier = 2.2f;
                this.engineOffset = 12.0f;
                this.engineSize = 6.0f;
                this.lowAltitude = true;
                this.riseSpeed = 0.02f;
                this.health = 7500.0f;
                this.armor = 9.0f;
                this.canBoost = true;
                this.landShake = 4.0f;
                this.immunities = ObjectSet.with(StatusEffects.burning);
                this.commandLimit = 8;
                this.weapons.add(new Weapon("vela-weapon"){
                    {
                        this.mirror = false;
                        this.top = false;
                        this.shake = 4.0f;
                        this.shootY = 13.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.firstShotDelay = Fx.greenLaserChargeSmall.lifetime - 1.0f;
                        this.reload = 155.0f;
                        this.recoil = 0.0f;
                        this.chargeSound = Sounds.lasercharge2;
                        this.shootSound = Sounds.beam;
                        this.continuous = true;
                        this.cooldownTime = 200.0f;
                        this.bullet = new ContinuousLaserBulletType(){
                            {
                                this.damage = 30.0f;
                                this.length = 175.0f;
                                this.hitEffect = Fx.hitMeltHeal;
                                this.drawSize = 420.0f;
                                this.lifetime = 160.0f;
                                this.shake = 1.0f;
                                this.despawnEffect = Fx.smokeCloud;
                                this.smokeEffect = Fx.none;
                                this.shootEffect = Fx.greenLaserChargeSmall;
                                this.incendChance = 0.1f;
                                this.incendSpread = 5.0f;
                                this.incendAmount = 1;
                                this.healPercent = 1.0f;
                                this.collidesTeam = true;
                                this.colors = new Color[]{Pal.heal.cpy().a(0.2f), Pal.heal.cpy().a(0.5f), Pal.heal.cpy().mul(1.2f), Color.white};
                            }
                        };
                        this.shootStatus = StatusEffects.slow;
                        this.shootStatusDuration = this.bullet.lifetime + this.firstShotDelay;
                    }
                });
            }
        };
        corvus = new UnitType("corvus"){
            {
                this.hitSize = 29.0f;
                this.health = 18000.0f;
                this.armor = 9.0f;
                this.landShake = 1.5f;
                this.rotateSpeed = 1.5f;
                this.commandLimit = 8;
                this.legCount = 4;
                this.legLength = 14.0f;
                this.legBaseOffset = 11.0f;
                this.legMoveSpace = 1.5f;
                this.legTrns = 0.58f;
                this.hovering = true;
                this.visualElevation = 0.2f;
                this.allowLegStep = true;
                this.ammoType = AmmoTypes.powerHigh;
                this.groundLayer = 75.0f;
                this.speed = 0.3f;
                this.mineTier = 2;
                this.mineSpeed = 7.0f;
                this.drawShields = false;
                this.weapons.add(new Weapon("corvus-weapon"){
                    {
                        this.shootSound = Sounds.laserblast;
                        this.chargeSound = Sounds.lasercharge;
                        this.soundPitchMin = 1.0f;
                        this.top = false;
                        this.mirror = false;
                        this.shake = 14.0f;
                        this.shootY = 5.0f;
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.reload = 350.0f;
                        this.recoil = 0.0f;
                        this.cooldownTime = 350.0f;
                        this.shootStatusDuration = 120.0f;
                        this.shootStatus = StatusEffects.unmoving;
                        this.firstShotDelay = Fx.greenLaserCharge.lifetime;
                        this.bullet = new LaserBulletType(){
                            {
                                this.length = 460.0f;
                                this.damage = 560.0f;
                                this.width = 75.0f;
                                this.lifetime = 65.0f;
                                this.lightningSpacing = 35.0f;
                                this.lightningLength = 5;
                                this.lightningDelay = 1.1f;
                                this.lightningLengthRand = 15;
                                this.lightningDamage = 50.0f;
                                this.lightningAngleRand = 40.0f;
                                this.largeHit = true;
                                this.lightColor = this.lightningColor = Pal.heal;
                                this.shootEffect = Fx.greenLaserCharge;
                                this.healPercent = 25.0f;
                                this.collidesTeam = true;
                                this.sideAngle = 15.0f;
                                this.sideWidth = 0.0f;
                                this.sideLength = 0.0f;
                                this.colors = new Color[]{Pal.heal.cpy().a(0.4f), Pal.heal, Color.white};
                            }
                        };
                    }
                });
            }
        };
        crawler = new UnitType("crawler"){
            {
                this.defaultController = SuicideAI::new;
                this.speed = 1.0f;
                this.hitSize = 8.0f;
                this.health = 180.0f;
                this.mechSideSway = 0.25f;
                this.range = 40.0f;
                this.weapons.add(new Weapon(){
                    {
                        this.reload = 24.0f;
                        this.shootCone = 180.0f;
                        this.ejectEffect = Fx.none;
                        this.shootSound = Sounds.explosion;
                        this.bullet = new BombBulletType(0.0f, 0.0f, "clear"){
                            {
                                this.hitEffect = Fx.pulverize;
                                this.lifetime = 10.0f;
                                this.speed = 1.0f;
                                this.splashDamageRadius = 58.0f;
                                this.instantDisappear = true;
                                this.splashDamage = 85.0f;
                                this.killShooter = true;
                                this.hittable = false;
                                this.collidesAir = true;
                            }
                        };
                    }
                });
            }
        };
        atrax = new UnitType("atrax"){
            {
                this.speed = 0.5f;
                this.drag = 0.4f;
                this.hitSize = 10.0f;
                this.rotateSpeed = 3.0f;
                this.targetAir = false;
                this.health = 600.0f;
                this.immunities = ObjectSet.with(StatusEffects.burning, StatusEffects.melting);
                this.legCount = 4;
                this.legLength = 9.0f;
                this.legTrns = 0.6f;
                this.legMoveSpace = 1.4f;
                this.hovering = true;
                this.armor = 3.0f;
                this.allowLegStep = true;
                this.visualElevation = 0.2f;
                this.groundLayer = 74.0f;
                this.weapons.add(new Weapon("eruption"){
                    {
                        this.top = false;
                        this.shootY = 3.0f;
                        this.reload = 10.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 1.0f;
                        this.x = 7.0f;
                        this.shootSound = Sounds.flame;
                        this.bullet = new LiquidBulletType(Liquids.slag){
                            {
                                this.damage = 11.0f;
                                this.speed = 2.3f;
                                this.drag = 0.01f;
                                this.shootEffect = Fx.shootSmall;
                                this.lifetime = 56.0f;
                                this.collidesAir = false;
                            }
                        };
                    }
                });
            }
        };
        spiroct = new UnitType("spiroct"){
            {
                this.speed = 0.4f;
                this.drag = 0.4f;
                this.hitSize = 12.0f;
                this.rotateSpeed = 3.0f;
                this.health = 900.0f;
                this.immunities = ObjectSet.with(StatusEffects.burning, StatusEffects.melting);
                this.legCount = 6;
                this.legLength = 13.0f;
                this.legTrns = 0.8f;
                this.legMoveSpace = 1.4f;
                this.legBaseOffset = 2.0f;
                this.hovering = true;
                this.armor = 5.0f;
                this.ammoType = AmmoTypes.power;
                this.buildSpeed = 0.75f;
                this.allowLegStep = true;
                this.visualElevation = 0.3f;
                this.groundLayer = 75.0f;
                this.weapons.add(new Weapon("spiroct-weapon"){
                    {
                        this.shootY = 4.0f;
                        this.reload = 15.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.rotate = true;
                        this.shootSound = Sounds.sap;
                        this.x = 8.5f;
                        this.y = -1.5f;
                        this.bullet = new SapBulletType(){
                            {
                                this.sapStrength = 0.4f;
                                this.length = 75.0f;
                                this.damage = 20.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.hitColor = this.color = Color.valueOf("bf92f9");
                                this.despawnEffect = Fx.none;
                                this.width = 0.54f;
                                this.lifetime = 35.0f;
                                this.knockback = -1.24f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("mount-purple-weapon"){
                    {
                        this.reload = 20.0f;
                        this.rotate = true;
                        this.x = 4.0f;
                        this.y = 3.0f;
                        this.shootSound = Sounds.sap;
                        this.bullet = new SapBulletType(){
                            {
                                this.sapStrength = 0.8f;
                                this.length = 40.0f;
                                this.damage = 16.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.hitColor = this.color = Color.valueOf("bf92f9");
                                this.despawnEffect = Fx.none;
                                this.width = 0.4f;
                                this.lifetime = 25.0f;
                                this.knockback = -0.65f;
                            }
                        };
                    }
                });
            }
        };
        arkyid = new UnitType("arkyid"){
            {
                this.drag = 0.1f;
                this.speed = 0.5f;
                this.hitSize = 21.0f;
                this.health = 8000.0f;
                this.armor = 6.0f;
                this.rotateSpeed = 2.7f;
                this.legCount = 6;
                this.legMoveSpace = 1.0f;
                this.legPairOffset = 3.0f;
                this.legLength = 30.0f;
                this.legExtension = -15.0f;
                this.legBaseOffset = 10.0f;
                this.landShake = 1.0f;
                this.legLengthScl = 0.96f;
                this.rippleScale = 2.0f;
                this.legSpeed = 0.2f;
                this.ammoType = AmmoTypes.power;
                this.buildSpeed = 1.0f;
                this.legSplashDamage = 32.0f;
                this.legSplashRange = 30.0f;
                this.hovering = true;
                this.allowLegStep = true;
                this.visualElevation = 0.65f;
                this.groundLayer = 75.0f;
                final SapBulletType sapper = new SapBulletType(){
                    {
                        this.sapStrength = 0.85f;
                        this.length = 55.0f;
                        this.damage = 37.0f;
                        this.shootEffect = Fx.shootSmall;
                        this.hitColor = this.color = Color.valueOf("bf92f9");
                        this.despawnEffect = Fx.none;
                        this.width = 0.55f;
                        this.lifetime = 30.0f;
                        this.knockback = -1.0f;
                    }
                };
                this.weapons.add(new Weapon("spiroct-weapon"){
                    {
                        super(name);
                        this.reload = 9.0f;
                        this.x = 4.0f;
                        this.y = 8.0f;
                        this.rotate = true;
                        this.bullet = sapper;
                        this.shootSound = Sounds.sap;
                    }
                }, new Weapon("spiroct-weapon"){
                    {
                        super(name);
                        this.reload = 15.0f;
                        this.x = 9.0f;
                        this.y = 6.0f;
                        this.rotate = true;
                        this.bullet = sapper;
                        this.shootSound = Sounds.sap;
                    }
                }, new Weapon("spiroct-weapon"){
                    {
                        super(name);
                        this.reload = 23.0f;
                        this.x = 14.0f;
                        this.y = 0.0f;
                        this.rotate = true;
                        this.bullet = sapper;
                        this.shootSound = Sounds.sap;
                    }
                }, new Weapon("large-purple-mount"){
                    {
                        this.y = -7.0f;
                        this.x = 9.0f;
                        this.shootY = 7.0f;
                        this.reload = 45.0f;
                        this.shake = 3.0f;
                        this.rotateSpeed = 2.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.artillery;
                        this.rotate = true;
                        this.shadow = 8.0f;
                        this.recoil = 3.0f;
                        this.bullet = new ArtilleryBulletType(2.0f, 12.0f){
                            {
                                this.hitEffect = Fx.sapExplosion;
                                this.knockback = 0.8f;
                                this.lifetime = 70.0f;
                                this.height = 19.0f;
                                this.width = 19.0f;
                                this.collidesTiles = true;
                                this.ammoMultiplier = 4.0f;
                                this.splashDamageRadius = 70.0f;
                                this.splashDamage = 65.0f;
                                this.backColor = Pal.sapBulletBack;
                                this.frontColor = this.lightningColor = Pal.sapBullet;
                                this.lightning = 3;
                                this.lightningLength = 10;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                shake = 5.0f;
                                this.status = StatusEffects.sapped;
                                this.statusDuration = 600.0f;
                            }
                        };
                    }
                });
            }
        };
        toxopid = new UnitType("toxopid"){
            {
                this.drag = 0.1f;
                this.speed = 0.5f;
                this.hitSize = 21.0f;
                this.health = 22000.0f;
                this.armor = 13.0f;
                this.rotateSpeed = 1.9f;
                this.legCount = 8;
                this.legMoveSpace = 0.8f;
                this.legPairOffset = 3.0f;
                this.legLength = 75.0f;
                this.legExtension = -20.0f;
                this.legBaseOffset = 8.0f;
                this.landShake = 1.0f;
                this.legSpeed = 0.1f;
                this.legLengthScl = 0.93f;
                this.rippleScale = 3.0f;
                this.legSpeed = 0.19f;
                this.ammoType = AmmoTypes.powerHigh;
                this.buildSpeed = 1.0f;
                this.legSplashDamage = 80.0f;
                this.legSplashRange = 60.0f;
                this.hovering = true;
                this.allowLegStep = true;
                this.visualElevation = 0.95f;
                this.groundLayer = 75.0f;
                this.weapons.add(new Weapon("large-purple-mount"){
                    {
                        this.y = -5.0f;
                        this.x = 11.0f;
                        this.shootY = 7.0f;
                        this.reload = 30.0f;
                        this.shake = 4.0f;
                        this.rotateSpeed = 2.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootBig;
                        this.rotate = true;
                        this.shadow = 12.0f;
                        this.recoil = 3.0f;
                        this.shots = 2;
                        this.spacing = 17.0f;
                        this.bullet = new ShrapnelBulletType(){
                            {
                                this.length = 90.0f;
                                this.damage = 110.0f;
                                this.width = 25.0f;
                                this.serrationLenScl = 7.0f;
                                this.serrationSpaceOffset = 60.0f;
                                this.serrationFadeOffset = 0.0f;
                                this.serrations = 10;
                                this.serrationWidth = 6.0f;
                                this.fromColor = Pal.sapBullet;
                                this.toColor = Pal.sapBulletBack;
                                this.shootEffect = this.smokeEffect = Fx.sparkShoot;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("toxopid-cannon"){
                    {
                        this.y = -14.0f;
                        this.x = 0.0f;
                        this.shootY = 22.0f;
                        this.mirror = false;
                        this.reload = 210.0f;
                        this.shake = 10.0f;
                        this.recoil = 10.0f;
                        this.rotateSpeed = 1.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.artillery;
                        this.rotate = true;
                        this.shadow = 30.0f;
                        this.bullet = new ArtilleryBulletType(3.0f, 50.0f){
                            {
                                this.hitEffect = Fx.sapExplosion;
                                this.knockback = 0.8f;
                                this.lifetime = 80.0f;
                                this.height = 25.0f;
                                this.width = 25.0f;
                                this.collides = true;
                                this.collidesTiles = true;
                                this.ammoMultiplier = 4.0f;
                                this.splashDamageRadius = 80.0f;
                                this.splashDamage = 75.0f;
                                this.backColor = Pal.sapBulletBack;
                                this.frontColor = this.lightningColor = Pal.sapBullet;
                                this.lightning = 5;
                                this.lightningLength = 20;
                                this.smokeEffect = Fx.shootBigSmoke2;
                                this.hitShake = 10.0f;
                                this.status = StatusEffects.sapped;
                                this.statusDuration = 600.0f;
                                this.fragLifeMin = 0.3f;
                                this.fragBullets = 9;
                                this.fragBullet = new ArtilleryBulletType(2.3f, 30.0f){
                                    {
                                        this.hitEffect = Fx.sapExplosion;
                                        this.knockback = 0.8f;
                                        this.lifetime = 90.0f;
                                        this.height = 20.0f;
                                        this.width = 20.0f;
                                        this.collidesTiles = false;
                                        this.splashDamageRadius = 70.0f;
                                        this.splashDamage = 40.0f;
                                        this.backColor = Pal.sapBulletBack;
                                        this.frontColor = this.lightningColor = Pal.sapBullet;
                                        this.lightning = 2;
                                        this.lightningLength = 5;
                                        this.smokeEffect = Fx.shootBigSmoke2;
                                        this.hitShake = 5.0f;
                                        this.status = StatusEffects.sapped;
                                        this.statusDuration = 600.0f;
                                    }
                                };
                            }
                        };
                    }
                });
            }
        };
        flare = new UnitType("flare"){
            {
                this.speed = 3.0f;
                this.accel = 0.08f;
                this.drag = 0.01f;
                this.flying = true;
                this.health = 75.0f;
                this.engineOffset = 5.5f;
                this.range = 140.0f;
                this.targetAir = false;
                this.commandLimit = 4;
                this.circleTarget = true;
                this.weapons.add(new Weapon(){
                    {
                        this.y = 0.0f;
                        this.x = 2.0f;
                        this.reload = 13.0f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(2.5f, 9.0f){
                            {
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.lifetime = 45.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.smokeEffect = Fx.shootSmallSmoke;
                                this.ammoMultiplier = 2.0f;
                            }
                        };
                        this.shootSound = Sounds.pew;
                    }
                });
            }
        };
        horizon = new UnitType("horizon"){
            {
                this.health = 340.0f;
                this.speed = 1.7f;
                this.accel = 0.08f;
                this.drag = 0.016f;
                this.flying = true;
                this.hitSize = 9.0f;
                this.targetAir = false;
                this.engineOffset = 7.8f;
                this.range = 140.0f;
                this.faceTarget = false;
                this.armor = 3.0f;
                this.targetFlag = BlockFlag.factory;
                this.commandLimit = 5;
                this.circleTarget = true;
                this.weapons.add(new Weapon(){
                    {
                        this.minShootVelocity = 0.75f;
                        this.x = 3.0f;
                        this.shootY = 0.0f;
                        this.reload = 12.0f;
                        this.shootCone = 180.0f;
                        this.ejectEffect = Fx.none;
                        this.inaccuracy = 15.0f;
                        this.ignoreRotation = true;
                        this.shootSound = Sounds.none;
                        this.bullet = new BombBulletType(27.0f, 25.0f){
                            {
                                this.width = 10.0f;
                                this.height = 14.0f;
                                this.hitEffect = Fx.flakExplosion;
                                this.shootEffect = Fx.none;
                                this.smokeEffect = Fx.none;
                                this.status = StatusEffects.blasted;
                                this.statusDuration = 60.0f;
                            }
                        };
                    }
                });
            }
        };
        zenith = new UnitType("zenith"){
            {
                this.health = 700.0f;
                this.speed = 1.8f;
                this.accel = 0.04f;
                this.drag = 0.016f;
                this.flying = true;
                this.range = 140.0f;
                this.hitSize = 20.0f;
                this.lowAltitude = true;
                this.armor = 5.0f;
                this.engineOffset = 12.0f;
                this.engineSize = 3.0f;
                this.weapons.add(new Weapon("zenith-missiles"){
                    {
                        this.reload = 40.0f;
                        this.x = 7.0f;
                        this.rotate = true;
                        this.shake = 1.0f;
                        this.shots = 2;
                        this.inaccuracy = 5.0f;
                        this.velocityRnd = 0.2f;
                        this.shootSound = Sounds.missile;
                        this.bullet = new MissileBulletType(3.0f, 14.0f){
                            {
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 60.0f;
                                this.keepVelocity = false;
                                this.splashDamageRadius = 25.0f;
                                this.splashDamage = 16.0f;
                                this.lifetime = 60.0f;
                                this.trailColor = Pal.unitBack;
                                this.backColor = Pal.unitBack;
                                this.frontColor = Pal.unitFront;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 6.0f;
                                this.weaveMag = 1.0f;
                            }
                        };
                    }
                });
            }
        };
        antumbra = new UnitType("antumbra"){
            {
                this.speed = 0.8f;
                this.accel = 0.04f;
                this.drag = 0.04f;
                this.rotateSpeed = 1.9f;
                this.flying = true;
                this.lowAltitude = true;
                this.health = 7000.0f;
                this.armor = 9.0f;
                this.engineOffset = 21.0f;
                this.engineSize = 5.3f;
                this.hitSize = 56.0f;
                this.targetFlag = BlockFlag.battery;
                final MissileBulletType missiles = new MissileBulletType(2.7f, 10.0f){
                    {
                        this.width = 8.0f;
                        this.height = 8.0f;
                        this.shrinkY = 0.0f;
                        this.drag = -0.01f;
                        this.splashDamageRadius = 20.0f;
                        this.splashDamage = 30.0f;
                        this.ammoMultiplier = 4.0f;
                        this.lifetime = 50.0f;
                        this.hitEffect = Fx.blastExplosion;
                        this.despawnEffect = Fx.blastExplosion;
                        this.status = StatusEffects.blasted;
                        this.statusDuration = 60.0f;
                    }
                };
                this.weapons.add(new Weapon("missiles-mount"){
                    {
                        super(name);
                        this.y = 8.0f;
                        this.x = 17.0f;
                        this.reload = 20.0f;
                        this.ejectEffect = Fx.casing1;
                        this.rotateSpeed = 8.0f;
                        this.bullet = missiles;
                        this.shootSound = Sounds.missile;
                        this.rotate = true;
                        this.shadow = 6.0f;
                    }
                }, new Weapon("missiles-mount"){
                    {
                        super(name);
                        this.y = -8.0f;
                        this.x = 17.0f;
                        this.reload = 35.0f;
                        this.rotateSpeed = 8.0f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = missiles;
                        this.shootSound = Sounds.missile;
                        this.rotate = true;
                        this.shadow = 6.0f;
                    }
                }, new Weapon("large-bullet-mount"){
                    {
                        this.y = 2.0f;
                        this.x = 10.0f;
                        this.shootY = 10.0f;
                        this.reload = 12.0f;
                        this.shake = 1.0f;
                        this.rotateSpeed = 2.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shootBig;
                        this.rotate = true;
                        this.shadow = 8.0f;
                        this.bullet = new BasicBulletType(7.0f, 50.0f){
                            {
                                this.width = 12.0f;
                                this.height = 18.0f;
                                this.lifetime = 25.0f;
                                this.shootEffect = Fx.shootBig;
                            }
                        };
                    }
                });
            }
        };
        eclipse = new UnitType("eclipse"){
            {
                this.speed = 0.52f;
                this.accel = 0.04f;
                this.drag = 0.04f;
                this.rotateSpeed = 1.0f;
                this.flying = true;
                this.lowAltitude = true;
                this.health = 20000.0f;
                this.engineOffset = 38.0f;
                this.engineSize = 7.3f;
                this.hitSize = 58.0f;
                this.destructibleWreck = false;
                this.armor = 13.0f;
                this.targetFlag = BlockFlag.reactor;
                final FlakBulletType fragBullet = new FlakBulletType(4.0f, 5.0f){
                    {
                        this.shootEffect = Fx.shootBig;
                        this.ammoMultiplier = 4.0f;
                        this.splashDamage = 42.0f;
                        this.splashDamageRadius = 25.0f;
                        this.collidesGround = true;
                        this.lifetime = 38.0f;
                        this.status = StatusEffects.blasted;
                        this.statusDuration = 60.0f;
                    }
                };
                this.weapons.add(new Weapon("large-laser-mount"){
                    {
                        this.shake = 4.0f;
                        this.shootY = 9.0f;
                        this.x = 18.0f;
                        this.y = 5.0f;
                        this.rotateSpeed = 2.0f;
                        this.reload = 45.0f;
                        this.recoil = 4.0f;
                        this.shootSound = Sounds.laser;
                        this.shadow = 20.0f;
                        this.rotate = true;
                        this.bullet = new LaserBulletType(){
                            {
                                this.damage = 90.0f;
                                this.sideAngle = 20.0f;
                                this.sideWidth = 1.5f;
                                this.sideLength = 80.0f;
                                this.width = 25.0f;
                                this.length = 200.0f;
                                this.shootEffect = Fx.shockwave;
                                this.colors = new Color[]{Color.valueOf("ec7458aa"), Color.valueOf("ff9c5a"), Color.white};
                            }
                        };
                    }
                }, new Weapon("large-artillery"){
                    {
                        super(name);
                        this.x = 11.0f;
                        this.y = 27.0f;
                        this.rotateSpeed = 2.0f;
                        this.reload = 9.0f;
                        this.shootSound = Sounds.shoot;
                        this.shadow = 7.0f;
                        this.rotate = true;
                        this.recoil = 0.5f;
                        this.bullet = fragBullet;
                    }
                }, new Weapon("large-artillery"){
                    {
                        super(name);
                        this.y = -13.0f;
                        this.x = 20.0f;
                        this.reload = 12.0f;
                        this.ejectEffect = Fx.casing1;
                        this.rotateSpeed = 7.0f;
                        this.shake = 1.0f;
                        this.shootSound = Sounds.shoot;
                        this.rotate = true;
                        this.shadow = 12.0f;
                        this.bullet = fragBullet;
                    }
                });
            }
        };
        mono = new UnitType("mono"){
            {
                this.defaultController = MinerAI::new;
                this.flying = true;
                this.drag = 0.06f;
                this.accel = 0.12f;
                this.speed = 1.5f;
                this.health = 100.0f;
                this.engineSize = 1.8f;
                this.engineOffset = 5.7f;
                this.range = 50.0f;
                this.isCounted = false;
                this.ammoType = AmmoTypes.powerLow;
                this.mineTier = 1;
                this.mineSpeed = 2.5f;
            }
        };
        poly = new UnitType("poly"){
            {
                this.defaultController = BuilderAI::new;
                this.flying = true;
                this.drag = 0.05f;
                this.speed = 2.6f;
                this.rotateSpeed = 15.0f;
                this.accel = 0.1f;
                this.range = 130.0f;
                this.health = 400.0f;
                this.buildSpeed = 0.5f;
                this.engineOffset = 6.5f;
                this.hitSize = 8.0f;
                this.lowAltitude = true;
                this.ammoType = AmmoTypes.power;
                this.mineTier = 2;
                this.mineSpeed = 3.5f;
                this.abilities.add(new RepairFieldAbility(5.0f, 300.0f, 50.0f));
                this.weapons.add(new Weapon("heal-weapon-mount"){
                    {
                        this.top = false;
                        this.y = -2.5f;
                        this.x = 3.5f;
                        this.reload = 30.0f;
                        this.ejectEffect = Fx.none;
                        this.recoil = 2.0f;
                        this.shootSound = Sounds.missile;
                        this.shots = 1;
                        this.velocityRnd = 0.5f;
                        this.inaccuracy = 15.0f;
                        this.alternate = true;
                        this.bullet = new MissileBulletType(4.0f, 12.0f){
                            {
                                this.homingPower = 0.08f;
                                this.weaveMag = 4.0f;
                                this.weaveScale = 4.0f;
                                this.lifetime = 56.0f;
                                this.keepVelocity = false;
                                this.shootEffect = Fx.shootHeal;
                                this.smokeEffect = Fx.hitLaser;
                                this.hitEffect = this.despawnEffect = Fx.hitLaser;
                                this.frontColor = Color.white;
                                this.hitSound = Sounds.none;
                                this.healPercent = 5.5f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.trailColor = Pal.heal;
                            }
                        };
                    }
                });
            }
        };
        mega = new UnitType("mega"){
            {
                this.defaultController = RepairAI::new;
                this.mineTier = 3;
                this.mineSpeed = 4.0f;
                this.health = 460.0f;
                this.armor = 3.0f;
                this.speed = 2.5f;
                this.accel = 0.06f;
                this.drag = 0.017f;
                this.lowAltitude = true;
                this.flying = true;
                this.engineOffset = 10.5f;
                this.rotateShooting = false;
                this.hitSize = 15.0f;
                this.engineSize = 3.0f;
                this.payloadCapacity = 256.0f;
                this.buildSpeed = 2.6f;
                this.isCounted = false;
                this.ammoType = AmmoTypes.power;
                this.weapons.add(new Weapon("heal-weapon-mount"){
                    {
                        this.shootSound = Sounds.lasershoot;
                        this.reload = 25.0f;
                        this.x = 8.0f;
                        this.y = -6.0f;
                        this.rotate = true;
                        this.bullet = new LaserBoltBulletType(5.2f, 10.0f){
                            {
                                this.lifetime = 35.0f;
                                this.healPercent = 5.5f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                            }
                        };
                    }
                }, new Weapon("heal-weapon-mount"){
                    {
                        this.shootSound = Sounds.lasershoot;
                        this.reload = 15.0f;
                        this.x = 4.0f;
                        this.y = 5.0f;
                        this.rotate = true;
                        this.bullet = new LaserBoltBulletType(5.2f, 8.0f){
                            {
                                this.lifetime = 35.0f;
                                this.healPercent = 3.0f;
                                this.collidesTeam = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                            }
                        };
                    }
                });
            }
        };
        quad = new UnitType("quad"){
            {
                this.armor = 8.0f;
                this.health = 6000.0f;
                this.speed = 1.4f;
                this.rotateSpeed = 2.0f;
                this.accel = 0.05f;
                this.drag = 0.017f;
                this.lowAltitude = false;
                this.flying = true;
                this.circleTarget = true;
                this.engineOffset = 12.0f;
                this.engineSize = 6.0f;
                this.rotateShooting = false;
                this.hitSize = 32.0f;
                this.payloadCapacity = 576.0f;
                this.buildSpeed = 2.5f;
                this.buildBeamOffset = 23.0f;
                this.range = 140.0f;
                this.targetAir = false;
                this.targetFlag = BlockFlag.battery;
                this.ammoType = AmmoTypes.powerHigh;
                this.weapons.add(new Weapon(){
                    {
                        this.y = 0.0f;
                        this.x = 0.0f;
                        this.mirror = false;
                        this.reload = 55.0f;
                        this.minShootVelocity = 0.01f;
                        this.soundPitchMin = 1.0f;
                        this.shootSound = Sounds.plasmadrop;
                        this.bullet = new BasicBulletType(){
                            {
                                this.sprite = "large-bomb";
                                this.height = 30.0f;
                                this.width = 30.0f;
                                this.maxRange = 30.0f;
                                ignoreRotation = true;
                                this.backColor = Pal.heal;
                                this.frontColor = Color.white;
                                this.mixColorTo = Color.white;
                                this.hitSound = Sounds.plasmaboom;
                                shootCone = 180.0f;
                                ejectEffect = Fx.none;
                                this.despawnShake = 4.0f;
                                this.collidesAir = false;
                                this.lifetime = 70.0f;
                                this.despawnEffect = Fx.greenBomb;
                                this.hitEffect = Fx.massiveExplosion;
                                this.keepVelocity = false;
                                this.spin = 2.0f;
                                this.shrinkY = 0.7f;
                                this.shrinkX = 0.7f;
                                this.speed = 0.001f;
                                this.collides = false;
                                this.healPercent = 15.0f;
                                this.splashDamage = 220.0f;
                                this.splashDamageRadius = 80.0f;
                            }
                        };
                    }
                });
            }
        };
        oct = new UnitType("oct"){
            {
                this.defaultController = DefenderAI::new;
                this.armor = 16.0f;
                this.health = 24000.0f;
                this.speed = 0.8f;
                this.rotateSpeed = 1.0f;
                this.accel = 0.04f;
                this.drag = 0.018f;
                this.flying = true;
                this.engineOffset = 46.0f;
                this.engineSize = 7.8f;
                this.rotateShooting = false;
                this.hitSize = 60.0f;
                this.payloadCapacity = 1797.7601f;
                this.buildSpeed = 4.0f;
                this.drawShields = false;
                this.commandLimit = 6;
                this.lowAltitude = true;
                this.buildBeamOffset = 43.0f;
                this.ammoCapacity = 1300;
                this.ammoResupplyAmount = 20;
                this.abilities.add(new ForceFieldAbility(140.0f, 4.0f, 7000.0f, 480.0f), new RepairFieldAbility(130.0f, 120.0f, 140.0f));
            }
        };
        risso = new UnitType("risso"){
            {
                this.speed = 1.1f;
                this.drag = 0.13f;
                this.hitSize = 9.0f;
                this.health = 280.0f;
                this.accel = 0.4f;
                this.rotateSpeed = 3.3f;
                this.trailLength = 20;
                this.rotateShooting = false;
                this.armor = 2.0f;
                this.weapons.add(new Weapon("mount-weapon"){
                    {
                        this.reload = 12.0f;
                        this.x = 4.0f;
                        this.shootY = 4.0f;
                        this.y = 1.5f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = Bullets.standardCopper;
                    }
                });
                this.weapons.add(new Weapon("missiles-mount"){
                    {
                        this.mirror = false;
                        this.reload = 20.0f;
                        this.x = 0.0f;
                        this.y = -5.0f;
                        this.rotate = true;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.missile;
                        this.bullet = new MissileBulletType(2.7f, 12.0f, "missile"){
                            {
                                this.keepVelocity = true;
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 60.0f;
                                this.splashDamageRadius = 25.0f;
                                this.splashDamage = 10.0f;
                                this.lifetime = 80.0f;
                                this.trailColor = Color.gray;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 8.0f;
                                this.weaveMag = 2.0f;
                            }
                        };
                    }
                });
            }
        };
        minke = new UnitType("minke"){
            {
                this.health = 600.0f;
                this.speed = 0.9f;
                this.drag = 0.15f;
                this.hitSize = 11.0f;
                this.armor = 4.0f;
                this.accel = 0.3f;
                this.rotateSpeed = 2.6f;
                this.rotateShooting = false;
                this.trailLength = 20;
                this.trailX = 5.5f;
                this.trailY = -4.0f;
                this.trailScl = 1.9f;
                this.abilities.add(new StatusFieldAbility(StatusEffects.overclock, 360.0f, 360.0f, 60.0f));
                this.weapons.add(new Weapon("mount-weapon"){
                    {
                        this.reload = 15.0f;
                        this.x = 5.0f;
                        this.y = 3.5f;
                        this.rotate = true;
                        this.rotateSpeed = 5.0f;
                        this.inaccuracy = 10.0f;
                        this.ejectEffect = Fx.casing1;
                        this.shootSound = Sounds.shoot;
                        this.bullet = Bullets.flakLead;
                    }
                });
                this.weapons.add(new Weapon("artillery-mount"){
                    {
                        this.reload = 30.0f;
                        this.x = 5.0f;
                        this.y = -5.0f;
                        this.rotate = true;
                        this.inaccuracy = 2.0f;
                        this.rotateSpeed = 2.0f;
                        this.shake = 1.5f;
                        this.ejectEffect = Fx.casing2;
                        this.shootSound = Sounds.bang;
                        this.bullet = Bullets.artilleryDense;
                    }
                });
            }
        };
        bryde = new UnitType("bryde"){
            {
                this.health = 900.0f;
                this.speed = 0.85f;
                this.accel = 0.2f;
                this.rotateSpeed = 1.8f;
                this.drag = 0.17f;
                this.hitSize = 16.0f;
                this.armor = 7.0f;
                this.rotateShooting = false;
                this.trailLength = 22;
                this.trailX = 7.0f;
                this.trailY = -9.0f;
                this.trailScl = 1.5f;
                this.abilities.add(new ShieldRegenFieldAbility(20.0f, 40.0f, 240.0f, 60.0f));
                this.weapons.add(new Weapon("large-artillery"){
                    {
                        this.reload = 65.0f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -3.5f;
                        this.rotateSpeed = 1.7f;
                        this.rotate = true;
                        this.shootY = 7.0f;
                        this.shake = 5.0f;
                        this.recoil = 4.0f;
                        this.shadow = 12.0f;
                        this.shots = 1;
                        this.inaccuracy = 3.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.artillery;
                        this.bullet = new ArtilleryBulletType(3.2f, 12.0f){
                            {
                                this.trailMult = 0.8f;
                                this.hitEffect = Fx.massiveExplosion;
                                this.knockback = 1.5f;
                                this.lifetime = 100.0f;
                                this.height = 15.5f;
                                this.width = 15.0f;
                                this.collidesTiles = false;
                                this.ammoMultiplier = 4.0f;
                                this.splashDamageRadius = 40.0f;
                                this.splashDamage = 80.0f;
                                this.backColor = Pal.missileYellowBack;
                                this.frontColor = Pal.missileYellow;
                                this.trailEffect = Fx.artilleryTrail;
                                this.trailSize = 6.0f;
                                this.hitShake = 4.0f;
                                this.shootEffect = Fx.shootBig2;
                                this.status = StatusEffects.blasted;
                                this.statusDuration = 60.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("missiles-mount"){
                    {
                        this.reload = 20.0f;
                        this.x = 8.5f;
                        this.y = -9.0f;
                        this.shadow = 6.0f;
                        this.rotateSpeed = 4.0f;
                        this.rotate = true;
                        this.shots = 2;
                        this.shotDelay = 3.0f;
                        this.inaccuracy = 5.0f;
                        this.velocityRnd = 0.1f;
                        this.shootSound = Sounds.missile;
                        this.ejectEffect = Fx.none;
                        this.bullet = new MissileBulletType(2.7f, 12.0f){
                            {
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 60.0f;
                                this.keepVelocity = false;
                                this.splashDamageRadius = 25.0f;
                                this.splashDamage = 10.0f;
                                this.lifetime = 80.0f;
                                this.trailColor = Color.gray;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 8.0f;
                                this.weaveMag = 1.0f;
                            }
                        };
                    }
                });
            }
        };
        sei = new UnitType("sei"){
            {
                this.health = 10500.0f;
                this.armor = 12.0f;
                this.speed = 0.73f;
                this.drag = 0.17f;
                this.hitSize = 39.0f;
                this.accel = 0.2f;
                this.rotateSpeed = 1.3f;
                this.rotateShooting = false;
                this.trailLength = 50;
                this.trailX = 18.0f;
                this.trailY = -21.0f;
                this.trailScl = 3.0f;
                this.weapons.add(new Weapon("sei-launcher"){
                    {
                        this.x = 0.0f;
                        this.y = 0.0f;
                        this.rotate = true;
                        this.rotateSpeed = 4.0f;
                        this.mirror = false;
                        this.shadow = 20.0f;
                        this.shootY = 2.0f;
                        this.recoil = 4.0f;
                        this.reload = 45.0f;
                        this.shots = 6;
                        this.spacing = 10.0f;
                        this.velocityRnd = 0.4f;
                        this.inaccuracy = 7.0f;
                        this.ejectEffect = Fx.none;
                        this.shake = 3.0f;
                        this.shootSound = Sounds.missile;
                        this.xRand = 8.0f;
                        this.shotDelay = 1.0f;
                        this.bullet = new MissileBulletType(4.2f, 42.0f){
                            {
                                this.homingPower = 0.12f;
                                this.width = 8.0f;
                                this.height = 8.0f;
                                this.shrinkY = 0.0f;
                                this.shrinkX = 0.0f;
                                this.drag = -0.003f;
                                this.homingRange = 80.0f;
                                this.keepVelocity = false;
                                this.splashDamageRadius = 35.0f;
                                this.splashDamage = 45.0f;
                                this.lifetime = 62.0f;
                                this.trailColor = Pal.bulletYellowBack;
                                this.backColor = Pal.bulletYellowBack;
                                this.frontColor = Pal.bulletYellow;
                                this.hitEffect = Fx.blastExplosion;
                                this.despawnEffect = Fx.blastExplosion;
                                this.weaveScale = 8.0f;
                                this.weaveMag = 2.0f;
                            }
                        };
                    }
                });
                this.weapons.add(new Weapon("large-bullet-mount"){
                    {
                        this.reload = 60.0f;
                        this.cooldownTime = 90.0f;
                        this.x = 17.5f;
                        this.y = -16.5f;
                        this.rotateSpeed = 4.0f;
                        this.rotate = true;
                        this.shootY = 7.0f;
                        this.shake = 2.0f;
                        this.recoil = 3.0f;
                        this.shadow = 12.0f;
                        this.ejectEffect = Fx.casing3;
                        this.shootSound = Sounds.shootBig;
                        this.shots = 3;
                        this.shotDelay = 4.0f;
                        this.inaccuracy = 1.0f;
                        this.bullet = new BasicBulletType(7.0f, 57.0f){
                            {
                                this.width = 13.0f;
                                this.height = 19.0f;
                                this.shootEffect = Fx.shootBig;
                                this.lifetime = 35.0f;
                            }
                        };
                    }
                });
            }
        };
        omura = new UnitType("omura"){
            {
                this.health = 22000.0f;
                this.speed = 0.62f;
                this.drag = 0.18f;
                this.hitSize = 50.0f;
                this.armor = 16.0f;
                this.accel = 0.19f;
                this.rotateSpeed = 0.9f;
                this.rotateShooting = false;
                float spawnTime = 900.0f;
                this.abilities.add(new UnitSpawnAbility(flare, spawnTime, 19.25f, -31.75f), new UnitSpawnAbility(flare, spawnTime, -19.25f, -31.75f));
                this.trailLength = 70;
                this.trailX = 23.0f;
                this.trailY = -32.0f;
                this.trailScl = 3.5f;
                this.weapons.add(new Weapon("omura-cannon"){
                    {
                        this.reload = 110.0f;
                        this.cooldownTime = 90.0f;
                        this.mirror = false;
                        this.x = 0.0f;
                        this.y = -3.5f;
                        this.rotateSpeed = 1.4f;
                        this.rotate = true;
                        this.shootY = 23.0f;
                        this.shake = 6.0f;
                        this.recoil = 10.5f;
                        this.shadow = 50.0f;
                        this.shootSound = Sounds.railgun;
                        this.shots = 1;
                        this.ejectEffect = Fx.none;
                        this.bullet = new RailBulletType(){
                            {
                                this.shootEffect = Fx.railShoot;
                                this.length = 500.0f;
                                this.updateEffectSeg = 60.0f;
                                this.pierceEffect = Fx.railHit;
                                this.updateEffect = Fx.railTrail;
                                this.hitEffect = Fx.massiveExplosion;
                                this.smokeEffect = Fx.shootBig2;
                                this.damage = 1250.0f;
                                this.pierceDamageFactor = 0.5f;
                            }
                        };
                    }
                });
            }
        };
        alpha = new UnitType("alpha"){
            {
                this.defaultController = BuilderAI::new;
                this.isCounted = false;
                this.flying = true;
                this.mineSpeed = 6.5f;
                this.mineTier = 1;
                this.buildSpeed = 0.5f;
                this.drag = 0.05f;
                this.speed = 3.0f;
                this.rotateSpeed = 15.0f;
                this.accel = 0.1f;
                this.itemCapacity = 30;
                this.health = 150.0f;
                this.engineOffset = 6.0f;
                this.hitSize = 8.0f;
                this.commandLimit = 3;
                this.alwaysUnlocked = true;
                this.weapons.add(new Weapon("small-basic-weapon"){
                    {
                        this.reload = 17.0f;
                        this.x = 2.75f;
                        this.y = 1.0f;
                        this.top = false;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(2.5f, 11.0f){
                            {
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.lifetime = 60.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.smokeEffect = Fx.shootSmallSmoke;
                                this.buildingDamageMultiplier = 0.01f;
                            }
                        };
                    }
                });
            }
        };
        beta = new UnitType("beta"){
            {
                this.defaultController = BuilderAI::new;
                this.isCounted = false;
                this.flying = true;
                this.mineSpeed = 7.0f;
                this.mineTier = 1;
                this.buildSpeed = 0.75f;
                this.drag = 0.05f;
                this.speed = 3.3f;
                this.rotateSpeed = 17.0f;
                this.accel = 0.1f;
                this.itemCapacity = 50;
                this.health = 170.0f;
                this.engineOffset = 6.0f;
                this.hitSize = 9.0f;
                this.rotateShooting = false;
                this.lowAltitude = true;
                this.commandLimit = 4;
                this.weapons.add(new Weapon("small-mount-weapon"){
                    {
                        this.top = false;
                        this.reload = 20.0f;
                        this.x = 3.0f;
                        this.y = 0.5f;
                        this.rotate = true;
                        this.shots = 2;
                        this.shotDelay = 4.0f;
                        this.spacing = 0.0f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(3.0f, 11.0f){
                            {
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.lifetime = 60.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.smokeEffect = Fx.shootSmallSmoke;
                                this.buildingDamageMultiplier = 0.01f;
                            }
                        };
                    }
                });
            }
        };
        gamma = new UnitType("gamma"){
            {
                this.defaultController = BuilderAI::new;
                this.isCounted = false;
                this.flying = true;
                this.mineSpeed = 8.0f;
                this.mineTier = 2;
                this.buildSpeed = 1.0f;
                this.drag = 0.05f;
                this.speed = 3.55f;
                this.rotateSpeed = 19.0f;
                this.accel = 0.11f;
                this.itemCapacity = 70;
                this.health = 220.0f;
                this.engineOffset = 6.0f;
                this.hitSize = 11.0f;
                this.commandLimit = 5;
                this.weapons.add(new Weapon("small-mount-weapon"){
                    {
                        this.top = false;
                        this.reload = 15.0f;
                        this.x = 1.0f;
                        this.y = 2.0f;
                        this.shots = 2;
                        this.spacing = 2.0f;
                        this.inaccuracy = 3.0f;
                        this.shotDelay = 3.0f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(3.5f, 11.0f){
                            {
                                this.width = 6.5f;
                                this.height = 11.0f;
                                this.lifetime = 70.0f;
                                this.shootEffect = Fx.shootSmall;
                                this.smokeEffect = Fx.shootSmallSmoke;
                                this.buildingDamageMultiplier = 0.01f;
                                this.homingPower = 0.04f;
                            }
                        };
                    }
                });
            }
        };
        block = new UnitType("block"){
            {
                this.speed = 0.0f;
                this.hitSize = 0.0f;
                this.health = 1.0f;
                this.rotateSpeed = 360.0f;
                this.itemCapacity = 0;
                this.commandLimit = 0;
            }

            @Override
            public boolean isHidden() {
                return true;
            }
        };
    }
}

