/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.audio.Music;
import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.TextField;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Time;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import mindustry.Vars;
import mindustry.audio.SoundControl;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.content.TechTree;
import mindustry.core.GameState;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.game.Objectives;
import mindustry.game.Rules;
import mindustry.game.Saves;
import mindustry.game.Schematics;
import mindustry.game.Teams;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Musics;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.input.Binding;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.input.MobileInput;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.maps.SectorDamage;
import mindustry.net.WorldReloader;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.ui.Cicon;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class Control
implements ApplicationListener,
Loadable {
    public Saves saves;
    public SoundControl sound;
    public InputHandler input;
    private Interval timer = new Interval(2);
    private boolean hiscore = false;
    private boolean wasPaused = false;

    public Control() {
        this.saves = new Saves();
        this.sound = new SoundControl();
        Events.on(EventType.ClientLoadEvent.class, e -> {
            if (Vars.mods.skipModLoading() && Vars.mods.list().any()) {
                Time.runTask(4.0f, () -> Vars.ui.showInfo("@mods.initfailed"));
            }
        });
        Events.on(EventType.StateChangeEvent.class, event -> {
            block3: {
                block2: {
                    if (event.from == GameState.State.playing && event.to == GameState.State.menu) break block2;
                    if (event.from != GameState.State.menu || event.to == GameState.State.menu) break block3;
                }
                Time.runTask(5.0f, Vars.platform::updateRPC);
            }
        });
        Events.on(EventType.PlayEvent.class, event -> {
            Vars.player.team(Vars.netServer.assignTeam(Vars.player));
            Vars.player.add();
            Vars.state.set(GameState.State.playing);
        });
        Events.on(EventType.WorldLoadEvent.class, event -> {
            if (Mathf.zero(Vars.player.x) && Mathf.zero(Vars.player.y)) {
                CoreBlock.CoreBuild core = Vars.player.bestCore();
                if (core != null) {
                    Vars.player.set(core);
                    Core.camera.position.set(core);
                }
            } else {
                Core.camera.position.set(Vars.player);
            }
        });
        Events.on(EventType.SaveLoadEvent.class, event -> this.input.checkUnit());
        Events.on(EventType.ResetEvent.class, event -> {
            Vars.player.reset();
            this.hiscore = false;
            this.saves.resetSave();
        });
        Events.on(EventType.WaveEvent.class, event -> {
            if (Vars.state.map.getHightScore() < Vars.state.wave) {
                this.hiscore = true;
                Vars.state.map.setHighScore(Vars.state.wave);
            }
            Sounds.wave.play();
        });
        Events.on(EventType.GameOverEvent.class, event -> {
            Vars.state.stats.wavesLasted = Vars.state.wave;
            Effect.shake(5.0f, 6.0f, Core.camera.position.x, Core.camera.position.y);
            Call.gameOver(event.winner);
        });
        Events.on(EventType.WorldLoadEvent.class, e -> Vars.player.add());
        Events.on(EventType.WorldLoadEvent.class, event -> Core.app.post(() -> {
            if (Vars.state.rules.pvp && !Vars.net.active()) {
                try {
                    Vars.net.host(6567);
                    Vars.player.admin(true);
                }
                catch (IOException e) {
                    Vars.ui.showException("@server.error", e);
                    Vars.state.set(GameState.State.menu);
                }
            }
        }));
        Events.on(EventType.UnlockEvent.class, e -> {
            if (e.content.showUnlock()) {
                Vars.ui.hudfrag.showUnlock(e.content);
            }
            this.checkAutoUnlocks();
            if (e.content instanceof SectorPreset) {
                for (TechTree.TechNode node : TechTree.all) {
                    if (node.content.unlocked() || !node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)o -> {
                        Objectives.SectorComplete sec;
                        Objectives.Objective sec$temp = o;
                        return sec$temp instanceof Objectives.SectorComplete && (sec = (Objectives.SectorComplete)sec$temp) == (Objectives.SectorComplete)sec$temp && sec.preset == e.content;
                    }))) || node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)o -> !o.complete())))) continue;
                    Vars.ui.hudfrag.showToast(new TextureRegionDrawable(node.content.icon(Cicon.large)), Core.bundle.get("available"));
                }
            }
        });
        Events.on(EventType.SectorCaptureEvent.class, e -> this.checkAutoUnlocks());
        Events.on(EventType.BlockBuildEndEvent.class, e -> {
            if (e.team == Vars.player.team()) {
                if (e.breaking) {
                    ++Vars.state.stats.buildingsDeconstructed;
                } else {
                    ++Vars.state.stats.buildingsBuilt;
                }
            }
        });
        Events.on(EventType.BlockDestroyEvent.class, e -> {
            if (e.tile.team() == Vars.player.team()) {
                ++Vars.state.stats.buildingsDestroyed;
            }
        });
        Events.on(EventType.UnitDestroyEvent.class, e -> {
            if (e.unit.team() != Vars.player.team()) {
                ++Vars.state.stats.enemyUnitsDestroyed;
            }
        });
        Events.on(EventType.GameOverEvent.class, e -> {
            if (Vars.state.isCampaign() && !Vars.net.client() && !Vars.headless && this.saves.getCurrent() != null) {
                this.saves.getCurrent().save();
            }
        });
        Events.run((Object)EventType.Trigger.newGame, () -> {
            CoreBlock.CoreBuild core = Vars.player.closestCore();
            if (core == null) {
                return;
            }
            if (Core.settings.getInt("musicvol") > 0) {
                Musics.land.stop();
                Musics.land.play();
                Musics.land.setVolume((float)Core.settings.getInt("musicvol") / 100.0f);
            }
            Core.app.post(() -> Vars.ui.hudfrag.showLand());
            Vars.renderer.zoomIn(Fx.coreLand.lifetime);
            Core.app.post(() -> Fx.coreLand.at(core.getX(), core.getY(), 0.0f, core.block));
            Core.camera.position.set(core);
            Vars.player.set(core);
            Time.run(Fx.coreLand.lifetime, () -> {
                Fx.launch.at(core);
                Effect.shake(5.0f, 5.0f, core);
                if (Vars.state.isCampaign()) {
                    Vars.ui.announce("[accent]" + Vars.state.rules.sector.name() + "\n" + (Vars.state.rules.sector.info.resources.any() ? "[lightgray]" + Core.bundle.get("sectors.resources") + "[white] " + Vars.state.rules.sector.info.resources.toString(" ", u -> u.emoji()) : ""), 5.0f);
                }
            });
        });
    }

    @Override
    public void loadAsync() {
        Draw.scl = 1.0f / (float)Core.atlas.find((String)"scale_marker").width;
        Core.input.setCatch(KeyCode.back, true);
        Core.settings.defaults("ip", "localhost", "color-0", Vars.playerColors[8].rgba(), "name", "", "lastBuild", 0);
        this.createPlayer();
        this.saves.load();
    }

    void checkAutoUnlocks() {
        if (Vars.net.client()) {
            return;
        }
        for (TechTree.TechNode node : TechTree.all) {
            if (node.content.unlocked() || node.requirements.length != 0 || node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)o -> !o.complete())))) continue;
            node.content.unlock();
        }
    }

    void createPlayer() {
        Vars.player = Player.create();
        Vars.player.name = Core.settings.getString("name");
        Vars.player.color.set(Core.settings.getInt("color-0"));
        this.input = Vars.mobile ? new MobileInput() : new DesktopInput();
        if (Vars.state.isGame()) {
            Vars.player.add();
        }
        Events.on(EventType.ClientLoadEvent.class, e -> this.input.add());
    }

    public void setInput(InputHandler newInput) {
        Block block = this.input.block;
        boolean added = Core.input.getInputProcessors().contains(this.input);
        this.input.remove();
        this.input = newInput;
        newInput.block = block;
        if (added) {
            newInput.add();
        }
    }

    public void playMap(Map map, Rules rules) {
        Vars.ui.loadAnd(() -> {
            Vars.logic.reset();
            Vars.world.loadMap(map, rules);
            Vars.state.rules = rules;
            Vars.state.rules.sector = null;
            Vars.state.rules.editor = false;
            Vars.logic.play();
            if (Core.settings.getBool("savecreate") && !Vars.world.isInvalidMap()) {
                Vars.control.saves.addSave(map.name() + " " + new SimpleDateFormat("MMM dd h:mm", Locale.getDefault()).format(new Date()));
            }
            Events.fire(EventType.Trigger.newGame);
        });
    }

    public void playSector(Sector sector) {
        this.playSector(sector, sector);
    }

    public void playSector(@Nullable Sector origin, Sector sector) {
        this.playSector(origin, sector, new WorldReloader());
    }

    void playSector(@Nullable Sector origin, Sector sector, WorldReloader reloader) {
        Vars.ui.loadAnd(() -> {
            if (this.saves.getCurrent() != null && Vars.state.isGame()) {
                Vars.control.saves.getCurrent().save();
                Vars.control.saves.resetSave();
            }
            Vars.ui.planet.hide();
            Saves.SaveSlot slot = sector.save;
            sector.planet.setLastSector(sector);
            if (slot != null && !Vars.clearSectors) {
                try {
                    reloader.begin();
                    slot.load();
                    slot.setAutosave(true);
                    Vars.state.rules.sector = sector;
                    if (Vars.state.rules.defaultTeam.cores().isEmpty()) {
                        if (sector.info.spawnPosition == 0) {
                            sector.save = null;
                            slot.delete();
                            this.playSector(origin, sector, reloader);
                            return;
                        }
                        Tile spawn = Vars.world.tile(sector.info.spawnPosition);
                        spawn.setBlock(Blocks.coreShard, Vars.state.rules.defaultTeam);
                        SectorDamage.apply(1.0f);
                        Vars.state.wave = 1;
                        Vars.state.wavetime = Vars.state.rules.waveSpacing * 2.0f;
                        sector.info.wasCaptured = false;
                        Vars.state.rules.waves = true;
                        int n = Vars.state.rules.attackMode ? -1 : (sector.preset != null && sector.preset.captureWave > 0 ? sector.preset.captureWave : (Vars.state.rules.winWave = Vars.state.rules.winWave > Vars.state.wave ? Vars.state.rules.winWave : 30));
                        if (Vars.state.rules.attackMode) {
                            for (Teams.BlockPlan plan : Vars.state.rules.waveTeam.data().blocks) {
                                Tile tile = Vars.world.tile(plan.x, plan.y);
                                if (tile == null) continue;
                                tile.setBlock(Vars.content.block(plan.block), Vars.state.rules.waveTeam, plan.rotation);
                                if (plan.config == null || tile.build == null) continue;
                                tile.build.configureAny(plan.config);
                            }
                            Vars.state.rules.waveTeam.data().blocks.clear();
                        }
                        Groups.unit.clear();
                        Groups.fire.clear();
                        Groups.puddle.clear();
                        Schematics.placeLaunchLoadout(spawn.x, spawn.y);
                        Vars.player.set(spawn.x * 8, spawn.y * 8);
                        Core.camera.position.set(Vars.player);
                        Events.fire(new EventType.SectorLaunchEvent(sector));
                        Events.fire(EventType.Trigger.newGame);
                    }
                    Vars.state.set(GameState.State.playing);
                    reloader.end();
                }
                catch (SaveIO.SaveException e) {
                    Log.err(e);
                    sector.save = null;
                    Time.runTask(10.0f, () -> Vars.ui.showErrorMessage("@save.corrupted"));
                    slot.delete();
                    this.playSector(origin, sector);
                }
                Vars.ui.planet.hide();
            } else {
                reloader.begin();
                Vars.world.loadSector(sector);
                Vars.state.rules.sector = sector;
                sector.info.origin = origin;
                sector.info.destination = origin;
                Vars.logic.play();
                Vars.control.saves.saveSector(sector);
                Events.fire(new EventType.SectorLaunchEvent(sector));
                Events.fire(EventType.Trigger.newGame);
                reloader.end();
            }
        });
    }

    public boolean isHighScore() {
        return this.hiscore;
    }

    @Override
    public void dispose() {
        if (this.saves != null && this.saves.getCurrent() != null && this.saves.getCurrent().isAutosave() && !Vars.net.client() && !Vars.state.isMenu()) {
            try {
                SaveIO.save(Vars.control.saves.getCurrent().file);
                Log.info("Saved on exit.");
            }
            catch (Throwable t) {
                Log.err(t);
            }
        }
        for (Music music : Core.assets.getAll(Music.class, new Seq())) {
            music.stop();
        }
        Vars.net.dispose();
    }

    @Override
    public void pause() {
        if (Core.settings.getBool("backgroundpause", true)) {
            this.wasPaused = Vars.state.is(GameState.State.paused);
            if (Vars.state.is(GameState.State.playing)) {
                Vars.state.set(GameState.State.paused);
            }
        }
    }

    @Override
    public void resume() {
        if (Vars.state.is(GameState.State.paused) && !this.wasPaused && Core.settings.getBool("backgroundpause", true)) {
            Vars.state.set(GameState.State.playing);
        }
    }

    @Override
    public void init() {
        Vars.platform.updateRPC();
        if (Core.settings.getBool("uiscalechanged", false)) {
            Core.app.post(() -> Core.app.post(() -> {
                BaseDialog dialog = new BaseDialog("@confirm");
                dialog.setFillParent(true);
                float[] countdown = new float[]{660.0f};
                Runnable exit = () -> {
                    Core.settings.put("uiscale", 100);
                    Core.settings.put("uiscalechanged", false);
                    dialog.hide();
                    Core.app.exit();
                };
                dialog.cont.label(() -> {
                    if (countdown[0] <= 0.0f) {
                        exit.run();
                    }
                    Object[] objectArray = new Object[1];
                    countdown[0] = countdown[0] - Time.delta;
                    objectArray[0] = (int)(countdown[0] / 60.0f);
                    return Core.bundle.format("uiscale.reset", objectArray);
                }).pad(10.0f).expand().center();
                dialog.buttons.defaults().size(200.0f, 60.0f);
                dialog.buttons.button("@uiscale.cancel", exit);
                dialog.buttons.button("@ok", () -> {
                    Core.settings.put("uiscalechanged", false);
                    dialog.hide();
                });
                dialog.show();
            }));
        }
    }

    @Override
    public void update() {
        if (Core.assets == null) {
            return;
        }
        this.saves.update();
        try {
            Core.assets.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.input.updateState();
        this.sound.update();
        if (Core.input.keyTap(Binding.fullscreen)) {
            boolean full = Core.settings.getBool("fullscreen");
            if (full) {
                Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
            } else {
                Core.graphics.setFullscreenMode(Core.graphics.getDisplayMode());
            }
            Core.settings.put("fullscreen", !full);
        }
        if (Float.isNaN(Vars.player.x) || Float.isNaN(Vars.player.y)) {
            Vars.player.set(0.0f, 0.0f);
            if (!Vars.player.dead()) {
                Vars.player.unit().kill();
            }
        }
        if (Float.isNaN(Core.camera.position.x)) {
            Core.camera.position.x = (float)Vars.world.unitWidth() / 2.0f;
        }
        if (Float.isNaN(Core.camera.position.y)) {
            Core.camera.position.y = (float)Vars.world.unitHeight() / 2.0f;
        }
        if (Vars.state.isGame()) {
            this.input.update();
            if (this.timer.get(0, 300.0f)) {
                Vars.platform.updateRPC();
            }
            CoreBlock.CoreBuild core = Vars.state.rules.defaultTeam.core();
            if (!Vars.net.client() && core != null && Vars.state.isCampaign()) {
                core.items.each((i, a) -> i.unlock());
            }
            if (Core.input.keyTap(Binding.pause) && !Core.scene.hasDialog() && !Core.scene.hasKeyboard() && !Vars.ui.restart.isShown() && (Vars.state.is(GameState.State.paused) || Vars.state.is(GameState.State.playing))) {
                Vars.state.set(Vars.state.is(GameState.State.playing) ? GameState.State.paused : GameState.State.playing);
            }
            if (Core.input.keyTap(Binding.menu) && !Vars.ui.restart.isShown() && !Vars.ui.minimapfrag.shown()) {
                if (Vars.ui.chatfrag.shown()) {
                    Vars.ui.chatfrag.hide();
                } else if (!Vars.ui.paused.isShown() && !Core.scene.hasDialog()) {
                    Vars.ui.paused.show();
                    Vars.state.set(GameState.State.paused);
                }
            }
            if (!Vars.mobile && Core.input.keyTap(Binding.screenshot) && !(Core.scene.getKeyboardFocus() instanceof TextField) && !Core.scene.hasKeyboard()) {
                Vars.renderer.takeMapScreenshot();
            }
        } else {
            if (!Vars.state.isPaused()) {
                Time.update();
            }
            if (!Core.scene.hasDialog() && !Core.scene.root.getChildren().isEmpty() && !(Core.scene.root.getChildren().peek() instanceof Dialog) && Core.input.keyTap(KeyCode.back)) {
                Vars.platform.hide();
            }
        }
    }
}

