/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Events;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.game.GameStats;
import mindustry.game.Rules;
import mindustry.game.Teams;
import mindustry.gen.Unit;
import mindustry.maps.Map;
import mindustry.type.Sector;
import mindustry.world.blocks.Attributes;

public class GameState {
    public int wave = 1;
    public float wavetime;
    public boolean gameOver = false;
    public boolean serverPaused = false;
    public boolean wasTimeout;
    public Map map = Vars.emptyMap;
    public Rules rules = new Rules();
    public GameStats stats = new GameStats();
    public Attributes envAttrs = new Attributes();
    public Teams teams = new Teams();
    public int enemies;
    private State state = State.menu;

    public Unit boss() {
        return this.teams.boss;
    }

    public void set(State astate) {
        if (astate == State.paused && Vars.net.active()) {
            return;
        }
        Events.fire(new EventType.StateChangeEvent(this.state, astate));
        this.state = astate;
    }

    public boolean hasSpawns() {
        return this.rules.waves && (!this.isCampaign() || !this.rules.attackMode);
    }

    public boolean isCampaign() {
        return this.rules.sector != null;
    }

    public boolean hasSector() {
        return this.rules.sector != null;
    }

    @Nullable
    public Sector getSector() {
        return this.rules.sector;
    }

    public boolean isEditor() {
        return this.rules.editor;
    }

    public boolean isPaused() {
        return this.is(State.paused) && !Vars.net.active() || this.gameOver && (!Vars.net.active() || this.isCampaign()) || this.serverPaused && !this.isMenu();
    }

    public boolean isPlaying() {
        return this.state == State.playing || this.state == State.paused && !this.isPaused();
    }

    public boolean isGame() {
        return this.state != State.menu;
    }

    public boolean isMenu() {
        return this.state == State.menu;
    }

    public boolean is(State astate) {
        return this.state == astate;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        paused,
        playing,
        menu;

    }
}

