/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.core.GameState;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.SectorInfo;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.maps.SectorDamage;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class Logic
implements ApplicationListener {
    public Logic() {
        Events.on(EventType.BlockDestroyEvent.class, event -> {
            Tile tile = event.tile;
            if (tile.build == null || !tile.block().rebuildable || Vars.net.client()) {
                return;
            }
            tile.build.addPlan(true);
        });
        Events.on(EventType.BlockBuildEndEvent.class, event -> {
            if (!event.breaking) {
                Teams.TeamData data = Vars.state.teams.get(event.team);
                Iterator<Teams.BlockPlan> it = data.blocks.iterator();
                while (it.hasNext()) {
                    Teams.BlockPlan b = it.next();
                    Block block = Vars.content.block(b.block);
                    if (!event.tile.block().bounds(event.tile.x, event.tile.y, Tmp.r1).overlaps(block.bounds(b.x, b.y, Tmp.r2))) continue;
                    it.remove();
                }
            }
        });
        Events.on(EventType.SaveLoadEvent.class, e -> {
            if (Vars.state.isCampaign()) {
                Vars.state.rules.coreIncinerates = true;
                SectorInfo info = Vars.state.rules.sector.info;
                info.write();
                int wavesPassed = info.wavesPassed;
                if (wavesPassed > 0) {
                    Groups.unit.each(u -> {
                        if (u.team == Vars.state.rules.waveTeam) {
                            u.remove();
                        }
                    });
                }
                if (wavesPassed > 0) {
                    Vars.state.wave += wavesPassed;
                    Vars.state.wavetime = Vars.state.rules.waveSpacing;
                    SectorDamage.applyCalculatedDamage();
                }
                info.damage = 0.0f;
                info.wavesPassed = 0;
                info.hasCore = true;
                info.secondsPassed = 0.0f;
                Vars.state.rules.sector.saveInfo();
            }
        });
        Events.on(EventType.WorldLoadEvent.class, e -> {
            Vars.state.rules.waveTeam.rules().infiniteAmmo = true;
            if (Vars.state.isCampaign()) {
                if (Vars.state.getSector().preset == null || Vars.state.getSector().preset.useAI) {
                    Vars.state.rules.waveTeam.rules().ai = true;
                }
                Vars.state.rules.coreIncinerates = true;
                Vars.state.rules.waveTeam.rules().aiTier = Vars.state.getSector().threat * 0.8f;
                Vars.state.rules.waveTeam.rules().infiniteResources = true;
                for (CoreBlock.CoreBuild core : Vars.state.rules.waveTeam.cores()) {
                    for (Item item : Vars.content.items()) {
                        core.items.set(item, core.block.itemCapacity);
                    }
                }
            }
            Core.settings.manualSave();
        });
        Events.on(EventType.UnlockEvent.class, e -> {
            if (Vars.net.server()) {
                Call.researched(e.content);
            }
        });
        Events.on(EventType.SectorCaptureEvent.class, e -> {
            if (!Vars.net.client() && e.sector == Vars.state.getSector() && e.sector.isBeingPlayed()) {
                for (Tile tile : Vars.world.tiles) {
                    if (!tile.isCenter() || tile.build == null || tile.build.team != Vars.state.rules.waveTeam) continue;
                    Building b = tile.build;
                    Call.setTeam(b, Team.derelict);
                    Time.run(Mathf.random(0.0f, 360.0f), () -> {
                        if (Mathf.chance(0.25)) {
                            b.kill();
                        }
                    });
                }
                Groups.unit.each(u -> {
                    if (u.team == Vars.state.rules.waveTeam) {
                        Time.run(Mathf.random(0.0f, 300.0f), u::kill);
                    }
                });
            }
        });
        Events.on(EventType.TurnEvent.class, e -> {
            if (Vars.net.server() && Vars.state.isCampaign()) {
                int[] out = new int[Vars.content.items().size];
                Vars.state.getSector().info.production.each((item, stat) -> {
                    out[item.id] = Math.max(0, (int)(stat.mean * 7200.0f / 60.0f));
                });
                Call.sectorProduced(out);
            }
        });
    }

    public void play() {
        Vars.state.set(GameState.State.playing);
        Vars.state.wavetime = Vars.state.rules.waveSpacing * 2.0f;
        Events.fire(new EventType.PlayEvent());
        if (!Vars.state.isCampaign()) {
            for (Teams.TeamData team : Vars.state.teams.getActive()) {
                if (!team.hasCore()) continue;
                CoreBlock.CoreBuild entity = team.core();
                entity.items.clear();
                for (ItemStack stack : Vars.state.rules.loadout) {
                    entity.items.add(stack.item, stack.amount);
                }
            }
        }
    }

    public void reset() {
        GameState.State prev = Vars.state.getState();
        Vars.state = new GameState();
        Events.fire(new EventType.StateChangeEvent(prev, GameState.State.menu));
        Groups.clear();
        Time.clear();
        Events.fire(new EventType.ResetEvent());
        Core.settings.manualSave();
    }

    public void skipWave() {
        this.runWave();
    }

    public void runWave() {
        Vars.spawner.spawnEnemies();
        ++Vars.state.wave;
        Vars.state.wavetime = Vars.state.rules.waveSpacing;
        Events.fire(new EventType.WaveEvent());
    }

    private void checkGameState() {
        int countAlive;
        if (Vars.state.isCampaign()) {
            if (Vars.state.teams.playerCores().size == 0 && !Vars.state.gameOver) {
                Vars.state.gameOver = true;
                Events.fire(new EventType.GameOverEvent(Vars.state.rules.waveTeam));
            }
            if (Vars.state.rules.waves && Vars.spawner.countSpawns() + Vars.state.teams.cores((Team)Vars.state.rules.waveTeam).size <= 0) {
                Vars.state.rules.waves = false;
            }
            if (Vars.state.rules.waves && Vars.state.enemies == 0 && Vars.state.rules.winWave > 0 && Vars.state.wave >= Vars.state.rules.winWave && !Vars.spawner.isSpawning() || Vars.state.rules.attackMode && Vars.state.rules.waveTeam.cores().isEmpty()) {
                Call.sectorCapture();
            }
        } else if (!Vars.state.rules.attackMode && Vars.state.teams.playerCores().size == 0 && !Vars.state.gameOver) {
            Vars.state.gameOver = true;
            Events.fire(new EventType.GameOverEvent(Vars.state.rules.waveTeam));
        } else if (Vars.state.rules.attackMode && ((countAlive = Vars.state.teams.getActive().count(Teams.TeamData::hasCore)) <= 1 || !Vars.state.rules.pvp && Vars.state.rules.defaultTeam.core() == null) && !Vars.state.gameOver) {
            Teams.TeamData left = Vars.state.teams.getActive().find(Teams.TeamData::hasCore);
            Events.fire(new EventType.GameOverEvent(left == null ? Team.derelict : left.team));
            Vars.state.gameOver = true;
        }
    }

    private void updateWeather() {
        Vars.state.rules.weather.removeAll(w -> w.weather == null);
        for (Weather.WeatherEntry entry : Vars.state.rules.weather) {
            entry.cooldown -= Time.delta;
            if (!(entry.cooldown < 0.0f) && !entry.always || entry.weather.isActive()) continue;
            float duration = entry.always ? Float.POSITIVE_INFINITY : Mathf.random(entry.minDuration, entry.maxDuration);
            entry.cooldown = duration + Mathf.random(entry.minFrequency, entry.maxFrequency);
            Tmp.v1.setToRandomDirection();
            Call.createWeather(entry.weather, entry.intensity, duration, Tmp.v1.x, Tmp.v1.y);
        }
    }

    public static void sectorCapture() {
        Vars.state.rules.waves = false;
        if (Vars.state.rules.sector == null) {
            Vars.state.rules.attackMode = false;
            return;
        }
        Vars.state.rules.sector.info.wasCaptured = true;
        Events.fire(new EventType.SectorCaptureEvent(Vars.state.rules.sector));
        Vars.state.rules.attackMode = false;
        if (!Vars.headless && !Vars.net.client()) {
            Vars.control.saves.saveSector(Vars.state.rules.sector);
        }
    }

    public static void updateGameOver(Team winner) {
        Vars.state.gameOver = true;
    }

    public static void gameOver(Team winner) {
        Vars.state.stats.wavesLasted = Vars.state.wave;
        Vars.ui.restart.show(winner);
        Vars.netClient.setQuiet();
    }

    public static void researched(Content content) {
        UnlockableContent u;
        Content content2 = content;
        if (!(content2 instanceof UnlockableContent) || (u = (UnlockableContent)content2) != (UnlockableContent)content2) {
            return;
        }
        TechTree.TechNode node = u.node();
        while (node != null) {
            node.content.unlock();
            node = node.parent;
        }
        Vars.state.rules.researched.add(u.name);
    }

    public static void sectorProduced(int[] amounts) {
        if (!Vars.state.isCampaign()) {
            return;
        }
        Planet planet = Vars.state.rules.sector.planet;
        boolean any = false;
        for (Item item : Vars.content.items()) {
            int sumMissing;
            int am = amounts[item.id];
            if (am <= 0 || (sumMissing = planet.sectors.sum(s -> s.hasBase() ? s.info.storageCapacity - s.info.items.get(item) : 0)) == 0) continue;
            double percent = Math.min((double)am / (double)sumMissing, 1.0);
            for (Sector sec : planet.sectors) {
                if (!sec.hasBase()) continue;
                int added = (int)Math.ceil((double)(sec.info.storageCapacity - sec.info.items.get(item)) * percent);
                sec.info.items.add(item, added);
                any = true;
            }
        }
        if (any) {
            for (Sector sec : planet.sectors) {
                sec.saveInfo();
            }
        }
    }

    @Override
    public void dispose() {
        Core.settings.manualSave();
    }

    @Override
    public void update() {
        Events.fire(EventType.Trigger.update);
        Vars.universe.updateGlobal();
        if (Core.settings.modified() && !Vars.state.isPlaying()) {
            Core.settings.forceSave();
        }
        if (Vars.state.isGame()) {
            if (!Vars.net.client()) {
                Vars.state.enemies = Groups.unit.count(u -> u.team() == Vars.state.rules.waveTeam && u.isCounted());
            }
            if (!Vars.state.isPaused()) {
                Vars.state.teams.updateTeamStats();
                if (Vars.state.isCampaign()) {
                    Vars.state.rules.sector.info.update();
                }
                if (Vars.state.isCampaign()) {
                    Vars.universe.update();
                }
                Time.update();
                if (!Vars.net.client() && !Vars.state.isEditor()) {
                    this.updateWeather();
                    for (Teams.TeamData data : Vars.state.teams.getActive()) {
                        if (!data.hasAI()) continue;
                        data.ai.update();
                    }
                }
                if (Vars.state.rules.waves && Vars.state.rules.waveTimer && !Vars.state.gameOver && !this.isWaitingWave()) {
                    Vars.state.wavetime = Math.max(Vars.state.wavetime - Time.delta, 0.0f);
                }
                if (!Vars.net.client() && Vars.state.wavetime <= 0.0f && Vars.state.rules.waves) {
                    this.runWave();
                }
                Vars.state.envAttrs.clear();
                Groups.weather.each(w -> Vars.state.envAttrs.add(w.weather.attrs, w.opacity));
                Groups.update();
            }
            if (!Vars.net.client() && !Vars.world.isInvalidMap() && !Vars.state.isEditor() && Vars.state.rules.canGameOver) {
                this.checkGameState();
            }
        }
    }

    public boolean isWaitingWave() {
        return (Vars.state.rules.waitEnemies || Vars.state.wave >= Vars.state.rules.winWave && Vars.state.rules.winWave > 0) && Vars.state.enemies > 0;
    }
}

