/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.math.Rand;
import arc.struct.IntSet;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.CommandHandler;
import arc.util.Interval;
import arc.util.Log;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.ReusableByteInStream;
import arc.util.serialization.Base64Coder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.core.Version;
import mindustry.entities.Effect;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Rules;
import mindustry.gen.Call;
import mindustry.gen.EntityMapping;
import mindustry.gen.Groups;
import mindustry.gen.Mechc;
import mindustry.gen.Nulls;
import mindustry.gen.Player;
import mindustry.gen.RemoteReadClient;
import mindustry.gen.Syncc;
import mindustry.gen.Unit;
import mindustry.net.Administration;
import mindustry.net.Net;
import mindustry.net.NetworkIO;
import mindustry.net.Packets;
import mindustry.net.ValidateException;
import mindustry.ui.Fonts;
import mindustry.world.Tile;
import mindustry.world.modules.ItemModule;

public class NetClient
implements ApplicationListener {
    private static final float dataTimeout = 1080.0f;
    private static final float playerSyncTime = 2.0f;
    public static final float viewScale = 2.0f;
    private long ping;
    private Interval timer = new Interval(5);
    private boolean connecting = false;
    private boolean quiet = false;
    private boolean quietReset = false;
    private float timeoutTime = 0.0f;
    private int lastSent;
    private IntSet removed = new IntSet();
    private ReusableByteInStream byteStream = new ReusableByteInStream();
    private DataInputStream dataStream = new DataInputStream(this.byteStream);
    private ObjectMap<String, Seq<Cons<String>>> customPacketHandlers = new ObjectMap();

    public NetClient() {
        Vars.net.handleClient(Packets.Connect.class, packet -> {
            Log.info("Connecting to server: @", packet.addressTCP);
            Vars.player.admin(false);
            this.reset();
            if (!Vars.net.client()) {
                Log.info("Connection canceled.");
                this.disconnectQuietly();
                return;
            }
            Vars.ui.loadfrag.hide();
            Vars.ui.loadfrag.show("@connecting.data");
            Vars.ui.loadfrag.setButton(() -> {
                Vars.ui.loadfrag.hide();
                this.disconnectQuietly();
            });
            String locale = Core.settings.getString("locale");
            if (locale.equals("default")) {
                locale = Locale.getDefault().toString();
            }
            Packets.ConnectPacket c = new Packets.ConnectPacket();
            c.name = Vars.player.name;
            c.locale = locale;
            c.mods = Vars.mods.getModStrings();
            c.mobile = Vars.mobile;
            c.versionType = Version.type;
            c.color = Vars.player.color().rgba();
            c.usid = this.getUsid(packet.addressTCP);
            c.uuid = Vars.platform.getUUID();
            if (c.uuid == null) {
                Vars.ui.showErrorMessage("@invalidid");
                Vars.ui.loadfrag.hide();
                this.disconnectQuietly();
                return;
            }
            Vars.net.send(c, Net.SendMode.tcp);
        });
        Vars.net.handleClient(Packets.Disconnect.class, packet -> {
            if (this.quietReset) {
                return;
            }
            this.connecting = false;
            Vars.logic.reset();
            Vars.platform.updateRPC();
            Vars.player.name(Core.settings.getString("name"));
            Vars.player.color().set(Core.settings.getInt("color-0"));
            if (this.quiet) {
                return;
            }
            Time.runTask(3.0f, Vars.ui.loadfrag::hide);
            if (packet.reason != null) {
                switch (packet.reason) {
                    case "closed": {
                        Vars.ui.showSmall("@disconnect", "@disconnect.closed");
                        break;
                    }
                    case "timeout": {
                        Vars.ui.showSmall("@disconnect", "@disconnect.timeout");
                        break;
                    }
                    case "error": {
                        Vars.ui.showSmall("@disconnect", "@disconnect.error");
                    }
                }
            } else {
                Vars.ui.showErrorMessage("@disconnect");
            }
        });
        Vars.net.handleClient(Packets.WorldStream.class, data -> {
            Log.info("Received world data: @ bytes.", data.stream.available());
            NetworkIO.loadWorld(new InflaterInputStream(data.stream));
            this.finishConnecting();
        });
        Vars.net.handleClient(Packets.InvokePacket.class, packet -> RemoteReadClient.readPacket(packet.reader(), packet.type));
    }

    public void addPacketHandler(String type, Cons<String> handler) {
        ((Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons<String>>)((Object)((Prov<Seq>)Seq::new))))).add(handler);
    }

    public Seq<Cons<String>> getPacketHandlers(String type) {
        return (Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons<String>>)((Object)((Prov<Seq>)Seq::new))));
    }

    public static void clientPacketReliable(String type, String contents) {
        if (Vars.netClient.customPacketHandlers.containsKey(type)) {
            for (Cons<String> c : Vars.netClient.customPacketHandlers.get(type)) {
                c.get(contents);
            }
        }
    }

    public static void clientPacketUnreliable(String type, String contents) {
        NetClient.clientPacketReliable(type, contents);
    }

    public static void sendMessage(String message, String sender, Player playersender) {
        if (Vars.ui != null) {
            Vars.ui.chatfrag.addMessage(message, sender);
        }
        if (playersender != null) {
            playersender.lastText(message);
            playersender.textFadeTime(1.0f);
        }
    }

    public static void sendMessage(String message) {
        if (Vars.ui != null) {
            Vars.ui.chatfrag.addMessage(message, null);
        }
    }

    public static void sendChatMessage(Player player, String message) {
        if (!(!Vars.net.server() || player == null || player.con == null || Time.timeSinceMillis(player.con.connectTime) >= 500L && player.con.hasConnected && player.isAdded())) {
            return;
        }
        if (message.length() > 150) {
            throw new ValidateException(player, "Player has sent a message above the text limit.");
        }
        Events.fire(new EventType.PlayerChatEvent(player, message));
        if (message.startsWith(Vars.netServer.clientCommands.getPrefix())) {
            Log.info("<&fi@: @&fr>", "&lk" + player.name, "&lw" + message);
        }
        CommandHandler.CommandResponse response = Vars.netServer.clientCommands.handleMessage(message, player);
        if (response.type == CommandHandler.ResponseType.noCommand) {
            if ((message = Vars.netServer.admins.filterMessage(player, message)) == null) {
                return;
            }
            if (!Vars.headless) {
                NetClient.sendMessage(message, NetClient.colorizeName(player.id, player.name), player);
            }
            Log.info("&fi@: @", "&lc" + player.name, "&lw" + message);
            Call.sendMessage(message, NetClient.colorizeName(player.id(), player.name), player);
        } else if (response.type != CommandHandler.ResponseType.valid) {
            String text = response.type == CommandHandler.ResponseType.manyArguments ? "[scarlet]Too many arguments. Usage:[lightgray] " + response.command.text + "[gray] " + response.command.paramText : (response.type == CommandHandler.ResponseType.fewArguments ? "[scarlet]Too few arguments. Usage:[lightgray] " + response.command.text + "[gray] " + response.command.paramText : "[scarlet]Unknown command. Check [lightgray]/help[scarlet].");
            player.sendMessage(text);
        }
    }

    public static String colorizeName(int id, String name) {
        Player player = Groups.player.getByID(id);
        if (name == null || player == null) {
            return null;
        }
        return "[#" + player.color().toString().toUpperCase() + "]" + name;
    }

    public static void connect(String ip, int port) {
        Vars.netClient.disconnectQuietly();
        Vars.logic.reset();
        Vars.ui.join.connect(ip, port);
    }

    public static void ping(Player player, long time) {
        Call.pingResponse(player.con, time);
    }

    public static void pingResponse(long time) {
        Vars.netClient.ping = Time.timeSinceMillis(time);
    }

    public static void traceInfo(Player player, Administration.TraceInfo info) {
        if (player != null) {
            Vars.ui.traces.show(player, info);
        }
    }

    public static void kick(Packets.KickReason reason) {
        Vars.netClient.disconnectQuietly();
        Vars.logic.reset();
        if (reason == Packets.KickReason.serverRestarting) {
            Vars.ui.join.reconnect();
            return;
        }
        if (!reason.quiet) {
            if (reason.extraText() != null) {
                Vars.ui.showText(reason.toString(), reason.extraText());
            } else {
                Vars.ui.showText("@disconnect", reason.toString());
            }
        }
        Vars.ui.loadfrag.hide();
    }

    public static void kick(String reason) {
        Vars.netClient.disconnectQuietly();
        Vars.logic.reset();
        Vars.ui.showText("@disconnect", reason, 8);
        Vars.ui.loadfrag.hide();
    }

    public static void setHudText(String message) {
        if (message == null) {
            return;
        }
        Vars.ui.hudfrag.setHudText(message);
    }

    public static void hideHudText() {
        Vars.ui.hudfrag.toggleHudText(false);
    }

    public static void setHudTextReliable(String message) {
        NetClient.setHudText(message);
    }

    public static void announce(String message) {
        if (message == null) {
            return;
        }
        Vars.ui.announce(message);
    }

    public static void infoMessage(String message) {
        if (message == null) {
            return;
        }
        Vars.ui.showText("", message);
    }

    public static void infoPopup(String message, float duration, int align, int top, int left, int bottom, int right) {
        if (message == null) {
            return;
        }
        Vars.ui.showInfoPopup(message, duration, align, top, left, bottom, right);
    }

    public static void label(String message, float duration, float worldx, float worldy) {
        if (message == null) {
            return;
        }
        Vars.ui.showLabel(message, duration, worldx, worldy);
    }

    public static void effect(Effect effect, float x, float y, float rotation, Color color) {
        if (effect == null) {
            return;
        }
        effect.at(x, y, rotation, color);
    }

    public static void effectReliable(Effect effect, float x, float y, float rotation, Color color) {
        NetClient.effect(effect, x, y, rotation, color);
    }

    public static void infoToast(String message, float duration) {
        if (message == null) {
            return;
        }
        Vars.ui.showInfoToast(message, duration);
    }

    public static void warningToast(int unicode, String text) {
        if (text == null || Fonts.icon.getData().getGlyph((char)unicode) == null) {
            return;
        }
        Vars.ui.hudfrag.showToast(Fonts.getGlyph(Fonts.icon, (char)unicode), text);
    }

    public static void setRules(Rules rules) {
        Vars.state.rules = rules;
    }

    public static void worldDataBegin() {
        Groups.clear();
        Vars.netClient.removed.clear();
        Vars.logic.reset();
        Vars.netClient.connecting = true;
        Vars.net.setClientLoaded(false);
        Vars.ui.loadfrag.show("@connecting.data");
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            Vars.netClient.disconnectQuietly();
        });
    }

    public static void setPosition(float x, float y) {
        Vars.player.unit().set(x, y);
        Vars.player.set(x, y);
    }

    public static void playerDisconnect(int playerid) {
        if (Vars.netClient != null) {
            Vars.netClient.addRemovedEntity(playerid);
        }
        Groups.player.removeByID(playerid);
    }

    public static void entitySnapshot(short amount, short dataLen, byte[] data) {
        try {
            Vars.netClient.byteStream.setBytes(Vars.net.decompressSnapshot(data, dataLen));
            DataInputStream input = Vars.netClient.dataStream;
            for (int j = 0; j < amount; ++j) {
                int id = input.readInt();
                byte typeID = input.readByte();
                Syncc entity = Groups.sync.getByID(id);
                boolean add = false;
                boolean created = false;
                if (entity == null && id == Vars.player.id()) {
                    entity = Vars.player;
                    add = true;
                }
                if (entity == null) {
                    entity = (Syncc)EntityMapping.map(typeID).get();
                    entity.id(id);
                    if (!Vars.netClient.isEntityUsed(entity.id())) {
                        add = true;
                    }
                    created = true;
                }
                entity.readSync(Reads.get(input));
                if (created) {
                    entity.snapSync();
                }
                if (!add) continue;
                entity.add();
                Vars.netClient.addRemovedEntity(entity.id());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void blockSnapshot(short amount, short dataLen, byte[] data) {
        try {
            Vars.netClient.byteStream.setBytes(Vars.net.decompressSnapshot(data, dataLen));
            DataInputStream input = Vars.netClient.dataStream;
            for (int i = 0; i < amount; ++i) {
                int pos = input.readInt();
                short block = input.readShort();
                Tile tile = Vars.world.tile(pos);
                if (tile == null || tile.build == null) {
                    Log.warn("Missing entity at @. Skipping block snapshot.", tile);
                    break;
                }
                if (tile.build.block.id != block) {
                    Log.warn("Block ID mismatch at @: @ != @. Skipping block snapshot.", tile, tile.build.block.id, block);
                    break;
                }
                tile.build.readAll(Reads.get(input), tile.build.version());
            }
        }
        catch (Exception e) {
            Log.err(e);
        }
    }

    public static void stateSnapshot(float waveTime, int wave, int enemies, boolean paused, boolean gameOver, int timeData, short coreDataLen, byte[] coreData) {
        try {
            if (wave > Vars.state.wave) {
                Vars.state.wave = wave;
                Events.fire(new EventType.WaveEvent());
            }
            Vars.state.gameOver = gameOver;
            Vars.state.wavetime = waveTime;
            Vars.state.wave = wave;
            Vars.state.enemies = enemies;
            Vars.state.serverPaused = paused;
            Vars.universe.updateNetSeconds(timeData);
            Vars.netClient.byteStream.setBytes(Vars.net.decompressSnapshot(coreData, coreDataLen));
            DataInputStream input = Vars.netClient.dataStream;
            int cores = input.readInt();
            for (int i = 0; i < cores; ++i) {
                int pos = input.readInt();
                Tile tile = Vars.world.tile(pos);
                if (tile != null && tile.build != null) {
                    tile.build.items.read(Reads.get(input));
                    continue;
                }
                new ItemModule().read(Reads.get(input));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update() {
        if (!Vars.net.client()) {
            return;
        }
        if (Vars.state.isGame()) {
            if (!this.connecting) {
                this.sync();
            }
        } else if (!this.connecting) {
            Vars.net.disconnect();
        } else {
            this.timeoutTime += Time.delta;
            if (this.timeoutTime > 1080.0f) {
                Log.err("Failed to load data!", new Object[0]);
                Vars.ui.loadfrag.hide();
                this.quiet = true;
                Vars.ui.showErrorMessage("@disconnect.data");
                Vars.net.disconnect();
                this.timeoutTime = 0.0f;
            }
        }
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public int getPing() {
        return (int)this.ping;
    }

    private void finishConnecting() {
        Vars.state.set(GameState.State.playing);
        this.connecting = false;
        Vars.ui.join.hide();
        Vars.net.setClientLoaded(true);
        Core.app.post(Call::connectConfirm);
        Time.runTask(40.0f, Vars.platform::updateRPC);
        Core.app.post(Vars.ui.loadfrag::hide);
    }

    private void reset() {
        Vars.net.setClientLoaded(false);
        this.removed.clear();
        this.timeoutTime = 0.0f;
        this.connecting = true;
        this.quietReset = false;
        this.quiet = false;
        this.lastSent = 0;
        Groups.clear();
        Vars.ui.chatfrag.clearMessages();
    }

    public void beginConnecting() {
        this.connecting = true;
    }

    public void disconnectQuietly() {
        this.quiet = true;
        this.connecting = false;
        Vars.net.disconnect();
    }

    public void disconnectNoReset() {
        this.quietReset = true;
        this.quiet = true;
        Vars.net.disconnect();
    }

    public void setQuiet() {
        this.quiet = true;
    }

    public void clearRemovedEntity(int id) {
        this.removed.remove(id);
    }

    public void addRemovedEntity(int id) {
        this.removed.add(id);
    }

    public boolean isEntityUsed(int id) {
        return this.removed.contains(id);
    }

    void sync() {
        if (this.timer.get(0, 2.0f)) {
            Mechc m;
            BuildPlan[] requests = null;
            if (Vars.player.isBuilder()) {
                int i;
                int usedRequests = Math.min(Vars.player.unit().plans().size, 10);
                int totalLength = 0;
                for (i = 0; i < usedRequests; ++i) {
                    byte[] b;
                    BuildPlan plan = Vars.player.unit().plans().get(i);
                    Object object = plan.config;
                    if (object instanceof byte[] && (b = (byte[])object) == (byte[])object) {
                        int length = b.length;
                        totalLength += length;
                    }
                    if (totalLength <= 1024) continue;
                    usedRequests = i + 1;
                    break;
                }
                requests = new BuildPlan[usedRequests];
                for (i = 0; i < usedRequests; ++i) {
                    requests[i] = Vars.player.unit().plans().get(i);
                }
            }
            Unit unit = Vars.player.dead() ? Nulls.unit : Vars.player.unit();
            int uid = Vars.player.dead() ? -1 : unit.id;
            Unit unit2 = unit;
            Call.clientSnapshot(this.lastSent++, uid, Vars.player.dead(), Vars.player.dead() ? Vars.player.x : unit.x, Vars.player.dead() ? Vars.player.y : unit.y, Vars.player.unit().aimX(), Vars.player.unit().aimY(), unit.rotation, unit2 instanceof Mechc && (m = (Mechc)((Object)unit2)) == (Mechc)((Object)unit2) ? m.baseRotation() : 0.0f, unit.vel.x, unit.vel.y, Vars.player.unit().mineTile, Vars.player.boosting, Vars.player.shooting, Vars.ui.chatfrag.shown(), Vars.control.input.isBuilding, requests, Core.camera.position.x, Core.camera.position.y, Core.camera.width * 2.0f, Core.camera.height * 2.0f);
        }
        if (this.timer.get(1, 60.0f)) {
            Call.ping(Time.millis());
        }
    }

    String getUsid(String ip) {
        if (ip.contains("/")) {
            ip = ip.substring(ip.indexOf("/") + 1);
        }
        if (Core.settings.getString("usid-" + ip, null) != null) {
            return Core.settings.getString("usid-" + ip, null);
        }
        byte[] bytes = new byte[8];
        new Rand().nextBytes(bytes);
        String result = new String(Base64Coder.encode(bytes));
        Core.settings.put("usid-" + ip, result);
        return result;
    }
}

