/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons2;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.math.Mathf;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.CommandHandler;
import arc.util.Interval;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Timekeeper;
import arc.util.Timer;
import arc.util.io.FastDeflaterOutputStream;
import arc.util.io.ReusableByteOutStream;
import arc.util.io.Writes;
import arc.util.serialization.Base64Coder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.zip.CRC32;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.GameState;
import mindustry.core.NetClient;
import mindustry.core.Version;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Mechc;
import mindustry.gen.Player;
import mindustry.gen.RemoteReadServer;
import mindustry.gen.Syncc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.net.Administration;
import mindustry.net.NetConnection;
import mindustry.net.NetworkIO;
import mindustry.net.Packets;
import mindustry.net.ValidateException;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class NetServer
implements ApplicationListener {
    private static final int maxSnapshotSize = 800;
    private static final int timerBlockSync = 0;
    private static final int serverSyncTime = 200;
    private static final float blockSyncTime = 360.0f;
    private static final FloatBuffer fbuffer = FloatBuffer.allocate(20);
    private static final Vec2 vector = new Vec2();
    private static final Rect viewport = new Rect();
    private static final float correctDist = 112.0f;
    public final Administration admins = new Administration();
    public final CommandHandler clientCommands = new CommandHandler("/");
    public TeamAssigner assigner = (player, players) -> {
        if (Vars.state.rules.pvp) {
            Teams.TeamData re = Vars.state.teams.getActive().min(data -> {
                if (Vars.state.rules.waveTeam == data.team && Vars.state.rules.waves || !data.team.active()) {
                    return 2.1474836E9f;
                }
                int count = 0;
                for (Player other : players) {
                    if (other.team() != data.team || other == player) continue;
                    ++count;
                }
                return count;
            });
            return re == null ? null : re.team;
        }
        return Vars.state.rules.defaultTeam;
    };
    private boolean closing = false;
    private Interval timer = new Interval();
    private ReusableByteOutStream writeBuffer = new ReusableByteOutStream(127);
    private Writes outputBuffer = new Writes(new DataOutputStream(this.writeBuffer));
    private ReusableByteOutStream syncStream = new ReusableByteOutStream();
    private DataOutputStream dataStream = new DataOutputStream(this.syncStream);
    private ObjectMap<String, Seq<Cons2<Player, String>>> customPacketHandlers = new ObjectMap();

    public NetServer() {
        Vars.net.handleServer(Packets.Connect.class, (con, connect) -> {
            Events.fire(new EventType.ConnectionEvent((NetConnection)con));
            if (this.admins.isIPBanned(connect.addressTCP) || this.admins.isSubnetBanned(connect.addressTCP)) {
                con.kick(Packets.KickReason.banned);
            }
        });
        Vars.net.handleServer(Packets.Disconnect.class, (con, packet) -> {
            if (con.player != null) {
                NetServer.onDisconnect(con.player, packet.reason);
            }
        });
        Vars.net.handleServer(Packets.ConnectPacket.class, (con, packet) -> {
            boolean preventDuplicates;
            if (con.kicked) {
                return;
            }
            if (con.address.startsWith("steam:")) {
                packet.uuid = con.address.substring("steam:".length());
            }
            con.connectTime = Time.millis();
            String uuid = packet.uuid;
            byte[] buuid = Base64Coder.decode(uuid);
            CRC32 crc = new CRC32();
            crc.update(buuid, 0, 8);
            ByteBuffer buff = ByteBuffer.allocate(8);
            buff.put(buuid, 8, 8);
            buff.position(0);
            if (crc.getValue() != buff.getLong()) {
                con.kick(Packets.KickReason.clientOutdated);
                return;
            }
            if (this.admins.isIPBanned(con.address) || this.admins.isSubnetBanned(con.address)) {
                return;
            }
            if (con.hasBegunConnecting) {
                con.kick(Packets.KickReason.idInUse);
                return;
            }
            Administration.PlayerInfo info = this.admins.getInfo(uuid);
            con.hasBegunConnecting = true;
            con.mobile = packet.mobile;
            if (packet.uuid == null || packet.usid == null) {
                con.kick(Packets.KickReason.idInUse);
                return;
            }
            if (this.admins.isIDBanned(uuid)) {
                con.kick(Packets.KickReason.banned);
                return;
            }
            if (Time.millis() < this.admins.getKickTime(uuid, con.address)) {
                con.kick(Packets.KickReason.recentKick);
                return;
            }
            if (this.admins.getPlayerLimit() > 0 && Groups.player.size() >= this.admins.getPlayerLimit() && !Vars.netServer.admins.isAdmin(uuid, packet.usid)) {
                con.kick(Packets.KickReason.playerLimit);
                return;
            }
            Seq<String> extraMods = packet.mods.copy();
            Seq<String> missingMods = Vars.mods.getIncompatibility(extraMods);
            if (!extraMods.isEmpty() || !missingMods.isEmpty()) {
                StringBuilder result = new StringBuilder("[accent]Incompatible mods![]\n\n");
                if (!missingMods.isEmpty()) {
                    result.append("Missing:[lightgray]\n").append("> ").append(missingMods.toString("\n> "));
                    result.append("[]\n");
                }
                if (!extraMods.isEmpty()) {
                    result.append("Unnecessary mods:[lightgray]\n").append("> ").append(extraMods.toString("\n> "));
                }
                con.kick(result.toString(), 0L);
            }
            if (!this.admins.isWhitelisted(packet.uuid, packet.usid)) {
                info.adminUsid = packet.usid;
                info.lastName = packet.name;
                info.id = packet.uuid;
                this.admins.save();
                Call.infoMessage(con, "You are not whitelisted here.");
                Log.info("&lcDo &lywhitelist-add @&lc to whitelist the player &lb'@'", packet.uuid, packet.name);
                con.kick(Packets.KickReason.whitelist);
                return;
            }
            if (packet.versionType == null || (packet.version == -1 || !packet.versionType.equals(Version.type)) && Version.build != -1 && !this.admins.allowsCustomClients()) {
                con.kick(!Version.type.equals(packet.versionType) ? Packets.KickReason.typeMismatch : Packets.KickReason.customClient);
                return;
            }
            boolean bl = preventDuplicates = Vars.headless && Vars.netServer.admins.isStrict();
            if (preventDuplicates) {
                if (Groups.player.contains(p -> p.name.trim().equalsIgnoreCase(packet.name.trim()))) {
                    con.kick(Packets.KickReason.nameInUse);
                    return;
                }
                if (Groups.player.contains(player -> player.uuid().equals(packet.uuid) || player.usid().equals(packet.usid))) {
                    con.kick(Packets.KickReason.idInUse);
                    return;
                }
            }
            packet.name = this.fixName(packet.name);
            if (packet.name.trim().length() <= 0) {
                con.kick(Packets.KickReason.nameEmpty);
                return;
            }
            if (packet.locale == null) {
                packet.locale = "en";
            }
            String ip = con.address;
            this.admins.updatePlayerJoined(uuid, ip, packet.name);
            if (packet.version != Version.build && Version.build != -1 && packet.version != -1) {
                con.kick(packet.version > Version.build ? Packets.KickReason.serverOutdated : Packets.KickReason.clientOutdated);
                return;
            }
            if (packet.version == -1) {
                con.modclient = true;
            }
            Player player2 = Player.create();
            player2.admin = this.admins.isAdmin(uuid, packet.usid);
            player2.con = con;
            player2.con.usid = packet.usid;
            player2.con.uuid = uuid;
            player2.con.mobile = packet.mobile;
            player2.name = packet.name;
            player2.locale = packet.locale;
            player2.color.set(packet.color).a(1.0f);
            if (!player2.admin && !info.admin) {
                info.adminUsid = packet.usid;
            }
            try {
                this.writeBuffer.reset();
                player2.write(this.outputBuffer);
            }
            catch (Throwable t) {
                con.kick(Packets.KickReason.nameEmpty);
                Log.err(t);
                return;
            }
            con.player = player2;
            player2.team(this.assignTeam(player2));
            this.sendWorldData(player2);
            Vars.platform.updateRPC();
            Events.fire(new EventType.PlayerConnect(player2));
        });
        Vars.net.handleServer(Packets.InvokePacket.class, (con, packet) -> {
            if (con.player == null || con.kicked) {
                return;
            }
            try {
                RemoteReadServer.readPacket(packet.reader(), packet.type, con.player);
            }
            catch (ValidateException e) {
                Log.debug("Validation failed for '@': @", e.player, e.getMessage());
            }
            catch (RuntimeException e) {
                ValidateException v;
                Throwable v$temp = e.getCause();
                if (v$temp instanceof ValidateException && (v = (ValidateException)v$temp) == (ValidateException)v$temp) {
                    Log.debug("Validation failed for '@': @", v.player, v.getMessage());
                }
                throw e;
            }
        });
        this.registerCommands();
    }

    @Override
    public void init() {
        Vars.mods.eachClass(mod -> mod.registerClientCommands(this.clientCommands));
    }

    private void registerCommands() {
        this.clientCommands.register("help", "[page]", "Lists all commands.", (args, player) -> {
            if (args.length > 0 && !Strings.canParseInt(args[0])) {
                player.sendMessage("[scarlet]'page' must be a number.");
                return;
            }
            int commandsPerPage = 6;
            int page = args.length > 0 ? Strings.parseInt(args[0]) : 1;
            int pages = Mathf.ceil((float)this.clientCommands.getCommandList().size / (float)commandsPerPage);
            if (--page >= pages || page < 0) {
                player.sendMessage("[scarlet]'page' must be a number between[orange] 1[] and[orange] " + pages + "[scarlet].");
                return;
            }
            StringBuilder result = new StringBuilder();
            result.append(Strings.format("[orange]-- Commands Page[lightgray] @[gray]/[lightgray]@[orange] --\n\n", page + 1, pages));
            for (int i = commandsPerPage * page; i < Math.min(commandsPerPage * (page + 1), this.clientCommands.getCommandList().size); ++i) {
                CommandHandler.Command command = this.clientCommands.getCommandList().get(i);
                result.append("[orange] /").append(command.text).append("[white] ").append(command.paramText).append("[lightgray] - ").append(command.description).append("\n");
            }
            player.sendMessage(result.toString());
        });
        this.clientCommands.register("t", "<message...>", "Send a message only to your teammates.", (args, player) -> {
            String message = this.admins.filterMessage((Player)player, args[0]);
            if (message != null) {
                Groups.player.each(p -> p.team() == player.team(), o -> o.sendMessage(message, (Player)player, "[#" + player.team().color.toString() + "]<T>" + NetClient.colorizeName(player.id(), player.name)));
            }
        });
        this.clientCommands.register("a", "<message...>", "Send a message only to admins.", (args, player) -> {
            if (!player.admin) {
                player.sendMessage("[scarlet]You must be admin to use this command.");
                return;
            }
            Groups.player.each(Player::admin, a -> a.sendMessage(args[0], (Player)player, "[#" + Pal.adminChat.toString() + "]<A>" + NetClient.colorizeName(player.id, player.name)));
        });
        final int kickDuration = 3600;
        final float voteDuration = 30.0f;
        int voteCooldown = 300;
        ObjectMap cooldowns = new ObjectMap();
        class VoteSession {
            Player target;
            ObjectSet<String> voted = new ObjectSet();
            VoteSession[] map;
            Timer.Task task;
            int votes;

            public VoteSession(VoteSession[] map, Player target) {
                this.target = target;
                this.map = map;
                this.task = Timer.schedule(() -> {
                    if (!this.checkPass()) {
                        Call.sendMessage(Strings.format("[lightgray]Vote failed. Not enough votes to kick[orange] @[lightgray].", target.name));
                        map[0] = null;
                        this.task.cancel();
                    }
                }, voteDuration);
            }

            void vote(Player player, int d) {
                this.votes += d;
                this.voted.addAll((String[])new String[]{player.uuid(), NetServer.this.admins.getInfo((String)player.uuid()).lastIP});
                Call.sendMessage(Strings.format("[lightgray]@[lightgray] has voted on kicking[orange] @[].[accent] (@/@)\n[lightgray]Type[orange] /vote <y/n>[] to agree.", player.name, this.target.name, this.votes, NetServer.this.votesRequired()));
                this.checkPass();
            }

            boolean checkPass() {
                if (this.votes >= NetServer.this.votesRequired()) {
                    Call.sendMessage(Strings.format("[orange]Vote passed.[scarlet] @[orange] will be banned from the server for @ minutes.", this.target.name, kickDuration / 60));
                    this.target.getInfo().lastKicked = Time.millis() + (long)(kickDuration * 1000);
                    Groups.player.each(p -> p.uuid().equals(this.target.uuid()), p -> p.kick(Packets.KickReason.vote));
                    this.map[0] = null;
                    this.task.cancel();
                    return true;
                }
                return false;
            }
        }
        VoteSession[] currentlyKicking = new VoteSession[]{null};
        this.clientCommands.register("votekick", "[player...]", "Vote to kick a player.", (args, player) -> {
            if (!Administration.Config.enableVotekick.bool()) {
                player.sendMessage("[scarlet]Vote-kick is disabled on this server.");
                return;
            }
            if (Groups.player.size() < 3) {
                player.sendMessage("[scarlet]At least 3 players are needed to start a votekick.");
                return;
            }
            if (player.isLocal()) {
                player.sendMessage("[scarlet]Just kick them yourself if you're the host.");
                return;
            }
            if (currentlyKicking[0] != null) {
                player.sendMessage("[scarlet]A vote is already in progress.");
                return;
            }
            if (args.length == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append("[orange]Players to kick: \n");
                Groups.player.each(p -> !p.admin && p.con != null && p != player, p -> builder.append("[lightgray] ").append(p.name).append("[accent] (#").append(p.id()).append(")\n"));
                player.sendMessage(builder.toString());
            } else {
                Player found;
                if (args[0].length() > 1 && args[0].startsWith("#") && Strings.canParseInt(args[0].substring(1))) {
                    int id = Strings.parseInt(args[0].substring(1));
                    found = Groups.player.find(p -> p.id() == id);
                } else {
                    found = Groups.player.find(p -> p.name.equalsIgnoreCase(args[0]));
                }
                if (found != null) {
                    if (found.admin) {
                        player.sendMessage("[scarlet]Did you really expect to be able to kick an admin?");
                    } else if (found.isLocal()) {
                        player.sendMessage("[scarlet]Local players cannot be kicked.");
                    } else if (found.team() != player.team()) {
                        player.sendMessage("[scarlet]Only players on your team can be kicked.");
                    } else {
                        Timekeeper vtime = (Timekeeper)((Object)cooldowns.get(player.uuid(), () -> new Timekeeper(voteCooldown)));
                        if (!vtime.get()) {
                            player.sendMessage("[scarlet]You must wait " + voteCooldown / 60 + " minutes between votekicks.");
                            return;
                        }
                        VoteSession session = new VoteSession(currentlyKicking, found);
                        session.vote((Player)player, 1);
                        vtime.reset();
                        currentlyKicking[0] = session;
                    }
                } else {
                    player.sendMessage("[scarlet]No player [orange]'" + args[0] + "'[scarlet] found.");
                }
            }
        });
        this.clientCommands.register("vote", "<y/n>", "Vote to kick the current player.", (arg, player) -> {
            if (currentlyKicking[0] == null) {
                player.sendMessage("[scarlet]Nobody is being voted on.");
            } else {
                int sign;
                if (player.isLocal()) {
                    player.sendMessage("Local players can't vote. Kick the player yourself instead.");
                    return;
                }
                if (currentlyKicking[0].voted.contains(player.uuid()) || currentlyKicking[0].voted.contains(this.admins.getInfo((String)player.uuid()).lastIP)) {
                    player.sendMessage("[scarlet]You've already voted. Sit down.");
                    return;
                }
                if (currentlyKicking[0].target == player) {
                    player.sendMessage("[scarlet]You can't vote on your own trial.");
                    return;
                }
                if (currentlyKicking[0].target.team() != player.team()) {
                    player.sendMessage("[scarlet]You can't vote for other teams.");
                    return;
                }
                switch (arg[0].toLowerCase()) {
                    case "y": 
                    case "yes": {
                        int n = 1;
                        break;
                    }
                    case "n": 
                    case "no": {
                        int n = -1;
                        break;
                    }
                    default: {
                        int n = sign = 0;
                    }
                }
                if (sign == 0) {
                    player.sendMessage("[scarlet]Vote either 'y' (yes) or 'n' (no).");
                    return;
                }
                currentlyKicking[0].vote((Player)player, sign);
            }
        });
        this.clientCommands.register("sync", "Re-synchronize world state.", (args, player) -> {
            if (player.isLocal()) {
                player.sendMessage("[scarlet]Re-synchronizing as the host is pointless.");
            } else {
                if (Time.timeSinceMillis(player.getInfo().lastSyncTime) < 5000L) {
                    player.sendMessage("[scarlet]You may only /sync every 5 seconds.");
                    return;
                }
                player.getInfo().lastSyncTime = Time.millis();
                Call.worldDataBegin(player.con);
                Vars.netServer.sendWorldData((Player)player);
            }
        });
    }

    public int votesRequired() {
        return 2 + (Groups.player.size() > 4 ? 1 : 0);
    }

    public Team assignTeam(Player current) {
        return this.assigner.assign(current, Groups.player);
    }

    public Team assignTeam(Player current, Iterable<Player> players) {
        return this.assigner.assign(current, players);
    }

    public void sendWorldData(Player player) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        FastDeflaterOutputStream def = new FastDeflaterOutputStream(stream);
        NetworkIO.writeWorld(player, def);
        Packets.WorldStream data = new Packets.WorldStream();
        data.stream = new ByteArrayInputStream(stream.toByteArray());
        player.con.sendStream(data);
        Log.debug("Packed @ bytes of world data.", stream.size());
    }

    public void addPacketHandler(String type, Cons2<Player, String> handler) {
        ((Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons2<Player, String>>)((Object)((Prov<Seq>)Seq::new))))).add(handler);
    }

    public Seq<Cons2<Player, String>> getPacketHandlers(String type) {
        return (Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons2<Player, String>>)((Object)((Prov<Seq>)Seq::new))));
    }

    public static void onDisconnect(Player player, String reason) {
        if (player.con == null) {
            player.remove();
            return;
        }
        if (!player.con.hasDisconnected) {
            if (player.con.hasConnected) {
                Events.fire(new EventType.PlayerLeave(player));
                if (Administration.Config.showConnectMessages.bool()) {
                    Call.sendMessage("[accent]" + player.name + "[accent] has disconnected.");
                }
                Call.playerDisconnect(player.id());
            }
            String message = Strings.format("&lb@&fi&lk has disconnected. &fi&lk[&lb@&fi&lk] (@)", player.name, player.uuid(), reason);
            if (Administration.Config.showConnectMessages.bool()) {
                Log.info(message);
            }
        }
        player.remove();
        player.con.hasDisconnected = true;
    }

    public static void serverPacketReliable(Player player, String type, String contents) {
        if (Vars.netServer.customPacketHandlers.containsKey(type)) {
            for (Cons2<Player, String> c : Vars.netServer.customPacketHandlers.get(type)) {
                c.get(player, contents);
            }
        }
    }

    public static void serverPacketUnreliable(Player player, String type, String contents) {
        NetServer.serverPacketReliable(player, type, contents);
    }

    private static boolean invalid(float f) {
        return Float.isInfinite(f) || Float.isNaN(f);
    }

    public static void clientSnapshot(Player player, int snapshotID, int unitID, boolean dead, float x, float y, float pointerX, float pointerY, float rotation, float baseRotation, float xVelocity, float yVelocity, Tile mining, boolean boosting, boolean shooting, boolean chatting, boolean building, @Nullable BuildPlan[] requests, float viewX, float viewY, float viewWidth, float viewHeight) {
        boolean verifyPosition;
        NetConnection con = player.con;
        if (con == null || snapshotID < con.lastReceivedClientSnapshot) {
            return;
        }
        if (NetServer.invalid(x)) {
            x = 0.0f;
        }
        if (NetServer.invalid(y)) {
            y = 0.0f;
        }
        if (NetServer.invalid(xVelocity)) {
            xVelocity = 0.0f;
        }
        if (NetServer.invalid(yVelocity)) {
            yVelocity = 0.0f;
        }
        if (NetServer.invalid(pointerX)) {
            pointerX = 0.0f;
        }
        if (NetServer.invalid(pointerY)) {
            pointerY = 0.0f;
        }
        if (NetServer.invalid(rotation)) {
            rotation = 0.0f;
        }
        if (NetServer.invalid(baseRotation)) {
            baseRotation = 0.0f;
        }
        boolean bl = verifyPosition = Vars.netServer.admins.isStrict() && Vars.headless;
        if (con.lastReceivedClientTime == 0L) {
            con.lastReceivedClientTime = Time.millis() - 16L;
        }
        con.viewX = viewX;
        con.viewY = viewY;
        con.viewWidth = viewWidth;
        con.viewHeight = viewHeight;
        if (!player.dead() && player.unit().isFlying() && player.unit() instanceof Mechc) {
            shooting = false;
        }
        if (!(player.dead() || !player.unit().type.flying && player.unit().type.canBoost)) {
            boosting = false;
        }
        player.mouseX = pointerX;
        player.mouseY = pointerY;
        player.typing = chatting;
        player.shooting = shooting;
        player.boosting = boosting;
        player.unit().controlWeapons(shooting, shooting);
        player.unit().aim(pointerX, pointerY);
        if (player.isBuilder()) {
            player.unit().clearBuilding();
            player.unit().updateBuilding(building);
            if (requests != null) {
                for (BuildPlan req : requests) {
                    Tile tile;
                    if (req == null || (tile = Vars.world.tile(req.x, req.y)) == null || !req.breaking && req.block == null || req.breaking && tile.block() == Blocks.air || !req.breaking && tile.block() == req.block && (!req.block.rotate || tile.build != null && tile.build.rotation == req.rotation) || con.rejectedRequests.contains((BuildPlan)((Object)((Boolf<BuildPlan>)r -> r.breaking == req.breaking && r.x == req.x && r.y == req.y)))) continue;
                    if (!Vars.netServer.admins.allowAction(player, req.breaking ? Administration.ActionType.breakBlock : Administration.ActionType.placeBlock, tile, action -> {
                        action.block = req.block;
                        action.rotation = req.rotation;
                        action.config = req.config;
                    })) {
                        Call.removeQueueBlock(player.con, req.x, req.y, req.breaking);
                        con.rejectedRequests.add(req);
                        continue;
                    }
                    player.unit().plans().addLast(req);
                }
            }
        }
        player.unit().mineTile = mining;
        con.rejectedRequests.clear();
        if (!player.dead()) {
            Unit unit = player.unit();
            long elapsed = Time.timeSinceMillis(con.lastReceivedClientTime);
            float maxSpeed = unit.realSpeed();
            float maxMove = (float)elapsed / 1000.0f * 60.0f * maxSpeed * 1.2f;
            boolean ignorePosition = dead || unit.id != unitID;
            float newx = unit.x;
            float newy = unit.y;
            if (!ignorePosition) {
                unit.vel.set(xVelocity, yVelocity).limit(maxSpeed);
                vector.set(x, y).sub(unit);
                vector.limit(maxMove);
                float prevx = unit.x;
                float prevy = unit.y;
                if (!unit.isFlying()) {
                    unit.move(NetServer.vector.x, NetServer.vector.y);
                } else {
                    unit.trns(NetServer.vector.x, NetServer.vector.y);
                }
                newx = unit.x;
                newy = unit.y;
                if (!verifyPosition) {
                    unit.set(prevx, prevy);
                    newx = x;
                    newy = y;
                } else if (!Mathf.within(x, y, newx, newy, 112.0f)) {
                    Call.setPosition(player.con, newx, newy);
                }
            }
            fbuffer.limit(20);
            fbuffer.position(0);
            if (unit instanceof Mechc) {
                fbuffer.put(baseRotation);
            }
            fbuffer.put(rotation);
            fbuffer.put(newx);
            fbuffer.put(newy);
            fbuffer.flip();
            unit.readSyncManual(fbuffer);
        } else {
            player.x = x;
            player.y = y;
        }
        con.lastReceivedClientSnapshot = snapshotID;
        con.lastReceivedClientTime = Time.millis();
    }

    public static void adminRequest(Player player, Player other, Packets.AdminAction action) {
        if (!player.admin && !player.isLocal()) {
            Log.warn("ACCESS DENIED: Player @ / @ attempted to perform admin action '@' on '@' without proper security access.", player.name, player.con == null ? "null" : player.con.address, action.name(), other == null ? null : other.name);
            return;
        }
        if (other == null || other.admin && !player.isLocal() && other != player) {
            Log.warn("@ attempted to perform admin action on nonexistant or admin player.", player.name);
            return;
        }
        if (action == Packets.AdminAction.wave) {
            Vars.logic.skipWave();
            Log.info("&lc@ has skipped the wave.", player.name);
        } else if (action == Packets.AdminAction.ban) {
            Vars.netServer.admins.banPlayerID(other.con.uuid);
            Vars.netServer.admins.banPlayerIP(other.con.address);
            other.kick(Packets.KickReason.banned);
            Log.info("&lc@ has banned @.", player.name, other.name);
        } else if (action == Packets.AdminAction.kick) {
            other.kick(Packets.KickReason.kick);
            Log.info("&lc@ has kicked @.", player.name, other.name);
        } else if (action == Packets.AdminAction.trace) {
            Administration.PlayerInfo stats = Vars.netServer.admins.getInfo(other.uuid());
            Administration.TraceInfo info = new Administration.TraceInfo(other.con.address, other.uuid(), other.con.modclient, other.con.mobile, stats.timesJoined, stats.timesKicked);
            if (player.con != null) {
                Call.traceInfo(player.con, other, info);
            } else {
                NetClient.traceInfo(other, info);
            }
            Log.info("&lc@ has requested trace info of @.", player.name, other.name);
        }
    }

    public static void connectConfirm(Player player) {
        if (player.con.kicked) {
            return;
        }
        player.add();
        if (player.con == null || player.con.hasConnected) {
            return;
        }
        player.con.hasConnected = true;
        if (Administration.Config.showConnectMessages.bool()) {
            Call.sendMessage("[accent]" + player.name + "[accent] has connected.");
            String message = Strings.format("&lb@&fi&lk has connected. &fi&lk[&lb@&fi&lk]", player.name, player.uuid());
            Log.info(message);
        }
        if (!Administration.Config.motd.string().equalsIgnoreCase("off")) {
            player.sendMessage(Administration.Config.motd.string());
        }
        Events.fire(new EventType.PlayerJoin(player));
    }

    public boolean isWaitingForPlayers() {
        if (Vars.state.rules.pvp && !Vars.state.gameOver) {
            int used = 0;
            for (Teams.TeamData t : Vars.state.teams.getActive()) {
                if (Groups.player.count(p -> p.team() == t.team) <= 0) continue;
                ++used;
            }
            return used < 2;
        }
        return false;
    }

    @Override
    public void update() {
        if (!Vars.headless && !this.closing && Vars.net.server() && Vars.state.isMenu()) {
            this.closing = true;
            Vars.ui.loadfrag.show("@server.closing");
            Time.runTask(5.0f, () -> {
                Vars.net.closeServer();
                Vars.ui.loadfrag.hide();
                this.closing = false;
            });
        }
        if (Vars.state.isGame() && Vars.net.server()) {
            if (Vars.state.rules.pvp) {
                Vars.state.serverPaused = this.isWaitingForPlayers();
            }
            this.sync();
        }
    }

    public void openServer() {
        try {
            Vars.net.host(Administration.Config.port.num());
            Log.info("Opened a server on port @.", Administration.Config.port.num());
        }
        catch (BindException e) {
            Log.err("Unable to host: Port already in use! Make sure no other servers are running on the same port in your network.", new Object[0]);
            Vars.state.set(GameState.State.menu);
        }
        catch (IOException e) {
            Log.err(e);
            Vars.state.set(GameState.State.menu);
        }
    }

    public void kickAll(Packets.KickReason reason) {
        for (NetConnection con : Vars.net.getConnections()) {
            con.kick(reason);
        }
    }

    public void writeBlockSnapshots() throws IOException {
        this.syncStream.reset();
        short sent = 0;
        for (Building entity : Groups.build) {
            if (!entity.block.sync) continue;
            sent = (short)(sent + 1);
            this.dataStream.writeInt(entity.pos());
            this.dataStream.writeShort(entity.block.id);
            entity.writeAll(Writes.get(this.dataStream));
            if (this.syncStream.size() <= 800) continue;
            this.dataStream.close();
            byte[] stateBytes = this.syncStream.toByteArray();
            Call.blockSnapshot(sent, (short)stateBytes.length, Vars.net.compressSnapshot(stateBytes));
            sent = 0;
            this.syncStream.reset();
        }
        if (sent > 0) {
            this.dataStream.close();
            byte[] stateBytes = this.syncStream.toByteArray();
            Call.blockSnapshot(sent, (short)stateBytes.length, Vars.net.compressSnapshot(stateBytes));
        }
    }

    public void writeEntitySnapshot(Player player) throws IOException {
        this.syncStream.reset();
        int sum = Vars.state.teams.present.sum(t -> t.cores.size);
        this.dataStream.writeInt(sum);
        for (Teams.TeamData data : Vars.state.teams.present) {
            for (CoreBlock.CoreBuild coreBuild : data.cores) {
                this.dataStream.writeInt(coreBuild.tile.pos());
                coreBuild.items.write(Writes.get(this.dataStream));
            }
        }
        this.dataStream.close();
        byte[] stateBytes = this.syncStream.toByteArray();
        Call.stateSnapshot(player.con, Vars.state.wavetime, Vars.state.wave, Vars.state.enemies, Vars.state.serverPaused, Vars.state.gameOver, Vars.universe.seconds(), (short)stateBytes.length, Vars.net.compressSnapshot(stateBytes));
        viewport.setSize(player.con.viewWidth, player.con.viewHeight).setCenter(player.con.viewX, player.con.viewY);
        this.syncStream.reset();
        int sent = 0;
        for (Syncc syncc : Groups.sync) {
            this.dataStream.writeInt(syncc.id());
            this.dataStream.writeByte(syncc.classId());
            syncc.writeSync(Writes.get(this.dataStream));
            ++sent;
            if (this.syncStream.size() <= 800) continue;
            this.dataStream.close();
            byte[] syncBytes = this.syncStream.toByteArray();
            Call.entitySnapshot(player.con, (short)sent, (short)syncBytes.length, Vars.net.compressSnapshot(syncBytes));
            sent = 0;
            this.syncStream.reset();
        }
        if (sent > 0) {
            this.dataStream.close();
            byte[] syncBytes = this.syncStream.toByteArray();
            Call.entitySnapshot(player.con, (short)sent, (short)syncBytes.length, Vars.net.compressSnapshot(syncBytes));
        }
    }

    String fixName(String name) {
        if ((name = name.trim()).equals("[") || name.equals("]")) {
            return "";
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '[' || i == name.length() - 1 || name.charAt(i + 1) == '[' || i != 0 && name.charAt(i - 1) == '[') continue;
            String prev = name.substring(0, i);
            String next = name.substring(i);
            String result = this.checkColor(next);
            name = prev + result;
        }
        StringBuilder result = new StringBuilder();
        int curChar = 0;
        while (curChar < name.length() && result.toString().getBytes(Strings.utf8).length < 40) {
            result.append(name.charAt(curChar++));
        }
        return result.toString();
    }

    String checkColor(String str) {
        for (int i = 1; i < str.length(); ++i) {
            Color result;
            if (str.charAt(i) != ']') continue;
            String color = str.substring(1, i);
            if (Colors.get(color.toUpperCase()) != null || Colors.get(color.toLowerCase()) != null) {
                Color color2 = result = Colors.get(color.toLowerCase()) == null ? Colors.get(color.toUpperCase()) : Colors.get(color.toLowerCase());
                if (!(result.a <= 0.8f)) continue;
                return str.substring(i + 1);
            }
            try {
                result = Color.valueOf(color);
                if (!(result.a <= 0.8f)) continue;
                return str.substring(i + 1);
            }
            catch (Exception e) {
                return str;
            }
        }
        return str;
    }

    void sync() {
        try {
            Groups.player.each(p -> !p.isLocal(), player -> {
                if (player.con == null || !player.con.isConnected()) {
                    NetServer.onDisconnect(player, "disappeared");
                    return;
                }
                NetConnection connection = player.con;
                if (Time.timeSinceMillis(connection.syncTime) < 200L || !connection.hasConnected) {
                    return;
                }
                connection.syncTime = Time.millis();
                try {
                    this.writeEntitySnapshot((Player)player);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            if (Groups.player.size() > 0 && Core.settings.getBool("blocksync") && this.timer.get(0, 360.0f)) {
                this.writeBlockSnapshots();
            }
        }
        catch (IOException e) {
            Log.err(e);
        }
    }

    public static interface TeamAssigner {
        public Team assign(Player var1, Iterable<Player> var2);
    }
}

