/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Structs;
import arc.util.serialization.Base64Coder;
import java.net.URL;
import java.net.URLClassLoader;
import mindustry.Vars;
import mindustry.mod.Scripts;
import mindustry.net.ArcNetProvider;
import mindustry.net.Net;
import mindustry.type.Publishable;
import mindustry.ui.dialogs.FileChooser;
import rhino.Context;

public interface Platform {
    default public ClassLoader loadJar(Fi jar, String mainClass) throws Exception {
        return new URLClassLoader(new URL[]{jar.file().toURI().toURL()}, this.getClass().getClassLoader());
    }

    default public void updateLobby() {
    }

    default public void inviteFriends() {
    }

    default public void publish(Publishable pub) {
    }

    default public void viewListing(Publishable pub) {
    }

    default public void viewListingID(String mapid) {
    }

    default public Seq<Fi> getWorkshopContent(Class<? extends Publishable> type) {
        return new Seq<Fi>(0);
    }

    default public void openWorkshop() {
    }

    default public Net.NetProvider getNet() {
        return new ArcNetProvider();
    }

    default public Scripts createScripts() {
        return new Scripts();
    }

    default public Context getScriptContext() {
        Context c = Context.enter();
        c.setOptimizationLevel(9);
        return c;
    }

    default public void updateRPC() {
    }

    default public String getUUID() {
        String uuid = Core.settings.getString("uuid", "");
        if (uuid.isEmpty()) {
            byte[] result = new byte[8];
            new Rand().nextBytes(result);
            uuid = new String(Base64Coder.encode(result));
            Core.settings.put("uuid", uuid);
            return uuid;
        }
        return uuid;
    }

    default public void shareFile(Fi file) {
    }

    default public void export(String name, String extension, FileWriter writer) {
        if (!Vars.ios) {
            Vars.platform.showFileChooser(false, extension, file -> Vars.ui.loadAnd(() -> {
                try {
                    writer.write((Fi)file);
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                    Log.err(e);
                }
            }));
        } else {
            Vars.ui.loadAnd(() -> {
                try {
                    Fi result = Core.files.local(name + "." + extension);
                    writer.write(result);
                    Vars.platform.shareFile(result);
                }
                catch (Throwable e) {
                    Vars.ui.showException(e);
                    Log.err(e);
                }
            });
        }
    }

    default public void showFileChooser(boolean open, String title, String extension, Cons<Fi> cons) {
        new FileChooser(title, file -> file.extEquals(extension), open, file -> {
            if (!open) {
                cons.get(file.parent().child(file.nameWithoutExtension() + "." + extension));
            } else {
                cons.get((Fi)file);
            }
        }).show();
    }

    default public void showFileChooser(boolean open, String extension, Cons<Fi> cons) {
        this.showFileChooser(open, open ? "@open" : "@save", extension, cons);
    }

    default public void showMultiFileChooser(Cons<Fi> cons, String ... extensions) {
        if (Vars.mobile) {
            this.showFileChooser(true, extensions[0], cons);
        } else {
            new FileChooser("@open", file -> Structs.contains(extensions, file.extension().toLowerCase()), true, cons).show();
        }
    }

    default public void hide() {
    }

    default public void beginForceLandscape() {
    }

    default public void endForceLandscape() {
    }

    public static interface FileWriter {
        public void write(Fi var1) throws Throwable;
    }
}

