/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.graphics.Camera;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.g2d.Bloom;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.ui.layout.Scl;
import arc.util.Buffers;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.ScreenUtils;
import arc.util.Time;
import java.nio.Buffer;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Drawc;
import mindustry.gen.Groups;
import mindustry.graphics.BlockRenderer;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.LightRenderer;
import mindustry.graphics.MinimapRenderer;
import mindustry.graphics.OverlayRenderer;
import mindustry.graphics.Pal;
import mindustry.graphics.Pixelator;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.PlanetRenderer;
import mindustry.ui.Cicon;
import mindustry.world.blocks.storage.CoreBlock;

public class Renderer
implements ApplicationListener {
    public static float laserOpacity = 0.5f;
    public static float bridgeOpacity = 0.75f;
    public final BlockRenderer blocks = new BlockRenderer();
    public final MinimapRenderer minimap = new MinimapRenderer();
    public final OverlayRenderer overlays = new OverlayRenderer();
    public final LightRenderer lights = new LightRenderer();
    public final Pixelator pixelator = new Pixelator();
    public PlanetRenderer planets;
    @Nullable
    public Bloom bloom;
    public FrameBuffer effectBuffer = new FrameBuffer();
    public boolean animateShields;
    public boolean drawWeather = true;
    public boolean drawStatus;
    public float minZoom = 1.5f;
    public float maxZoom = 6.0f;
    @Nullable
    private CoreBlock.CoreBuild landCore;
    private Color clearColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private float targetscale;
    private float camerascale = this.targetscale = Scl.scl(4.0f);
    private float landscale;
    private float landTime;
    private float weatherAlpha;
    private float minZoomScl = Scl.scl(0.01f);
    private float shakeIntensity;
    private float shaketime;

    public Renderer() {
        Core.camera = new Camera();
        Shaders.init();
    }

    public void shake(float intensity, float duration) {
        this.shakeIntensity = Math.max(this.shakeIntensity, intensity);
        this.shaketime = Math.max(this.shaketime, duration);
    }

    @Override
    public void init() {
        this.planets = new PlanetRenderer();
        if (Core.settings.getBool("bloom", !Vars.ios)) {
            this.setupBloom();
        }
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.landCore = Vars.player.bestCore();
        });
    }

    @Override
    public void update() {
        Color.white.set(1.0f, 1.0f, 1.0f, 1.0f);
        float dest = Mathf.round(this.targetscale, 0.5f);
        this.camerascale = Mathf.lerpDelta(this.camerascale, dest, 0.1f);
        if (Mathf.equal(this.camerascale, dest, 0.001f)) {
            this.camerascale = dest;
        }
        laserOpacity = (float)Core.settings.getInt("lasersopacity") / 100.0f;
        bridgeOpacity = (float)Core.settings.getInt("bridgeopacity") / 100.0f;
        this.animateShields = Core.settings.getBool("animatedshields");
        this.drawStatus = Core.settings.getBool("blockstatus");
        if (this.landTime > 0.0f) {
            this.landTime -= Time.delta;
            this.camerascale = this.landscale = Interp.pow5In.apply(this.minZoomScl, Scl.scl(4.0f), 1.0f - this.landTime / Fx.coreLand.lifetime);
            this.weatherAlpha = 0.0f;
        } else {
            this.weatherAlpha = Mathf.lerpDelta(this.weatherAlpha, 1.0f, 0.08f);
        }
        Core.camera.width = (float)Core.graphics.getWidth() / this.camerascale;
        Core.camera.height = (float)Core.graphics.getHeight() / this.camerascale;
        if (Vars.state.isMenu()) {
            this.landTime = 0.0f;
            Core.graphics.clear(Color.black);
        } else {
            this.updateShake(0.75f);
            if (this.pixelator.enabled()) {
                this.pixelator.drawPixelate();
            } else {
                this.draw();
            }
        }
    }

    public boolean isLanding() {
        return this.landTime > 0.0f;
    }

    public float weatherAlpha() {
        return this.weatherAlpha;
    }

    public float landScale() {
        return this.landTime > 0.0f ? this.landscale : 1.0f;
    }

    @Override
    public void dispose() {
        Events.fire(new EventType.DisposeEvent());
    }

    @Override
    public void resume() {
        if (Core.settings.getBool("bloom") && this.bloom != null) {
            this.bloom.resume();
        }
    }

    void setupBloom() {
        try {
            if (this.bloom != null) {
                this.bloom.dispose();
                this.bloom = null;
            }
            this.bloom = new Bloom(true);
        }
        catch (Throwable e) {
            Core.settings.put("bloom", false);
            Vars.ui.showErrorMessage("@error.bloom");
            Log.err(e);
        }
    }

    public void toggleBloom(boolean enabled) {
        if (enabled) {
            if (this.bloom == null) {
                this.setupBloom();
            }
        } else if (this.bloom != null) {
            this.bloom.dispose();
            this.bloom = null;
        }
    }

    void updateShake(float scale) {
        if (this.shaketime > 0.0f) {
            float intensity = this.shakeIntensity * ((float)Core.settings.getInt("screenshake", 4) / 4.0f) * scale;
            Core.camera.position.add(Mathf.range(intensity), Mathf.range(intensity));
            this.shakeIntensity -= 0.25f * Time.delta;
            this.shaketime -= Time.delta;
            this.shakeIntensity = Mathf.clamp(this.shakeIntensity, 0.0f, 100.0f);
        } else {
            this.shakeIntensity = 0.0f;
        }
    }

    public void draw() {
        Events.fire(EventType.Trigger.preDraw);
        Core.camera.update();
        if (Float.isNaN(Core.camera.position.x) || Float.isNaN(Core.camera.position.y)) {
            Core.camera.position.set(Vars.player);
        }
        Core.graphics.clear(this.clearColor);
        Draw.reset();
        if (Core.settings.getBool("animatedwater") || this.animateShields) {
            this.effectBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
        }
        Draw.proj(Core.camera);
        this.blocks.floor.checkChanges();
        this.blocks.processBlocks();
        Draw.sort(true);
        Events.fire(EventType.Trigger.draw);
        if (this.pixelator.enabled()) {
            this.pixelator.register();
        }
        Draw.draw(-10.0f, this::drawBackground);
        Draw.draw(0.0f, this.blocks.floor::drawFloor);
        Draw.draw(29.0f, this.blocks::drawShadows);
        Draw.draw(29.91f, () -> {
            this.blocks.floor.beginDraw();
            this.blocks.floor.drawLayer(CacheLayer.walls);
            this.blocks.floor.endDraw();
        });
        Draw.drawRange(40.0f, () -> Draw.shader(Shaders.blockbuild, true), Draw::shader);
        if (Vars.state.rules.lighting) {
            Draw.draw(140.0f, this.lights::draw);
        }
        if (Vars.enableDarkness) {
            Draw.draw(80.0f, this.blocks::drawDarkness);
        }
        if (this.bloom != null) {
            this.bloom.resize(Core.graphics.getWidth() / 4, Core.graphics.getHeight() / 4);
            Draw.draw(99.99f, this.bloom::capture);
            Draw.draw(110.01f, this.bloom::render);
        }
        Draw.draw(85.0f, this.overlays::drawBottom);
        if (this.animateShields && Shaders.shield != null) {
            Draw.drawRange(125.0f, 1.0f, () -> this.effectBuffer.begin(Color.clear), () -> {
                this.effectBuffer.end();
                this.effectBuffer.blit(Shaders.shield);
            });
            Draw.drawRange(122.0f, 1.0f, () -> this.effectBuffer.begin(Color.clear), () -> {
                this.effectBuffer.end();
                this.effectBuffer.blit(Shaders.buildBeam);
            });
        }
        Draw.draw(120.0f, this.overlays::drawTop);
        Draw.draw(160.0f, this::drawLanding);
        this.blocks.drawBlocks();
        Groups.draw.draw(Drawc::draw);
        Draw.reset();
        Draw.flush();
        Draw.sort(false);
        Events.fire(EventType.Trigger.postDraw);
    }

    private void drawBackground() {
    }

    private void drawLanding() {
        CoreBlock.CoreBuild entity;
        CoreBlock.CoreBuild coreBuild = entity = this.landCore == null ? Vars.player.bestCore() : this.landCore;
        if (this.landTime > 0.0f && entity != null) {
            float fract = this.landTime / Fx.coreLand.lifetime;
            TextureRegion reg = entity.block.icon(Cicon.full);
            float scl = Scl.scl(4.0f) / this.camerascale;
            float s = (float)reg.width * Draw.scl * scl * 4.0f * fract;
            Draw.color(Pal.lightTrail);
            Draw.rect("circle-shadow", entity.x, entity.y, s, s);
            Angles.randLenVectors(1L, 1.0f - fract, 100, 1000.0f * scl * (1.0f - fract), (x, y, fin, fout) -> {
                Lines.stroke(scl * fin);
                Lines.lineAngle(entity.x + x, entity.y + y, Mathf.angle(x, y), (fin * 20.0f + 1.0f) * scl);
            });
            Draw.color();
            Draw.mixcol(Color.white, fract);
            Draw.rect(reg, entity.x, entity.y, (float)reg.width * Draw.scl * scl, (float)reg.height * Draw.scl * scl, fract * 135.0f);
            Draw.reset();
        }
    }

    public void scaleCamera(float amount) {
        this.targetscale *= amount / 4.0f + 1.0f;
        this.clampScale();
    }

    public void clampScale() {
        this.targetscale = Mathf.clamp(this.targetscale, this.minScale(), this.maxScale());
    }

    public float getDisplayScale() {
        return this.camerascale;
    }

    public float minScale() {
        return Scl.scl(this.minZoom);
    }

    public float maxScale() {
        return Mathf.round(Scl.scl(this.maxZoom));
    }

    public float getScale() {
        return this.targetscale;
    }

    public void setScale(float scl) {
        this.targetscale = scl;
        this.clampScale();
    }

    public void zoomIn(float duration) {
        this.landscale = this.minZoomScl;
        this.landTime = duration;
    }

    public void takeMapScreenshot() {
        int h;
        int w = Vars.world.width() * 8;
        int memory = w * (h = Vars.world.height() * 8) * 4 / 1024 / 1024;
        if (memory >= (Vars.mobile ? 65 : 120)) {
            Vars.ui.showInfo("@screenshot.invalid");
            return;
        }
        FrameBuffer buffer = new FrameBuffer(w, h);
        this.drawWeather = false;
        float vpW = Core.camera.width;
        float vpH = Core.camera.height;
        float px = Core.camera.position.x;
        float py = Core.camera.position.y;
        Vars.disableUI = true;
        Core.camera.width = w;
        Core.camera.height = h;
        Core.camera.position.x = (float)w / 2.0f + 4.0f;
        Core.camera.position.y = (float)h / 2.0f + 4.0f;
        buffer.begin();
        this.draw();
        buffer.end();
        Vars.disableUI = false;
        Core.camera.width = vpW;
        Core.camera.height = vpH;
        Core.camera.position.set(px, py);
        buffer.begin();
        byte[] lines = ScreenUtils.getFrameBufferPixels(0, 0, w, h, true);
        for (int i = 0; i < lines.length; i += 4) {
            lines[i + 3] = -1;
        }
        buffer.end();
        Pixmap fullPixmap = new Pixmap(w, h, Pixmap.Format.rgba8888);
        Buffers.copy(lines, 0, (Buffer)fullPixmap.getPixels(), lines.length);
        Fi file = Vars.screenshotDirectory.child("screenshot-" + Time.millis() + ".png");
        PixmapIO.writePNG(file, fullPixmap);
        fullPixmap.dispose();
        Vars.ui.showInfoFade(Core.bundle.format("screenshot", file.toString()));
        this.drawWeather = true;
        buffer.dispose();
    }
}

