/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.Graphics;
import arc.Input;
import arc.assets.AssetDescriptor;
import arc.assets.Loadable;
import arc.func.Boolp;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.PixmapPacker;
import arc.input.KeyCode;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.Scene;
import arc.scene.actions.Actions;
import arc.scene.event.ClickListener;
import arc.scene.event.Touchable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.TextField;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Collapser;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.core.Control;
import mindustry.editor.MapEditorDialog;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Sounds;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.LogicDialog;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.AboutDialog;
import mindustry.ui.dialogs.AdminsDialog;
import mindustry.ui.dialogs.BansDialog;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.ColorPicker;
import mindustry.ui.dialogs.ContentInfoDialog;
import mindustry.ui.dialogs.ControlsDialog;
import mindustry.ui.dialogs.CustomGameDialog;
import mindustry.ui.dialogs.DatabaseDialog;
import mindustry.ui.dialogs.DiscordDialog;
import mindustry.ui.dialogs.GameOverDialog;
import mindustry.ui.dialogs.HostDialog;
import mindustry.ui.dialogs.JoinDialog;
import mindustry.ui.dialogs.LanguageDialog;
import mindustry.ui.dialogs.LoadDialog;
import mindustry.ui.dialogs.MapsDialog;
import mindustry.ui.dialogs.ModsDialog;
import mindustry.ui.dialogs.PausedDialog;
import mindustry.ui.dialogs.PlanetDialog;
import mindustry.ui.dialogs.ResearchDialog;
import mindustry.ui.dialogs.SchematicsDialog;
import mindustry.ui.dialogs.SettingsMenuDialog;
import mindustry.ui.dialogs.TraceDialog;
import mindustry.ui.fragments.ChatFragment;
import mindustry.ui.fragments.FadeInFragment;
import mindustry.ui.fragments.HintsFragment;
import mindustry.ui.fragments.HudFragment;
import mindustry.ui.fragments.LoadingFragment;
import mindustry.ui.fragments.MenuFragment;
import mindustry.ui.fragments.MinimapFragment;
import mindustry.ui.fragments.PlayerListFragment;
import mindustry.ui.fragments.ScriptConsoleFragment;

public class UI
implements ApplicationListener,
Loadable {
    public static PixmapPacker packer;
    public MenuFragment menufrag;
    public HudFragment hudfrag;
    public ChatFragment chatfrag;
    public ScriptConsoleFragment scriptfrag;
    public MinimapFragment minimapfrag;
    public PlayerListFragment listfrag;
    public LoadingFragment loadfrag;
    public HintsFragment hints;
    public WidgetGroup menuGroup;
    public WidgetGroup hudGroup;
    public AboutDialog about;
    public GameOverDialog restart;
    public CustomGameDialog custom;
    public MapsDialog maps;
    public LoadDialog load;
    public DiscordDialog discord;
    public JoinDialog join;
    public HostDialog host;
    public PausedDialog paused;
    public SettingsMenuDialog settings;
    public ControlsDialog controls;
    public MapEditorDialog editor;
    public LanguageDialog language;
    public BansDialog bans;
    public AdminsDialog admins;
    public TraceDialog traces;
    public DatabaseDialog database;
    public ContentInfoDialog content;
    public PlanetDialog planet;
    public ResearchDialog research;
    public SchematicsDialog schematics;
    public ModsDialog mods;
    public ColorPicker picker;
    public LogicDialog logic;
    public Graphics.Cursor drillCursor;
    public Graphics.Cursor unloadCursor;

    public UI() {
        Fonts.loadFonts();
    }

    @Override
    public void loadAsync() {
    }

    @Override
    public void loadSync() {
        Fonts.outline.getData().markupEnabled = true;
        Fonts.def.getData().markupEnabled = true;
        Fonts.def.setOwnsTexture(false);
        Core.assets.getAll(Font.class, new Seq()).each(font -> font.setUseIntegerPositions(true));
        Core.scene = new Scene();
        Core.input.addProcessor(Core.scene);
        int[] insets = Core.graphics.getSafeInsets();
        Core.scene.marginLeft = insets[0];
        Core.scene.marginRight = insets[1];
        Core.scene.marginTop = insets[2];
        Core.scene.marginBottom = insets[3];
        Tex.load();
        Icon.load();
        Styles.load();
        Tex.loadStyles();
        Fonts.loadContentIcons();
        Dialog.setShowAction(() -> Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.1f)));
        Dialog.setHideAction(() -> Actions.sequence((Action)Actions.fadeOut(0.1f)));
        Tooltip.Tooltips.getInstance().animations = false;
        Tooltip.Tooltips.getInstance().textProvider = text -> new Tooltip(t -> t.background(Styles.black6).margin(4.0f).add((CharSequence)text));
        Core.settings.setErrorHandler(e -> {
            Log.err(e);
            Core.app.post(() -> this.showErrorMessage("Failed to access local storage.\nSettings will not be saved."));
        });
        ClickListener.clicked = () -> Sounds.press.play();
        Colors.put("accent", Pal.accent);
        Colors.put("unlaunched", Color.valueOf("8982ed"));
        Colors.put("highlight", Pal.accent.cpy().lerp(Color.white, 0.3f));
        Colors.put("stat", Pal.stat);
        this.drillCursor = Core.graphics.newCursor("drill", Fonts.cursorScale());
        this.unloadCursor = Core.graphics.newCursor("unload", Fonts.cursorScale());
    }

    @Override
    public Seq<AssetDescriptor> getDependencies() {
        return Seq.with(new AssetDescriptor<Control>(Control.class), new AssetDescriptor<Font>("outline", Font.class), new AssetDescriptor<Font>("default", Font.class), new AssetDescriptor<Font>("chat", Font.class));
    }

    @Override
    public void update() {
        Element e;
        if (Vars.disableUI || Core.scene == null) {
            return;
        }
        Events.fire(EventType.Trigger.uiDrawBegin);
        Core.scene.act();
        Core.scene.draw();
        if (Core.input.keyTap(KeyCode.mouseLeft) && Core.scene.getKeyboardFocus() instanceof TextField && !((e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true)) instanceof TextField)) {
            Core.scene.setKeyboardFocus(null);
        }
        Events.fire(EventType.Trigger.uiDrawEnd);
    }

    @Override
    public void init() {
        this.menuGroup = new WidgetGroup();
        this.hudGroup = new WidgetGroup();
        this.menufrag = new MenuFragment();
        this.hudfrag = new HudFragment();
        this.hints = new HintsFragment();
        this.chatfrag = new ChatFragment();
        this.minimapfrag = new MinimapFragment();
        this.listfrag = new PlayerListFragment();
        this.loadfrag = new LoadingFragment();
        this.scriptfrag = new ScriptConsoleFragment();
        this.picker = new ColorPicker();
        this.editor = new MapEditorDialog();
        this.controls = new ControlsDialog();
        this.restart = new GameOverDialog();
        this.join = new JoinDialog();
        this.discord = new DiscordDialog();
        this.load = new LoadDialog();
        this.custom = new CustomGameDialog();
        this.language = new LanguageDialog();
        this.database = new DatabaseDialog();
        this.settings = new SettingsMenuDialog();
        this.host = new HostDialog();
        this.paused = new PausedDialog();
        this.about = new AboutDialog();
        this.bans = new BansDialog();
        this.admins = new AdminsDialog();
        this.traces = new TraceDialog();
        this.maps = new MapsDialog();
        this.content = new ContentInfoDialog();
        this.planet = new PlanetDialog();
        this.research = new ResearchDialog();
        this.mods = new ModsDialog();
        this.schematics = new SchematicsDialog();
        this.logic = new LogicDialog();
        Group group = Core.scene.root;
        this.menuGroup.setFillParent(true);
        this.menuGroup.touchable = Touchable.childrenOnly;
        this.menuGroup.visible(() -> Vars.state.isMenu());
        this.hudGroup.setFillParent(true);
        this.hudGroup.touchable = Touchable.childrenOnly;
        this.hudGroup.visible(() -> Vars.state.isGame());
        Core.scene.add(this.menuGroup);
        Core.scene.add(this.hudGroup);
        this.hudfrag.build(this.hudGroup);
        this.menufrag.build(this.menuGroup);
        this.chatfrag.container().build(this.hudGroup);
        this.minimapfrag.build(this.hudGroup);
        this.listfrag.build(this.hudGroup);
        this.scriptfrag.container().build(this.hudGroup);
        this.loadfrag.build(group);
        new FadeInFragment().build(group);
    }

    @Override
    public void resize(int width, int height) {
        if (Core.scene == null) {
            return;
        }
        int[] insets = Core.graphics.getSafeInsets();
        Core.scene.marginLeft = insets[0];
        Core.scene.marginRight = insets[1];
        Core.scene.marginTop = insets[2];
        Core.scene.marginBottom = insets[3];
        Core.scene.resize(width, height);
        Events.fire(new EventType.ResizeEvent());
    }

    public TextureRegionDrawable getIcon(String name) {
        if (Icon.icons.containsKey(name)) {
            return Icon.icons.get(name);
        }
        return (TextureRegionDrawable)Core.atlas.getDrawable("error");
    }

    public TextureRegionDrawable getIcon(String name, String def) {
        if (Icon.icons.containsKey(name)) {
            return Icon.icons.get(name);
        }
        return this.getIcon(def);
    }

    public void loadAnd(Runnable call) {
        this.loadAnd("@loading", call);
    }

    public void loadAnd(String text, Runnable call) {
        this.loadfrag.show(text);
        Time.runTask(7.0f, () -> {
            call.run();
            this.loadfrag.hide();
        });
    }

    public void showTextInput(final String titleText, final String dtext, final int textLength, final String def, final boolean inumeric, final Cons<String> confirmed) {
        if (Vars.mobile) {
            Core.input.getTextInput(new Input.TextInput(){
                {
                    this.title = titleText.startsWith("@") ? Core.bundle.get(titleText.substring(1)) : titleText;
                    this.text = def;
                    this.numeric = inumeric;
                    this.maxLength = textLength;
                    this.accepted = confirmed;
                }
            });
        } else {
            new Dialog(titleText){
                {
                    super(title);
                    this.cont.margin(30.0f).add(dtext).padRight(6.0f);
                    TextField.TextFieldFilter filter = inumeric ? TextField.TextFieldFilter.digitsOnly : (f, c) -> true;
                    TextField field = this.cont.field(def, t -> {}).size(330.0f, 50.0f).get();
                    field.setFilter((f, c) -> field.getText().length() < textLength && filter.acceptChar(f, c));
                    this.buttons.defaults().size(120.0f, 54.0f).pad(4.0f);
                    this.buttons.button("@cancel", this::hide);
                    this.buttons.button("@ok", () -> {
                        confirmed.get(field.getText());
                        this.hide();
                    }).disabled(b -> field.getText().isEmpty());
                    this.keyDown(KeyCode.enter, () -> {
                        String text = field.getText();
                        if (!text.isEmpty()) {
                            confirmed.get(text);
                            this.hide();
                        }
                    });
                    this.keyDown(KeyCode.escape, this::hide);
                    this.keyDown(KeyCode.back, this::hide);
                    this.show();
                    Core.scene.setKeyboardFocus(field);
                    field.setCursorPosition(def.length());
                }
            };
        }
    }

    public void showTextInput(String title, String text, String def, Cons<String> confirmed) {
        this.showTextInput(title, text, 32, def, confirmed);
    }

    public void showTextInput(String titleText, String text, int textLength, String def, Cons<String> confirmed) {
        this.showTextInput(titleText, text, textLength, def, false, confirmed);
    }

    public void showInfoFade(String info) {
        Table table = new Table();
        table.touchable = Touchable.disabled;
        table.setFillParent(true);
        table.actions(Actions.fadeOut(7.0f, Interp.fade), Actions.remove());
        table.top().add(info).style(Styles.outlineLabel).padTop(10.0f);
        Core.scene.add(table);
    }

    public void showInfoToast(String info, float duration) {
        Table table = new Table();
        table.setFillParent(true);
        table.touchable = Touchable.disabled;
        table.update(() -> {
            if (Vars.state.isMenu()) {
                table.remove();
            }
        });
        table.actions(Actions.delay(duration * 0.9f), Actions.fadeOut(duration * 0.1f, Interp.fade), Actions.remove());
        table.top().table(Styles.black3, t -> t.margin(4.0f).add(info).style(Styles.outlineLabel)).padTop(10.0f);
        Core.scene.add(table);
    }

    public void showInfoPopup(String info, float duration, int align, int top, int left, int bottom, int right) {
        Table table = new Table();
        table.setFillParent(true);
        table.touchable = Touchable.disabled;
        table.update(() -> {
            if (Vars.state.isMenu()) {
                table.remove();
            }
        });
        table.actions(Actions.delay(duration), Actions.remove());
        table.align(align).table(Styles.black3, t -> t.margin(4.0f).add(info).style(Styles.outlineLabel)).pad(top, left, bottom, right);
        Core.scene.add(table);
    }

    public void showLabel(String info, float duration, float worldx, float worldy) {
        Table table = new Table(Styles.black3).margin(4.0f);
        table.touchable = Touchable.disabled;
        table.update(() -> {
            if (Vars.state.isMenu()) {
                table.remove();
            }
            Vec2 v = Core.camera.project(worldx, worldy);
            table.setPosition(v.x, v.y, 1);
        });
        table.actions(Actions.delay(duration), Actions.remove());
        table.add(info).style(Styles.outlineLabel);
        table.pack();
        table.act(0.0f);
        Core.scene.root.addChildAt(0, table);
        ((Element)table.getChildren().first()).act(0.0f);
    }

    public void showInfo(String info) {
        this.showInfo(info, () -> {});
    }

    public void showInfo(final String info, final Runnable listener) {
        new Dialog(""){
            {
                super(title);
                this.getCell(this.cont).growX();
                this.cont.margin(15.0f).add(info).width(400.0f).wrap().get().setAlignment(1, 1);
                this.buttons.button("@ok", () -> {
                    this.hide();
                    listener.run();
                }).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showInfoOnHidden(final String info, final Runnable listener) {
        new Dialog(""){
            {
                super(title);
                this.getCell(this.cont).growX();
                this.cont.margin(15.0f).add(info).width(400.0f).wrap().get().setAlignment(1, 1);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.hidden(listener);
                this.closeOnBack();
            }
        }.show();
    }

    public void showStartupInfo(final String info) {
        new Dialog(""){
            {
                super(title);
                this.getCell(this.cont).growX();
                this.cont.margin(15.0f).add(info).width(400.0f).wrap().get().setAlignment(8);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showErrorMessage(final String text) {
        new Dialog(""){
            {
                super(title);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                this.cont.add("@error.title");
                this.cont.row();
                this.cont.image().width(300.0f).pad(2.0f).height(4.0f).color(Color.scarlet);
                this.cont.row();
                this.cont.add(text).pad(2.0f).growX().wrap().get().setAlignment(1);
                this.cont.row();
                this.cont.button("@ok", this::hide).size(120.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showException(Throwable t) {
        this.showException("", t);
    }

    public void showException(final String text, final Throwable exc) {
        this.loadfrag.hide();
        new Dialog(""){
            {
                super(title);
                String message = Strings.getFinalMessage(exc);
                this.setFillParent(true);
                this.cont.margin(15.0f);
                this.cont.add("@error.title").colspan(2);
                this.cont.row();
                this.cont.image().width(300.0f).pad(2.0f).colspan(2).height(4.0f).color(Color.scarlet);
                this.cont.row();
                this.cont.add((text.startsWith("@") ? Core.bundle.get(text.substring(1)) : text) + (message == null ? "" : "\n[lightgray](" + message + ")")).colspan(2).wrap().growX().center().get().setAlignment(1);
                this.cont.row();
                Collapser col = new Collapser(base -> base.pane((Table t) -> t.margin(14.0f).add(Strings.neatError(exc)).color(Color.lightGray).left()), true);
                this.cont.button("@details", Styles.togglet, col::toggle).size(180.0f, 50.0f).checked(b -> !col.isCollapsed()).fillX().right();
                this.cont.button("@ok", this::hide).size(110.0f, 50.0f).fillX().left();
                this.cont.row();
                this.cont.add(col).colspan(2).pad(2.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showText(String titleText, String text) {
        this.showText(titleText, text, 1);
    }

    public void showText(String titleText, final String text, final int align) {
        new Dialog(titleText){
            {
                super(title);
                this.cont.row();
                this.cont.image().width(400.0f).pad(2.0f).colspan(2).height(4.0f).color(Pal.accent);
                this.cont.row();
                this.cont.add(text).width(400.0f).wrap().get().setAlignment(align, align);
                this.cont.row();
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showInfoText(String titleText, final String text) {
        new Dialog(titleText){
            {
                super(title);
                this.cont.margin(15.0f).add(text).width(400.0f).wrap().left().get().setAlignment(8, 8);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showSmall(String titleText, final String text) {
        new Dialog(titleText){
            {
                super(title);
                this.cont.margin(10.0f).add(text);
                this.titleTable.row();
                this.titleTable.image().color(Pal.accent).height(3.0f).growX().pad(2.0f);
                this.buttons.button("@ok", this::hide).size(110.0f, 50.0f).pad(4.0f);
                this.closeOnBack();
            }
        }.show();
    }

    public void showConfirm(String title, String text, Runnable confirmed) {
        this.showConfirm(title, text, null, confirmed);
    }

    public void showConfirm(String title, String text, Boolp hide, Runnable confirmed) {
        BaseDialog dialog = new BaseDialog(title);
        dialog.cont.add(text).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.button("@cancel", dialog::hide);
        dialog.buttons.button("@ok", () -> {
            dialog.hide();
            confirmed.run();
        });
        if (hide != null) {
            dialog.update(() -> {
                if (hide.get()) {
                    dialog.hide();
                }
            });
        }
        dialog.keyDown(KeyCode.enter, () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.keyDown(KeyCode.escape, dialog::hide);
        dialog.keyDown(KeyCode.back, dialog::hide);
        dialog.show();
    }

    public void showCustomConfirm(String title, String text, String yes, String no, Runnable confirmed, Runnable denied) {
        BaseDialog dialog = new BaseDialog(title);
        dialog.cont.add(text).width(Vars.mobile ? 400.0f : 500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.button(no, () -> {
            dialog.hide();
            denied.run();
        });
        dialog.buttons.button(yes, () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.keyDown(KeyCode.escape, dialog::hide);
        dialog.keyDown(KeyCode.back, dialog::hide);
        dialog.show();
    }

    public void announce(String text) {
        this.announce(text, 3.0f);
    }

    public void announce(String text, float duration) {
        Table t = new Table(Styles.black3);
        t.touchable = Touchable.disabled;
        t.margin(8.0f).add(text).style(Styles.outlineLabel).labelAlign(1);
        t.update(() -> t.setPosition((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 2.0f, 1));
        t.actions(Actions.fadeOut(duration, Interp.pow4In), Actions.remove());
        t.pack();
        t.act(0.1f);
        Core.scene.add(t);
    }

    public void showOkText(String title, String text, Runnable confirmed) {
        BaseDialog dialog = new BaseDialog(title);
        dialog.cont.add(text).width(500.0f).wrap().pad(4.0f).get().setAlignment(1, 1);
        dialog.buttons.defaults().size(200.0f, 54.0f).pad(2.0f);
        dialog.setFillParent(false);
        dialog.buttons.button("@ok", () -> {
            dialog.hide();
            confirmed.run();
        });
        dialog.show();
    }

    public static String formatAmount(int number) {
        int mag = Math.abs(number);
        if (mag >= 1000000000) {
            return Strings.fixed((float)number / 1.0E9f, 1) + "[gray]" + Core.bundle.get("unit.billions") + "[]";
        }
        if (mag >= 1000000) {
            return Strings.fixed((float)number / 1000000.0f, 1) + "[gray]" + Core.bundle.get("unit.millions") + "[]";
        }
        if (mag >= 10000) {
            return number / 1000 + "[gray]" + Core.bundle.get("unit.thousands") + "[]";
        }
        if (mag >= 1000) {
            return Strings.fixed((float)number / 1000.0f, 1) + "[gray]" + Core.bundle.get("unit.thousands") + "[]";
        }
        return number + "";
    }

    public static int roundAmount(int number) {
        if (number >= 1000000000) {
            return Mathf.round(number, 100000000);
        }
        if (number >= 1000000) {
            return Mathf.round(number, 100000);
        }
        if (number >= 10000) {
            return Mathf.round(number, 1000);
        }
        if (number >= 1000) {
            return Mathf.round(number, 100);
        }
        if (number >= 100) {
            return Mathf.round(number, 100);
        }
        if (number >= 10) {
            return Mathf.round(number, 10);
        }
        return number;
    }
}

