/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Tmp;
import arc.util.noise.Noise;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.Liquids;
import mindustry.content.Weathers;
import mindustry.core.GameState;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.Rules;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.maps.MapException;
import mindustry.maps.filters.GenerateFilter;
import mindustry.type.Liquid;
import mindustry.type.Sector;
import mindustry.type.Weather;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.WorldContext;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.legacy.LegacyBlock;

public class World {
    public final Context context = new Context();
    public Tiles tiles = new Tiles(0, 0);
    private boolean generating;
    private boolean invalidMap;
    private ObjectMap<Map, Runnable> customMapLoaders = new ObjectMap();

    public void addMapLoader(Map map, Runnable loader) {
        this.customMapLoaders.put(map, loader);
    }

    public boolean isInvalidMap() {
        return this.invalidMap;
    }

    public boolean solid(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile == null || tile.solid();
    }

    public boolean passable(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile != null && tile.passable();
    }

    public boolean wallSolid(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile == null || tile.block().solid;
    }

    public boolean wallSolidFull(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile == null || tile.block().solid && tile.block().fillsTile;
    }

    public boolean isAccessible(int x, int y) {
        return !this.wallSolid(x, y - 1) || !this.wallSolid(x, y + 1) || !this.wallSolid(x - 1, y) || !this.wallSolid(x + 1, y);
    }

    public int width() {
        return this.tiles.width;
    }

    public int height() {
        return this.tiles.height;
    }

    public int unitWidth() {
        return this.width() * 8;
    }

    public int unitHeight() {
        return this.height() * 8;
    }

    public Floor floor(int x, int y) {
        Tile tile = this.tile(x, y);
        return tile == null ? Blocks.air.asFloor() : tile.floor();
    }

    public Floor floorWorld(float x, float y) {
        Tile tile = this.tileWorld(x, y);
        return tile == null ? Blocks.air.asFloor() : tile.floor();
    }

    @Nullable
    public Tile tile(int pos) {
        return this.tile(Point2.x(pos), Point2.y(pos));
    }

    @Nullable
    public Tile tile(int x, int y) {
        return this.tiles.get(x, y);
    }

    @Nullable
    public Tile tileBuilding(int x, int y) {
        Tile tile = this.tiles.get(x, y);
        if (tile == null) {
            return null;
        }
        if (tile.build != null) {
            return tile.build.tile();
        }
        return tile;
    }

    @Nullable
    public Building build(int x, int y) {
        Tile tile = this.tile(x, y);
        if (tile == null) {
            return null;
        }
        return tile.build;
    }

    @Nullable
    public Building build(int pos) {
        Tile tile = this.tile(pos);
        if (tile == null) {
            return null;
        }
        return tile.build;
    }

    public Tile rawTile(int x, int y) {
        return this.tiles.getn(x, y);
    }

    @Nullable
    public Tile tileWorld(float x, float y) {
        return this.tile(Math.round(x / 8.0f), Math.round(y / 8.0f));
    }

    @Nullable
    public Building buildWorld(float x, float y) {
        return this.build(Math.round(x / 8.0f), Math.round(y / 8.0f));
    }

    public static float conv(float coord) {
        return coord / 8.0f;
    }

    public static float unconv(float coord) {
        return coord * 8.0f;
    }

    public static int toTile(float coord) {
        return Math.round(coord / 8.0f);
    }

    private void clearTileEntities() {
        for (Tile tile : this.tiles) {
            if (tile == null || tile.build == null) continue;
            tile.build.remove();
        }
    }

    public Tiles resize(int width, int height) {
        this.clearTileEntities();
        if (this.tiles.width != width || this.tiles.height != height) {
            this.tiles = new Tiles(width, height);
        }
        return this.tiles;
    }

    public void beginMapLoad() {
        this.generating = true;
    }

    public void endMapLoad() {
        for (Tile tile : this.tiles) {
            LegacyBlock l;
            Block block = tile.block();
            if (block instanceof LegacyBlock && (l = (LegacyBlock)block) == (LegacyBlock)block) {
                l.removeSelf(tile);
                continue;
            }
            if (tile.build == null) continue;
            tile.build.updateProximity();
        }
        this.addDarkness(this.tiles);
        Groups.resize(-500.0f, -500.0f, (float)(this.tiles.width * 8) + 1000.0f, (float)(this.tiles.height * 8) + 1000.0f);
        this.generating = false;
        Events.fire(new EventType.WorldLoadEvent());
    }

    public Rect getQuadBounds(Rect in) {
        return in.set(-500.0f, -500.0f, (float)(Vars.world.width() * 8) + 1000.0f, (float)(Vars.world.height() * 8) + 1000.0f);
    }

    public void setGenerating(boolean gen) {
        this.generating = gen;
    }

    public boolean isGenerating() {
        return this.generating;
    }

    public void loadGenerator(int width, int height, Cons<Tiles> generator) {
        this.beginMapLoad();
        this.resize(width, height);
        generator.get(this.tiles);
        this.endMapLoad();
    }

    public void loadSector(Sector sector) {
        this.setSectorRules(sector);
        int size = sector.getSize();
        this.loadGenerator(size, size, tiles -> {
            if (sector.preset != null) {
                sector.preset.generator.generate((Tiles)tiles);
                sector.preset.rules.get(Vars.state.rules);
            } else {
                sector.planet.generator.generate((Tiles)tiles, sector);
            }
            Vars.state.rules.sector = sector;
        });
        if (sector.preset == null) {
            sector.planet.generator.postGenerate(this.tiles);
        }
        this.setSectorRules(sector);
        if (Vars.state.rules.defaultTeam.core() != null) {
            sector.info.spawnPosition = Vars.state.rules.defaultTeam.core().pos();
        }
    }

    private void setSectorRules(Sector sector) {
        boolean hasSpores;
        Vars.state.map = new Map(StringMap.of("name", sector.preset == null ? sector.planet.localizedName + "; Sector " + sector.id : sector.preset.localizedName));
        Vars.state.rules.sector = sector;
        Vars.state.rules.weather.clear();
        ObjectIntMap<Floor> floorc = new ObjectIntMap<Floor>();
        ObjectSet<UnlockableContent> content = new ObjectSet<UnlockableContent>();
        for (Tile tile : Vars.world.tiles) {
            if (Vars.world.getDarkness(tile.x, tile.y) >= 3.0f) continue;
            Liquid liquid = tile.floor().liquidDrop;
            if (tile.floor().itemDrop != null) {
                content.add(tile.floor().itemDrop);
            }
            if (tile.overlay().itemDrop != null) {
                content.add(tile.overlay().itemDrop);
            }
            if (liquid != null) {
                content.add(liquid);
            }
            if (tile.block().isStatic()) continue;
            floorc.increment(tile.floor());
            if (tile.overlay() == Blocks.air) continue;
            floorc.increment(tile.overlay());
        }
        Seq entries = floorc.entries().toArray();
        entries.sort(e -> -e.value);
        entries.removeAll(e -> e.value < 30);
        Block[] floors = new Block[entries.size];
        for (int i = 0; i < entries.size; ++i) {
            floors[i] = (Block)entries.get((int)i).key;
        }
        boolean hasSnow = floors[0].name.contains("ice") || floors[0].name.contains("snow");
        boolean hasRain = !hasSnow && content.contains(Liquids.water) && !floors[0].name.contains("sand");
        boolean hasDesert = !hasSnow && !hasRain && floors[0] == Blocks.sand;
        boolean bl = hasSpores = floors[0].name.contains("spore") || floors[0].name.contains("moss") || floors[0].name.contains("tainted");
        if (hasSnow) {
            Vars.state.rules.weather.add(new Weather.WeatherEntry(Weathers.snow));
        }
        if (hasRain) {
            Vars.state.rules.weather.add(new Weather.WeatherEntry(Weathers.rain));
            Vars.state.rules.weather.add(new Weather.WeatherEntry(Weathers.fog));
        }
        if (hasDesert) {
            Vars.state.rules.weather.add(new Weather.WeatherEntry(Weathers.sandstorm));
        }
        if (hasSpores) {
            Vars.state.rules.weather.add(new Weather.WeatherEntry(Weathers.sporestorm));
        }
        sector.info.resources = content.asArray();
        sector.info.resources.sort(Structs.comps(Structs.comparing(Content::getContentType), Structs.comparingInt(c -> c.id)));
        sector.saveInfo();
    }

    public Context filterContext(Map map) {
        return new FilterContext(map);
    }

    public void loadMap(Map map) {
        this.loadMap(map, new Rules());
    }

    public void loadMap(Map map, Rules checkRules) {
        if (this.customMapLoaders.containsKey(map)) {
            this.customMapLoaders.get(map).run();
            return;
        }
        try {
            SaveIO.load(map.file, (WorldContext)new FilterContext(map));
        }
        catch (Throwable e) {
            Log.err(e);
            if (!Vars.headless) {
                Vars.ui.showErrorMessage("@map.invalid");
                Core.app.post(() -> Vars.state.set(GameState.State.menu));
                this.invalidMap = true;
            }
            this.generating = false;
            return;
        }
        Vars.state.map = map;
        this.invalidMap = false;
        if (!Vars.headless) {
            if (Vars.state.teams.playerCores().size == 0 && !checkRules.pvp) {
                Vars.ui.showErrorMessage("@map.nospawn");
                this.invalidMap = true;
            } else if (checkRules.pvp) {
                if (Vars.state.teams.getActive().count(Teams.TeamData::hasCore) < 2) {
                    this.invalidMap = true;
                    Vars.ui.showErrorMessage("@map.nospawn.pvp");
                }
            } else if (checkRules.attackMode) {
                this.invalidMap = Vars.state.teams.get(Vars.state.rules.waveTeam).noCores();
                if (this.invalidMap) {
                    Vars.ui.showErrorMessage("@map.nospawn.attack");
                }
            }
        } else {
            boolean bl = this.invalidMap = !Vars.state.teams.getActive().contains((Teams.TeamData)((Object)((Boolf<Teams.TeamData>)Teams.TeamData::hasCore)));
            if (this.invalidMap) {
                throw new MapException(map, "Map has no cores!");
            }
        }
        if (this.invalidMap) {
            Core.app.post(() -> Vars.state.set(GameState.State.menu));
        }
    }

    public void notifyChanged(Tile tile) {
        if (!this.generating) {
            Core.app.post(() -> Events.fire(new EventType.TileChangeEvent(tile)));
        }
    }

    public void raycastEachWorld(float x0, float y0, float x1, float y1, Geometry.Raycaster cons) {
        this.raycastEach(World.toTile(x0), World.toTile(y0), World.toTile(x1), World.toTile(y1), cons);
    }

    public void raycastEach(int x0f, int y0f, int x1, int y1, Geometry.Raycaster cons) {
        int x0 = x0f;
        int y0 = y0f;
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (!(cons.accept(x0, y0) || x0 == x1 && y0 == y1)) {
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    public boolean raycast(int x0f, int y0f, int x1, int y1, Geometry.Raycaster cons) {
        int x0 = x0f;
        int y0 = y0f;
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx - dy;
        while (!cons.accept(x0, y0)) {
            if (x0 == x1 && y0 == y1) {
                return false;
            }
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x0 += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y0 += sy;
        }
        return true;
    }

    public void addDarkness(Tiles tiles) {
        int i;
        byte[] dark = new byte[tiles.width * tiles.height];
        byte[] writeBuffer = new byte[tiles.width * tiles.height];
        int darkIterations = 4;
        for (i = 0; i < dark.length; ++i) {
            Object tile = tiles.geti(i);
            if (!((Tile)tile).isDarkened()) continue;
            dark[i] = darkIterations;
        }
        for (i = 0; i < darkIterations; ++i) {
            for (Tile tile : tiles) {
                int idx = tile.y * tiles.width + tile.x;
                boolean min = false;
                Point2[] point2Array = Geometry.d4;
                int n = point2Array.length;
                for (int j = 0; j < n; ++j) {
                    Point2 point = point2Array[j];
                    int newX = tile.x + point.x;
                    int newY = tile.y + point.y;
                    int nidx = newY * tiles.width + newX;
                    if (!tiles.in(newX, newY) || dark[nidx] >= dark[idx]) continue;
                    min = true;
                    break;
                }
                writeBuffer[idx] = (byte)Math.max(0, dark[idx] - Mathf.num(min));
            }
            System.arraycopy(writeBuffer, 0, dark, 0, writeBuffer.length);
        }
        for (Object tile : tiles) {
            int idx = ((Tile)tile).y * tiles.width + ((Tile)tile).x;
            if (((Tile)tile).isDarkened()) {
                ((Tile)tile).data = dark[idx];
            }
            if (dark[idx] != 4) continue;
            boolean full = true;
            for (Point2 p : Geometry.d4) {
                int px = p.x + ((Tile)tile).x;
                int py = p.y + ((Tile)tile).y;
                int nidx = py * tiles.width + px;
                if (!tiles.in(px, py) || ((Tile)tile).isDarkened() && dark[nidx] == 4) continue;
                full = false;
                break;
            }
            if (!full) continue;
            ((Tile)tile).data = (byte)5;
        }
    }

    public float getDarkness(int x, int y) {
        Tile tile;
        int edgeBlend = 2;
        float dark = 0.0f;
        int edgeDst = Math.min(x, Math.min(y, Math.min(Math.abs(x - (this.tiles.width - 1)), Math.abs(y - (this.tiles.height - 1)))));
        if (edgeDst <= edgeBlend) {
            dark = Math.max((float)(edgeBlend - edgeDst) * (4.0f / (float)edgeBlend), dark);
        }
        if (Vars.state.hasSector() && Vars.state.getSector().preset == null) {
            int circleBlend = 14;
            float offset = Vars.state.getSector().rect.rotation + 90.0f;
            float angle = Angles.angle(x, y, this.tiles.width / 2, this.tiles.height / 2) + offset;
            int sides = Vars.state.getSector().tile.corners.length;
            float step = 360.0f / (float)sides;
            float prev = Mathf.round(angle, step);
            float next = prev + step;
            float length = (float)Vars.state.getSector().getSize() / 2.0f;
            float rawDst = Intersector.distanceLinePoint(Tmp.v1.trns(prev, length), Tmp.v2.trns(next, length), Tmp.v3.set(x - this.tiles.width / 2, y - this.tiles.height / 2).rotate(offset)) / Mathf.sqrt3 - 1.0f;
            int circleDst = (int)((rawDst += Noise.noise(x, y, 11.0f, 7.0f) + Noise.noise(x, y, 22.0f, 15.0f)) - (length - (float)circleBlend));
            if (circleDst > 0) {
                dark = Math.max((float)circleDst, dark);
            }
        }
        if ((tile = Vars.world.tile(x, y)) != null && tile.block().solid && tile.block().fillsTile && !tile.block().synthetic()) {
            dark = Math.max(dark, (float)tile.data);
        }
        return dark;
    }

    private class Context
    implements WorldContext {
        Context() {
        }

        @Override
        public Tile tile(int index) {
            return World.this.tiles.geti(index);
        }

        @Override
        public void resize(int width, int height) {
            World.this.resize(width, height);
        }

        @Override
        public Tile create(int x, int y, int floorID, int overlayID, int wallID) {
            Tile tile = new Tile(x, y, floorID, overlayID, wallID);
            World.this.tiles.set(x, y, tile);
            return tile;
        }

        @Override
        public boolean isGenerating() {
            return World.this.isGenerating();
        }

        @Override
        public void begin() {
            World.this.beginMapLoad();
        }

        @Override
        public void end() {
            World.this.endMapLoad();
        }
    }

    private class FilterContext
    extends Context {
        final Map map;

        FilterContext(Map map) {
            this.map = map;
        }

        @Override
        public void end() {
            Seq<GenerateFilter> filters = this.map.filters();
            if (!filters.isEmpty()) {
                GenerateFilter.GenerateInput input = new GenerateFilter.GenerateInput();
                for (GenerateFilter filter : filters) {
                    filter.randomize();
                    input.begin(filter, World.this.width(), World.this.height(), (x, y) -> World.this.tiles.getn(x, y));
                    filter.apply(World.this.tiles, input);
                }
            }
            super.end();
        }
    }
}

