/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ctype;

import arc.files.Fi;
import arc.util.Disposable;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.ctype.ContentType;
import mindustry.mod.Mods;

public abstract class Content
implements Comparable<Content>,
Disposable {
    public final short id;
    public ModContentInfo minfo = new ModContentInfo();

    public Content() {
        this.id = (short)Vars.content.getBy((ContentType)this.getContentType()).size;
        Vars.content.handleContent(this);
    }

    public abstract ContentType getContentType();

    public void init() {
    }

    public void load() {
    }

    public boolean hasErrored() {
        return this.minfo.error != null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public int compareTo(Content c) {
        return Integer.compare(this.id, c.id);
    }

    public String toString() {
        return this.getContentType().name() + "#" + this.id;
    }

    public static class ModContentInfo {
        @Nullable
        public Mods.LoadedMod mod;
        @Nullable
        public Fi sourceFile;
        @Nullable
        public String error;
        @Nullable
        public Throwable baseError;
    }
}

