/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ctype;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.TechTree;
import mindustry.ctype.MappableContent;
import mindustry.game.EventType;
import mindustry.graphics.MultiPacker;
import mindustry.type.ItemStack;
import mindustry.ui.Cicon;
import mindustry.ui.Fonts;
import mindustry.world.meta.Stats;

public abstract class UnlockableContent
extends MappableContent {
    public Stats stats = new Stats();
    public String localizedName;
    @Nullable
    public String description;
    @Nullable
    public String details;
    public boolean alwaysUnlocked = false;
    public boolean inlineDescription = true;
    public int iconId = 0;
    protected TextureRegion[] cicons = new TextureRegion[Cicon.all.length];
    protected boolean unlocked;

    public UnlockableContent(String name) {
        super(name);
        this.localizedName = Core.bundle.get((Object)((Object)this.getContentType()) + "." + this.name + ".name", this.name);
        this.description = Core.bundle.getOrNull((Object)((Object)this.getContentType()) + "." + this.name + ".description");
        this.details = Core.bundle.getOrNull((Object)((Object)this.getContentType()) + "." + this.name + ".details");
        this.unlocked = Core.settings != null && Core.settings.getBool(this.name + "-unlocked", false);
    }

    @Nullable
    public TechTree.TechNode node() {
        return TechTree.get(this);
    }

    public String displayDescription() {
        return this.minfo.mod == null ? this.description : this.description + "\n" + Core.bundle.format("mod.display", this.minfo.mod.meta.displayName());
    }

    public void checkStats() {
        if (!this.stats.intialized) {
            this.setStats();
            this.stats.intialized = true;
        }
    }

    public void setStats() {
    }

    public void createIcons(MultiPacker packer) {
    }

    public ItemStack[] researchRequirements() {
        return ItemStack.empty;
    }

    public String emoji() {
        return Fonts.getUnicodeStr(this.name);
    }

    public TextureRegion icon(Cicon icon) {
        if (this.cicons[icon.ordinal()] == null) {
            this.cicons[icon.ordinal()] = Core.atlas.find(this.getContentType().name() + "-" + this.name + "-" + icon.name(), Core.atlas.find(this.getContentType().name() + "-" + this.name + "-full", Core.atlas.find(this.name + "-" + icon.name(), Core.atlas.find(this.name + "-full", Core.atlas.find(this.name, Core.atlas.find(this.getContentType().name() + "-" + this.name, Core.atlas.find(this.name + "1")))))));
        }
        return this.cicons[icon.ordinal()];
    }

    public Cicon prefDatabaseIcon() {
        return Cicon.xlarge;
    }

    public void getDependencies(Cons<UnlockableContent> cons) {
    }

    public void display(Table table) {
    }

    public void onUnlock() {
    }

    public boolean isHidden() {
        return false;
    }

    public boolean showUnlock() {
        return true;
    }

    public void unlock() {
        if (!this.unlocked && !this.alwaysUnlocked) {
            this.unlocked = true;
            Core.settings.put(this.name + "-unlocked", true);
            this.onUnlock();
            Events.fire(new EventType.UnlockEvent(this));
        }
    }

    public void quietUnlock() {
        if (!this.unlocked()) {
            this.unlocked = true;
            Core.settings.put(this.name + "-unlocked", true);
        }
    }

    public boolean unlocked() {
        if (Vars.net != null && Vars.net.client()) {
            return this.unlocked || this.alwaysUnlocked || Vars.state.rules.researched.contains(this.name);
        }
        return this.unlocked || this.alwaysUnlocked;
    }

    public void clearUnlock() {
        if (this.unlocked) {
            this.unlocked = false;
            Core.settings.put(this.name + "-unlocked", false);
        }
    }

    public boolean unlockedNow() {
        return this.unlocked() || !Vars.state.isCampaign();
    }

    public boolean locked() {
        return !this.unlocked();
    }
}

