/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.func.Prov;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.editor.DrawOperation;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.TileOp;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.modules.ConsumeModule;
import mindustry.world.modules.ItemModule;
import mindustry.world.modules.LiquidModule;
import mindustry.world.modules.PowerModule;

public class EditorTile
extends Tile {
    public EditorTile(int x, int y, int floor, int overlay, int wall) {
        super(x, y, floor, overlay, wall);
    }

    @Override
    public void setFloor(Floor type) {
        if (this.skip()) {
            super.setFloor(type);
            return;
        }
        if (type instanceof OverlayFloor) {
            if (this.floor.hasSurface() || !type.needsSurface) {
                this.setOverlayID(type.id);
            }
            return;
        }
        if (this.floor == type && this.overlayID() == 0) {
            return;
        }
        if (this.overlayID() != 0) {
            this.op(DrawOperation.OpType.overlay, this.overlayID());
        }
        if (this.floor != type) {
            this.op(DrawOperation.OpType.floor, this.floor.id);
        }
        super.setFloor(type);
    }

    @Override
    public void setBlock(Block type, Team team, int rotation) {
        if (this.skip()) {
            super.setBlock(type, team, rotation);
            return;
        }
        if (this.block == type && (this.build == null || this.build.rotation == rotation)) {
            this.update();
            return;
        }
        if (!this.isCenter()) {
            EditorTile cen = (EditorTile)this.build.tile;
            cen.op(DrawOperation.OpType.rotation, (byte)this.build.rotation);
            cen.op(DrawOperation.OpType.team, (byte)this.build.team.id);
            cen.op(DrawOperation.OpType.block, this.block.id);
            this.update();
        } else {
            if (this.build != null) {
                this.op(DrawOperation.OpType.rotation, (byte)this.build.rotation);
            }
            if (this.build != null) {
                this.op(DrawOperation.OpType.team, (byte)this.build.team.id);
            }
            this.op(DrawOperation.OpType.block, this.block.id);
        }
        super.setBlock(type, team, rotation);
    }

    @Override
    public void setTeam(Team team) {
        if (this.skip()) {
            super.setTeam(team);
            return;
        }
        if (this.getTeamID() == team.id) {
            return;
        }
        this.op(DrawOperation.OpType.team, (byte)this.getTeamID());
        super.setTeam(team);
        this.getLinkedTiles((Tile t) -> Vars.ui.editor.editor.renderer.updatePoint(t.x, t.y));
    }

    @Override
    public void setOverlay(Block overlay) {
        if (this.skip()) {
            super.setOverlay(overlay);
            return;
        }
        if (!this.floor.hasSurface() && overlay.asFloor().needsSurface) {
            return;
        }
        if (this.overlay() == overlay) {
            return;
        }
        this.op(DrawOperation.OpType.overlay, this.overlay.id);
        super.setOverlay(overlay);
    }

    @Override
    protected void fireChanged() {
        if (this.skip()) {
            super.fireChanged();
        } else {
            this.update();
        }
    }

    @Override
    public void recache() {
        if (this.skip()) {
            super.recache();
        }
    }

    @Override
    protected void changed() {
        if (Vars.state.isGame()) {
            super.changed();
        }
    }

    @Override
    protected void changeBuild(Team team, Prov<Building> entityprov, int rotation) {
        Block block;
        if (this.skip()) {
            super.changeBuild(team, entityprov, rotation);
            return;
        }
        this.build = null;
        if (this.block == null) {
            this.block = Blocks.air;
        }
        if (this.floor == null) {
            this.floor = (Floor)Blocks.air;
        }
        if ((block = this.block()).hasBuilding()) {
            this.build = entityprov.get().init(this, team, false, rotation);
            this.build.cons = new ConsumeModule(this.build);
            if (block.hasItems) {
                this.build.items = new ItemModule();
            }
            if (block.hasLiquids) {
                this.build.liquids(new LiquidModule());
            }
            if (block.hasPower) {
                this.build.power(new PowerModule());
            }
        }
    }

    private void update() {
        Vars.ui.editor.editor.renderer.updatePoint(this.x, this.y);
    }

    private boolean skip() {
        return Vars.state.isGame() || Vars.ui.editor.editor.isLoading();
    }

    private void op(DrawOperation.OpType type, short value) {
        Vars.ui.editor.editor.addTileOp(TileOp.get(this.x, this.y, (byte)type.ordinal(), value));
    }
}

