/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.func.Boolf;
import arc.func.Cons;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Bresenham2;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.util.Structs;
import mindustry.content.Blocks;
import mindustry.editor.MapEditor;
import mindustry.game.Team;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public enum EditorTool {
    zoom(KeyCode.v),
    pick(KeyCode.i){

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (!Structs.inBounds(x, y, editor.width(), editor.height())) {
                return;
            }
            Tile tile = editor.tile(x, y);
            editor.drawBlock = tile.block() == Blocks.air || !tile.block().inEditor ? (tile.overlay() == Blocks.air ? tile.floor() : tile.overlay()) : tile.block();
        }
    }
    ,
    line(KeyCode.l, new String[]{"replace", "orthogonal"}){

        @Override
        public void touchedLine(MapEditor editor, int x1, int y1, int x2, int y2) {
            if (this.mode == 1) {
                if (Math.abs(x2 - x1) > Math.abs(y2 - y1)) {
                    y2 = y1;
                } else {
                    x2 = x1;
                }
            }
            Bresenham2.line(x1, y1, x2, y2, (x, y) -> {
                if (this.mode == 0) {
                    editor.drawBlocksReplace(x, y);
                } else {
                    editor.drawBlocks(x, y);
                }
            });
        }
    }
    ,
    pencil(KeyCode.b, new String[]{"replace", "square", "drawteams"}){
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (this.mode == -1) {
                editor.drawBlocks(x, y);
            } else if (this.mode == 0) {
                editor.drawBlocksReplace(x, y);
            } else if (this.mode == 1) {
                editor.drawBlocks(x, y, true, tile -> true);
            } else if (this.mode == 2) {
                editor.drawCircle(x, y, tile -> tile.setTeam(editor.drawTeam));
            }
        }
    }
    ,
    eraser(KeyCode.e, new String[]{"eraseores"}){
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            editor.drawCircle(x, y, tile -> {
                if (this.mode == -1) {
                    tile.remove();
                } else if (this.mode == 0) {
                    tile.clearOverlay();
                }
            });
        }
    }
    ,
    fill(KeyCode.g, new String[]{"replaceall", "fillteams"}){
        IntSeq stack;
        {
            this.edit = true;
            this.stack = new IntSeq();
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (!Structs.inBounds(x, y, editor.width(), editor.height())) {
                return;
            }
            Tile tile = editor.tile(x, y);
            if (editor.drawBlock.isMultiblock()) {
                pencil.touched(editor, x, y);
                return;
            }
            if (this.mode == 0 || this.mode == -1) {
                Cons<Tile> setter;
                Boolf<Tile> tester;
                if (tile.block().isMultiblock()) {
                    return;
                }
                if (editor.drawBlock.isOverlay()) {
                    Floor dest = tile.overlay();
                    if (dest == editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.overlay() == dest && (t.floor().hasSurface() || !t.floor().needsSurface);
                    setter = t -> t.setOverlay(editor.drawBlock);
                } else if (editor.drawBlock.isFloor()) {
                    Floor dest = tile.floor();
                    if (dest == editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.floor() == dest;
                    setter = t -> t.setFloorUnder(editor.drawBlock.asFloor());
                } else {
                    Block dest = tile.block();
                    if (dest == editor.drawBlock) {
                        return;
                    }
                    tester = t -> t.block() == dest;
                    setter = t -> t.setBlock(editor.drawBlock, editor.drawTeam);
                }
                this.fill(editor, x, y, this.mode == 0, tester, setter);
            } else if (this.mode == 1 && tile.synthetic()) {
                Team dest = tile.team();
                if (dest == editor.drawTeam) {
                    return;
                }
                this.fill(editor, x, y, false, t -> t.getTeamID() == dest.id && t.synthetic(), t -> t.setTeam(editor.drawTeam));
            }
        }

        void fill(MapEditor editor, int x, int y, boolean replace, Boolf<Tile> tester, Cons<Tile> filler) {
            int width = editor.width();
            int height = editor.height();
            if (replace) {
                for (int cx = 0; cx < width; ++cx) {
                    for (int cy = 0; cy < height; ++cy) {
                        Tile tile = editor.tile(cx, cy);
                        if (!tester.get(tile)) continue;
                        filler.get(tile);
                    }
                }
            } else {
                this.stack.clear();
                this.stack.add(Point2.pack(x, y));
                try {
                    while (this.stack.size > 0 && this.stack.size < width * height) {
                        int x1;
                        int popped = this.stack.pop();
                        x = Point2.x(popped);
                        y = Point2.y(popped);
                        for (x1 = x; x1 >= 0 && tester.get(editor.tile(x1, y)); --x1) {
                        }
                        ++x1;
                        boolean spanAbove = false;
                        boolean spanBelow = false;
                        while (x1 < width && tester.get(editor.tile(x1, y))) {
                            filler.get(editor.tile(x1, y));
                            if (!spanAbove && y > 0 && tester.get(editor.tile(x1, y - 1))) {
                                this.stack.add(Point2.pack(x1, y - 1));
                                spanAbove = true;
                            } else if (spanAbove && !tester.get(editor.tile(x1, y - 1))) {
                                spanAbove = false;
                            }
                            if (!spanBelow && y < height - 1 && tester.get(editor.tile(x1, y + 1))) {
                                this.stack.add(Point2.pack(x1, y + 1));
                                spanBelow = true;
                            } else if (spanBelow && y < height - 1 && !tester.get(editor.tile(x1, y + 1))) {
                                spanBelow = false;
                            }
                            ++x1;
                        }
                    }
                    this.stack.clear();
                }
                catch (OutOfMemoryError e) {
                    this.stack = null;
                    System.gc();
                    e.printStackTrace();
                    this.stack = new IntSeq();
                }
            }
        }
    }
    ,
    spray(KeyCode.r, new String[]{"replace"}){
        final double chance = 0.012;
        {
            this.edit = true;
            this.draggable = true;
        }

        @Override
        public void touched(MapEditor editor, int x, int y) {
            if (editor.drawBlock.isFloor()) {
                editor.drawCircle(x, y, tile -> {
                    if (Mathf.chance(0.012)) {
                        tile.setFloor(editor.drawBlock.asFloor());
                    }
                });
            } else if (this.mode == 0) {
                editor.drawBlocks(x, y, tile -> Mathf.chance(0.012) && tile.block() != Blocks.air);
            } else {
                editor.drawBlocks(x, y, tile -> Mathf.chance(0.012));
            }
        }
    };

    public static final EditorTool[] all;
    public final String[] altModes;
    public KeyCode key = KeyCode.unset;
    public int mode = -1;
    public boolean edit;
    public boolean draggable;

    private EditorTool() {
        this(new String[0]);
    }

    private EditorTool(KeyCode code) {
        this(new String[0]);
        this.key = code;
    }

    private EditorTool(String ... altModes) {
        this.altModes = altModes;
    }

    private EditorTool(KeyCode code, String ... altModes) {
        this.altModes = altModes;
        this.key = code;
    }

    public void touched(MapEditor editor, int x, int y) {
    }

    public void touchedLine(MapEditor editor, int x1, int y1, int x2, int y2) {
    }

    static {
        all = EditorTool.values();
    }
}

