/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Pixmap;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.struct.StringMap;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.editor.DrawOperation;
import mindustry.editor.EditorTile;
import mindustry.editor.MapRenderer;
import mindustry.editor.OperationStack;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.TileOp;
import mindustry.io.MapIO;
import mindustry.maps.Map;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.WorldContext;

public class MapEditor {
    public static final int[] brushSizes = new int[]{1, 2, 3, 4, 5, 9, 15, 20};
    public StringMap tags = new StringMap();
    public MapRenderer renderer = new MapRenderer(this);
    private final Context context = new Context();
    private OperationStack stack = new OperationStack();
    private DrawOperation currentOp;
    private boolean loading;
    public int brushSize = 1;
    public int rotation;
    public Block drawBlock = Blocks.stone;
    public Team drawTeam = Team.sharded;

    public boolean isLoading() {
        return this.loading;
    }

    public void beginEdit(int width, int height) {
        this.reset();
        this.loading = true;
        this.createTiles(width, height);
        this.renderer.resize(width, height);
        this.loading = false;
    }

    public void beginEdit(Map map) {
        this.reset();
        this.loading = true;
        this.tags.putAll(map.tags);
        if (map.file.parent().parent().name().equals("1127400") && Vars.steam) {
            this.tags.put("steamid", map.file.parent().name());
        }
        this.load(() -> MapIO.loadMap(map, this.context));
        this.renderer.resize(this.width(), this.height());
        this.loading = false;
    }

    public void beginEdit(Pixmap pixmap) {
        this.reset();
        this.createTiles(pixmap.getWidth(), pixmap.getHeight());
        this.load(() -> MapIO.readImage(pixmap, this.tiles()));
        this.renderer.resize(this.width(), this.height());
    }

    public void load(Runnable r) {
        this.loading = true;
        r.run();
        this.loading = false;
    }

    private void createTiles(int width, int height) {
        Tiles tiles = Vars.world.resize(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                tiles.set(x, y, new EditorTile(x, y, Blocks.stone.id, 0, 0));
            }
        }
    }

    public Map createMap(Fi file) {
        return new Map(file, this.width(), this.height(), new StringMap(this.tags), true);
    }

    private void reset() {
        this.clearOp();
        this.brushSize = 1;
        this.drawBlock = Blocks.stone;
        this.tags = new StringMap();
    }

    public Tiles tiles() {
        return Vars.world.tiles;
    }

    public Tile tile(int x, int y) {
        return Vars.world.rawTile(x, y);
    }

    public int width() {
        return Vars.world.width();
    }

    public int height() {
        return Vars.world.height();
    }

    public void drawBlocksReplace(int x, int y) {
        this.drawBlocks(x, y, tile -> tile.block() != Blocks.air || this.drawBlock.isFloor());
    }

    public void drawBlocks(int x, int y) {
        this.drawBlocks(x, y, false, tile -> true);
    }

    public void drawBlocks(int x, int y, Boolf<Tile> tester) {
        this.drawBlocks(x, y, false, tester);
    }

    public void drawBlocks(int x, int y, boolean square, Boolf<Tile> tester) {
        if (this.drawBlock.isMultiblock()) {
            if (!this.hasOverlap(x = Mathf.clamp(x, (this.drawBlock.size - 1) / 2, this.width() - this.drawBlock.size / 2 - 1), y = Mathf.clamp(y, (this.drawBlock.size - 1) / 2, this.height() - this.drawBlock.size / 2 - 1))) {
                this.tile(x, y).setBlock(this.drawBlock, this.drawTeam, this.rotation);
            }
        } else {
            boolean isFloor = this.drawBlock.isFloor() && this.drawBlock != Blocks.air;
            Cons<Tile> drawer = tile -> {
                if (!tester.get((Tile)tile)) {
                    return;
                }
                if (isFloor) {
                    tile.setFloor(this.drawBlock.asFloor());
                } else if (!tile.block().isMultiblock() || this.drawBlock.isMultiblock()) {
                    if (this.drawBlock.rotate && tile.build != null && tile.build.rotation != this.rotation) {
                        this.addTileOp(TileOp.get(tile.x, tile.y, (byte)DrawOperation.OpType.rotation.ordinal(), (byte)this.rotation));
                    }
                    tile.setBlock(this.drawBlock, this.drawTeam, this.rotation);
                }
            };
            if (square) {
                this.drawSquare(x, y, drawer);
            } else {
                this.drawCircle(x, y, drawer);
            }
        }
    }

    boolean hasOverlap(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        if (tile != null && tile.isCenter() && tile.block() != this.drawBlock && tile.block().size == this.drawBlock.size && tile.x == x && tile.y == y) {
            return false;
        }
        int offsetx = -(this.drawBlock.size - 1) / 2;
        int offsety = -(this.drawBlock.size - 1) / 2;
        for (int dx = 0; dx < this.drawBlock.size; ++dx) {
            for (int dy = 0; dy < this.drawBlock.size; ++dy) {
                int worldx = dx + offsetx + x;
                int worldy = dy + offsety + y;
                Tile other = Vars.world.tile(worldx, worldy);
                if (other == null || !other.block().isMultiblock()) continue;
                return true;
            }
        }
        return false;
    }

    public void addCliffs() {
        for (Tile tile : Vars.world.tiles) {
            if (!tile.block().isStatic() || tile.block() == Blocks.cliff) continue;
            int rotation = 0;
            for (int i = 0; i < 8; ++i) {
                Tile other = Vars.world.tiles.get(tile.x + Geometry.d8[i].x, tile.y + Geometry.d8[i].y);
                if (other == null || other.block().isStatic()) continue;
                rotation |= 1 << i;
            }
            if (rotation != 0) {
                tile.setBlock(Blocks.cliff);
            }
            tile.data = (byte)rotation;
        }
        for (Tile tile : Vars.world.tiles) {
            if (tile.block() == Blocks.cliff || !tile.block().isStatic()) continue;
            tile.setBlock(Blocks.air);
        }
    }

    public void addFloorCliffs() {
        for (Tile tile : Vars.world.tiles) {
            if (!tile.floor().hasSurface() || tile.block() == Blocks.cliff) continue;
            int rotation = 0;
            for (int i = 0; i < 8; ++i) {
                Tile other = Vars.world.tiles.get(tile.x + Geometry.d8[i].x, tile.y + Geometry.d8[i].y);
                if (other == null || other.floor().hasSurface()) continue;
                rotation |= 1 << i;
            }
            if (rotation != 0) {
                tile.setBlock(Blocks.cliff);
            }
            tile.data = (byte)rotation;
        }
    }

    public void drawCircle(int x, int y, Cons<Tile> drawer) {
        for (int rx = -this.brushSize; rx <= this.brushSize; ++rx) {
            for (int ry = -this.brushSize; ry <= this.brushSize; ++ry) {
                if (!Mathf.within(rx, ry, (float)this.brushSize - 0.5f + 1.0E-4f)) continue;
                int wx = x + rx;
                int wy = y + ry;
                if (wx < 0 || wy < 0 || wx >= this.width() || wy >= this.height()) continue;
                drawer.get(this.tile(wx, wy));
            }
        }
    }

    public void drawSquare(int x, int y, Cons<Tile> drawer) {
        for (int rx = -this.brushSize; rx <= this.brushSize; ++rx) {
            for (int ry = -this.brushSize; ry <= this.brushSize; ++ry) {
                int wx = x + rx;
                int wy = y + ry;
                if (wx < 0 || wy < 0 || wx >= this.width() || wy >= this.height()) continue;
                drawer.get(this.tile(wx, wy));
            }
        }
    }

    public void resize(int width, int height) {
        this.clearOp();
        Tiles previous = Vars.world.tiles;
        int offsetX = (this.width() - width) / 2;
        int offsetY = (this.height() - height) / 2;
        this.loading = true;
        Tiles tiles = Vars.world.resize(width, height);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int px = offsetX + x;
                int py = offsetY + y;
                if (previous.in(px, py)) {
                    Object out;
                    tiles.set(x, y, previous.getn(px, py));
                    Tile tile = tiles.getn(x, y);
                    tile.x = (short)x;
                    tile.y = (short)y;
                    if (tile.build == null || !tile.isCenter()) continue;
                    tile.build.x = (float)(x * 8) + tile.block().offset;
                    tile.build.y = (float)(y * 8) + tile.block().offset;
                    Object config = tile.build.config();
                    if (config == null || (out = BuildPlan.pointConfig(tile.block(), config, p -> p.sub(offsetX, offsetY))) == config) continue;
                    tile.build.configureAny(out);
                    continue;
                }
                tiles.set(x, y, new EditorTile(x, y, Blocks.stone.id, 0, 0));
            }
        }
        this.renderer.resize(width, height);
        this.loading = false;
    }

    public void clearOp() {
        this.stack.clear();
    }

    public void undo() {
        if (this.stack.canUndo()) {
            this.stack.undo();
        }
    }

    public void redo() {
        if (this.stack.canRedo()) {
            this.stack.redo();
        }
    }

    public boolean canUndo() {
        return this.stack.canUndo();
    }

    public boolean canRedo() {
        return this.stack.canRedo();
    }

    public void flushOp() {
        if (this.currentOp == null || this.currentOp.isEmpty()) {
            return;
        }
        this.stack.add(this.currentOp);
        this.currentOp = null;
    }

    public void addTileOp(long data) {
        if (this.loading) {
            return;
        }
        if (this.currentOp == null) {
            this.currentOp = new DrawOperation(this);
        }
        this.currentOp.addOperation(data);
        this.renderer.updatePoint(TileOp.x(data), TileOp.y(data));
    }

    class Context
    implements WorldContext {
        Context() {
        }

        @Override
        public Tile tile(int index) {
            return Vars.world.tiles.geti(index);
        }

        @Override
        public void resize(int width, int height) {
            Vars.world.resize(width, height);
        }

        @Override
        public Tile create(int x, int y, int floorID, int overlayID, int wallID) {
            EditorTile tile = new EditorTile(x, y, floorID, overlayID, wallID);
            MapEditor.this.tiles().set(x, y, tile);
            return tile;
        }

        @Override
        public boolean isGenerating() {
            return Vars.world.isGenerating();
        }

        @Override
        public void begin() {
            Vars.world.beginMapLoad();
        }

        @Override
        public void end() {
            Vars.world.endMapLoad();
        }
    }
}

