/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.files.Fi;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.ClickListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Dialog;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Slider;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.content.UnitTypes;
import mindustry.core.GameState;
import mindustry.editor.EditorTool;
import mindustry.editor.MapEditor;
import mindustry.editor.MapGenerateDialog;
import mindustry.editor.MapInfoDialog;
import mindustry.editor.MapLoadDialog;
import mindustry.editor.MapResizeDialog;
import mindustry.editor.MapView;
import mindustry.game.Gamemode;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.io.MapIO;
import mindustry.maps.Map;
import mindustry.ui.Cicon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Boulder;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.meta.BuildVisibility;

public class MapEditorDialog
extends Dialog
implements Disposable {
    public final MapEditor editor;
    private MapView view;
    private MapInfoDialog infoDialog;
    private MapLoadDialog loadDialog;
    private MapResizeDialog resizeDialog;
    private MapGenerateDialog generateDialog;
    private ScrollPane pane;
    private BaseDialog menu;
    private Table blockSelection;
    private Rules lastSavedRules;
    private boolean saved = false;
    private boolean shownWithMap = false;
    private Seq<Block> blocksOut = new Seq();

    public MapEditorDialog() {
        super("");
        this.background(Styles.black);
        this.editor = new MapEditor();
        this.view = new MapView(this.editor);
        this.infoDialog = new MapInfoDialog(this.editor);
        this.generateDialog = new MapGenerateDialog(this.editor, true);
        this.menu = new BaseDialog("@menu");
        this.menu.addCloseButton();
        float swidth = 180.0f;
        this.menu.cont.table((Table t) -> {
            t.defaults().size(swidth, 60.0f).padBottom(5.0f).padRight(5.0f).padLeft(5.0f);
            t.button("@editor.savemap", Icon.save, this::save);
            t.button("@editor.mapinfo", Icon.pencil, () -> {
                this.infoDialog.show();
                this.menu.hide();
            });
            t.row();
            t.button("@editor.generate", Icon.terrain, () -> {
                this.generateDialog.show(this.generateDialog::applyToEditor);
                this.menu.hide();
            });
            t.button("@editor.resize", Icon.resize, () -> {
                this.resizeDialog.show();
                this.menu.hide();
            });
            t.row();
            t.button("@editor.import", Icon.download, () -> {
                Object[] objectArray = new Object[12];
                objectArray[0] = "@editor.importmap";
                objectArray[1] = "@editor.importmap.description";
                objectArray[2] = Icon.download;
                objectArray[3] = this.loadDialog::show;
                objectArray[4] = "@editor.importfile";
                objectArray[5] = "@editor.importfile.description";
                objectArray[6] = Icon.file;
                objectArray[7] = () -> Vars.platform.showFileChooser(true, "msav", file -> Vars.ui.loadAnd(() -> Vars.maps.tryCatchMapError(() -> {
                    if (MapIO.isImage(file)) {
                        Vars.ui.showInfo("@editor.errorimage");
                    } else {
                        this.editor.beginEdit(MapIO.createMap(file, true));
                    }
                })));
                objectArray[8] = "@editor.importimage";
                objectArray[9] = "@editor.importimage.description";
                objectArray[10] = Icon.fileImage;
                objectArray[11] = () -> Vars.platform.showFileChooser(true, "png", file -> Vars.ui.loadAnd(() -> {
                    try {
                        Pixmap pixmap = new Pixmap((Fi)file);
                        this.editor.beginEdit(pixmap);
                        pixmap.dispose();
                    }
                    catch (Exception e) {
                        Vars.ui.showException("@editor.errorload", e);
                        Log.err(e);
                    }
                }));
                this.createDialog("@editor.import", objectArray);
            });
            t.button("@editor.export", Icon.upload, () -> this.createDialog("@editor.export", "@editor.exportfile", "@editor.exportfile.description", Icon.file, () -> Vars.platform.export(this.editor.tags.get("name", "unknown"), "msav", file -> MapIO.writeMap(file, this.editor.createMap(file))), "@editor.exportimage", "@editor.exportimage.description", Icon.fileImage, () -> Vars.platform.export(this.editor.tags.get("name", "unknown"), "png", file -> {
                Pixmap out = MapIO.writeImage(this.editor.tiles());
                file.writePNG(out);
                out.dispose();
            })));
        });
        this.menu.cont.row();
        if (Vars.steam) {
            this.menu.cont.button("@editor.publish.workshop", Icon.link, () -> {
                Map builtin = Vars.maps.all().find((T m) -> m.name().equals(this.editor.tags.get("name", "").trim()));
                if (this.editor.tags.containsKey("steamid") && builtin != null && !builtin.custom) {
                    Vars.platform.viewListingID((String)this.editor.tags.get("steamid"));
                    return;
                }
                Map map = this.save();
                if (this.editor.tags.containsKey("steamid") && map != null) {
                    Vars.platform.viewListing(map);
                    return;
                }
                if (map == null) {
                    return;
                }
                if (map.tags.get("description", "").length() < 4) {
                    Vars.ui.showErrorMessage("@editor.nodescription");
                    return;
                }
                if (!Structs.contains(Gamemode.all, g -> g.valid(map))) {
                    Vars.ui.showErrorMessage("@map.nospawn");
                    return;
                }
                Vars.platform.publish(map);
            }).padTop(-3.0f).size(swidth * 2.0f + 10.0f, 60.0f).update((T b) -> b.setText(this.editor.tags.containsKey("steamid") ? (this.editor.tags.get("author", "").equals(Vars.steamPlayerName) ? "@workshop.listing" : "@view.workshop") : "@editor.publish.workshop"));
            this.menu.cont.row();
        }
        this.menu.cont.button("@editor.ingame", Icon.right, this::playtest).padTop(!Vars.steam ? -3.0f : 1.0f).size(swidth * 2.0f + 10.0f, 60.0f);
        this.menu.cont.row();
        this.menu.cont.button("@quit", Icon.exit, () -> {
            this.tryExit();
            this.menu.hide();
        }).size(swidth * 2.0f + 10.0f, 60.0f);
        this.resizeDialog = new MapResizeDialog(this.editor, (x, y) -> {
            if (this.editor.width() != x || this.editor.height() != y) {
                Vars.ui.loadAnd(() -> this.editor.resize(x, y));
            }
        });
        this.loadDialog = new MapLoadDialog(map -> Vars.ui.loadAnd(() -> {
            try {
                this.editor.beginEdit((Map)map);
            }
            catch (Exception e) {
                Vars.ui.showException("@editor.errorload", e);
                Log.err(e);
            }
        }));
        this.setFillParent(true);
        this.clearChildren();
        this.margin(0.0f);
        this.update(() -> {
            if (Core.scene.getKeyboardFocus() instanceof Dialog && Core.scene.getKeyboardFocus() != this) {
                return;
            }
            if (Core.scene != null && Core.scene.getKeyboardFocus() == this) {
                this.doInput();
            }
        });
        this.shown(() -> {
            this.saved = true;
            if (!Core.settings.getBool("landscape")) {
                Vars.platform.beginForceLandscape();
            }
            this.editor.clearOp();
            Core.scene.setScrollFocus(this.view);
            if (!this.shownWithMap) {
                Vars.logic.reset();
                Vars.state.rules = new Rules();
                this.editor.beginEdit(200, 200);
            }
            this.shownWithMap = false;
            Time.runTask(10.0f, Vars.platform::updateRPC);
        });
        this.hidden(() -> {
            this.editor.clearOp();
            Vars.platform.updateRPC();
            if (!Core.settings.getBool("landscape")) {
                Vars.platform.endForceLandscape();
            }
        });
        this.shown(this::build);
    }

    public void resumeEditing() {
        Vars.state.set(GameState.State.menu);
        this.shownWithMap = true;
        this.show();
        Vars.state.rules = this.lastSavedRules == null ? new Rules() : this.lastSavedRules;
        this.lastSavedRules = null;
        this.saved = false;
        this.editor.renderer.updateAll();
    }

    private void playtest() {
        this.menu.hide();
        Vars.ui.loadAnd(() -> {
            this.lastSavedRules = Vars.state.rules;
            this.hide();
            Vars.state.teams = new Teams();
            Vars.player.reset();
            Vars.state.rules = Gamemode.editor.apply(this.lastSavedRules.copy());
            Vars.state.rules.sector = null;
            Vars.state.map = new Map(StringMap.of("name", "Editor Playtesting", "width", this.editor.width(), "height", this.editor.height()));
            Vars.world.endMapLoad();
            Vars.player.set((float)(Vars.world.width() * 8) / 2.0f, (float)(Vars.world.height() * 8) / 2.0f);
            Vars.player.clearUnit();
            Groups.unit.clear();
            Groups.build.clear();
            Groups.weather.clear();
            Vars.logic.play();
            if (Vars.player.team().core() == null) {
                Vars.player.set((float)(Vars.world.width() * 8) / 2.0f, (float)(Vars.world.height() * 8) / 2.0f);
                Unit unit = UnitTypes.alpha.spawn(Vars.player.team(), Vars.player.x, Vars.player.y);
                unit.spawnedByCore = true;
                Vars.player.unit(unit);
            }
        });
    }

    @Nullable
    public Map save() {
        boolean isEditor = Vars.state.rules.editor;
        Vars.state.rules.editor = false;
        String name = this.editor.tags.get("name", "").trim();
        this.editor.tags.put("rules", JsonIO.write(Vars.state.rules));
        this.editor.tags.remove("width");
        this.editor.tags.remove("height");
        Vars.player.clearUnit();
        Map returned = null;
        if (name.isEmpty()) {
            this.infoDialog.show();
            Core.app.post(() -> Vars.ui.showErrorMessage("@editor.save.noname"));
        } else {
            Map map = Vars.maps.all().find((T m) -> m.name().equals(name));
            if (map != null && !map.custom) {
                this.handleSaveBuiltin(map);
            } else {
                returned = Vars.maps.saveMap(this.editor.tags);
                Vars.ui.showInfoFade("@editor.saved");
            }
        }
        this.menu.hide();
        this.saved = true;
        Vars.state.rules.editor = isEditor;
        return returned;
    }

    protected void handleSaveBuiltin(Map map) {
        Vars.ui.showErrorMessage("@editor.save.overwrite");
    }

    private void createDialog(String title, Object ... arguments) {
        BaseDialog dialog = new BaseDialog(title);
        float h = 90.0f;
        dialog.cont.defaults().size(360.0f, h).padBottom(5.0f).padRight(5.0f).padLeft(5.0f);
        for (int i = 0; i < arguments.length; i += 4) {
            String name = (String)arguments[i];
            String description = (String)arguments[i + 1];
            Drawable iconname = (Drawable)arguments[i + 2];
            Runnable listenable = (Runnable)arguments[i + 3];
            TextButton button = dialog.cont.button(name, () -> {
                listenable.run();
                dialog.hide();
                this.menu.hide();
            }).left().margin(0.0f).get();
            button.clearChildren();
            button.image(iconname).padLeft(10.0f);
            button.table((Table t) -> {
                t.add(name).growX().wrap();
                t.row();
                t.add(description).color(Color.gray).growX().wrap();
            }).growX().pad(10.0f).padLeft(5.0f);
            button.row();
            dialog.cont.row();
        }
        dialog.addCloseButton();
        dialog.show();
    }

    @Override
    public Dialog show() {
        return super.show(Core.scene, Actions.sequence((Action)Actions.alpha(1.0f)));
    }

    @Override
    public void hide() {
        super.hide(Actions.sequence((Action)Actions.alpha(0.0f)));
    }

    @Override
    public void dispose() {
        this.editor.renderer.dispose();
    }

    public void beginEditMap(Fi file) {
        Vars.ui.loadAnd(() -> {
            try {
                this.shownWithMap = true;
                this.editor.beginEdit(MapIO.createMap(file, true));
                this.show();
            }
            catch (Exception e) {
                Log.err(e);
                Vars.ui.showException("@editor.errorload", e);
            }
        });
    }

    public MapView getView() {
        return this.view;
    }

    public MapGenerateDialog getGenerateDialog() {
        return this.generateDialog;
    }

    public void resetSaved() {
        this.saved = false;
    }

    public boolean hasPane() {
        return Core.scene.getScrollFocus() == this.pane || Core.scene.getKeyboardFocus() != this;
    }

    public void build() {
        float size = 58.0f;
        this.clearChildren();
        this.table((Table cont) -> {
            cont.left();
            cont.table((Table mid) -> {
                mid.top();
                Table tools = new Table().top();
                ButtonGroup group = new ButtonGroup();
                Table[] lastTable = new Table[]{null};
                Cons<EditorTool> addTool = tool -> {
                    ImageButton button = new ImageButton((Drawable)Vars.ui.getIcon(tool.name()), Styles.clearTogglei);
                    button.clicked(() -> {
                        this.view.setTool((EditorTool)((Object)((Object)((Object)tool))));
                        if (lastTable[0] != null) {
                            lastTable[0].remove();
                        }
                    });
                    button.update(() -> button.setChecked(this.view.getTool() == tool));
                    group.add(button);
                    if (tool.altModes.length > 0) {
                        button.clicked((ClickListener l) -> {
                            if (!Vars.mobile) {
                                l.setButton(KeyCode.mouseRight);
                            }
                        }, (ClickListener e) -> {
                            if (Vars.mobile && e.getTapCount() < 2) {
                                return;
                            }
                            if (lastTable[0] != null) {
                                lastTable[0].remove();
                            }
                            Table table = new Table(Styles.black9);
                            table.defaults().size(300.0f, 70.0f);
                            for (int i = 0; i < tool.altModes.length; ++i) {
                                int mode = i;
                                String name = tool.altModes[i];
                                table.button((Button b) -> {
                                    b.left();
                                    b.marginLeft(6.0f);
                                    b.setStyle(Styles.clearTogglet);
                                    b.add(Core.bundle.get("toolmode." + name)).left();
                                    b.row();
                                    b.add(Core.bundle.get("toolmode." + name + ".description")).color(Color.lightGray).left();
                                }, () -> {
                                    tool.mode = tool.mode == mode ? -1 : mode;
                                    table.remove();
                                }).update((T b) -> b.setChecked(tool.mode == mode));
                                table.row();
                            }
                            table.update(() -> {
                                Vec2 v = button.localToStageCoordinates(Tmp.v1.setZero());
                                table.setPosition(v.x, v.y, 10);
                                if (!this.isShown()) {
                                    table.remove();
                                    lastTable[0] = null;
                                }
                            });
                            table.pack();
                            table.act(Core.graphics.getDeltaTime());
                            this.addChild(table);
                            lastTable[0] = table;
                        });
                    }
                    Label mode = new Label("");
                    mode.setColor(Pal.remove);
                    mode.update(() -> mode.setText(tool.mode == -1 ? "" : "M" + (tool.mode + 1) + " "));
                    mode.setAlignment(20, 20);
                    mode.touchable = Touchable.disabled;
                    tools.stack(button, mode);
                };
                tools.defaults().size(size, size);
                tools.button((Drawable)Icon.menu, Styles.cleari, this.menu::show);
                ImageButton grid = tools.button((Drawable)Icon.grid, Styles.clearTogglei, () -> this.view.setGrid(!this.view.isGrid())).get();
                addTool.get(EditorTool.zoom);
                tools.row();
                ImageButton undo = tools.button((Drawable)Icon.undo, Styles.cleari, this.editor::undo).get();
                ImageButton redo = tools.button((Drawable)Icon.redo, Styles.cleari, this.editor::redo).get();
                addTool.get(EditorTool.pick);
                tools.row();
                undo.setDisabled(() -> !this.editor.canUndo());
                redo.setDisabled(() -> !this.editor.canRedo());
                undo.update(() -> undo.getImage().setColor(undo.isDisabled() ? Color.gray : Color.white));
                redo.update(() -> redo.getImage().setColor(redo.isDisabled() ? Color.gray : Color.white));
                grid.update(() -> grid.setChecked(this.view.isGrid()));
                addTool.get(EditorTool.line);
                addTool.get(EditorTool.pencil);
                addTool.get(EditorTool.eraser);
                tools.row();
                addTool.get(EditorTool.fill);
                addTool.get(EditorTool.spray);
                ImageButton rotate = tools.button((Drawable)Icon.right, Styles.cleari, () -> {
                    this.editor.rotation = (this.editor.rotation + 1) % 4;
                }).get();
                rotate.getImage().update(() -> {
                    rotate.getImage().setRotation(this.editor.rotation * 90);
                    rotate.getImage().setOrigin(1);
                });
                tools.row();
                tools.table(Tex.underline, t -> t.add("@editor.teams")).colspan(3).height(40.0f).width(size * 3.0f + 3.0f).padBottom(3.0f);
                tools.row();
                ButtonGroup<ImageButton> teamgroup = new ButtonGroup<ImageButton>();
                int i = 0;
                for (Team team : Team.baseTeams) {
                    ImageButton button = new ImageButton((Drawable)Tex.whiteui, Styles.clearTogglePartiali);
                    button.margin(4.0f);
                    button.getImageCell().grow();
                    button.getStyle().imageUpColor = team.color;
                    button.clicked(() -> {
                        this.editor.drawTeam = team;
                    });
                    button.update(() -> button.setChecked(this.editor.drawTeam == team));
                    teamgroup.add(button);
                    tools.add(button);
                    if (i++ % 3 != 2) continue;
                    tools.row();
                }
                mid.add(tools).top().padBottom(-6.0f);
                mid.row();
                mid.table(Tex.underline, t -> {
                    Slider slider = new Slider(0.0f, MapEditor.brushSizes.length - 1, 1.0f, false);
                    slider.moved(f -> {
                        this.editor.brushSize = MapEditor.brushSizes[(int)f];
                    });
                    for (int j = 0; j < MapEditor.brushSizes.length; ++j) {
                        if (MapEditor.brushSizes[j] != this.editor.brushSize) continue;
                        slider.setValue(j);
                    }
                    t.top();
                    t.add("@editor.brush");
                    t.row();
                    t.add(slider).width(size * 3.0f - 20.0f).padTop(4.0f);
                }).padTop(5.0f).growX().top();
                mid.row();
                if (!Vars.mobile) {
                    mid.table((Table t) -> t.button("@editor.center", (Drawable)Icon.move, Styles.cleart, this.view::center).growX().margin(9.0f)).growX().top();
                }
                if (Vars.experimental) {
                    mid.row();
                    mid.table((Table t) -> t.button("Cliffs", (Drawable)Icon.terrain, Styles.cleart, this.editor::addCliffs).growX().margin(9.0f)).growX().top();
                }
            }).margin(0.0f).left().growY();
            cont.table((Table t) -> t.add(this.view).grow()).grow();
            cont.table(this::addBlockSelection).right().growY();
        }).grow();
    }

    private void doInput() {
        if (Core.input.ctrl()) {
            for (int i = 0; i < this.view.getTool().altModes.length; ++i) {
                if (i + 1 >= KeyCode.numbers.length || !Core.input.keyTap(KeyCode.numbers[i + 1])) continue;
                this.view.getTool().mode = i;
            }
        } else {
            for (EditorTool tool : EditorTool.all) {
                if (!Core.input.keyTap(tool.key)) continue;
                this.view.setTool(tool);
                break;
            }
        }
        if (Core.input.keyTap(KeyCode.escape) && !this.menu.isShown()) {
            this.menu.show();
        }
        if (Core.input.keyTap(KeyCode.r)) {
            this.editor.rotation = Mathf.mod(this.editor.rotation + 1, 4);
        }
        if (Core.input.keyTap(KeyCode.e)) {
            this.editor.rotation = Mathf.mod(this.editor.rotation - 1, 4);
        }
        if (Core.input.ctrl()) {
            if (Core.input.keyTap(KeyCode.z)) {
                this.editor.undo();
            }
            if (Core.input.keyTap(KeyCode.t)) {
                for (int x = 0; x < this.editor.width(); ++x) {
                    for (int y = 0; y < this.editor.height(); ++y) {
                        Tile tile = this.editor.tile(x, y);
                        if (tile.block().breakable && tile.block() instanceof Boulder) {
                            tile.setBlock(Blocks.air);
                            this.editor.renderer.updatePoint(x, y);
                        }
                        if (tile.overlay() == Blocks.air || tile.overlay() == Blocks.spawn) continue;
                        tile.setOverlay(Blocks.air);
                        this.editor.renderer.updatePoint(x, y);
                    }
                }
                this.editor.flushOp();
            }
            if (Core.input.keyTap(KeyCode.y)) {
                this.editor.redo();
            }
            if (Core.input.keyTap(KeyCode.s)) {
                this.save();
            }
            if (Core.input.keyTap(KeyCode.g)) {
                this.view.setGrid(!this.view.isGrid());
            }
        }
    }

    private void tryExit() {
        Vars.ui.showConfirm("@confirm", "@editor.unsaved", this::hide);
    }

    private void addBlockSelection(Table cont) {
        this.blockSelection = new Table();
        this.pane = new ScrollPane((Element)this.blockSelection);
        this.pane.setFadeScrollBars(false);
        this.pane.setOverscroll(true, false);
        this.pane.exited(() -> {
            if (this.pane.hasScroll()) {
                Core.scene.setScrollFocus(this.view);
            }
        });
        cont.table((Table search) -> {
            search.image(Icon.zoom).padRight(8.0f);
            search.field("", this::rebuildBlockSelection).name("editor/search").maxTextLength(40).get().setMessageText("@players.search");
        }).pad(-2.0f);
        cont.row();
        cont.table(Tex.underline, extra -> extra.labelWrap(() -> this.editor.drawBlock.localizedName).width(200.0f).center()).growX();
        cont.row();
        cont.add(this.pane).expandY().top().left();
        this.rebuildBlockSelection("");
    }

    private void rebuildBlockSelection(String searchText) {
        this.blockSelection.clear();
        this.blocksOut.clear();
        this.blocksOut.addAll(Vars.content.blocks());
        this.blocksOut.sort((b1, b2) -> {
            int core = -Boolean.compare(b1 instanceof CoreBlock, b2 instanceof CoreBlock);
            if (core != 0) {
                return core;
            }
            int synth = Boolean.compare(b1.synthetic(), b2.synthetic());
            if (synth != 0) {
                return synth;
            }
            int ore = Boolean.compare(b1 instanceof OverlayFloor, b2 instanceof OverlayFloor);
            if (ore != 0) {
                return ore;
            }
            return Integer.compare(b1.id, b2.id);
        });
        int i = 0;
        for (Block block : this.blocksOut) {
            TextureRegion region = block.icon(Cicon.medium);
            if (!Core.atlas.isFound(region) || !block.inEditor || block.buildVisibility == BuildVisibility.debugOnly || !searchText.isEmpty() && !block.localizedName.toLowerCase().contains(searchText.toLowerCase())) continue;
            ImageButton button = new ImageButton((Drawable)Tex.whiteui, Styles.clearTogglei);
            button.getStyle().imageUp = new TextureRegionDrawable(region);
            button.clicked(() -> {
                this.editor.drawBlock = block;
            });
            button.resizeImage(32.0f);
            button.update(() -> button.setChecked(this.editor.drawBlock == block));
            this.blockSelection.add(button).size(50.0f).tooltip(block.localizedName);
            if (i == 0) {
                this.editor.drawBlock = block;
            }
            if (++i % 4 != 0) continue;
            this.blockSelection.row();
        }
        if (i == 0) {
            this.blockSelection.add("@none").color(Color.lightGray).padLeft(80.0f).padTop(10.0f);
        }
    }
}

