/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Scaling;
import arc.util.async.AsyncExecutor;
import arc.util.async.AsyncResult;
import mindustry.Vars;
import mindustry.editor.MapEditor;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.PackTile;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.MapIO;
import mindustry.maps.filters.BlendFilter;
import mindustry.maps.filters.ClearFilter;
import mindustry.maps.filters.CoreSpawnFilter;
import mindustry.maps.filters.DistortFilter;
import mindustry.maps.filters.EnemySpawnFilter;
import mindustry.maps.filters.FilterOption;
import mindustry.maps.filters.GenerateFilter;
import mindustry.maps.filters.MedianFilter;
import mindustry.maps.filters.MirrorFilter;
import mindustry.maps.filters.NoiseFilter;
import mindustry.maps.filters.OreFilter;
import mindustry.maps.filters.OreMedianFilter;
import mindustry.maps.filters.RiverNoiseFilter;
import mindustry.maps.filters.ScatterFilter;
import mindustry.maps.filters.SpawnPathFilter;
import mindustry.maps.filters.TerrainFilter;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.CachedTile;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class MapGenerateDialog
extends BaseDialog {
    private final Prov<GenerateFilter>[] filterTypes = new Prov[]{NoiseFilter::new, ScatterFilter::new, TerrainFilter::new, DistortFilter::new, RiverNoiseFilter::new, OreFilter::new, OreMedianFilter::new, MedianFilter::new, BlendFilter::new, MirrorFilter::new, ClearFilter::new, CoreSpawnFilter::new, EnemySpawnFilter::new, SpawnPathFilter::new};
    private final MapEditor editor;
    private final boolean applied;
    private Pixmap pixmap;
    private Texture texture;
    private GenerateFilter.GenerateInput input = new GenerateFilter.GenerateInput();
    Seq<GenerateFilter> filters = new Seq();
    private int scaling = Vars.mobile ? 3 : 1;
    private Table filterTable;
    private AsyncExecutor executor = new AsyncExecutor(1);
    private AsyncResult<Void> result;
    boolean generating;
    private long[] buffer1;
    private long[] buffer2;
    private Cons<Seq<GenerateFilter>> applier;
    CachedTile ctile = new CachedTile(){

        @Override
        protected void changeBuild(Team team, Prov<Building> entityprov, int rotation) {
        }

        @Override
        public void setBlock(Block type, Team team, int rotation, Prov<Building> entityprov) {
            this.block = type;
        }
    };

    public MapGenerateDialog(MapEditor editor, boolean applied) {
        super("@editor.generate");
        this.editor = editor;
        this.applied = applied;
        this.shown(this::setup);
        this.addCloseButton();
        if (applied) {
            this.buttons.button("@editor.apply", Icon.ok, () -> Vars.ui.loadAnd(() -> {
                this.apply();
                this.hide();
            })).size(160.0f, 64.0f);
        } else {
            this.buttons.button("@settings.reset", () -> {
                this.filters.set(Vars.maps.readFilters(""));
                this.rebuildFilters();
                this.update();
            }).size(160.0f, 64.0f);
        }
        this.buttons.button("@editor.randomize", Icon.refresh, () -> {
            for (GenerateFilter filter : this.filters) {
                filter.randomize();
            }
            this.update();
        }).size(160.0f, 64.0f);
        this.buttons.button("@add", Icon.add, this::showAdd).height(64.0f).width(150.0f);
        if (!applied) {
            this.hidden(this::apply);
        }
        this.onResize(this::rebuildFilters);
    }

    public void show(Seq<GenerateFilter> filters, Cons<Seq<GenerateFilter>> applier) {
        this.filters = filters;
        this.applier = applier;
        this.show();
    }

    public void show(Cons<Seq<GenerateFilter>> applier) {
        this.show(this.filters, applier);
    }

    public void applyToEditor(Seq<GenerateFilter> filters) {
        long[] writeTiles = new long[this.editor.width() * this.editor.height()];
        for (GenerateFilter filter : filters) {
            this.input.begin(filter, this.editor.width(), this.editor.height(), this.editor::tile);
            for (int x = 0; x < this.editor.width(); ++x) {
                for (int y = 0; y < this.editor.height(); ++y) {
                    Tile tile = this.editor.tile(x, y);
                    this.input.apply(x, y, tile.block(), tile.floor(), tile.overlay());
                    filter.apply(this.input);
                    writeTiles[x + y * Vars.world.width()] = PackTile.get(this.input.block.id, this.input.floor.id, this.input.overlay.id);
                }
            }
            this.editor.load(() -> {
                for (int i = 0; i < this.editor.width() * this.editor.height(); ++i) {
                    Tile tile = Vars.world.tiles.geti(i);
                    long write = writeTiles[i];
                    Block block = Vars.content.block(PackTile.block(write));
                    Block floor = Vars.content.block(PackTile.floor(write));
                    Block overlay = Vars.content.block(PackTile.overlay(write));
                    if (!tile.synthetic() && !block.synthetic()) {
                        tile.setBlock(block);
                    }
                    tile.setFloor((Floor)floor);
                    tile.setOverlay(overlay);
                }
            });
        }
        this.editor.renderer.updateAll();
        this.editor.clearOp();
    }

    void setup() {
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
            this.pixmap = null;
            this.texture = null;
        }
        this.pixmap = new Pixmap(this.editor.width() / this.scaling, this.editor.height() / this.scaling);
        this.texture = new Texture(this.pixmap);
        this.cont.clear();
        this.cont.table((Table t) -> {
            t.margin(8.0f);
            t.stack(new BorderImage(this.texture){
                {
                    this.setScaling(Scaling.fit);
                }

                @Override
                public void draw() {
                    super.draw();
                    for (GenerateFilter filter : MapGenerateDialog.this.filters) {
                        filter.draw(this);
                    }
                }
            }, new Stack(){
                {
                    this.add(new Image(Styles.black8));
                    this.add(new Image((Drawable)Icon.refresh, Scaling.none));
                    this.visible(() -> MapGenerateDialog.this.generating && !Vars.updateEditorOnChange);
                }
            }).uniformX().grow().padRight(10.0f);
            t.pane((Table p) -> {
                this.filterTable = p.marginRight(6.0f);
            }).update((T pane) -> {
                if (Core.scene.getKeyboardFocus() instanceof Dialog && Core.scene.getKeyboardFocus() != this) {
                    return;
                }
                Vec2 v = pane.stageToLocalCoordinates(Core.input.mouse());
                if (v.x >= 0.0f && v.y >= 0.0f && v.x <= pane.getWidth() && v.y <= pane.getHeight()) {
                    Core.scene.setScrollFocus((Element)pane);
                } else {
                    Core.scene.setScrollFocus(null);
                }
            }).grow().uniformX().get().setScrollingDisabled(true, false);
        }).grow();
        this.buffer1 = this.create();
        this.buffer2 = this.create();
        this.update();
        this.rebuildFilters();
    }

    long[] create() {
        return new long[this.editor.width() / this.scaling * (this.editor.height() / this.scaling)];
    }

    void rebuildFilters() {
        int cols = Math.max((int)((float)Core.graphics.getWidth() / 2.0f / Scl.scl(290.0f)), 1);
        this.filterTable.clearChildren();
        this.filterTable.top().left();
        int i = 0;
        for (GenerateFilter filter : this.filters) {
            this.filterTable.table(Tex.pane, c -> {
                c.margin(0.0f);
                c.table(Tex.whiteui, t -> {
                    t.setColor(Pal.gray);
                    t.top().left();
                    t.add(filter.name()).left().padLeft(6.0f).width(100.0f).wrap();
                    t.add().growX();
                    ImageButton.ImageButtonStyle style = Styles.geni;
                    t.defaults().size(42.0f);
                    t.button((Drawable)Icon.refresh, style, () -> {
                        filter.randomize();
                        this.update();
                    });
                    t.button((Drawable)Icon.upOpen, style, () -> {
                        int idx = this.filters.indexOf(filter);
                        this.filters.swap(idx, Math.max(0, idx - 1));
                        this.rebuildFilters();
                        this.update();
                    });
                    t.button((Drawable)Icon.downOpen, style, () -> {
                        int idx = this.filters.indexOf(filter);
                        this.filters.swap(idx, Math.min(this.filters.size - 1, idx + 1));
                        this.rebuildFilters();
                        this.update();
                    });
                    t.button((Drawable)Icon.cancel, style, () -> {
                        this.filters.remove(filter);
                        this.rebuildFilters();
                        this.update();
                    });
                }).growX();
                c.row();
                c.table((Table f) -> {
                    f.left().top();
                    for (FilterOption option : filter.options()) {
                        option.changed = this::update;
                        f.table((Table t) -> {
                            t.left();
                            option.build((Table)t);
                        }).growX().left();
                        f.row();
                    }
                }).grow().left().pad(6.0f).top();
            }).width(280.0f).pad(3.0f).top().left().fillY();
            if (++i % cols != 0) continue;
            this.filterTable.row();
        }
        if (this.filters.isEmpty()) {
            this.filterTable.add("@filters.empty").wrap().width(200.0f);
        }
    }

    void showAdd() {
        BaseDialog selection = new BaseDialog("@add");
        selection.cont.pane((Table p) -> {
            p.marginRight(14.0f);
            p.defaults().size(210.0f, 60.0f);
            int i = 0;
            for (Prov<GenerateFilter> gen : this.filterTypes) {
                GenerateFilter filter = gen.get();
                if (filter.isPost() && this.applied) continue;
                p.button(filter.name(), () -> {
                    this.filters.add(filter);
                    this.rebuildFilters();
                    this.update();
                    selection.hide();
                });
                if (++i % 2 != 0) continue;
                p.row();
            }
            p.button("@filter.defaultores", () -> {
                Vars.maps.addDefaultOres(this.filters);
                this.rebuildFilters();
                this.update();
                selection.hide();
            });
        }).get().setScrollingDisabled(true, false);
        selection.addCloseButton();
        selection.show();
    }

    long pack(Tile tile) {
        return PackTile.get(tile.blockID(), tile.floorID(), tile.overlayID());
    }

    Tile unpack(long tile) {
        this.ctile.setFloor((Floor)Vars.content.block(PackTile.floor(tile)));
        this.ctile.setBlock(Vars.content.block(PackTile.block(tile)));
        this.ctile.setOverlay(Vars.content.block(PackTile.overlay(tile)));
        return this.ctile;
    }

    void apply() {
        if (this.result != null) {
            this.result.get();
        }
        this.buffer1 = null;
        this.buffer2 = null;
        this.generating = false;
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
            this.pixmap = null;
            this.texture = null;
        }
        this.applier.get(this.filters);
    }

    void update() {
        if (this.generating) {
            return;
        }
        Seq<GenerateFilter> copy = new Seq<GenerateFilter>(this.filters);
        this.result = this.executor.submit(() -> {
            try {
                int w = this.pixmap.getWidth();
                Vars.world.setGenerating(true);
                this.generating = true;
                if (!this.filters.isEmpty()) {
                    for (int px2 = 0; px2 < this.pixmap.getWidth(); ++px2) {
                        for (int py2 = 0; py2 < this.pixmap.getHeight(); ++py2) {
                            this.buffer1[px2 + py2 * w] = this.pack(this.editor.tile(px2 * this.scaling, py2 * this.scaling));
                        }
                    }
                }
                for (GenerateFilter filter : copy) {
                    this.input.begin(filter, this.editor.width(), this.editor.height(), (x, y) -> this.unpack(this.buffer1[Mathf.clamp(x / this.scaling, 0, this.pixmap.getWidth() - 1) + w * Mathf.clamp(y / this.scaling, 0, this.pixmap.getHeight() - 1)]));
                    this.pixmap.each((px, py) -> {
                        int x = px * this.scaling;
                        int y = py * this.scaling;
                        long tile = this.buffer1[px + py * w];
                        this.input.apply(x, y, Vars.content.block(PackTile.block(tile)), Vars.content.block(PackTile.floor(tile)), Vars.content.block(PackTile.overlay(tile)));
                        filter.apply(this.input);
                        this.buffer2[px + py * w] = PackTile.get(this.input.block.id, this.input.floor.id, this.input.overlay.id);
                    });
                    this.pixmap.each((px, py) -> {
                        this.buffer1[px + py * w] = this.buffer2[px + py * w];
                    });
                }
                for (int px3 = 0; px3 < this.pixmap.getWidth(); ++px3) {
                    for (int py3 = 0; py3 < this.pixmap.getHeight(); ++py3) {
                        int color;
                        if (this.filters.isEmpty()) {
                            Tile tile = this.editor.tile(px3 * this.scaling, py3 * this.scaling);
                            color = MapIO.colorFor(tile.block(), tile.floor(), tile.overlay(), Team.derelict);
                        } else {
                            long tile = this.buffer1[px3 + py3 * w];
                            color = MapIO.colorFor(Vars.content.block(PackTile.block(tile)), Vars.content.block(PackTile.floor(tile)), Vars.content.block(PackTile.overlay(tile)), Team.derelict);
                        }
                        this.pixmap.draw(px3, this.pixmap.getHeight() - 1 - py3, color);
                    }
                }
                Core.app.post(() -> {
                    if (this.pixmap == null || this.texture == null) {
                        return;
                    }
                    this.texture.draw(this.pixmap);
                    this.generating = false;
                });
            }
            catch (Exception e) {
                this.generating = false;
                Log.err(e);
            }
            Vars.world.setGenerating(false);
        });
    }
}

