/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.scene.ui.TextArea;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.struct.StringMap;
import mindustry.Vars;
import mindustry.editor.MapEditor;
import mindustry.editor.MapGenerateDialog;
import mindustry.editor.WaveInfoDialog;
import mindustry.game.Rules;
import mindustry.io.JsonIO;
import mindustry.maps.filters.GenerateFilter;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.CustomRulesDialog;

public class MapInfoDialog
extends BaseDialog {
    private final MapEditor editor;
    private final WaveInfoDialog waveInfo;
    private final MapGenerateDialog generate;
    private final CustomRulesDialog ruleInfo = new CustomRulesDialog();

    public MapInfoDialog(MapEditor editor) {
        super("@editor.mapinfo");
        this.editor = editor;
        this.waveInfo = new WaveInfoDialog(editor);
        this.generate = new MapGenerateDialog(editor, false);
        this.addCloseButton();
        this.shown(this::setup);
    }

    private void setup() {
        this.cont.clear();
        StringMap tags = this.editor.tags;
        this.cont.pane((Table t) -> {
            t.add("@editor.mapname").padRight(8.0f).left();
            t.defaults().padTop(15.0f);
            TextField name = t.field(tags.get("name", ""), text -> tags.put("name", text)).size(400.0f, 55.0f).addInputDialog(50).get();
            name.setMessageText("@unknown");
            t.row();
            t.add("@editor.description").padRight(8.0f).left();
            TextArea description = t.area(tags.get("description", ""), Styles.areaField, text -> tags.put("description", text)).size(400.0f, 140.0f).addInputDialog(1000).get();
            t.row();
            t.add("@editor.author").padRight(8.0f).left();
            TextField author = t.field(tags.get("author", Core.settings.getString("mapAuthor", "")), text -> {
                tags.put("author", text);
                Core.settings.put("mapAuthor", text);
            }).size(400.0f, 55.0f).addInputDialog(50).get();
            author.setMessageText("@unknown");
            t.row();
            t.add("@editor.rules").padRight(8.0f).left();
            t.button("@edit", () -> {
                this.ruleInfo.show(Vars.state.rules, () -> {
                    Vars.state.rules = new Rules();
                    return Vars.state.rules;
                });
                this.hide();
            }).left().width(200.0f);
            t.row();
            t.add("@editor.waves").padRight(8.0f).left();
            t.button("@edit", () -> {
                this.waveInfo.show();
                this.hide();
            }).left().width(200.0f);
            t.row();
            t.add("@editor.generation").padRight(8.0f).left();
            t.button("@edit", () -> {
                this.generate.show(Vars.maps.readFilters(this.editor.tags.get("genfilters", "")), (Seq<GenerateFilter> filters) -> this.editor.tags.put("genfilters", JsonIO.write(filters)));
                this.hide();
            }).left().width(200.0f);
            name.change();
            description.change();
            author.change();
            t.margin(16.0f);
        });
    }
}

