/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.func.Cons;
import arc.scene.Element;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.util.Scaling;
import mindustry.Vars;
import mindustry.maps.Map;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class MapLoadDialog
extends BaseDialog {
    private Map selected = null;

    public MapLoadDialog(Cons<Map> loader) {
        super("@editor.loadmap");
        this.shown(this::rebuild);
        TextButton button = new TextButton("@load");
        button.setDisabled(() -> this.selected == null);
        button.clicked(() -> {
            if (this.selected != null) {
                loader.get(this.selected);
                this.hide();
            }
        });
        this.buttons.defaults().size(200.0f, 50.0f);
        this.buttons.button("@cancel", this::hide);
        this.buttons.add(button);
    }

    public void rebuild() {
        this.cont.clear();
        if (Vars.maps.all().size > 0) {
            this.selected = Vars.maps.all().first();
        }
        ButtonGroup<TextButton> group = new ButtonGroup<TextButton>();
        int maxcol = 3;
        int i = 0;
        Table table = new Table();
        table.defaults().size(200.0f, 90.0f).pad(4.0f);
        table.margin(10.0f);
        ScrollPane pane = new ScrollPane((Element)table, Styles.horizontalPane);
        pane.setFadeScrollBars(false);
        for (Map map : Vars.maps.all()) {
            TextButton button = new TextButton(map.name(), Styles.togglet);
            button.add(new BorderImage(map.safeTexture(), 2.0f).setScaling(Scaling.fit)).size(64.0f);
            button.getCells().reverse();
            button.clicked(() -> {
                this.selected = map;
            });
            button.getLabelCell().grow().left().padLeft(5.0f);
            group.add(button);
            table.add(button);
            if (++i % maxcol != 0) continue;
            table.row();
        }
        if (Vars.maps.all().size == 0) {
            table.add("@maps.none").center();
        } else {
            this.cont.add("@editor.loadmap");
        }
        this.cont.row();
        this.cont.add(pane);
    }
}

