/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.func.Intc2;
import arc.math.Mathf;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.editor.MapEditor;
import mindustry.ui.dialogs.BaseDialog;

public class MapResizeDialog
extends BaseDialog {
    public static int minSize = 50;
    public static int maxSize = 500;
    public static int increment = 50;
    int width;
    int height;

    public MapResizeDialog(MapEditor editor, Intc2 cons) {
        super("@editor.resizemap");
        this.shown(() -> {
            this.cont.clear();
            this.width = editor.width();
            this.height = editor.height();
            Table table = new Table();
            for (boolean w : Mathf.booleans) {
                table.add(w ? "@width" : "@height").padRight(8.0f);
                table.defaults().height(60.0f).padTop(8.0f);
                table.field((w ? this.width : this.height) + "", TextField.TextFieldFilter.digitsOnly, (String value) -> {
                    int val = Integer.parseInt(value);
                    if (w) {
                        this.width = val;
                    } else {
                        this.height = val;
                    }
                }).valid(value -> Strings.canParsePositiveInt(value) && Integer.parseInt(value) <= maxSize && Integer.parseInt(value) >= minSize).addInputDialog(3);
                table.row();
            }
            this.cont.row();
            this.cont.add(table);
        });
        this.buttons.defaults().size(200.0f, 50.0f);
        this.buttons.button("@cancel", this::hide);
        this.buttons.button("@ok", () -> {
            cons.get(this.width, this.height);
            this.hide();
        });
    }
}

