/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.math.Mathf;
import arc.scene.event.Touchable;
import arc.scene.ui.Button;
import arc.scene.ui.Label;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.editor.MapEditor;
import mindustry.editor.WaveGraph;
import mindustry.game.SpawnGroup;
import mindustry.game.Waves;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.type.UnitType;
import mindustry.ui.Cicon;
import mindustry.ui.dialogs.BaseDialog;

public class WaveInfoDialog
extends BaseDialog {
    private int displayed = 20;
    Seq<SpawnGroup> groups = new Seq();
    private Table table;
    private int start = 0;
    private UnitType lastType = UnitTypes.dagger;
    private float updateTimer;
    private float updatePeriod = 1.0f;
    private WaveGraph graph = new WaveGraph();

    public WaveInfoDialog(MapEditor editor) {
        super("@waves.title");
        this.shown(this::setup);
        this.hidden(() -> {
            Vars.state.rules.spawns = this.groups;
        });
        this.addCloseListener();
        this.onResize(this::setup);
        this.addCloseButton();
        this.buttons.button("@waves.edit", () -> {
            BaseDialog dialog = new BaseDialog("@waves.edit");
            dialog.addCloseButton();
            dialog.setFillParent(false);
            dialog.cont.defaults().size(210.0f, 64.0f);
            dialog.cont.button("@waves.copy", () -> {
                Vars.ui.showInfoFade("@waves.copied");
                Core.app.setClipboardText(Vars.maps.writeWaves(this.groups));
                dialog.hide();
            }).disabled(b -> this.groups == null);
            dialog.cont.row();
            dialog.cont.button("@waves.load", () -> {
                try {
                    this.groups = Vars.maps.readWaves(Core.app.getClipboardText());
                    this.buildGroups();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Vars.ui.showErrorMessage("@waves.invalid");
                }
                dialog.hide();
            }).disabled(b -> Core.app.getClipboardText() == null || Core.app.getClipboardText().isEmpty());
            dialog.cont.row();
            dialog.cont.button("@settings.reset", () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                this.groups = JsonIO.copy(Vars.waves.get());
                this.buildGroups();
                dialog.hide();
            }));
            dialog.show();
        }).size(270.0f, 64.0f);
        this.buttons.defaults().width(60.0f);
        this.buttons.button("<", () -> {}).update((T t) -> {
            if (t.getClickListener().isPressed()) {
                this.shift(-1);
            }
        });
        this.buttons.button(">", () -> {}).update((T t) -> {
            if (t.getClickListener().isPressed()) {
                this.shift(1);
            }
        });
        this.buttons.button("-", () -> {}).update((T t) -> {
            if (t.getClickListener().isPressed()) {
                this.view(-1);
            }
        });
        this.buttons.button("+", () -> {}).update((T t) -> {
            if (t.getClickListener().isPressed()) {
                this.view(1);
            }
        });
        if (Vars.experimental) {
            this.buttons.button("Random", Icon.refresh, () -> {
                this.groups.clear();
                this.groups = Waves.generate(0.1f);
                this.updateWaves();
            }).width(200.0f);
        }
    }

    void view(int amount) {
        this.updateTimer += Time.delta;
        if (this.updateTimer >= this.updatePeriod) {
            this.displayed += amount;
            if (this.displayed < 5) {
                this.displayed = 5;
            }
            this.updateTimer = 0.0f;
            this.updateWaves();
        }
    }

    void shift(int amount) {
        this.updateTimer += Time.delta;
        if (this.updateTimer >= this.updatePeriod) {
            this.start += amount;
            if (this.start < 0) {
                this.start = 0;
            }
            this.updateTimer = 0.0f;
            this.updateWaves();
        }
    }

    void setup() {
        this.groups = JsonIO.copy(Vars.state.rules.spawns.isEmpty() ? Vars.waves.get() : Vars.state.rules.spawns);
        this.cont.clear();
        this.cont.stack(new Table(Tex.clear, main -> {
            main.pane((Table t) -> {
                this.table = t;
            }).growX().growY().padRight(8.0f).get().setScrollingDisabled(true, false);
            main.row();
            main.button("@add", () -> {
                if (this.groups == null) {
                    this.groups = new Seq();
                }
                this.groups.add(new SpawnGroup(this.lastType));
                this.buildGroups();
            }).growX().height(70.0f);
        }), new Label("@waves.none"){
            {
                this.visible(() -> WaveInfoDialog.this.groups.isEmpty());
                this.touchable = Touchable.disabled;
                this.setWrap(true);
                this.setAlignment(1, 1);
            }
        }).width(390.0f).growY();
        this.graph = new WaveGraph();
        this.cont.add(this.graph).grow();
        this.buildGroups();
    }

    void buildGroups() {
        this.table.clear();
        this.table.top();
        this.table.margin(10.0f);
        if (this.groups != null) {
            for (SpawnGroup group : this.groups) {
                this.table.table(Tex.button, t -> {
                    t.margin(0.0f).defaults().pad(3.0f).padLeft(5.0f).growX().left();
                    t.button((Button b) -> {
                        b.left();
                        b.image(group.type.icon(Cicon.medium)).size(32.0f).padRight(3.0f).scaling(Scaling.fit);
                        b.add(group.type.localizedName).color(Pal.accent);
                        b.add().growX();
                        b.button(Icon.cancel, () -> {
                            this.groups.remove(group);
                            this.table.getCell(t).pad(0.0f);
                            t.remove();
                            this.updateWaves();
                        }).pad(-6.0f).size(46.0f).padRight(-12.0f);
                    }, () -> this.showUpdate(group)).height(46.0f).pad(-6.0f).padBottom(0.0f);
                    t.row();
                    t.table((Table spawns) -> {
                        spawns.field("" + (group.begin + 1), TextField.TextFieldFilter.digitsOnly, (String text) -> {
                            if (Strings.canParsePositiveInt(text)) {
                                group.begin = Strings.parseInt(text) - 1;
                                this.updateWaves();
                            }
                        }).width(100.0f);
                        spawns.add("@waves.to").padLeft(4.0f).padRight(4.0f);
                        spawns.field(group.end == Integer.MAX_VALUE ? "" : group.end + 1 + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                            if (Strings.canParsePositiveInt(text)) {
                                group.end = Strings.parseInt(text) - 1;
                                this.updateWaves();
                            } else if (text.isEmpty()) {
                                group.end = Integer.MAX_VALUE;
                                this.updateWaves();
                            }
                        }).width(100.0f).get().setMessageText("\u221e");
                    });
                    t.row();
                    t.table((Table p) -> {
                        p.add("@waves.every").padRight(4.0f);
                        p.field(group.spacing + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                            if (Strings.canParsePositiveInt(text) && Strings.parseInt(text) > 0) {
                                group.spacing = Strings.parseInt(text);
                                this.updateWaves();
                            }
                        }).width(100.0f);
                        p.add("@waves.waves").padLeft(4.0f);
                    });
                    t.row();
                    t.table((Table a) -> {
                        a.field(group.unitAmount + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                            if (Strings.canParsePositiveInt(text)) {
                                group.unitAmount = Strings.parseInt(text);
                                this.updateWaves();
                            }
                        }).width(80.0f);
                        a.add(" + ");
                        a.field(Strings.fixed(Math.max(Mathf.zero(group.unitScaling) ? 0.0f : 1.0f / group.unitScaling, 0.0f), 2), TextField.TextFieldFilter.floatsOnly, (String text) -> {
                            if (Strings.canParsePositiveFloat(text)) {
                                group.unitScaling = 1.0f / Strings.parseFloat(text);
                                this.updateWaves();
                            }
                        }).width(80.0f);
                        a.add("@waves.perspawn").padLeft(4.0f);
                    });
                    t.row();
                    t.table((Table a) -> {
                        a.field((int)group.shields + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                            if (Strings.canParsePositiveInt(text)) {
                                group.shields = Strings.parseInt(text);
                                this.updateWaves();
                            }
                        }).width(80.0f);
                        a.add(" + ");
                        a.field((int)group.shieldScaling + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                            if (Strings.canParsePositiveInt(text)) {
                                group.shieldScaling = Strings.parseInt(text);
                                this.updateWaves();
                            }
                        }).width(80.0f);
                        a.add("@waves.shields").padLeft(4.0f);
                    });
                    t.row();
                    t.check("@waves.guardian", b -> {
                        group.effect = b ? StatusEffects.boss : null;
                    }).padTop(4.0f).update((T b) -> b.setChecked(group.effect == StatusEffects.boss)).padBottom(8.0f);
                }).width(340.0f).pad(8.0f);
                this.table.row();
            }
        } else {
            this.table.add("@editor.default");
        }
        this.updateWaves();
    }

    void showUpdate(SpawnGroup group) {
        BaseDialog dialog = new BaseDialog("");
        dialog.setFillParent(true);
        dialog.cont.pane((Table p) -> {
            int i = 0;
            for (UnitType type : Vars.content.units()) {
                if (type.isHidden()) continue;
                p.button((Button t) -> {
                    t.left();
                    t.image(type.icon(Cicon.medium)).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    t.add(type.localizedName);
                }, () -> {
                    this.lastType = type;
                    group.type = type;
                    dialog.hide();
                    this.buildGroups();
                }).pad(2.0f).margin(12.0f).fillX();
                if (++i % 3 != 0) continue;
                p.row();
            }
        });
        dialog.show();
    }

    void updateWaves() {
        this.graph.groups = this.groups;
        this.graph.from = this.start;
        this.graph.to = this.start + this.displayed;
        this.graph.rebuild();
    }
}

