/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Intc2;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.IntFloatMap;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.Lightning;
import mindustry.entities.Units;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;

public class Damage {
    private static Tile furthest;
    private static Rect rect;
    private static Rect hitrect;
    private static Vec2 tr;
    private static Vec2 seg1;
    private static Vec2 seg2;
    private static Seq<Unit> units;
    private static IntSet collidedBlocks;
    private static Building tmpBuilding;
    private static Unit tmpUnit;
    private static IntFloatMap damages;

    public static void dynamicExplosion(float x, float y, float flammability, float explosiveness, float power, float radius, boolean damage) {
        Damage.dynamicExplosion(x, y, flammability, explosiveness, power, radius, damage, true, null);
    }

    public static void dynamicExplosion(float x, float y, float flammability, float explosiveness, float power, float radius, boolean damage, boolean fire, @Nullable Team ignoreTeam) {
        if (damage) {
            int i = 0;
            while ((float)i < Mathf.clamp(power / 700.0f, 0.0f, 8.0f)) {
                int length = 5 + Mathf.clamp((int)(power / 500.0f), 1, 20);
                Time.run((float)i * 0.8f + Mathf.random(4.0f), () -> Lightning.create(Team.derelict, Pal.power, 3.0f, x, y, Mathf.random(360.0f), length + Mathf.range(2)));
                ++i;
            }
            if (fire) {
                i = 0;
                while ((float)i < Mathf.clamp(flammability / 4.0f, 0.0f, 30.0f)) {
                    Time.run((float)i / 2.0f, () -> Call.createBullet(Bullets.fireball, Team.derelict, x, y, Mathf.random(360.0f), Bullets.fireball.damage, 1.0f, 1.0f));
                    ++i;
                }
            }
            int waves = Mathf.clamp((int)(explosiveness / 4.0f), 0, 30);
            for (int i2 = 0; i2 < waves; ++i2) {
                int f = i2;
                Time.run((float)i2 * 2.0f, () -> {
                    Damage.damage(ignoreTeam, x, y, Mathf.clamp(radius + explosiveness, 0.0f, 50.0f) * (((float)f + 1.0f) / (float)waves), explosiveness / 2.0f, false);
                    Fx.blockExplosionSmoke.at(x + Mathf.range(radius), y + Mathf.range(radius));
                });
            }
        }
        if (explosiveness > 15.0f) {
            Fx.shockwave.at(x, y);
        }
        if (explosiveness > 30.0f) {
            Fx.bigShockwave.at(x, y);
        }
        float shake = Math.min(explosiveness / 4.0f + 3.0f, 9.0f);
        Effect.shake(shake, shake, x, y);
        Fx.dynamicExplosion.at(x, y, radius / 8.0f);
    }

    public static void createIncend(float x, float y, float range, int amount) {
        for (int i = 0; i < amount; ++i) {
            float cy;
            float cx = x + Mathf.range(range);
            Tile tile = Vars.world.tileWorld(cx, cy = y + Mathf.range(range));
            if (tile == null) continue;
            Fires.create(tile);
        }
    }

    public static float findLaserLength(Bullet b, float length) {
        Tmp.v1.trns(b.rotation(), length);
        furthest = null;
        boolean found = Vars.world.raycast(b.tileX(), b.tileY(), World.toTile(b.x + Tmp.v1.x), World.toTile(b.y + Tmp.v1.y), (x, y) -> {
            furthest = Vars.world.tile(x, y);
            return furthest != null && furthest.team() != b.team && Damage.furthest.block().absorbLasers;
        });
        return found && furthest != null ? Math.max(6.0f, b.dst(furthest.worldx(), furthest.worldy())) : length;
    }

    public static float collideLaser(Bullet b, float length, boolean large) {
        float resultLength = Damage.findLaserLength(b, length);
        Damage.collideLine(b, b.team, b.type.hitEffect, b.x, b.y, b.rotation(), resultLength, large);
        b.fdata = resultLength;
        return resultLength;
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length) {
        Damage.collideLine(hitter, team, effect, x, y, angle, length, false);
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length, boolean large) {
        Damage.collideLine(hitter, team, effect, x, y, angle, length, large, true);
    }

    public static void collideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length, boolean large, boolean laser) {
        if (laser) {
            length = Damage.findLaserLength(hitter, length);
        }
        collidedBlocks.clear();
        tr.trns(angle, length);
        Intc2 collider = (cx, cy) -> {
            boolean collide;
            Building tile = Vars.world.build(cx, cy);
            boolean bl = collide = tile != null && collidedBlocks.add(tile.pos());
            if (hitter.damage > 0.0f) {
                float health;
                float f = health = !collide ? 0.0f : tile.health;
                if (collide && tile.team != team && tile.collide(hitter)) {
                    tile.collision(hitter);
                    hitter.type.hit(hitter, tile.x, tile.y);
                }
                if (collide && hitter.type.testCollision(hitter, tile)) {
                    hitter.type.hitTile(hitter, tile, health, false);
                }
            }
        };
        if (hitter.type.collidesGround) {
            seg1.set(x, y);
            seg2.set(seg1).add(tr);
            Vars.world.raycastEachWorld(x, y, Damage.seg2.x, Damage.seg2.y, (cx, cy) -> {
                collider.get(cx, cy);
                for (Point2 p : Geometry.d4) {
                    Tile other = Vars.world.tile(p.x + cx, p.y + cy);
                    if (other == null || !large && !Intersector.intersectSegmentRectangle(seg1, seg2, other.getBounds(Tmp.r1))) continue;
                    collider.get(cx + p.x, cy + p.y);
                }
                return false;
            });
        }
        rect.setPosition(x, y).setSize(Damage.tr.x, Damage.tr.y);
        float x2 = Damage.tr.x + x;
        float y2 = Damage.tr.y + y;
        if (Damage.rect.width < 0.0f) {
            Damage.rect.x += Damage.rect.width;
            Damage.rect.width *= -1.0f;
        }
        if (Damage.rect.height < 0.0f) {
            Damage.rect.y += Damage.rect.height;
            Damage.rect.height *= -1.0f;
        }
        float expand = 3.0f;
        Damage.rect.y -= expand;
        Damage.rect.x -= expand;
        Damage.rect.width += expand * 2.0f;
        Damage.rect.height += expand * 2.0f;
        Cons<Unit> cons = e -> {
            e.hitbox(hitrect);
            Vec2 vec = Geometry.raycastRect(x, y, x2, y2, hitrect.grow(expand * 2.0f));
            if (vec != null && hitter.damage > 0.0f) {
                effect.at(vec.x, vec.y);
                e.collision(hitter, vec.x, vec.y);
                hitter.collision((Hitboxc)e, vec.x, vec.y);
            }
        };
        units.clear();
        Units.nearbyEnemies(team, rect, u -> {
            if (u.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround)) {
                units.add((Unit)u);
            }
        });
        units.sort(u -> u.dst2(hitter));
        units.each(cons);
    }

    public static Healthc linecast(Bullet hitter, float x, float y, float angle, float length) {
        tr.trns(angle, length);
        tmpBuilding = null;
        if (hitter.type.collidesGround) {
            Vars.world.raycastEachWorld(x, y, x + Damage.tr.x, y + Damage.tr.y, (cx, cy) -> {
                Building tile = Vars.world.build(cx, cy);
                if (tile != null && tile.team != hitter.team) {
                    tmpBuilding = tile;
                    return true;
                }
                return false;
            });
        }
        rect.setPosition(x, y).setSize(Damage.tr.x, Damage.tr.y);
        float x2 = Damage.tr.x + x;
        float y2 = Damage.tr.y + y;
        if (Damage.rect.width < 0.0f) {
            Damage.rect.x += Damage.rect.width;
            Damage.rect.width *= -1.0f;
        }
        if (Damage.rect.height < 0.0f) {
            Damage.rect.y += Damage.rect.height;
            Damage.rect.height *= -1.0f;
        }
        float expand = 3.0f;
        Damage.rect.y -= expand;
        Damage.rect.x -= expand;
        Damage.rect.width += expand * 2.0f;
        Damage.rect.height += expand * 2.0f;
        tmpUnit = null;
        Units.nearbyEnemies(hitter.team, rect, e -> {
            if (tmpUnit != null && e.dst2(x, y) > tmpUnit.dst2(x, y) || !e.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround)) {
                return;
            }
            e.hitbox(hitrect);
            Rect other = hitrect;
            other.y -= expand;
            other.x -= expand;
            other.width += expand * 2.0f;
            other.height += expand * 2.0f;
            Vec2 vec = Geometry.raycastRect(x, y, x2, y2, other);
            if (vec != null) {
                tmpUnit = e;
            }
        });
        if (tmpBuilding != null && tmpUnit != null) {
            if (Mathf.dst2(x, y, tmpUnit.getX(), tmpUnit.getY()) <= Mathf.dst2(x, y, tmpBuilding.getX(), tmpBuilding.getY())) {
                return tmpUnit;
            }
        } else if (tmpBuilding != null) {
            return tmpBuilding;
        }
        return tmpUnit;
    }

    public static void damageUnits(Team team, float x, float y, float size, float damage, Boolf<Unit> predicate, Cons<Unit> acceptor) {
        Cons<Unit> cons = entity -> {
            if (!predicate.get((Unit)entity)) {
                return;
            }
            entity.hitbox(hitrect);
            if (!hitrect.overlaps(rect)) {
                return;
            }
            entity.damage(damage);
            acceptor.get((Unit)entity);
        };
        rect.setSize(size * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
    }

    public static void damage(float x, float y, float radius, float damage) {
        Damage.damage(null, x, y, radius, damage, false);
    }

    public static void damage(Team team, float x, float y, float radius, float damage) {
        Damage.damage(team, x, y, radius, damage, false);
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean air, boolean ground) {
        Damage.damage(team, x, y, radius, damage, false, air, ground);
    }

    public static void status(Team team, float x, float y, float radius, StatusEffect effect, float duration, boolean air, boolean ground) {
        Cons<Unit> cons = entity -> {
            if (entity.team == team || !entity.within(x, y, radius) || entity.isFlying() && !air || entity.isGrounded() && !ground) {
                return;
            }
            entity.apply(effect, duration);
        };
        rect.setSize(radius * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean complete) {
        Damage.damage(team, x, y, radius, damage, complete, true, true);
    }

    public static void damage(Team team, float x, float y, float radius, float damage, boolean complete, boolean air, boolean ground) {
        Cons<Unit> cons = entity -> {
            if (entity.team == team || !entity.within(x, y, radius) || entity.isFlying() && !air || entity.isGrounded() && !ground) {
                return;
            }
            float amount = Damage.calculateDamage(x, y, entity.getX(), entity.getY(), radius, damage);
            entity.damage(amount);
            float dst = tr.set(entity.getX() - x, entity.getY() - y).len();
            entity.vel.add(tr.setLength((1.0f - dst / radius) * 2.0f / entity.mass()));
            if (complete && damage >= 9999999.0f && entity.isPlayer()) {
                Events.fire(EventType.Trigger.exclusionDeath);
            }
        };
        rect.setSize(radius * 2.0f).setCenter(x, y);
        if (team != null) {
            Units.nearbyEnemies(team, rect, cons);
        } else {
            Units.nearby(rect, cons);
        }
        if (ground) {
            if (!complete) {
                Damage.tileDamage(team, World.toTile(x), World.toTile(y), radius / 8.0f, damage);
            } else {
                Damage.completeDamage(team, x, y, radius, damage);
            }
        }
    }

    public static void tileDamage(Team team, int x, int y, float baseRadius, float damage) {
        Core.app.post(() -> {
            Building in = Vars.world.build(x, y);
            if (in != null && in.team != team && in.block.size > 1 && in.health > damage) {
                in.damage(damage * Math.min((float)in.block.size, baseRadius * 0.45f));
                return;
            }
            float radius = Math.min(baseRadius, 30.0f);
            float rad2 = radius * radius;
            int rays = Mathf.ceil(radius * 2.0f * (float)Math.PI);
            double spacing = Math.PI * 2 / (double)rays;
            damages.clear();
            block0: for (int i = 0; i <= rays; ++i) {
                float dealt = 0.0f;
                int startX = x;
                int startY = y;
                int endX = x + (int)(Math.cos(spacing * (double)i) * (double)radius);
                int endY = y + (int)(Math.sin(spacing * (double)i) * (double)radius);
                int xDist = Math.abs(endX - startX);
                int yDist = -Math.abs(endY - startY);
                int xStep = startX < endX ? 1 : -1;
                int yStep = startY < endY ? 1 : -1;
                int error = xDist + yDist;
                while (startX != endX || startY != endY) {
                    Building build = Vars.world.build(startX, startY);
                    if (build != null && build.team != team) {
                        float edgeScale = 0.6f;
                        float mult = (1.0f - Mathf.dst2(startX, startY, x, y) / rad2 + edgeScale) / (1.0f + edgeScale);
                        float next = damage * mult - dealt;
                        int p = Point2.pack(startX, startY);
                        damages.put(p, Math.max(damages.get(p), next));
                        if (next - (dealt += build.health) <= 0.0f) continue block0;
                    }
                    if (2 * error - yDist > xDist - 2 * error) {
                        error += yDist;
                        startX += xStep;
                        continue;
                    }
                    error += xDist;
                    startY += yStep;
                }
            }
            for (IntFloatMap.Entry e : damages) {
                short cy;
                short cx = Point2.x(e.key);
                Building build = Vars.world.build(cx, cy = Point2.y(e.key));
                if (build == null) continue;
                build.damage(e.value);
            }
        });
    }

    private static void completeDamage(Team team, float x, float y, float radius, float damage) {
        int trad = (int)(radius / 8.0f);
        for (int dx = -trad; dx <= trad; ++dx) {
            for (int dy = -trad; dy <= trad; ++dy) {
                Tile tile = Vars.world.tile(Math.round(x / 8.0f) + dx, Math.round(y / 8.0f) + dy);
                if (tile == null || tile.build == null || team != null && !team.isEnemy(tile.team()) || !(Mathf.dst(dx, dy) <= (float)trad)) continue;
                tile.build.damage(damage);
            }
        }
    }

    private static float calculateDamage(float x, float y, float tx, float ty, float radius, float damage) {
        float dist = Mathf.dst(x, y, tx, ty);
        float falloff = 0.4f;
        float scaled = Mathf.lerp(1.0f - dist / radius, 1.0f, falloff);
        return damage * scaled;
    }

    static {
        rect = new Rect();
        hitrect = new Rect();
        tr = new Vec2();
        seg1 = new Vec2();
        seg2 = new Vec2();
        units = new Seq();
        collidedBlocks = new IntSet();
        damages = new IntFloatMap();
    }
}

