/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Scaled;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.gen.Decal;
import mindustry.gen.EffectState;
import mindustry.gen.Posc;
import mindustry.graphics.Pal;
import mindustry.world.Tile;

public class Effect {
    private static final float shakeFalloff = 10000.0f;
    private static final EffectContainer container = new EffectContainer();
    private static final Seq<Effect> all = new Seq();
    private boolean initialized;
    public final int id;
    public Cons<EffectContainer> renderer;
    public float lifetime;
    public float clip;
    public float layer;
    public float layerDuration;

    public Effect(float life, float clipsize, Cons<EffectContainer> renderer) {
        this.renderer = e -> {};
        this.lifetime = 50.0f;
        this.layer = 110.0f;
        this.id = Effect.all.size;
        this.lifetime = life;
        this.renderer = renderer;
        this.clip = clipsize;
        all.add(this);
    }

    public Effect(float life, Cons<EffectContainer> renderer) {
        this(life, 50.0f, renderer);
    }

    public Effect() {
        this.renderer = e -> {};
        this.lifetime = 50.0f;
        this.layer = 110.0f;
        this.id = Effect.all.size;
        all.add(this);
    }

    public void init() {
    }

    public Effect layer(float l) {
        this.layer = l;
        return this;
    }

    public Effect layer(float l, float duration) {
        this.layer = l;
        this.layerDuration = duration;
        return this;
    }

    public void at(Position pos) {
        Effect.create(this, pos.getX(), pos.getY(), 0.0f, Color.white, null);
    }

    public void at(Position pos, float rotation) {
        Effect.create(this, pos.getX(), pos.getY(), rotation, Color.white, null);
    }

    public void at(float x, float y) {
        Effect.create(this, x, y, 0.0f, Color.white, null);
    }

    public void at(float x, float y, float rotation) {
        Effect.create(this, x, y, rotation, Color.white, null);
    }

    public void at(float x, float y, float rotation, Color color) {
        Effect.create(this, x, y, rotation, color, null);
    }

    public void at(float x, float y, Color color) {
        Effect.create(this, x, y, 0.0f, color, null);
    }

    public void at(float x, float y, float rotation, Color color, Object data) {
        Effect.create(this, x, y, rotation, color, data);
    }

    public void at(float x, float y, float rotation, Object data) {
        Effect.create(this, x, y, rotation, Color.white, data);
    }

    public float render(int id, Color color, float life, float lifetime, float rotation, float x, float y, Object data) {
        container.set(id, color, life, lifetime, rotation, x, y, data);
        Draw.z(this.layer);
        Draw.reset();
        this.render(container);
        Draw.reset();
        return Effect.container.lifetime;
    }

    public void render(EffectContainer e) {
        this.renderer.get(e);
    }

    @Nullable
    public static Effect get(int id) {
        return id >= Effect.all.size || id < 0 ? null : all.get(id);
    }

    private static void shake(float intensity, float duration) {
        if (!Vars.headless) {
            Vars.renderer.shake(intensity, duration);
        }
    }

    public static void shake(float intensity, float duration, float x, float y) {
        if (Core.camera == null) {
            return;
        }
        float distance = Core.camera.position.dst(x, y);
        if (distance < 1.0f) {
            distance = 1.0f;
        }
        Effect.shake(Mathf.clamp(1.0f / (distance * distance / 10000.0f)) * intensity, duration);
    }

    public static void shake(float intensity, float duration, Position loc) {
        Effect.shake(intensity, duration, loc.getX(), loc.getY());
    }

    public static void create(Effect effect, float x, float y, float rotation, Color color, Object data) {
        Rect pos;
        Rect view;
        if (Vars.headless || effect == Fx.none) {
            return;
        }
        if (Core.settings.getBool("effects") && (view = Core.camera.bounds(Tmp.r1)).overlaps(pos = Tmp.r2.setSize(effect.clip).setCenter(x, y))) {
            if (!effect.initialized) {
                effect.initialized = true;
                effect.init();
            }
            EffectState entity = EffectState.create();
            entity.effect = effect;
            entity.rotation = rotation;
            entity.data = data;
            entity.lifetime = effect.lifetime;
            entity.set(x, y);
            entity.color.set(color);
            if (data instanceof Posc) {
                entity.parent = (Posc)data;
            }
            entity.add();
        }
    }

    public static void decal(TextureRegion region, float x, float y, float rotation) {
        Effect.decal(region, x, y, rotation, 3600.0f, Pal.rubble);
    }

    public static void decal(TextureRegion region, float x, float y, float rotation, float lifetime, Color color) {
        if (Vars.headless || region == null || !Core.atlas.isFound(region)) {
            return;
        }
        Tile tile = Vars.world.tileWorld(x, y);
        if (tile == null || !tile.floor().hasSurface()) {
            return;
        }
        Decal decal = Decal.create();
        decal.set(x, y);
        decal.rotation(rotation);
        decal.lifetime(lifetime);
        decal.color().set(color);
        decal.region(region);
        decal.add();
    }

    public static void scorch(float x, float y, int size) {
        if (Vars.headless) {
            return;
        }
        size = Mathf.clamp(size, 0, 9);
        TextureAtlas.AtlasRegion region = Core.atlas.find("scorch-" + size + "-" + Mathf.random(2));
        Effect.decal(region, x, y, Mathf.random(4) * 90, 3600.0f, Pal.rubble);
    }

    public static void rubble(float x, float y, int blockSize) {
        if (Vars.headless) {
            return;
        }
        TextureAtlas.AtlasRegion region = Core.atlas.find("rubble-" + blockSize + "-" + (Core.atlas.has("rubble-" + blockSize + "-1") ? Integer.valueOf(Mathf.random(0, 1)) : "0"));
        Effect.decal(region, x, y, Mathf.random(4) * 90, 3600.0f, Pal.rubble);
    }

    public static class EffectContainer
    implements Scaled {
        public float x;
        public float y;
        public float time;
        public float lifetime;
        public float rotation;
        public Color color;
        public int id;
        public Object data;
        private EffectContainer innerContainer;

        public void set(int id, Color color, float life, float lifetime, float rotation, float x, float y, Object data) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.time = life;
            this.lifetime = lifetime;
            this.id = id;
            this.rotation = rotation;
            this.data = data;
        }

        public <T> T data() {
            return (T)this.data;
        }

        public void scaled(float lifetime, Cons<EffectContainer> cons) {
            if (this.innerContainer == null) {
                this.innerContainer = new EffectContainer();
            }
            if (this.time <= lifetime) {
                this.innerContainer.set(this.id, this.color, this.time, lifetime, this.rotation, this.x, this.y, this.data);
                cons.get(this.innerContainer);
            }
        }

        @Override
        public float fin() {
            return this.time / this.lifetime;
        }
    }
}

