/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.EntityGroup;
import mindustry.gen.Hitboxc;
import mindustry.world.Tile;

public class EntityCollisions {
    private static final int r = 1;
    private static final float seg = 1.0f;
    private Rect tmp = new Rect();
    private Vec2 vector = new Vec2();
    private Vec2 l1 = new Vec2();
    private Rect r1 = new Rect();
    private Rect r2 = new Rect();
    private Seq<Hitboxc> arrOut = new Seq();

    public void moveCheck(Hitboxc entity, float deltax, float deltay, SolidPred solidCheck) {
        if (!solidCheck.solid(entity.tileX(), entity.tileY())) {
            this.move(entity, deltax, deltay, solidCheck);
        }
    }

    public void move(Hitboxc entity, float deltax, float deltay) {
        this.move(entity, deltax, deltay, EntityCollisions::solid);
    }

    public void move(Hitboxc entity, float deltax, float deltay, SolidPred solidCheck) {
        if (Math.abs(deltax) < 1.0E-4f & Math.abs(deltay) < 1.0E-4f) {
            return;
        }
        boolean movedx = false;
        while (Math.abs(deltax) > 0.0f || !movedx) {
            movedx = true;
            this.moveDelta(entity, Math.min(Math.abs(deltax), 1.0f) * (float)Mathf.sign(deltax), 0.0f, true, solidCheck);
            if (Math.abs(deltax) >= 1.0f) {
                deltax -= 1.0f * (float)Mathf.sign(deltax);
                continue;
            }
            deltax = 0.0f;
        }
        boolean movedy = false;
        while (Math.abs(deltay) > 0.0f || !movedy) {
            movedy = true;
            this.moveDelta(entity, 0.0f, Math.min(Math.abs(deltay), 1.0f) * (float)Mathf.sign(deltay), false, solidCheck);
            if (Math.abs(deltay) >= 1.0f) {
                deltay -= 1.0f * (float)Mathf.sign(deltay);
                continue;
            }
            deltay = 0.0f;
        }
    }

    public void moveDelta(Hitboxc entity, float deltax, float deltay, boolean x, SolidPred solidCheck) {
        entity.hitboxTile(this.r1);
        entity.hitboxTile(this.r2);
        this.r1.x += deltax;
        this.r1.y += deltay;
        int tilex = Math.round((this.r1.x + this.r1.width / 2.0f) / 8.0f);
        int tiley = Math.round((this.r1.y + this.r1.height / 2.0f) / 8.0f);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                int wx = dx + tilex;
                int wy = dy + tiley;
                if (!solidCheck.solid(wx, wy)) continue;
                this.tmp.setSize(8.0f).setCenter(wx * 8, wy * 8);
                if (!this.tmp.overlaps(this.r1)) continue;
                Vec2 v = Geometry.overlap(this.r1, this.tmp, x);
                if (x) {
                    this.r1.x += v.x;
                }
                if (x) continue;
                this.r1.y += v.y;
            }
        }
        entity.trns(this.r1.x - this.r2.x, this.r1.y - this.r2.y);
    }

    public boolean overlapsTile(Rect rect) {
        rect.getCenter(this.vector);
        int r = 1;
        int tilex = Math.round(this.vector.x / 8.0f);
        int tiley = Math.round(this.vector.y / 8.0f);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                int wx = dx + tilex;
                int wy = dy + tiley;
                if (!EntityCollisions.solid(wx, wy)) continue;
                this.r2.setSize(8.0f).setCenter(wx * 8, wy * 8);
                if (!this.r2.overlaps(rect)) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends Hitboxc> void updatePhysics(EntityGroup<T> group) {
        QuadTree tree = group.tree();
        tree.clear();
        group.each(s -> {
            s.updateLastPosition();
            tree.insert(s);
        });
    }

    public static boolean legsSolid(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        return tile == null || tile.staticDarkness() >= 2 || tile.floor().solid && tile.block() == Blocks.air;
    }

    public static boolean waterSolid(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        return tile == null || tile.solid() || !tile.floor().isLiquid;
    }

    public static boolean solid(int x, int y) {
        Tile tile = Vars.world.tile(x, y);
        return tile == null || tile.solid();
    }

    private void checkCollide(Hitboxc a, Hitboxc b) {
        a.hitbox(this.r1);
        b.hitbox(this.r2);
        this.r1.x += a.lastX() - a.getX();
        this.r1.y += a.lastY() - a.getY();
        this.r2.x += b.lastX() - b.getX();
        this.r2.y += b.lastY() - b.getY();
        float vax = a.getX() - a.lastX();
        float vay = a.getY() - a.lastY();
        float vbx = b.getX() - b.lastX();
        float vby = b.getY() - b.lastY();
        if (a != b && a.collides(b)) {
            boolean collide;
            this.l1.set(a.getX(), a.getY());
            boolean bl = collide = this.r1.overlaps(this.r2) || this.collide(this.r1.x, this.r1.y, this.r1.width, this.r1.height, vax, vay, this.r2.x, this.r2.y, this.r2.width, this.r2.height, vbx, vby, this.l1);
            if (collide) {
                a.collision(b, this.l1.x, this.l1.y);
                b.collision(a, this.l1.x, this.l1.y);
            }
        }
    }

    private boolean collide(float x1, float y1, float w1, float h1, float vx1, float vy1, float x2, float y2, float w2, float h2, float vx2, float vy2, Vec2 out) {
        float yInvExit;
        float yInvEntry;
        float xInvExit;
        float xInvEntry;
        float px = vx1;
        float py = vy1;
        vx1 -= vx2;
        vy1 -= vy2;
        if (vx1 > 0.0f) {
            xInvEntry = x2 - (x1 + w1);
            xInvExit = x2 + w2 - x1;
        } else {
            xInvEntry = x2 + w2 - x1;
            xInvExit = x2 - (x1 + w1);
        }
        if (vy1 > 0.0f) {
            yInvEntry = y2 - (y1 + h1);
            yInvExit = y2 + h2 - y1;
        } else {
            yInvEntry = y2 + h2 - y1;
            yInvExit = y2 - (y1 + h1);
        }
        float xEntry = xInvEntry / vx1;
        float xExit = xInvExit / vx1;
        float yEntry = yInvEntry / vy1;
        float yExit = yInvExit / vy1;
        float entryTime = Math.max(xEntry, yEntry);
        float exitTime = Math.min(xExit, yExit);
        if (entryTime > exitTime || xExit < 0.0f || yExit < 0.0f || xEntry > 1.0f || yEntry > 1.0f) {
            return false;
        }
        float dx = x1 + w1 / 2.0f + px * entryTime;
        float dy = y1 + h1 / 2.0f + py * entryTime;
        out.set(dx, dy);
        return true;
    }

    public <T extends Hitboxc> void collide(EntityGroup<T> groupa) {
        groupa.each(solid -> {
            solid.hitbox(this.r1);
            this.r1.x += solid.lastX() - solid.getX();
            this.r1.y += solid.lastY() - solid.getY();
            solid.hitbox(this.r2);
            this.r2.merge(this.r1);
            this.arrOut.clear();
            solid.getCollisions(tree -> tree.intersect(this.r2, this.arrOut));
            for (Hitboxc sc : this.arrOut) {
                sc.hitbox(this.r1);
                if (!this.r2.overlaps(this.r1)) continue;
                this.checkCollide((Hitboxc)solid, sc);
                if (solid.isAdded()) continue;
                return;
            }
        });
    }

    public static interface SolidPred {
        public boolean solid(int var1, int var2);
    }
}

