/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.struct.IntMap;
import arc.struct.Seq;
import arc.util.Nullable;
import java.util.Comparator;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;

public class EntityGroup<T extends Entityc>
implements Iterable<T> {
    private static int lastId = 0;
    private final Seq<T> array;
    private final Seq<T> intersectArray = new Seq();
    private final Rect viewport = new Rect();
    private final Rect intersectRect = new Rect();
    private IntMap<T> map;
    private QuadTree tree;
    private boolean clearing;
    private int index;

    public static int nextId() {
        return lastId++;
    }

    public EntityGroup(Class<T> type, boolean spatial, boolean mapping) {
        this.array = new Seq(false, 32, type);
        if (spatial) {
            this.tree = new QuadTree(new Rect(0.0f, 0.0f, 0.0f, 0.0f));
        }
        if (mapping) {
            this.map = new IntMap();
        }
    }

    public void sort(Comparator<? super T> comp) {
        this.array.sort(comp);
    }

    public void collide() {
        Vars.collisions.collide(this);
    }

    public void updatePhysics() {
        Vars.collisions.updatePhysics(this);
    }

    public void update() {
        this.index = 0;
        while (this.index < this.array.size) {
            ((Entityc[])this.array.items)[this.index].update();
            ++this.index;
        }
    }

    public Seq<T> copy(Seq<T> arr) {
        arr.addAll(this.array);
        return arr;
    }

    public void each(Cons<T> cons) {
        this.index = 0;
        while (this.index < this.array.size) {
            cons.get(((Entityc[])this.array.items)[this.index]);
            ++this.index;
        }
    }

    public void each(Boolf<T> filter, Cons<T> cons) {
        this.index = 0;
        while (this.index < this.array.size) {
            if (filter.get(((Entityc[])this.array.items)[this.index])) {
                cons.get(((Entityc[])this.array.items)[this.index]);
            }
            ++this.index;
        }
    }

    public void draw(Cons<T> cons) {
        Core.camera.bounds(this.viewport);
        this.each(e -> {
            Drawc draw = (Drawc)e;
            if (this.viewport.overlaps(draw.x() - draw.clipSize() / 2.0f, draw.y() - draw.clipSize() / 2.0f, draw.clipSize(), draw.clipSize())) {
                cons.get(e);
            }
        });
    }

    public boolean useTree() {
        return this.map != null;
    }

    public boolean mappingEnabled() {
        return this.map != null;
    }

    @Nullable
    public T getByID(int id) {
        if (this.map == null) {
            throw new RuntimeException("Mapping is not enabled for group " + id + "!");
        }
        return (T)((Entityc)this.map.get(id));
    }

    public void removeByID(int id) {
        if (this.map == null) {
            throw new RuntimeException("Mapping is not enabled for group " + id + "!");
        }
        Entityc t = (Entityc)this.map.get(id);
        if (t != null) {
            t.remove();
        }
    }

    public void intersect(float x, float y, float width, float height, Cons<? super T> out) {
        if (this.isEmpty()) {
            return;
        }
        this.tree.intersect(x, y, width, height, out);
    }

    public Seq<T> intersect(float x, float y, float width, float height) {
        this.intersectArray.clear();
        if (this.isEmpty()) {
            return this.intersectArray;
        }
        this.tree.intersect(this.intersectRect.set(x, y, width, height), this.intersectArray);
        return this.intersectArray;
    }

    public QuadTree tree() {
        if (this.tree == null) {
            throw new RuntimeException("This group does not support quadtrees! Enable quadtrees when creating it.");
        }
        return this.tree;
    }

    public void resize(float x, float y, float w, float h) {
        if (this.tree != null) {
            this.tree = new QuadTree(new Rect(x, y, w, h));
        }
    }

    public boolean isEmpty() {
        return this.array.size == 0;
    }

    public T index(int i) {
        return (T)((Entityc)this.array.get(i));
    }

    public int size() {
        return this.array.size;
    }

    public boolean contains(Boolf<T> pred) {
        return this.array.contains(pred);
    }

    public int count(Boolf<T> pred) {
        return this.array.count(pred);
    }

    public void add(T type) {
        if (type == null) {
            throw new RuntimeException("Cannot add a null entity!");
        }
        this.array.add(type);
        if (this.mappingEnabled()) {
            this.map.put(type.id(), type);
        }
    }

    public void remove(T type) {
        if (this.clearing) {
            return;
        }
        if (type == null) {
            throw new RuntimeException("Cannot remove a null entity!");
        }
        int idx = this.array.indexOf(type, true);
        if (idx != -1) {
            this.array.remove(idx);
            if (this.map != null) {
                this.map.remove(type.id());
            }
            if (this.index >= idx) {
                --this.index;
            }
        }
    }

    public void clear() {
        this.clearing = true;
        this.array.each(Entityc::remove);
        this.array.clear();
        if (this.map != null) {
            this.map.clear();
        }
        this.clearing = false;
    }

    @Nullable
    public T find(Boolf<T> pred) {
        return (T)((Entityc)this.array.find(pred));
    }

    @Nullable
    public T first() {
        return (T)((Entityc)this.array.first());
    }

    @Override
    public Iterator<T> iterator() {
        return this.array.iterator();
    }
}

