/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Unitc;
import mindustry.world.Tile;

public class Lightning {
    private static final Rand random = new Rand();
    private static final Rect rect = new Rect();
    private static final Seq<Unitc> entities = new Seq();
    private static final IntSet hit = new IntSet();
    private static final int maxChain = 8;
    private static final float hitRange = 30.0f;
    private static boolean bhit = false;
    private static int lastSeed = 0;

    public static void create(Team team, Color color, float damage, float x, float y, float targetAngle, int length) {
        Lightning.createLightningInternal(null, lastSeed++, team, color, damage, x, y, targetAngle, length);
    }

    public static void create(Bullet bullet, Color color, float damage, float x, float y, float targetAngle, int length) {
        Lightning.createLightningInternal(bullet, lastSeed++, bullet.team, color, damage, x, y, targetAngle, length);
    }

    private static void createLightningInternal(@Nullable Bullet hitter, int seed, Team team, Color color, float damage, float x, float y, float rotation, int length) {
        random.setSeed(seed);
        hit.clear();
        BulletType hitCreate = hitter == null || hitter.type.lightningType == null ? Bullets.damageLightning : hitter.type.lightningType;
        Seq<Vec2> lines = new Seq<Vec2>();
        bhit = false;
        for (int i = 0; i < length / 2; ++i) {
            Unitc furthest;
            hitCreate.create(null, team, x, y, 0.0f, damage, 1.0f, 1.0f, hitter);
            lines.add(new Vec2(x + Mathf.range(3.0f), y + Mathf.range(3.0f)));
            if (lines.size > 1) {
                bhit = false;
                Vec2 from = (Vec2)lines.get(lines.size - 2);
                Vec2 to = (Vec2)lines.get(lines.size - 1);
                Vars.world.raycastEach(World.toTile(from.getX()), World.toTile(from.getY()), World.toTile(to.getX()), World.toTile(to.getY()), (wx, wy) -> {
                    Tile tile = Vars.world.tile(wx, wy);
                    if (tile != null && tile.block().insulated && tile.team() != team) {
                        bhit = true;
                        ((Vec2)lines.get(lines.size - 1)).set(wx * 8, wy * 8);
                        return true;
                    }
                    return false;
                });
                if (bhit) break;
            }
            rect.setSize(30.0f).setCenter(x, y);
            entities.clear();
            if (Lightning.hit.size < 8) {
                Units.nearbyEnemies(team, rect, u -> {
                    if (!hit.contains(u.id()) && (hitter == null || u.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround))) {
                        entities.add((Unitc)u);
                    }
                });
            }
            if ((furthest = Geometry.findFurthest(x, y, entities)) != null) {
                hit.add(furthest.id());
                x = furthest.x();
                y = furthest.y();
                continue;
            }
            x += Angles.trnsx(rotation += random.range(20.0f), 15.0f);
            y += Angles.trnsy(rotation, 15.0f);
        }
        Fx.lightning.at(x, y, rotation, color, lines);
    }
}

