/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.gen.Hitboxc;

public class Predict {
    private static Vec2 vec = new Vec2();
    private static Vec2 vresult = new Vec2();

    public static Vec2 intercept(float srcx, float srcy, float dstx, float dsty, float dstvx, float dstvy, float v) {
        float tx = dstx - srcx;
        float ty = dsty - srcy;
        float a = (dstvx /= Time.delta) * dstvx + (dstvy /= Time.delta) * dstvy - v * v;
        float b = 2.0f * (dstvx * tx + dstvy * ty);
        float c = tx * tx + ty * ty;
        Vec2 ts = Predict.quad(a, b, c);
        Vec2 sol = vresult.set(dstx, dsty);
        if (ts != null) {
            float t0 = ts.x;
            float t1 = ts.y;
            float t = Math.min(t0, t1);
            if (t < 0.0f) {
                t = Math.max(t0, t1);
            }
            if (t > 0.0f) {
                sol.set(dstx + dstvx * t, dsty + dstvy * t);
            }
        }
        return sol;
    }

    public static Vec2 intercept(Position src, Position dst, float v) {
        Hitboxc h;
        float ddx = 0.0f;
        float ddy = 0.0f;
        Position position = dst;
        if (position instanceof Hitboxc && (h = (Hitboxc)position) == (Hitboxc)position) {
            ddx += h.deltaX();
            ddy += h.deltaY();
        }
        if ((position = src) instanceof Hitboxc && (h = (Hitboxc)position) == (Hitboxc)position) {
            ddx -= h.deltaX();
            ddy -= h.deltaY();
        }
        return Predict.intercept(src.getX(), src.getY(), dst.getX(), dst.getY(), ddx, ddy, v);
    }

    public static Vec2 intercept(Hitboxc src, Hitboxc dst, float v) {
        return Predict.intercept(src.getX(), src.getY(), dst.getX(), dst.getY(), dst.deltaX() - src.deltaX() / (2.0f * Time.delta), dst.deltaY() - src.deltaX() / (2.0f * Time.delta), v);
    }

    private static Vec2 quad(float a, float b, float c) {
        Vec2 sol = null;
        if ((double)Math.abs(a) < 1.0E-6) {
            if ((double)Math.abs(b) < 1.0E-6) {
                sol = (double)Math.abs(c) < 1.0E-6 ? vec.set(0.0f, 0.0f) : null;
            } else {
                vec.set(-c / b, -c / b);
            }
        } else {
            float disc = b * b - 4.0f * a * c;
            if (disc >= 0.0f) {
                disc = Mathf.sqrt(disc);
                a = 2.0f * a;
                sol = vec.set((-b - disc) / a, (-b + disc) / a);
            }
        }
        return sol;
    }
}

