/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.math.Mathf;
import arc.struct.IntMap;
import arc.util.Time;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.entities.Fires;
import mindustry.game.Team;
import mindustry.gen.Puddle;
import mindustry.type.Liquid;
import mindustry.world.Tile;

public class Puddles {
    private static final IntMap<Puddle> map = new IntMap();
    public static final float maxLiquid = 70.0f;

    public static void deposit(Tile tile, Tile source, Liquid liquid, float amount) {
        Puddles.deposit(tile, source, liquid, amount, 0);
    }

    public static void deposit(Tile tile, Liquid liquid, float amount) {
        Puddles.deposit(tile, tile, liquid, amount, 0);
    }

    public static Puddle get(Tile tile) {
        return map.get(tile.pos());
    }

    public static void deposit(Tile tile, Tile source, Liquid liquid, float amount, int generation) {
        if (tile == null) {
            return;
        }
        if (tile.floor().isLiquid && !Puddles.canStayOn(liquid, tile.floor().liquidDrop)) {
            Puddles.reactPuddle(tile.floor().liquidDrop, liquid, amount, tile, (tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f);
            Puddle p = map.get(tile.pos());
            if (generation == 0 && p != null && p.lastRipple <= Time.time - 40.0f) {
                Fx.ripple.at((tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f, 1.0f, tile.floor().liquidDrop.color);
                p.lastRipple = Time.time;
            }
            return;
        }
        if (tile.floor().solid) {
            return;
        }
        Puddle p = map.get(tile.pos());
        if (p == null) {
            Puddle puddle = Puddle.create();
            puddle.tile(tile);
            puddle.liquid(liquid);
            puddle.amount(amount);
            puddle.generation(generation);
            puddle.set((tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f);
            puddle.add();
            map.put(tile.pos(), puddle);
        } else if (p.liquid() == liquid) {
            p.accepting(Math.max(amount, p.accepting()));
            if (generation == 0 && p.lastRipple <= Time.time - 40.0f && p.amount() >= 35.0f) {
                Fx.ripple.at((tile.worldx() + source.worldx()) / 2.0f, (tile.worldy() + source.worldy()) / 2.0f, 1.0f, p.liquid().color);
                p.lastRipple = Time.time;
            }
        } else {
            p.amount(p.amount() + Puddles.reactPuddle(p.liquid(), liquid, amount, p.tile(), (p.x() + source.worldx()) / 2.0f, (p.y() + source.worldy()) / 2.0f));
        }
    }

    public static void remove(Tile tile) {
        if (tile == null) {
            return;
        }
        map.remove(tile.pos());
    }

    public static void register(Puddle puddle) {
        map.put(puddle.tile().pos(), puddle);
    }

    private static float reactPuddle(Liquid dest, Liquid liquid, float amount, Tile tile, float x, float y) {
        if (dest.flammability > 0.3f && liquid.temperature > 0.7f || liquid.flammability > 0.3f && dest.temperature > 0.7f) {
            Fires.create(tile);
            if (Mathf.chance(0.006 * (double)amount)) {
                Bullets.fireball.createNet(Team.derelict, x, y, Mathf.random(360.0f), -1.0f, 1.0f, 1.0f);
            }
        } else {
            if (dest.temperature > 0.7f && liquid.temperature < 0.55f) {
                if (Mathf.chance(0.5f * amount)) {
                    Fx.steam.at(x, y);
                }
                return -0.1f * amount;
            }
            if (liquid.temperature > 0.7f && dest.temperature < 0.55f) {
                if (Mathf.chance(0.8f * amount)) {
                    Fx.steam.at(x, y);
                }
                return -0.4f * amount;
            }
        }
        return 0.0f;
    }

    private static boolean canStayOn(Liquid liquid, Liquid other) {
        return liquid == Liquids.oil && other == Liquids.water;
    }
}

