/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Core;
import arc.func.Boolf;
import arc.func.Cons;
import arc.math.geom.Geometry;
import arc.math.geom.Rect;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.comp.Sized;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Player;
import mindustry.gen.Posc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.world.Tile;

public class Units {
    private static final Rect hitrect = new Rect();
    private static Unit result;
    private static float cdist;
    private static boolean boolResult;

    public static void unitCapDeath(Unit unit) {
        if (unit != null) {
            unit.dead = true;
            Fx.unitCapKill.at(unit);
            Core.app.post(() -> Call.unitDestroy(unit.id));
        }
    }

    public static void unitDeath(int uid) {
        Unit unit = Groups.unit.getByID(uid);
        if (Vars.netClient != null) {
            Vars.netClient.addRemovedEntity(uid);
        }
        if (unit != null) {
            unit.killed();
        }
    }

    public static void unitDestroy(int uid) {
        Unit unit = Groups.unit.getByID(uid);
        if (Vars.netClient != null) {
            Vars.netClient.addRemovedEntity(uid);
        }
        if (unit != null) {
            unit.destroy();
        }
    }

    public static void unitDespawn(Unit unit) {
        Fx.unitDespawn.at(unit.x, unit.y, 0.0f, unit);
        unit.remove();
    }

    public static boolean canCreate(Team team, UnitType type) {
        return team.data().countType(type) < Units.getCap(team);
    }

    public static int getCap(Team team) {
        if (team == Vars.state.rules.waveTeam && !Vars.state.rules.pvp || Vars.state.isCampaign() && team == Vars.state.rules.waveTeam) {
            return Integer.MAX_VALUE;
        }
        return Math.max(0, Vars.state.rules.unitCapVariable ? Vars.state.rules.unitCap + Vars.indexer.getExtraUnits(team) : Vars.state.rules.unitCap);
    }

    public static boolean canInteract(Player player, Building tile) {
        return player == null || tile == null || tile.interactable(player.team());
    }

    public static boolean invalidateTarget(Posc target, Team team, float x, float y, float range) {
        Healthc h;
        Teamc t;
        Sized hb;
        Posc posc;
        return target == null || range != Float.MAX_VALUE && !target.within(x, y, range + ((posc = target) instanceof Sized && (hb = (Sized)((Object)posc)) == (Sized)((Object)posc) ? hb.hitSize() / 2.0f : 0.0f)) || (posc = target) instanceof Teamc && (t = (Teamc)posc) == (Teamc)posc && t.team() == team || (posc = target) instanceof Healthc && (h = (Healthc)posc) == (Healthc)posc && !h.isValid();
    }

    public static boolean invalidateTarget(Posc target, Team team, float x, float y) {
        return Units.invalidateTarget(target, team, x, y, Float.MAX_VALUE);
    }

    public static boolean invalidateTarget(Teamc target, Unit targeter, float range) {
        return Units.invalidateTarget(target, targeter.team(), targeter.x(), targeter.y(), range);
    }

    public static boolean anyEntities(Tile tile, boolean ground) {
        float size = tile.block().size * 8;
        return Units.anyEntities(tile.drawx() - size / 2.0f, tile.drawy() - size / 2.0f, size, size, ground);
    }

    public static boolean anyEntities(Tile tile) {
        return Units.anyEntities(tile, true);
    }

    public static boolean anyEntities(float x, float y, float width, float height) {
        return Units.anyEntities(x, y, width, height, true);
    }

    public static boolean anyEntities(float x, float y, float width, float height, boolean ground) {
        boolResult = false;
        Units.nearby(x, y, width, height, (Unit unit) -> {
            if (boolResult) {
                return;
            }
            if ((unit.isGrounded() && !unit.type.hovering) == ground) {
                unit.hitboxTile(hitrect);
                if (hitrect.overlaps(x, y, width, height)) {
                    boolResult = true;
                }
            }
        });
        return boolResult;
    }

    public static Building findDamagedTile(Team team, float x, float y) {
        return Geometry.findClosest(x, y, Vars.indexer.getDamaged(team));
    }

    public static Building findAllyTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        return Vars.indexer.findTile(team, x, y, range, pred);
    }

    public static Building findEnemyTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        if (team == Team.derelict) {
            return null;
        }
        return Vars.indexer.findEnemyTile(team, x, y, range, pred);
    }

    public static Teamc closestTarget(Team team, float x, float y, float range) {
        return Units.closestTarget(team, x, y, range, Healthc::isValid);
    }

    public static Teamc closestTarget(Team team, float x, float y, float range, Boolf<Unit> unitPred) {
        return Units.closestTarget(team, x, y, range, unitPred, t -> true);
    }

    public static Teamc closestTarget(Team team, float x, float y, float range, Boolf<Unit> unitPred, Boolf<Building> tilePred) {
        if (team == Team.derelict) {
            return null;
        }
        Unit unit = Units.closestEnemy(team, x, y, range, unitPred);
        if (unit != null) {
            return unit;
        }
        return Units.findEnemyTile(team, x, y, range, tilePred);
    }

    public static Teamc bestTarget(Team team, float x, float y, float range, Boolf<Unit> unitPred, Boolf<Building> tilePred, Sortf sort) {
        if (team == Team.derelict) {
            return null;
        }
        Unit unit = Units.bestEnemy(team, x, y, range, unitPred, sort);
        if (unit != null) {
            return unit;
        }
        return Units.findEnemyTile(team, x, y, range, tilePred);
    }

    public static Unit closestEnemy(Team team, float x, float y, float range, Boolf<Unit> predicate) {
        if (team == Team.derelict) {
            return null;
        }
        result = null;
        cdist = 0.0f;
        Units.nearbyEnemies(team, x - range, y - range, range * 2.0f, range * 2.0f, e -> {
            if (e.dead() || !predicate.get((Unit)e) || e.team == Team.derelict) {
                return;
            }
            float dst2 = e.dst2(x, y);
            if (dst2 < range * range && (result == null || dst2 < cdist)) {
                result = e;
                cdist = dst2;
            }
        });
        return result;
    }

    public static Unit bestEnemy(Team team, float x, float y, float range, Boolf<Unit> predicate, Sortf sort) {
        if (team == Team.derelict) {
            return null;
        }
        result = null;
        cdist = 0.0f;
        Units.nearbyEnemies(team, x - range, y - range, range * 2.0f, range * 2.0f, e -> {
            if (e.dead() || !predicate.get((Unit)e) || e.team == Team.derelict || !e.within(x, y, range + e.hitSize / 2.0f)) {
                return;
            }
            float cost = sort.cost((Unit)e, x, y);
            if (result == null || cost < cdist) {
                result = e;
                cdist = cost;
            }
        });
        return result;
    }

    public static Unit closest(Team team, float x, float y, Boolf<Unit> predicate) {
        result = null;
        cdist = 0.0f;
        for (Unit e : Groups.unit) {
            if (!predicate.get(e) || e.team() != team) continue;
            float dist = e.dst2(x, y);
            if (result != null && !(dist < cdist)) continue;
            result = e;
            cdist = dist;
        }
        return result;
    }

    public static Unit closest(Team team, float x, float y, float range, Boolf<Unit> predicate) {
        result = null;
        cdist = 0.0f;
        Units.nearby(team, x, y, range, (Unit e) -> {
            if (!predicate.get((Unit)e)) {
                return;
            }
            float dist = e.dst2(x, y);
            if (result == null || dist < cdist) {
                result = e;
                cdist = dist;
            }
        });
        return result;
    }

    public static Unit closest(Team team, float x, float y, float range, Boolf<Unit> predicate, Sortf sort) {
        result = null;
        cdist = 0.0f;
        Units.nearby(team, x, y, range, (Unit e) -> {
            if (!predicate.get((Unit)e)) {
                return;
            }
            float dist = sort.cost((Unit)e, x, y);
            if (result == null || dist < cdist) {
                result = e;
                cdist = dist;
            }
        });
        return result;
    }

    public static Unit closestOverlap(Team team, float x, float y, float range, Boolf<Unit> predicate) {
        result = null;
        cdist = 0.0f;
        Units.nearby(team, x - range, y - range, range * 2.0f, range * 2.0f, e -> {
            if (!predicate.get((Unit)e)) {
                return;
            }
            float dist = e.dst2(x, y);
            if (result == null || dist < cdist) {
                result = e;
                cdist = dist;
            }
        });
        return result;
    }

    public static void nearby(Team team, float x, float y, float width, float height, Cons<Unit> cons) {
        team.data().tree().intersect(x, y, width, height, cons);
    }

    public static void nearby(Team team, float x, float y, float radius, Cons<Unit> cons) {
        Units.nearby(team, x - radius, y - radius, radius * 2.0f, radius * 2.0f, unit -> {
            if (unit.within(x, y, radius + unit.hitSize / 2.0f)) {
                cons.get((Unit)unit);
            }
        });
    }

    public static void nearby(float x, float y, float width, float height, Cons<Unit> cons) {
        Groups.unit.intersect(x, y, width, height, cons);
    }

    public static void nearby(Rect rect, Cons<Unit> cons) {
        Units.nearby(rect.x, rect.y, rect.width, rect.height, cons);
    }

    public static void nearbyEnemies(Team team, float x, float y, float width, float height, Cons<Unit> cons) {
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            if (((Teams.TeamData[])data.items)[i].team == team) continue;
            Units.nearby(((Teams.TeamData[])data.items)[i].team, x, y, width, height, cons);
        }
    }

    public static void nearbyEnemies(Team team, Rect rect, Cons<Unit> cons) {
        Units.nearbyEnemies(team, rect.x, rect.y, rect.width, rect.height, cons);
    }

    public static interface Sortf {
        public float cost(Unit var1, float var2, float var3);
    }
}

