/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.audio.Sound;
import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Nullable;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.abilities.Ability;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;

public class MoveLightningAbility
extends Ability {
    public float damage = 35.0f;
    public float chance = 0.15f;
    public int length = 12;
    public float minSpeed = 0.8f;
    public float maxSpeed = 1.2f;
    public Color color = Color.valueOf("a9d8ff");
    public float offset = 0.0f;
    public String heatRegion = "error";
    @Nullable
    public BulletType bullet;
    public float bulletAngle = 0.0f;
    public float bulletSpread = 0.0f;
    public Effect shootEffect = Fx.sparkShoot;
    public Sound shootSound = Sounds.spark;

    MoveLightningAbility() {
    }

    public MoveLightningAbility(float damage, int length, float chance, float offset, float minSpeed, float maxSpeed, Color color, String heatRegion) {
        this.damage = damage;
        this.length = length;
        this.chance = chance;
        this.offset = offset;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.color = color;
        this.heatRegion = heatRegion;
    }

    public MoveLightningAbility(float damage, int length, float chance, float offset, float minSpeed, float maxSpeed, Color color) {
        this.damage = damage;
        this.length = length;
        this.chance = chance;
        this.offset = offset;
        this.minSpeed = minSpeed;
        this.maxSpeed = maxSpeed;
        this.color = color;
    }

    @Override
    public void update(Unit unit) {
        float scl = Mathf.clamp((unit.vel().len() - this.minSpeed) / (this.maxSpeed - this.minSpeed));
        if (Mathf.chance(Time.delta * this.chance * scl)) {
            float x = unit.x + Angles.trnsx(unit.rotation, this.offset, 0.0f);
            float y = unit.y + Angles.trnsy(unit.rotation, this.offset, 0.0f);
            this.shootEffect.at(x, y, unit.rotation, this.color);
            this.shootSound.at(unit);
            if (this.length > 0) {
                Lightning.create(unit.team, this.color, this.damage, x + unit.vel.x, y + unit.vel.y, unit.rotation, this.length);
            }
            if (this.bullet != null) {
                this.bullet.create(unit, unit.team, x, y, unit.rotation + this.bulletAngle + Mathf.range(this.bulletSpread));
            }
        }
    }

    @Override
    public void draw(Unit unit) {
        float scl = Mathf.clamp((unit.vel().len() - this.minSpeed) / (this.maxSpeed - this.minSpeed));
        TextureAtlas.AtlasRegion region = Core.atlas.find(this.heatRegion);
        if (Core.atlas.isFound(region) && scl > 1.0E-5f) {
            Draw.color(this.color);
            Draw.alpha(scl / 2.0f);
            Draw.blend(Blending.additive);
            Draw.rect((TextureRegion)region, unit.x + Mathf.range(scl / 2.0f), unit.y + Mathf.range(scl / 2.0f), unit.rotation - 90.0f);
            Draw.blend();
        }
    }
}

