/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.math.geom.Position;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;

public class RepairFieldAbility
extends Ability {
    public float amount = 1.0f;
    public float reload = 100.0f;
    public float range = 60.0f;
    public Effect healEffect = Fx.heal;
    public Effect activeEffect = Fx.healWaveDynamic;
    protected float timer;
    protected boolean wasHealed = false;

    RepairFieldAbility() {
    }

    public RepairFieldAbility(float amount, float reload, float range) {
        this.amount = amount;
        this.reload = reload;
        this.range = range;
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            this.wasHealed = false;
            Units.nearby(unit.team, unit.x, unit.y, this.range, other -> {
                if (other.damaged()) {
                    this.healEffect.at((Position)other);
                    this.wasHealed = true;
                }
                other.heal(this.amount);
            });
            if (this.wasHealed) {
                this.activeEffect.at(unit, this.range);
            }
            this.timer = 0.0f;
        }
    }
}

