/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;

public class ShieldRegenFieldAbility
extends Ability {
    public float amount = 1.0f;
    public float max = 100.0f;
    public float reload = 100.0f;
    public float range = 60.0f;
    public Effect applyEffect = Fx.shieldApply;
    public Effect activeEffect = Fx.shieldWave;
    protected float timer;
    protected boolean applied = false;

    ShieldRegenFieldAbility() {
    }

    public ShieldRegenFieldAbility(float amount, float max, float reload, float range) {
        this.amount = amount;
        this.max = max;
        this.reload = reload;
        this.range = range;
    }

    @Override
    public void update(Unit unit) {
        this.timer += Time.delta;
        if (this.timer >= this.reload) {
            this.applied = false;
            Units.nearby(unit.team, unit.x, unit.y, this.range, other -> {
                if (other.shield < this.max) {
                    other.shield = Math.max(other.shield + this.amount, this.max);
                    other.shieldAlpha = 1.0f;
                    this.applyEffect.at(unit);
                    this.applied = true;
                }
            });
            if (this.applied) {
                this.activeEffect.at(unit);
            }
            this.timer = 0.0f;
        }
    }
}

